

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_CheckRepPlanEntitiesSecurity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +=============================================================================================+
--  |                       Name: sec_CheckRepPlanEntitiesSecurity()
--  | Description: Checks whether user has permission on entities associated with replication plan
--  |              Currently, checking rights on the Hypervisor associated with the replication task of the plan
--  |              User is allowed to edit/delete the replication plan based on this stored proc, if regular regular permissions
--  |              like edit/delete on plan is not given.
--  |
--  |       Input: entityId, entityType, planSubtype, userId, selectOutput
--  |      Output: hasPermission
--  |      Author: sravanan
--  +=============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_CheckRepPlanEntitiesSecurity.sp,v $ $Id: sec_CheckRepPlanEntitiesSecurity.sp,v 1.1.4.4 2020/10/07 20:15:29 sravanan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_CheckRepPlanEntitiesSecurity')
BEGIN
	print '>>> Drop Stored Procedure: sec_CheckRepPlanEntitiesSecurity <<<'
	drop procedure sec_CheckRepPlanEntitiesSecurity
END
IF EXISTS (select * from GxQscripts where name='sec_CheckRepPlanEntitiesSecurity')
	delete from GxQscripts where name = 'sec_CheckRepPlanEntitiesSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CheckRepPlanEntitiesSecurity')
	delete from GXDBVersions where aliasname = 'sec_CheckRepPlanEntitiesSecurity'
GO
print '... Creating Procedure: sec_CheckRepPlanEntitiesSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_CheckRepPlanEntitiesSecurity
  @i_entityId INT,
  @i_entityType INT, 
  @i_planSubtype INT = 0,
  @i_userId INT,
  @i_selectOutput INT,
  @o_hasPermission INT OUTPUT 
AS
  DECLARE @hasPermission INT = 0
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#replicationSchedulePermission')		IS NOT NULL DROP TABLE #replicationSchedulePermission
CREATE TABLE #replicationSchedulePermission		(permissionId INT)
CREATE CLUSTERED INDEX replicationSchedulePermission_permissionId_Idx ON #replicationSchedulePermission(permissionId)
BEGIN
	DECLARE @planId INT = 0
IF(@i_entityType = 158)
	BEGIN
		SET @planId = @i_entityId
	END
ELSE IF(@i_entityType = 17)
	BEGIN
SET @planId = ISNULL((SELECT TOP 1 PP.componentNameId FROM App_PlanProp PP WHERE PP.attrName = 'Storage policy'
								AND ISNUMERIC(attrVal) = 1 AND attrVal = cast(@i_entityId as varchar(255))),0)
	END
	ELSE
	BEGIN
		SET @o_hasPermission = 0
		GOTO PROC_EXIT
	END
	IF (@i_planSubtype = 0)
		SET @i_planSubtype = ISNULL((SELECT subType FROM App_Plan WHERE id = @planId),0)
IF(@i_planSubType <> 83918853 OR @planId = 0) -- If input has any other plan subType apart from VSAReplication, return user has no permission.
   BEGIN
       SET @o_hasPermission = 0
   END
   ELSE
   BEGIN
		-- Replication plans created implicitely as part of replication group are hidden.
		-- So we need to fetch them explicitely. This is done so that MSP admin can view and make changes to the replication group created by tenant admin
		DECLARE @replicationTaskId INT = ISNULL((SELECT convert(int,attrVal) FROM App_PlanProp WITH(NOLOCK) WHERE componentNameId = @planId AND
attrName = 'Replication schedule policy' AND modified = 0 and attrval is not null),0)
		DECLARE @hypervisorClientId INT = 0
		DECLARE @apptypeId INT = 0
		DECLARE @scId INT = 0
		DECLARE @bkpSet INT = 0
		DECLARE @instance INT = 0
DECLARE @apptypeEntityType INT = 4
DECLARE @instanceEntityType INT = 5
DECLARE @bkpSetEntityType INT = 6
DECLARE @scEntityType INT = 7
		IF(@replicationTaskId <> 0)
		BEGIN
			SELECT @hypervisorClientId = clientId,
				   @apptypeId = apptypeId,
				   @scId = subclientId,
				   @bkpSet = backupsetId,
				   @instance = instanceId
			FROM TM_AssocEntity WITH(NOLOCK) WHERE taskId = @replicationTaskId AND clientId IS NOT NULL
		END
		ELSE
		BEGIN
			SELECT @hypervisorClientId = clientId,
				   @apptypeId = appTypeId,
				   @scId = APP.id,
				   @bkpSet = backupSet,
				   @instance = instance
FROM APP_Application APP WITH(NOLOCK) JOIN App_PlanProp PP WITH(NOLOCK) ON PP.componentNameId = @planId AND PP.attrName = 'Storage policy' AND PP.modified = 0
WHERE CONVERT(NVARCHAR(MAX),APP.dataArchGrpID) = PP.attrVal AND (APP.subclientStatus & 0x00004 = 0) AND (APP.subclientStatus & 0x00008 = 0)
		END
		IF(@hypervisorClientId = 0)
		BEGIN
			SET @o_hasPermission = 0
			GOTO PROC_EXIT
		END
		IF(@apptypeId = 0)
			SET @apptypeEntityType = 0
		IF(@instance = 0)
			SET @instanceEntityType = 0
		IF(@bkpSet = 0)
			SET @bkpSetEntityType = 0
		IF(@scId = 0)
			SET @scEntityType = 0
EXEC sec_getPermissionsOnEntity '#replicationSchedulePermission',@i_userId,3, @hypervisorClientId, @apptypeEntityType, @apptypeId, @instanceEntityType, @instance,
				@bkpSetEntityType,@bkpSet, @scEntityType, @scId
IF EXISTS(SELECT 1 FROM #replicationSchedulePermission WHERE permissionId = 31) OR
			(
EXISTS(SELECT 1 FROM #replicationSchedulePermission WHERE permissionId = 3) AND
EXISTS(SELECT 1 FROM #replicationSchedulePermission WHERE permissionId IN (20, 22))
			)
		BEGIN
			SET @o_hasPermission = 1
		END
		ELSE
		BEGIN
			SET @o_hasPermission = 0
		END
	END
END
PROC_EXIT:
IF(@i_selectOutput = 1)
BEGIN
	SET @hasPermission = @o_hasPermission
	SELECT @hasPermission
END
IF OBJECT_ID('tempdb.dbo.#replicationSchedulePermission')     IS NOT NULL DROP TABLE #replicationSchedulePermission
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_CheckRepPlanEntitiesSecurity')
	delete from GxQscripts where name = 'sec_CheckRepPlanEntitiesSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CheckRepPlanEntitiesSecurity')
	delete from GXDBVersions where aliasname = 'sec_CheckRepPlanEntitiesSecurity'
GO

insert into GXDBVersions values(2, 'sec_CheckRepPlanEntitiesSecurity',  '00010001000400040000', 'sec_CheckRepPlanEntitiesSecurity', '00010001000400040000')
GO

