

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_BackWardCompatabilityForOwners.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_BackWardCompatabilityForOwners <<<'

IF EXISTS (select * from sysobjects where name='sec_BackWardCompatabilityForOwners')
	drop procedure sec_BackWardCompatabilityForOwners
IF EXISTS (select * from GxQscripts where name='sec_BackWardCompatabilityForOwners')
	delete from GxQscripts where name = 'sec_BackWardCompatabilityForOwners'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_BackWardCompatabilityForOwners')
	delete from GXDBVersions where aliasname = 'sec_BackWardCompatabilityForOwners'
GO
print '... Creating Procedure: sec_BackWardCompatabilityForOwners'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_BackWardCompatabilityForOwners
  @i_xml XML,
  @i_userId integer,
  @entitytype integer,
  @entityId integer,
  @localeId integer =0,
  @isReturn integer=0,
  @skipSecurityCheck integer=0,
  @errorCode integer=0 OUTPUT,
  @errorString varchar(1024) ='' OUTPUT
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString varchar(1024)
SET @errorCode  =0
SET @errorString =''
DECLARE @spXML  XML
     /* <clientSecurity associatedUserGroupsOperationType="1" clientOwnersOperationType="1" clientUserGroupOwnersOperationType="1">
        <associatedUserGroups _type_="15" userGroupId="1" userGroupName="master" />
        <clientOwners val="test" />
        <clientOwners val="try" />
		<clientOwners val="commvault-nj\saggarwal" />
        <clientUserGroupOwners val="test1" />
        <ownerCapabilities individualCapabilitiesOperationType="1">
          <individualCapabilities val="18" />
          <individualCapabilities val="28" />
          <individualCapabilities val="6" />
          <inheritedCapabilities val="20" />
          <inheritedCapabilities val="39" />
        </ownerCapabilities>
      </clientSecurity>'
	*/
DECLARE @capabilitesOperationType integer = ISNULL((SELECT @i_xml.value('(/*/*/@individualCapabilitiesOperationType)[1]','integer')),0)
DECLARE @userOwnerOperationtype integer =  ISNULL((SELECT @i_xml.value('(/*/@clientOwnersOperationType)[1]','integer')),0)
DECLARE @userGroupOwnerOperationtype integer =  ISNULL((SELECT @i_xml.value('(/*/@clientUserGroupOwnersOperationType)[1]','integer')),0)
DECLARE @ownerCapabilities TABLE (capbilityId integer)
DECLARE @newOwnerOperationType INTEGER=0
INSERT INTO @ownerCapabilities
SELECT UG.value('(@val)[1]','INT')
FROM @i_xml.nodes('/*/*/individualCapabilities') AS Input(UG)
--Owners
DECLARE @ownerEntityTable TABLE (userId INTEGER DEFAULT 0,usergroupId INTEGER DEFAULT 0, externalGroupId INTEGER DEFAULT 0 ,login varchar(1024) )
IF(@userOwnerOperationtype<>0 AND @userGroupOwnerOperationtype<>0 and @userOwnerOperationtype<>@userGroupOwnerOperationtype)
BEGIN
	SET @errorCode=1;
	SET @errorString = 'User owner operation type and user group owner operation type cant be different in single request'
	GOTO EXIT_PROC
END
IF(@userOwnerOperationtype <>0)
	SET @newOwnerOperationType =@userOwnerOperationtype
ELSE IF(@userGroupOwnerOperationtype<>0)
	SET @newOwnerOperationType=@userGroupOwnerOperationtype
IF(@newOwnerOperationType<>0)
BEGIN
	IF(@userOwnerOperationtype<>0)
	BEGIN
	   INSERT INTO @ownerEntityTable (userId,login)
	   SELECT ISNULL(id,0),tbl.login FROM UMUsers RIGHT OUTER JOIN  (SELECT UG.value('(@val)[1]','nvarchar(1024)') as login
	   FROM @i_xml.nodes('/*/clientOwners') AS Input(UG)) tbl ON tbl.login=UMUsers.login and tbl.login is not null
	END
	IF (@userGroupOwnerOperationtype<>0)
	BEGIN
		INSERT INTO @ownerEntityTable (usergroupId,login)
	    SELECT ISNULL(id,0),tbl.name FROM UMGroups RIGHT OUTER JOIN  (SELECT UG.value('(@val)[1]','nvarchar(1024)') as name
	    FROM @i_xml.nodes('/*/clientUserGroupOwners') AS Input(UG)) tbl ON tbl.name=UMGroups.name and tbl.name is not null
		WHERE  CHARINDEX('\',tbl.name,1)=0
		INSERT INTO @ownerEntityTable (externalGroupId,login)
	    SELECT ISNULL(G.id,0),tbl.name FROM UMGroups G
		JOIN UMDSProviders P ON G.umdsProviderId=P.id
		RIGHT OUTER JOIN (SELECT UG.value('(@val)[1]','nvarchar(1024)') as name
			   FROM @i_xml.nodes('/*/clientUserGroupOwners') AS Input(UG)) tbl
		ON RIGHT(tbl.name,LEN(tbl.name)-CHARINDEX('\',tbl.name,1))=G.name
		 AND LTRIM(RTRIM(LEFT(tbl.name,CHARINDEX('\',tbl.name,1)-1)))=domainName
		WHERE CHARINDEX('\',tbl.name,1)<>0 and tbl.name is NOT NULL
	END
	IF EXISTS ( SELECT login FROM @ownerEntityTable where userID=0 and userGroupId=0 and externalGroupId=0)
	BEGIN
		DECLARE @loginName varchar(max)
		SELECT @loginName =COALESCE(@loginName+',','')+login
		FROM @ownerEntityTable where userID=0 and userGroupId=0 and externalGroupId=0
		SET @errorString='User/Group ['+@loginName+'] does not exists'
		SET @errorCode=1
		GOTO EXIT_PROC
	END
END
SET @spXML =(SELECT(SELECT @newOwnerOperationType as '@ownersOperationType',
					(SELECT @capabilitesOperationType as '@categoriesPermissionOperationType',
							(SELECT DISTINCT permissionId  as '@permissionId',
									categoryId AS '@categoryId',
'@_type_'= CASE WHEN permissionId<>0  THEN   122
ELSE 121
												END
							FROM @ownerCapabilities OC CROSS APPLY sec_getCapabilityToPermissionMap(OC.capbilityId,0)
							FOR XML PATH ('categoriesPermissionList'),TYPE)
					FOR XML PATH('categoryPermission'), TYPE),
					(SELECT userId as '@userId',usergroupId as '@userGroupId' ,externalGroupId as '@groupId'
					 FROM @ownerEntityTable
					 FOR XML PATH ('owners'), TYPE)
				FOR XML PATH('ownerAssociations'),TYPE)
			FOR XML PATH('App_SecurityAssociationForEntityList'))
EXIT_PROC:
IF(@errorCode=0)
BEGIN
	IF(@spXML is not null)
	BEGIN
		EXEC sec_populateOwnersTable @spXML,@i_userId,@localeId,1,@entitytype,@entityId,@skipSecurityCheck, @errorCode OUTPUT,@errorString OUTPUT
	END
END
IF(@isReturn=1)
	SELECT @errorCode,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_BackWardCompatabilityForOwners')
	delete from GxQscripts where name = 'sec_BackWardCompatabilityForOwners'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_BackWardCompatabilityForOwners')
	delete from GXDBVersions where aliasname = 'sec_BackWardCompatabilityForOwners'
GO

insert into GXDBVersions values(2, 'sec_BackWardCompatabilityForOwners',  '00000000000000000000', 'sec_BackWardCompatabilityForOwners', '00000000000000000000')
GO

