

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_AssociatePseudoClient.sp] ---------- 

--		ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_AssociatePseudoClient.sp,v $ $Id: sec_AssociatePseudoClient.sp,v 1.8.48.2 2018/03/22 03:08:15 jiechen Exp $";
-- =============================================
-- Author:		Ashish Gupta
-- Creation date: 05/03/2010
-- Description:	Grants all user groups with AGENT_MANAGEMENT and RESTORE capabilities rights to pseudo client.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_AssociatePseudoClient <<<'

IF EXISTS (select * from sysobjects where name='sec_AssociatePseudoClient')
	drop procedure sec_AssociatePseudoClient
IF EXISTS (select * from GxQscripts where name='sec_AssociatePseudoClient')
	delete from GxQscripts where name = 'sec_AssociatePseudoClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_AssociatePseudoClient')
	delete from GXDBVersions where aliasname = 'sec_AssociatePseudoClient'
GO
print '... Creating Procedure: sec_AssociatePseudoClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_AssociatePseudoClient
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INTEGER,
  @i_entityId INTEGER
AS
SET NOCOUNT ON
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg VARCHAR(64)
DECLARE @tblGrps				TABLE(id integer)
SET @errorMsg = 'Success'
SET @errorCode = 0
BEGIN TRY
	IF NOT EXISTS (SELECT * FROM App_Client WHERE id=@i_entityId)
	BEGIN
		SET @errorCode = -1
		SET @errorMsg = 'sec_AssociatePseudoClient: Invalid entity ID passed.'
		GOTO ERROR_OUT
	END
	IF NOT EXISTS (SELECT name FROM UMUsers WHERE id=@i_userId)
	BEGIN
		SET @errorCode = -2
		SET @errorMsg = 'sec_AssociatePseudoClient: Invalid user ID passed.'
		GOTO ERROR_OUT
	END
	IF ISNULL( (SELECT umDSproviderId FROM UMUsers WHERE id=@i_userId), 0) = 0
	BEGIN
		INSERT INTO @tblGrps
		SELECT groupId FROM UMUserGroup
		WHERE userId = @i_userId
	END
	ELSE
	BEGIN
		INSERT INTO @tblGrps
		SELECT DISTINCT umGroupId FROM UMDSGroupMaps
		WHERE umDSgroupId in (
			SELECT groupId FROM UMDSUserGroup
			WHERE userId = @i_userId
		)
	END
	IF dbo.isNewSecurity() = 0
	BEGIN
		delete @tblGrps
		WHERE id not in (
			SELECT groupId FROM (
				SELECT groupId,  dbo.BitwiseOR(POWER(2.0, capabilityId - 1)) AS Cap
				FROM UMGroupCapability GC INNER JOIN @tblGrps G
				ON G.id = GC.groupId
				GROUP BY groupId
			) A
WHERE A.Cap & CAST(POWER(2.0, 2 - 1) AS bigint) > 0)
		INSERT UMGroupAssociation
		SELECT id, 2009, @i_entityId, 0, 0, 0, 0, 0, 0, 0
		FROM @tblGrps
	END
	ELSE
	BEGIN
			DECLARE @userHasRights INT = 0
DECLARE @applicationCap BIGINT = CAST(POWER(2.0, 2 - 1) AS bigint)
			EXEC sec_userHasCapability @i_userId, @applicationCap, @userHasRights OUTPUT
			IF @userHasRights <> 0
			BEGIN
DECLARE @permissionsList NVARCHAR(MAX) = CAST(2 AS NVARCHAR(10))
				DECLARE @errorString NVARCHAR(MAX) = ''
EXEC sec_insertSecurityAssociation @i_userId, 0, @permissionsList, @i_userId, 0, @errorCode OUTPUT, @errorString OUTPUT, 3, @i_entityId
			END
	END
	DECLARE @loginName nvarchar(512) = ISNULL((SELECT login FROM UMUsers WHERE id = @i_userId),'')
	IF LEN(@loginName) > 0
	BEGIN
		EXEC DM2UpdateWBAClientOwners @i_entityId,@loginName, 1,0,@i_userId
	END
	EXEC sec_updateUserCredentials @i_userId, 1
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -3
	SET @errorMsg = 'sec_AssociatePseudoClient: Unknown exception occured.'
END CATCH
ERROR_OUT:
	SELECT @errorCode AS 'ErrorCode', @errorMsg AS 'ErrorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'sec_AssociatePseudoClient')
	delete from GxQscripts where name = 'sec_AssociatePseudoClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_AssociatePseudoClient')
	delete from GXDBVersions where aliasname = 'sec_AssociatePseudoClient'
GO

insert into GXDBVersions values(2, 'sec_AssociatePseudoClient',  '00010008004800020000', 'sec_AssociatePseudoClient', '00010008004800020000')
GO

