

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_AssociateBackupSetWithGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ashish Gupta
--	Date:   02/03/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_AssociateBackupSetWithGroup.sp,v $ $Id: sec_AssociateBackupSetWithGroup.sp,v 1.3.48.2 2018/03/22 03:05:33 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_AssociateBackupSetWithGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_AssociateBackupSetWithGroup')
	drop procedure sec_AssociateBackupSetWithGroup
IF EXISTS (select * from GxQscripts where name='sec_AssociateBackupSetWithGroup')
	delete from GxQscripts where name = 'sec_AssociateBackupSetWithGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_AssociateBackupSetWithGroup')
	delete from GXDBVersions where aliasname = 'sec_AssociateBackupSetWithGroup'
GO
print '... Creating Procedure: sec_AssociateBackupSetWithGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_AssociateBackupSetWithGroup
  @i_userId integer,
  @i_backupSetId integer
AS
BEGIN
	DECLARE @groupId			INT
	DECLARE @clientId			INT
	DECLARE @appTypeId			INT
	DECLARE @instanceId			INT
	SET @clientId = (SELECT TOP(1) clientId FROM App_Application WHERE backupSet = @i_backupSetId)
	SET @appTypeId = (SELECT TOP(1) appTypeId FROM App_Application WHERE backupSet = @i_backupSetId)
	SET @instanceId = (SELECT TOP(1) instance FROM App_Application WHERE backupSet = @i_backupSetId)
	IF dbo.isNewSecurity() = 0
	BEGIN
SET @groupId = (SELECT TOP(1) groupId FROM UMGroupCapability WHERE (capabilityId = 20 OR capabilityId = 22) AND groupId in (
SELECT DISTINCT groupId FROM UMGroupCapability WHERE capabilityId = 25 AND groupId in (
					SELECT groupId FROM UMUserGroup WHERE userId = @i_userId
					UNION
					SELECT umgroupId FROM  UMDSGroupMaps WHERE umDSgroupId in (
						SELECT groupId FROM UMDSUserGroup WHERE userId = @i_userId
					)
				)
			)
		)
		IF @groupId IS NOT NULL
		BEGIN
INSERT INTO UMGroupAssociation VALUES(@groupId, 2009, @clientId, 2230, @appTypeId, 2012, @i_backupSetId, 0, 0, 0)
			UPDATE umusers SET credSetTime = 0 WHERE id = @i_userId
			exec dbo.sec_updateUserCredentials @i_userId
		END
	END
	ELSE
	BEGIN
		DECLARE @userHasInPlace INT
		DECLARE @userHasOutPlace INT
		DECLARE @userHasComplianceSearch INT
DECLARE @inPlaceCap BIGINT = CAST(POWER(2.0, 20 - 1) AS bigint)
DECLARE @outPlaceCap BIGINT = CAST(POWER(2.0, 22 - 1) AS bigint)
DECLARE @ComplianceCap BIGINT = CAST(POWER(2.0, 25 - 1) AS bigint)
		EXEC sec_userHasCapability @i_userId, @inPlaceCap, @userHasInPlace OUTPUT
		EXEC sec_userHasCapability @i_userId, @outPlaceCap, @userHasOutPlace OUTPUT
		EXEC sec_userHasCapability @i_userId, @ComplianceCap, @userHasComplianceSearch OUTPUT
		IF ((@userHasInPlace <> 0) OR (@userHasOutPlace <> 0)) AND (@userHasComplianceSearch <> 0)
		BEGIN
			DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(25 AS NVARCHAR(10)) + ','
			IF @userHasInPlace <> 0
SET @permissionsList += CAST(20 AS NVARCHAR(10))
			ELSE
SET @permissionsList += CAST(22 AS NVARCHAR(10))
			DECLARE @errorCode INT
			DECLARE @errorString NVARCHAR(MAX) = ''
EXEC sec_insertSecurityAssociation @i_userId, 0, @permissionsList, @i_userId, 0, @errorCode OUTPUT, @errorString OUTPUT, 3, @clientId, 4 , @appTypeId, 5, @InstanceId, 6, @i_backupSetId
		END
	END
EXIT_PROC:
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'sec_AssociateBackupSetWithGroup')
	delete from GxQscripts where name = 'sec_AssociateBackupSetWithGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_AssociateBackupSetWithGroup')
	delete from GXDBVersions where aliasname = 'sec_AssociateBackupSetWithGroup'
GO

insert into GXDBVersions values(2, 'sec_AssociateBackupSetWithGroup',  '00010003004800020000', 'sec_AssociateBackupSetWithGroup', '00010003004800020000')
GO

