

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_ADUserLogin.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_ADUserLogin.sp,v $ $Id: sec_ADUserLogin.sp,v 1.67.2.42 2020/12/02 16:50:22 kveerapandian Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "sec_ADUserLogin"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_ADUserLogin')
BEGIN
	print '>>> Drop Stored Procedure: sec_ADUserLogin <<<'
	drop procedure sec_ADUserLogin
END
IF EXISTS (select * from GxQscripts where name='sec_ADUserLogin')
	delete from GxQscripts where name = 'sec_ADUserLogin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ADUserLogin')
	delete from GXDBVersions where aliasname = 'sec_ADUserLogin'
GO
print '... Creating Procedure: sec_ADUserLogin'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_ADUserLogin
  @i_userName nvarchar(255),
  @i_domainName varchar(255),
  @i_groupList nvarchar(MAX),
  @i_capability bigint,
  @i_isDominoLogin int = 0,
  @o_userCap bigint = 0 OUTPUT,
  @i_xmlText XML = '<DM2ContentIndexing_CVGalaxySecurityGroup />',
  @i_userGuid varchar(MAX) = '',
  @i_userEMail varchar(MAX) = '',
  @i_isSearch int = 0,
  @i_updateSmtp int = 0,
  @i_canonicalName nvarchar(255) = '',
  @i_providerId INT=0,
  @o_userId int = 0 OUTPUT,
  @o_errorCode int = 0 OUTPUT,
  @o_errorString nvarchar(1024) = '' OUTPUT
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nvarchar(255);
  DECLARE @o_appTypeId integer;
  DECLARE @o_subclientId integer;
  DECLARE @o_commcellNumber integer;
  DECLARE @o_isPrimary integer;
  DECLARE @o_isSecondary integer;
  DECLARE @o_caseClient integer;
  DECLARE @o_idxAppTypeId integer;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @userId			integer
DECLARE @UMDSProvider		integer
DECLARE @delimPos		integer
DECLARE	@delim			char
DECLARE @i_userLogIn	NVARCHAR(1024)
DECLARE @createTime		INT = dbo.getunixtime(GETUTCDATE())
DECLARE @canonicalName	nvarchar(255)=''
DECLARE @name nvarchar(255) = ''
SET	@delim			= ','
DECLARE @extGroupList	TABLE(	t_groupName	nvarchar(255),hostName nvarchar(255), providerid INT)
DECLARE @isUserReinstated BIT = 0
if object_id('tempdb.dbo.#userObjects') is not null
			BEGIN
				DROP TABLE #userObjects
			END
CREATE TABLE #userObjects	(	commCellId	integer,
				clientId	integer,
				appTypeId	integer,
				instanceId	integer,
				backupsetId	integer,
				subClientId	integer )
CREATE NONCLUSTERED INDEX userobj_clientId_BackupSetId_SubclientID_Idx ON #UserObjects(CLientID,SubclientID) INCLUDE (commCellId, InstanceId, BackupSetid,appTypeId)
if object_id('tempdb.dbo.#appIdTbl') is not null
			BEGIN
				DROP TABLE #appIdTbl
			END
CREATE TABLE #appIdTbl	(	id		integer,
				clientId	integer,
				appTypeId	integer,
				instance	integer,
				backupset	integer )
if object_id('tempdb.dbo.#tmpClientTbl') is not null
			BEGIN
				DROP TABLE #tmpClientTbl
			END
CREATE TABLE #tmpClientTbl (clientId	integer,
				clientName  nvarchar(max),
				appTypeId	integer,
				subclientId	integer,
				commcellNumber  integer,
				isPrimary	integer,
				isSecondary	integer,
				backupSetId	integer,
				caseClient integer,
				idxAppTypeId integer
			)
if object_id('tempdb.dbo.#tmpFilters') is not null
			BEGIN
				DROP TABLE #tmpFilters
			END
CREATE TABLE #tmpFilters (filterType integer,
					id	integer)
DECLARE @dominoGrpFlags		integer
DECLARE @dominoGrpId		integer
if object_id('tempdb.dbo.#t_userCaps') is not null
			BEGIN
				DROP TABLE #t_userCaps
			END
CREATE TABLE #t_userCaps 	(caps bigint)
DECLARE @serviceType int = 0
SET @i_userLogIn = @i_userName
IF @i_domainName <> ''
BEGIN
	DECLARE @flags	INT
	DECLARE @pwd	VARCHAR(15)
	SET @i_userLogIn = (@i_domainName + '\' + @i_userLogIn)
	if(@i_providerId=0)
	BEGIN
			SELECT  TOP 1 @UMDSProvider=ISNULL(id,0), @serviceType=ISNULL(serviceType, 0) FROM UMDSProviders where domainName = @i_domainName AND enabled = 1
	END
	ELSE
	BEGIN
		SELECT @UMDSProvider=ISNULL(id,0), @serviceType=ISNULL(serviceType, 0) FROM UMDSProviders where id=@i_providerId AND enabled = 1
	END
	if(@serviceType<>5)--Not for organization users
	BEGIN
	-- Parse comma separated group list and insert into @extGroupList table
		WHILE len(@i_groupList) > 0
		BEGIN
			SET @delimPos = CHARINDEX(@delim, @i_groupList)
			DECLARE @extGroupName nvarchar(512)
			IF @delimPos > 0
			BEGIN
				SET @extGroupName = substring(@i_groupList, 1, @delimPos-1)
				SET @i_groupList = substring(@i_groupList, @delimPos+1, len(@i_groupList)-@delimPos)
			END
			ELSE
			BEGIN
				SET @extGroupName = @i_groupList
				SET @i_groupList = ''
			END
			declare @hostName nvarchar(512)=NULL
			declare @groupName nvarchar(512)=NULL
			declare @groupProviderId INT = @UMDSProvider
			IF(charindex('\',@extGroupName) > 0)
			BEGIN
				SET @hostName = SUBSTRING(@extGroupName,0,charindex('\',@extGroupName))
				SET @groupName = SUBSTRING(@extGroupName,charindex('\',@extGroupName)+1,len(@extGroupName)-len(@hostName))
			END
			ELSE
				SET @groupName=@extGroupName
			INSERT INTO @extGroupList(t_groupname,hostname) VALUES (@groupName,@hostName)
		END
		--populate providerid from hostname
		UPDATE ExGrp SET providerid=id
		FROM @extGroupList ExGrp
		INNER JOIN UMDSProviders ON UMDSProviders.hostName=ExGrp.hostName WHERE ExGrp.hostName IS NOT NULL
		--if hostname is null, consider the provider id of the user
		UPDATE @extGroupList set providerId=@umdsprovider where hostName is NULL
SET @flags = CAST(0x001 AS INT) | CAST(0x400 AS INT)
		IF @i_isDominoLogin > 0
			SET @pwd = 'No Password'
		ELSE
			SET @pwd = '2AZdUUxUUyUUz'
		IF @i_isSearch = 0
		BEGIN
			--check for disabled users
			IF EXISTS(SELECT 1 FROM UMUSers (NOLOCK) WHERE login = @i_userLogIn and enabled =0) -- Deleted users have 'deleted' added in login.
			BEGIN
				SET @o_ErrorCode = 1131
				SET @o_ErrorString = 'Input user  [' + @i_userLogIn +'] is disabled'
				SET @i_userGuid = NULL
			END
			-- If user Guid is not supplied or is empty string, try to fetch the same from DB.
			ELSE IF(@i_userGuid is NULL or @i_userGuid = '')
				SET @i_userGuid = (SELECT TOP 1 userGuid FROM UMUsers where LOGIN = @i_userLogIn and enabled = 1 order by id desc)
			IF((@i_userGuid is not null and @i_userGuid <> '') OR @i_isDominoLogin > 0)
			BEGIN
				-- Check if AD has been discontinued
				IF @UMDSProvider IS null OR @UMDSProvider = 0
					BEGIN
						SET @o_ErrorCode = -1
						SET @o_ErrorString = 'Could not create user [' + @i_userLogIn +'] Missing or wrong domain name'
						SET @o_userId = 0
					END
				-- Check if the username exists and the guid doesn't.
				ELSE IF EXISTS(select top 1 id from UMUSERS where login = @i_userLogin and userGuid <> @i_userGuid )
				BEGIN
					-- If the user guid is empty, consider it a special case and update details.
					select top 1 @userId = id from UMUSERS where login = @i_userLogin and userGuid <> @i_userGuid
						UPDATE UMUsers SET
						email = case when @i_userEMail<>'' then @i_userEMail else email end,
						origUserGuid = userGuid,
						userGuid = @i_userGuid,
						name = CASE WHEN @i_canonicalName = '' THEN @i_userName ELSE @i_canonicalName END
						WHERE id = @userId
				END
				-- If user with same guid exists
				ELSE IF EXISTS (SELECT TOP 1 ID FROM UMUSERS WHERE USERGUID = @i_userGuid ORDER BY ID DESC)
				BEGIN
					-- Either the user is deleted or some values have been updated
					IF EXISTS(SELECT TOP(1) ID FROM UMUSERS WHERE userGuid = @i_userGuid and enabled = 1 order by id desc)
						BEGIN
						--donot reset flag USERS_WITH_LINKED_CLOUD_ACCOUNT that was set during user creation
						DECLARE @oldFlag INT = 0
							SELECT TOP(1) @userId = id, @name = name, @oldFlag = flags FROM UMUsers WHERE userGuid=@i_userGuid and enabled = 1 order by id desc
IF(@oldFlag & 0x4000 <> 0)
SET @flags = @flags | 0x4000
							MERGE UMUSERS as target
								USING (
										select @userId as id,
										CASE
											WHEN @i_canonicalName = '' AND (@name is null or @name = '')
												THEN @i_userName
											ELSE
												CASE
													WHEN @i_canonicalName <> @name AND @i_canonicalName <> ''
														THEN @i_canonicalName
													ELSE @name
												END
										END as name,
								'WebUI created user' as discription, @i_userLogIn as login, @pwd as password, @i_userEMail as email, @createTime as datePasswordSet,
							1 as enabled, @flags as flags) as Source
							ON (target.Id = source.id)
							WHEN MATCHED and (target.name != source.name OR target.login != source.login OR target.email != source.email OR target.flags != source.flags)
							THEN
								UPDATE SET
									Target.name = source.name,
									target.login = source.login,
									target.email = case when source.email <> '' then source.email else target.email end,
									target.flags = source.flags,
									target.modified = dbo.getUnixTime(GETUTCDATE());
						END
					ELSE IF EXISTS(SELECT TOP(1) ID FROM UMUSERS WHERE userGuid = @i_userGuid and enabled = 0 order by id desc)
					BEGIN
						SET @userId = (SELECT TOP(1) id  FROM UMUsers WHERE userGuid=@i_userGuid and enabled = 0 order by id desc)
						-- If the user is deleted, reinstate the user
								UPDATE UMUsers SET login = @i_userLogIn,
												email =  case when @i_userEMail<>'' then @i_userEMail else email end,
												password = @pwd,
												flags = @flags,
												enabled = 1,
												pVer = 2,
												Description = 'WebUI created user',
												umdsProviderId = @UMDSProvider,
												name = CASE WHEN @i_canonicalName = '' THEN @i_userName ELSE @i_canonicalName END
									WHERE id = @userId
						SET @o_ErrorCode = @@error
						SET @isUserReinstated = 1
					END
				END
				-- Neither user with same guid not login exists.
				-- Add a new user
				ELSE IF (@i_userGuid is not NULL or @i_userGuid != '' OR @i_isDominoLogin > 0)
				BEGIN
					INSERT INTO UMUsers  (name,description,login,password,email,datePasswordSet , dateExpires ,policy, enabled , flags,modified,pVer,Pager,lastLoginTime,credSetTime,umdsProviderId,userGUID,origUserGuid,origCCID)
					SELECT CASE WHEN @i_canonicalName = '' THEN @i_userName ELSE @i_canonicalName END,
						'WebUI created user', @i_userLogIn, @pwd, @i_userEMail, @createTime, 0, 0,
						1, @flags, 0, '2', '', 0, 0, @UMDSProvider, '', '', 2
					SET @userId = SCOPE_IDENTITY()
					SET @o_ErrorCode = @@error
					-- CMR 222531/226837: Do not create a new entry in UMUsers if AD user login failed due to no credentials.
					-- Adding an entry to know this user has been created by login protocol and the time it got created can be obtained from created column.
					-- Later down the login protocol, if canLogin stored procedure returned failure, then we can delete the AD user entry if he got created just now.
					-- Logic copied from EvSecurityMgr::addUser in EvSecurityMgr.cpp (Java GUI login).
					INSERT INTO UMUsersProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@userId, 'AD user created during login', 7, 1, @createTime, 0)
				END
			END
		END
	END
	SET @userId = ISNULL((select id from umusers where login = @i_userLogIn and enabled =1), 0)
	-- Update user group relationship from input parameters
	-- Notes:
	-- Users with id <= 0 will have provider ID = 0
	-- For organization users, we should not be deleting and adding back groups info like we do for AD or LN users.
	IF @UMDSProvider IS not null AND @UMDSProvider <> 0 AND @userId > 0 AND @serviceType <> 5 AND @i_isSearch = 0
	BEGIN
		-- REMOVE OLD USER AND EXTERNAL GROUP ASSOCIATIONS IF NOT PRESENT IN THE INPUT GROUP LIST
		DELETE UUG
			FROM UMDSUserGroup UUG
			INNER JOIN UMDSgroups G WITH(NOLOCK) ON G.id = UUG.groupId AND UUG.userId = @userId  and G.enabled = 1
			LEFT OUTER JOIN @extGroupList GL ON G.name = GL.t_groupName AND G.umdsProviderId = GL.providerId
			WHERE GL.t_groupName IS NULL
		DELETE UUG
			FROM UMUserGroup UUG
INNER JOIN UMGroups G WITH(NOLOCK) ON UUG.groupId = G.id and UUG.userId = @userId  and G.groupFlags&0x10000<>0x10000
			INNER JOIN UMDSProviders UMDSP on UMDSP.id = G.umdsProviderId
			LEFT JOIN @extGroupList GL ON G.name = GL.t_groupName  AND G.umdsProviderId = GL.providerId
WHERE GL.t_groupName IS NULL AND umdsProviderId<>0 and UMDSP.serviceType <> 5
		-- Create recent user and external group association
		MERGE UMDSUserGroup as TARGET
		USING (
				SELECT G.id FROM @extGroupList GL
				JOIN UMDSgroups G WITH(NOLOCK) ON G.name = GL.t_groupName AND G.umdsProviderId = GL.providerId and G.enabled = 1
			  ) AS SOURCE (id)
			ON SOURCE.id = TARGET.groupId AND TARGET.userId = @userId
		WHEN NOT MATCHED THEN
			INSERT (userId, groupId, flag) VALUES(@userId, SOURCE.id, @createTime);
		MERGE UMUserGroup as TARGET
		USING (
				SELECT G.id FROM @extGroupList GL
				JOIN UMGroups G WITH(NOLOCK) ON G.name = GL.t_groupName AND G.umdsProviderId = GL.providerId and G.groupFlags&1<>0
			  ) AS SOURCE (id)
			ON SOURCE.id = TARGET.groupId AND TARGET.userId = @userId
		WHEN NOT MATCHED THEN
			INSERT (userId, groupId, flag) VALUES(@userId, SOURCE.id, @createTime);
	END
	IF (@i_isDominoLogin > 0 AND @i_isSearch = 0)
	BEGIN
SET @dominoGrpFlags = (convert(int, 0x8000) + convert(int, 0x0001))
		SET @dominoGrpId = ISNULL((SELECT id FROM UMGroups
							WHERE name = 'Global Domino Enduser Group'
								AND (groupFlags & @dominoGrpFlags) = @dominoGrpFlags
								AND description = 'System dafault global domino enduser group'), 0 )
		IF (@dominoGrpId = 0)
		BEGIN
			INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID)
				VALUES(@dominoGrpFlags, 0, 0, 1, 'Global Domino Enduser Group', 'System dafault global domino enduser group', 2, NEWID())
			SET @dominoGrpId = ISNULL((SELECT id FROM UMGroups
								WHERE name = 'Global Domino Enduser Group'
									AND (groupFlags & @dominoGrpFlags) = @dominoGrpFlags
									AND description = 'System dafault global domino enduser group'), 0 )
			INSERT INTO UMGroupCapability (groupId, capabilityId, flag)
VALUES (@dominoGrpId, 24, 0)
		END
		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userId = @userId AND groupId = @dominoGrpId)
		BEGIN
			INSERT INTO UMUserGroup (userId, groupId, flag)
				VALUES (@userId, @dominoGrpId, 0)
		END
	END
END
--SET @userId = ISNULL((select id from umusers where login = @i_userLogIn and enabled =1), 0)
SELECT @userId = ISNULL(id, 0), @canonicalName = ISNULL(name, '') FROM UMUsers WHERE login = @i_userLogIn and enabled =1
-- Update last login time and email
IF @userId > 0
BEGIN
	UPDATE UMUsers SET lastLogInTime = dbo.GetUnixTime (GetUTCdate()) WHERE id=@userId
	IF(@i_updateSmtp=1 AND ISNULL(@i_userEMail,'') <> '')
		UPDATE UMUsers SET email= @i_userEMail WHERE id=@userId
	IF (ISNULL(@i_canonicalName,'') <> '') AND (@canonicalName<>@i_canonicalName)
		UPDATE UMUsers SET name= @i_canonicalName WHERE id=@userId
	-- CMR 222531/226837: Do not create a new entry in UMUsers if AD user login failed due to security failure. Also deny login if user does not have credentials same as Java GUI login.
	-- Logic copied from EvSecurityMgr::userLogin in EvSecurityGui.cpp (Java GUI login).
	IF NOT EXISTS (SELECT 1 FROM GxGlobalParam (NOLOCK) WHERE name = 'nAllowUserWithoutRightToLogin' AND value = '1' AND modified = 0)
	BEGIN
		DECLARE @canLogin INT = 0
		EXEC sec_canLogin @userId, @canLogin OUTPUT
		IF @canLogin = 0
		BEGIN
SET @o_errorCode = (3548 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode and localeid = 0)			-- we do not have a localeID passed into this SP.
			SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId))
			-- Check if this AD user entry has been added just now. If so, delete his entry.
IF NOT EXISTS (SELECT 1 FROM GxGlobalParam (NOLOCK) WHERE name = 'nDonotCreateUserOnCredentialFailure'	AND value = '0' AND modified = 0)
			BEGIN
				DELETE FROM UMUserGroup WHERE userId = @userId
				DELETE FROM UMDSUserGroup WHERE userID = @userID
				-- If he is a newly added entry, delete him.
IF EXISTS (SELECT 1 FROM UMUsersProp (NOLOCK) WHERE componentNameId = @userID AND attrName = 'AD user created during login' AND created = @createTime)
				BEGIN
					DELETE FROM UMUsers WHERE id = @userId
				END
				-- If he was already present with Deleted state, retain him as Deleted. (Sometimes, these historical records need to be preserved as in Cloud. So playing it safe, just roll back the current changes)
				ELSE IF @isUserReinstated = 1
				BEGIN
					UPDATE UMUsers
					SET login = @i_userLogIn + '(Deleted,' + CAST(@userId AS VARCHAR(10)) + ')',
						email =  'Email Disabled',
						password = 'Password Disabled',
						flags = 0,
						enabled = 0
					WHERE id = @userId
				END
				SET @o_userID = 0
				SET @o_userCap = 0
			END
			SELECT 0 as 'clientId', '' AS 'clientName', 0 AS 'appTypeId', 0 AS 'subclientId', 0 AS 'commcellNumber', 0 AS 'isPrimary', 0 AS 'isSecondary', 0 AS 'caseClient', 0 AS 'idxAppTypeId'
			WHERE 1 = 2		-- The SP requires this as output.
			RETURN			-- Return from here itself, as userId might be removed. Continuing would try to invoke Security SPs with deleted userId.
		END
	END
END
	-- Update user cache table
	IF @i_isSearch = 0
	BEGIN
		EXEC sec_updateUserCredentials @userId
		-- Get user capabilities in output parameter
		INSERT INTO #t_userCaps
		EXECUTE GetUserCapabilities @userId
		SET @o_userCap = ISNULL((SELECT TOP(1) caps FROM #t_userCaps), 0)
		SELECT 0 as 'clientId', '' AS 'clientName', 0 AS 'appTypeId', 0 AS 'subclientId', 0 AS 'commcellNumber', 0 AS 'isPrimary', 0 AS 'isSecondary', 0 AS 'caseClient', 0 AS 'idxAppTypeId'
		WHERE 1 = 2
	END
	ELSE
		BEGIN
			-----------------------------------------------------------------------------------------------------------------------------
DECLARE	@SUBCLIENT_ENTITY int = 7
DECLARE	@TMP_CLIENT INT = 3
DECLARE	@TMP_SUBCLIENT INT = 7
			-- In case of an incremental permission pull occurs, then this temp table used as the user doesn't logout and login in such case
			IF OBJECT_ID('tempdb.dbo.#SubClientsOutputTable') IS NOT NULL
			BEGIN
				DROP TABLE #SubClientsOutputTable
			END
			CREATE TABLE #SubClientsOutputTable
			(
				clientID INT,
				appTypeId INT,
				instanceId INT,
				backupsetID INT,
				subclientId INT
			)
			-- check if request is for incremental permission on only given sub client or client
			INSERT INTO #tmpFilters
			SELECT @TMP_SUBCLIENT, ISNULL(ref.value('@val', 'INT'), 0)
			FROM @i_xmlText.nodes('/DM2ContentIndexing_CVGalaxySecurityGroup/appIdList') A(ref)
			-- if subclient list is not given, use input clients
			--
			IF NOT EXISTS (SELECT 1 FROM #tmpFilters)
			BEGIN
				INSERT INTO #tmpFilters
				SELECT @TMP_CLIENT, ISNULL(ref.value('@clientId', 'INT'), 0)
				FROM @i_xmlText.nodes('/DM2ContentIndexing_CVGalaxySecurityGroup/clients') A(ref)
			END
			ELSE
			BEGIN
				--get all permissions under clients corresponding to requested sub clients..
				--
				INSERT INTO #tmpFilters
				SELECT DISTINCT @TMP_CLIENT, A.ClientID FROM APP_Application A, #tmpFilters B
				WHERE A.ID = B.id AND filterType = @TMP_SUBCLIENT
			END
			IF EXISTS (SELECT 1 FROM #tmpFilters where id > 0)
			BEGIN
				SELECT @i_xmlText = N''
				exec sec_getIdaObjectsForUser @userId, @SUBCLIENT_ENTITY, @i_capability, 0, '#SubClientsOutputTable'
				DECLARE @ccn INT
				SELECT @ccn = number FROM APP_Commcell WHERE id = 2
				SELECT DISTINCT SO.clientId,
				c.name as clientName,
				SO.appTypeId,
				SO.subclientId,
				@ccn as commcellNumber, 0 as isPrimary, 0 as isSecondary,
				caseClient = CASE WHEN EXISTS (select id from CMDefinition where clientId = SO.clientId) THEN 1 ELSE 0 END,
				idxAppTypeId = ISNULL(IdxInfo.type, SO.appTypeId)
				FROM #tmpFilters I
				JOIN #SubClientsOutputTable SO ON I.id = SO.clientID
				JOIN APP_Client C ON SO.clientID = C.id
				LEFT OUTER JOIN App_IndexDBInfo IdxInfo ON IdxInfo.backupSetId = SO.backupsetID
				WHERE I.filterType = @TMP_CLIENT AND I.id > 0
				GOTO CV_EXIT
			END
		IF object_id('tempdb.dbo.#sec_ADUserLogin_UserObjects') is not null DROP TABLE #sec_ADUserLogin_UserObjects
create table  #sec_ADUserLogin_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 2013, 0, '#sec_ADUserLogin_UserObjects'
		INSERT INTO #userObjects
		SELECT DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId
		FROM	#sec_ADUserLogin_UserObjects sec
		WHERE 	(@i_capability = 0 OR (capabilities & POWER(2, @i_capability-1)) > 0) AND ( clientId > 0 OR
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
		DROP TABLE #sec_ADUserLogin_UserObjects
		-- Get user capabilities in output parameter
		INSERT INTO #t_userCaps
		EXECUTE GetUserCapabilities @userId
		SET @o_userCap = ISNULL((SELECT TOP(1) caps FROM #t_userCaps), 0)
		-----------------------------------------------------------------------------------------------------------------------------
		-- using this table as temptable to store all subclient Ids
		-- -- which has CI enabled
		-- -- which has association to a datasource
		-- -- of which client has association to a datasource or CI enabled
		-- -- of which backupset has association to a datasource
		-- this temp table is needed to simplify the previous query and improve query performance, since nested query (which was used before this change) takes time
		IF OBJECT_ID('TempDb..#AppPropSet') IS NOT NULL
			DROP TABLE #AppPropSet
		CREATE TABLE #AppPropSet (
			scId		INT PRIMARY KEY
		)
		IF (@i_isSearch = 1)
		BEGIN
			INSERT INTO #AppPropSet (scId)
				SELECT
					A.id
				FROM APP_Application A
					INNER JOIN APP_ClientProp P ON
						P.componentNameId = A.clientId
						AND P.attrName IN (N'Content Indexing Enabled', N'Indexing datasource id')
						AND P.attrval <> '0'
						AND P.modified = 0
				UNION
				SELECT
					A.id
				FROM APP_Application A
					INNER JOIN APP_SubClientProp P ON
						P.componentNameId = A.id
						AND P.attrName = N'Indexing datasource id'
						AND P.cs_attrName = CHECKSUM(N'Indexing datasource id')
						AND P.attrval <> '0'
						AND P.modified = 0
				UNION
				SELECT
					A.id
				FROM APP_Application A
					INNER JOIN APP_BackupSetProp P ON
						P.componentNameId = A.id
						AND P.attrName = N'Indexing datasource id'
						AND P.attrval <> '0'
						AND P.modified = 0
		END
		----------------------------------------------------------------------------------------------------------------------------------
		-- filter non-windows clients for end user search
		-- filter out client without CI-enabled
		INSERT INTO #appIdTbl
		SELECT	A.id, clientId, appTypeId, instance, backupset
		FROM	APP_application A
		INNER JOIN APP_BackupSetName BS ON A.backupSet = BS.id
WHERE	(appTypeId in (93,  105, 137)
		OR EXISTS(SELECT 1 FROM App_IndexDBInfo where backupSetGUID = BS.GUID AND idxDbEngineType = 2) -- Indexing V2 Solr Engine
			OR 	(@i_isSearch = 2
					-- simplify the nested query (which was used before this change) to query from temp table #AppPropSet
					OR EXISTS (SELECT scId FROM #AppPropSet WHERE scId = A.id)
				)
			)
			AND
(@i_capability <> 24 OR
(@i_capability = 24 AND A.clientId in
					(select	C.id
					 from	APP_Client C, simOperatingSystem S
					 where	C.simOperatingSystemId = S.id and (S.type = 'Windows' OR S.SubType = 'NAS')))) -- For end user, any windows or NAS filer are supported
		----------------------------------------------------------------------------------------------------------------------------------
		-- dropping temp table #AppPropSet after done using it
		IF OBJECT_ID('TempDb..#AppPropSet') IS NOT NULL
			DROP TABLE #AppPropSet
		----------------------------------------------------------------------------------------------------------------------------------
		INSERT INTO #appIdTbl
SELECT	id, clientId, 1110, instance, backupset
		FROM	APP_application A
		WHERE	(
				EXISTS (select 1 from App_ClientProp where componentNameId = A.clientId and attrName='SharePoint Online Content Indexing' and attrval <> '0' and modified = 0)
			)
			AND
(@i_capability <> 24 OR
(@i_capability = 24 AND A.clientId in
					(select	C.id
					 from	APP_Client C, simOperatingSystem S
					 where	C.simOperatingSystemId = S.id and (S.type = 'Windows' OR S.SubType = 'NAS')))) -- For end user, any windows or NAS filer are supported
		-- For Domino login return following:
		-- 		- All subclients with apptype CV_APPTYPE_NOTES_DOC_DATA_MIGRATOR AND UNUSED_CV_APPTYPE_52 [Content Indexing does not need to be enabled]
		--		- All other clients with Content Indexing enabled
		IF EXISTS( select 1 from UMDSProviders where @i_capability = 24 and domainName = @i_domainName and serviceType = 3 )
		BEGIN
			INSERT #tmpClientTbl
			SELECT	DISTINCT 	clientId	= A.clientId,
			clientName  = ISNULL((select name from APP_Client where id = A.clientId),''),
			appTypeId	= A.appTypeId,
			subclientId	= A.id,
			commcellNumber  = (select number from APP_Commcell where id = 2),
			isPrimary	=  0,
			isSecondary	= 0,
			backupSetId = A.backupSet,
			caseClient = CASE WHEN EXISTS (select id from CMDefinition where clientId = A.clientId) THEN 1 ELSE 0 END,
			idxAppTypeId = ISNULL(I.type, A.appTypeId)
			FROM APP_Application A
			INNER JOIN APP_BackupSetName BS ON A.backupSet = BS.id
			LEFT OUTER JOIN App_IndexDBInfo I ON I.backupSetId = A.backupset
WHERE (A.appTypeId in (90, 52, 137)
			OR EXISTS(SELECT 1 FROM App_IndexDBInfo where backupSetGUID = BS.GUID AND idxDbEngineType = 2) -- Indexing V2 Solr Engine
				OR (@i_isSearch = 2 OR (@i_isSearch = 1 AND EXISTS (select id from APP_ClientProp where componentNameId=A.clientId and attrName=N'Content Indexing Enabled' and attrval <> '0' AND modified = 0 ))))
		END
		-- For AD and CC login return following:
		-- 		- All subclients with apptype CV_APPTYPE_CONTENT_INDEXING_IDA AND CV_APPTYPE_OCI_EXCH_MB_IDA [Content Indexing does not need to be enabled]
		--		- All clients with Content Indexing enabled
		--		- All clients with Sharepoint online content indexing enabled
		ELSE IF EXISTS (select * from #appIdTbl)
		INSERT #tmpClientTbl
		SELECT	DISTINCT 	clientId	= A.clientId,
			clientName  = ISNULL((select name from APP_Client where id = A.clientId),''),
			appTypeId	= A.appTypeId,
			subclientId	= (CASE WHEN T.instanceId = 0 OR T.backupsetId = 0 OR T.subClientId = 0 THEN A.id ELSE T.subClientId END),
			commcellNumber  = (select number from APP_Commcell where id = T.commCellId),
isPrimary	= ISNULL((select count(1) from APP_application where clientId=A.clientId and appTypeId=93), 0),
			isSecondary	= ISNULL((select count(1) from APP_ClientProp where componentNameId=A.clientId and attrName='Content Indexing Enabled'), 0),
			backupSetId = A.backupSet,
			caseClient = CASE WHEN EXISTS (select id from CMDefinition where clientId = A.clientId) THEN 1 ELSE 0 END,
			idxAppTypeId = ISNULL(I.type, A.appTypeId)
		FROM	#userObjects T, #appIdTbl A LEFT OUTER JOIN App_IndexDBInfo I ON I.backupSetId = A.backupset
		WHERE	(T.clientId = 0 OR T.clientId = A.clientId) AND
			(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
			(T.instanceId = 0 OR T.instanceId = A.instance) AND
			(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
			(T.subClientId = 0 OR T.subClientId = A.id)
		ORDER BY clientId, appTypeId, subclientId
		-- Do filteration based on input client, client group and backup set ids
		INSERT INTO #tmpFilters
		SELECT 2, ref.value('@val', 'INT')
		FROM  @i_xmlText.nodes ('DM2ContentIndexing_CVGalaxySecurityGroup/securityFilters[@field="BackupSet"]/fieldValues/values') R(ref)
		INSERT INTO #tmpFilters
		SELECT 1, ref.value('@val', 'INT')
		FROM  @i_xmlText.nodes ('DM2ContentIndexing_CVGalaxySecurityGroup/securityFilters[@field="Client"]/fieldValues/values') R(ref)
		INSERT INTO #tmpFilters
		SELECT 1, clientId
		FROM APP_ClientGroupAssoc WHERE clientGroupId in (
			SELECT ref.value('@val', 'INT')
			FROM  @i_xmlText.nodes ('DM2ContentIndexing_CVGalaxySecurityGroup/securityFilters[@field="ClientGroup"]/fieldValues/values') R(ref)
		)
		IF EXISTS (SELECT * FROM #tmpFilters WHERE filterType = 2)
		BEGIN
			SELECT DISTINCT clientId, clientName, appTypeId, subclientId, commcellNumber, isPrimary, isSecondary,caseClient, idxAppTypeId
			FROM #tmpClientTbl T1 INNER JOIN #tmpFilters T2 ON T1.backupSetId = T2.id AND filterType = 2
		END
		ELSE IF EXISTS (SELECT * FROM #tmpFilters WHERE filterType = 1)
		BEGIN
			SELECT DISTINCT clientId, clientName, appTypeId, subclientId, commcellNumber, isPrimary, isSecondary,caseClient, idxAppTypeId
			FROM #tmpClientTbl T1 INNER JOIN #tmpFilters T2 ON T1.clientId = T2.id
		END
		ELSE
		BEGIN
			SELECT DISTINCT clientId, clientName, appTypeId, subclientId, commcellNumber, isPrimary, isSecondary,caseClient, idxAppTypeId
			FROM #tmpClientTbl
		END
	END
CV_EXIT:
SET @o_userId = @userId
DROP TABLE #userObjects
DROP TABLE #appIdTbl
DROP TABLE #tmpClientTbl
DROP TABLE #tmpFilters
DROP TABLE #t_userCaps
IF OBJECT_ID('tempdb.dbo.#SubClientsOutputTable') IS NOT NULL
BEGIN
	DROP TABLE #SubClientsOutputTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_ADUserLogin')
	delete from GxQscripts where name = 'sec_ADUserLogin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ADUserLogin')
	delete from GXDBVersions where aliasname = 'sec_ADUserLogin'
GO

insert into GXDBVersions values(2, 'sec_ADUserLogin',  '00010067000200420000', 'sec_ADUserLogin', '00010067000200420000')
GO

