

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/saveCustomReportUserAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/saveCustomReportUserAssociation.sp,v $ $Id: saveCustomReportUserAssociation.sp,v 1.2.88.1 2018/03/22 00:57:09 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: saveCustomReportUserAssociation
--  |
--  | Description:
--  |  Add custom report id to table UMUserandGroupEntityAssociation with the details of the user associated
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        schakka   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: saveCustomReportUserAssociation <<<'

IF EXISTS (select * from sysobjects where name='saveCustomReportUserAssociation')
	drop procedure saveCustomReportUserAssociation
IF EXISTS (select * from GxQscripts where name='saveCustomReportUserAssociation')
	delete from GxQscripts where name = 'saveCustomReportUserAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='saveCustomReportUserAssociation')
	delete from GXDBVersions where aliasname = 'saveCustomReportUserAssociation'
GO
print '... Creating Procedure: saveCustomReportUserAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure saveCustomReportUserAssociation
  @i_customReportId INTEGER,
  @i_userId nVARCHAR(MAX),
  @i_groupId nVARCHAR(MAX),
  @i_providerId nVARCHAR(MAX),
  @i_ownerUserId INTEGER,
  @i_updateFlag INTEGER
AS
  DECLARE @o_retVal varchar(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ERRORSTR VARCHAR(MAX)=''
DECLARE @i_executeCapability BIGINT
select @i_executeCapability = CAST(POWER(2.0, 33-1) AS BIGINT)
BEGIN TRAN
IF @i_customReportId < 1
BEGIN
	SET @ERRORSTR = 'Invalid report id, failing..'
	GOTO PROC_EXIT;
END
IF @i_updateFlag = 1
BEGIN
	--Update flag is set, so we have to update the users of the custom report. so first we delete the entries, and then insert the new values
	DELETE FROM UMUserandGroupEntityAssociation
	WHERE entityType = 2900 AND objectId = @i_customReportId
END
IF @i_ownerUserId IS null OR @i_ownerUserId < 0
	SET	@i_ownerUserId = 0;
DECLARE @endIndex INTEGER =0
DECLARE @startIndex INTEGER =0
DECLARE @id integer
--2900 ->NEW EVENTTYPE FOR CUSTOM REPORT DEFINED IN Shared/CvLib/EvStatic.h
IF @i_userId IS NOT null AND @i_userId <> ''
BEGIN
	SET @i_userId = @i_userId + ',';
	SET @endIndex = CHARINDEX(',', @i_userId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_userId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = @id AND groupId = 0 AND providerId = 0 AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(@id, 0, 0, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_userId, @startIndex)
	END
END
SET @endIndex =0
SET @startIndex =0
SET @id = 0
IF @i_groupId IS NOT null AND @i_groupId <> ''
BEGIN
	SET @i_groupId = @i_groupId + ',';
	SET @endIndex = CHARINDEX(',', @i_groupId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_groupId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = 0 AND groupId = @id AND providerId = 0 AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(0, @id, 0, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_groupId, @startIndex)
	END
END
SET @endIndex =0
SET @startIndex =0
SET @id = 0
IF @i_providerId IS NOT null AND @i_providerId <> ''-- this clause needs to be SET properly(groupId should be retrieved)
BEGIN
	SET @i_providerId = @i_providerId + ',';
	SET @endIndex = CHARINDEX(',', @i_providerId, @startIndex)
	WHILE(@endIndex IS NOT null AND @endIndex <> 0)
	BEGIN
		SET @id = CAST(SUBSTRING(@i_providerId, @startIndex, @endIndex - @startIndex) AS INT)
		if(@id > 0)
		BEGIN
			IF NOT EXISTS(SELECT TOP 1 * FROM UMUserandGroupEntityAssociation
WHERE userId = 0 AND groupId = 0 AND providerId = @id AND capabilities = @i_executeCapability AND entityType = 2900 AND objectId = @i_customReportId)
				INSERT INTO UMUserandGroupEntityAssociation
				VALUES(0, 0, @id, @i_executeCapability, 2900, @i_customReportId, @i_ownerUserId);
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @i_providerId, @startIndex)
	END
END
DECLARE @error INT=0;
SELECT @error = @@ERROR
IF @error <> 0
BEGIN
    SET @errorStr = 'Error while INSERTING custom report related info into UMUserandGroupEntityAssociation'
    GOTO PROC_EXIT
END
IF @i_ownerUserId > 0
	exec sec_updateUserCredentials @i_ownerUserId, 1
PROC_EXIT:
	IF @ERRORSTR <> ''
	BEGIN
		SELECT @ERRORSTR
		ROLLBACK TRAN
	END
	ELSE
	BEGIN
		SELECT 'SUCCESS'
		COMMIT TRAN
	END
GO

IF EXISTS (select * from GxQscripts where name = 'saveCustomReportUserAssociation')
	delete from GxQscripts where name = 'saveCustomReportUserAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='saveCustomReportUserAssociation')
	delete from GXDBVersions where aliasname = 'saveCustomReportUserAssociation'
GO

insert into GXDBVersions values(2, 'saveCustomReportUserAssociation',  '00010002008800010000', 'saveCustomReportUserAssociation', '00010002008800010000')
GO

