

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptOptGetStoragePoliciesForResourcePoolRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptOptGetStoragePoliciesForResourcePoolRequest.sp,v $ $Id: rptOptGetStoragePoliciesForResourcePoolRequest.sp,v 1.5.60.5 2018/03/22 03:14:37 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetStoragePoliciesForResourcePoolRequest"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptOptGetStoragePoliciesForResourcePoolRequest <<<'

IF EXISTS (select * from sysobjects where name='rptOptGetStoragePoliciesForResourcePoolRequest')
	drop procedure rptOptGetStoragePoliciesForResourcePoolRequest
IF EXISTS (select * from GxQscripts where name='rptOptGetStoragePoliciesForResourcePoolRequest')
	delete from GxQscripts where name = 'rptOptGetStoragePoliciesForResourcePoolRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetStoragePoliciesForResourcePoolRequest')
	delete from GXDBVersions where aliasname = 'rptOptGetStoragePoliciesForResourcePoolRequest'
GO
print '... Creating Procedure: rptOptGetStoragePoliciesForResourcePoolRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptOptGetStoragePoliciesForResourcePoolRequest
  @i_jobId integer,
  @o_id integer OUTPUT
AS
  DECLARE @o_policyId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_copyType integer;
  DECLARE @o_controlHostId integer;
  DECLARE @o_DFM NVARCHAR(1024);
  DECLARE @o_ExtRelationId integer;
  DECLARE @o_NodeId integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblSPs	TABLE (t_policyId int, t_copyId int)
DECLARE @userId		integer
-- ----------------------------------------------------------------------------
--   TEMPORARY TABLES
-- ----------------------------------------------------------------------------
-- Drop all Temporary tables I'll be using in case a stale Temporary Table is still in memory
if object_id('tempdb.dbo.#rptOptGetStoragePoliciesForResourcePoolRequest_OutTable') is not null DROP TABLE #rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
CREATE TABLE #rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
(
    ArchGroupId				int,
    ArchGroupName			nvarchar(288),
    CopyId					int,
    CopyName				nvarchar(128),
    CopyType				int,
    ControlHostId			int,
    DFM						nvarchar(2048),
    ExtRelationId           int,
    NodeId					int
)
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblSPs EXEC rptOptGetStoragePolicies @i_jobId, @o_id OUTPUT
IF (@o_id = 0)
BEGIN
	INSERT	INTO	#rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
	SELECT	AGC.archGroupId, AG.name, AGC.id, AGC.name, AGC.isMirrorCopy, CH.ControlHostId, CH.SMArrayId,
			(CASE WHEN ISNUMERIC(R.ExtRelationId) = 1 THEN CAST(R.ExtRelationId AS INTEGER) ELSE 0 END),
			(CASE WHEN ISNUMERIC(SRN.ExtNodeId) = 1 THEN CAST(SRN.ExtNodeId AS INTEGER) ELSE 0 END)
	FROM	archGroupCopy AGC, SMCopyToRelationMap CRM INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON CRM.SMRelationNodeId = SRN.SMRelationNodeId, SMControlHost CH, SMRelation R, ArchGroup AG
	WHERE	AGC.archGroupId = AG.id
			AND AGC.id <> AG.defaultSnapCopy
			AND isSnapCopy = 1
			AND AGC.id = CRM.ArchGroupCopyId
			AND CRM.ControlHostId = CH.ControlHostId
			AND CRM.SMRelationId = R.SMRelationId
END
ELSE IF (@o_id = 1)
BEGIN
	INSERT INTO	#rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
	SELECT	AGC.archGroupId, AG.name, AGC.id, AGC.name, AGC.isMirrorCopy, CH.ControlHostId, CH.SMArrayId,
			(CASE WHEN ISNUMERIC(R.ExtRelationId) = 1 THEN CAST(R.ExtRelationId AS INTEGER) ELSE 0 END),
			(CASE WHEN ISNUMERIC(SRN.ExtNodeId) = 1 THEN CAST(SRN.ExtNodeId AS INTEGER) ELSE 0 END)
	FROM	archGroupCopy AGC, @tblSPs T, SMCopyToRelationMap CRM INNER JOIN SMRelationNode SRN WITH (NOLOCK) ON CRM.SMRelationNodeId = SRN.SMRelationNodeId, SMControlHost CH, SMRelation R, ArchGroup AG
	WHERE	AGC.archGroupId = T.t_policyId
			AND (T.t_copyId = 0 OR
				 T.t_copyId = AGC.id)
			AND AGC.archGroupId = AG.id
			AND AGC.id <> AG.defaultSnapCopy
			AND isSnapCopy = 1
			AND AGC.id = CRM.ArchGroupCopyId
			AND CRM.ControlHostId = CH.ControlHostId
			AND CRM.SMRelationId = R.SMRelationId
END
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @o_id = 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#rptUserObjects'
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR libraryId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE #rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
	WHERE NOT EXISTS (select * from #rptUserObjects where ArchGroupId IN (0, ArchGroupId))
	DROP TABLE #rptUserObjects
END
SELECT *
FROM	#rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
-- ----------------------------------------------------------------------------
--   DROP TEMPORARY TABLES
-- ----------------------------------------------------------------------------
DROP TABLE #rptOptGetStoragePoliciesForResourcePoolRequest_OutTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptOptGetStoragePoliciesForResourcePoolRequest')
	delete from GxQscripts where name = 'rptOptGetStoragePoliciesForResourcePoolRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetStoragePoliciesForResourcePoolRequest')
	delete from GXDBVersions where aliasname = 'rptOptGetStoragePoliciesForResourcePoolRequest'
GO

insert into GXDBVersions values(2, 'rptOptGetStoragePoliciesForResourcePoolRequest',  '00010005006000050000', 'rptOptGetStoragePoliciesForResourcePoolRequest', '00010005006000050000')
GO

