

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptOptGetClientsForLM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptOptGetClientsForLM.sp,v $ $Id: rptOptGetClientsForLM.sp,v 1.2.88.2 2018/03/22 03:13:43 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptOptGetClients"										|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION		|
--	| AND RETURNING RESULTS													|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptOptGetClientsForLM <<<'

IF EXISTS (select * from sysobjects where name='rptOptGetClientsForLM')
	drop procedure rptOptGetClientsForLM
IF EXISTS (select * from GxQscripts where name='rptOptGetClientsForLM')
	delete from GxQscripts where name = 'rptOptGetClientsForLM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetClientsForLM')
	delete from GXDBVersions where aliasname = 'rptOptGetClientsForLM'
GO
print '... Creating Procedure: rptOptGetClientsForLM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptOptGetClientsForLM
  @i_jobId integer,
  @o_id integer OUTPUT
AS
  DECLARE @o_clientId integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblClients	TABLE (id int)
DECLARE @userId INT;
DECLARE @tblClientGrps	TABLE (id int)
DECLARE @tblOutlookAddinClients	TABLE (clientId int)
DECLARE @xmlText XML;
DECLARE @handle INT;
DECLARE @includeAll INT;
DECLARE @includeOutlookAddinClients INT;
SET @userId = (select id
			   from UMUsers with (NOLOCK)
where login in (select top 1 value from TM_JobOptions with (NOLOCK) where jobId=@i_jobId and optionId=120008   ))
SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
SET @includeOutlookAddinClients		= dbo.GetOptionInt(1742658279, @i_jobId, 0, 0)
-- Selection Status [o_id]: -1 - none; 0 - all; 1 - list
	SET @includeAll = ISNULL((SELECT TOP 1 includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList', 1) WITH (includeAll int)), 0)
	IF @includeAll = 0		--some clients selected
	BEGIN
		INSERT INTO @tblClients
		SELECT clientId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientList', 1) WITH (clientId int)
		INSERT INTO @tblClientGrps
		SELECT clientGroupId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList', 1) WITH (clientGroupId int)
		--To do: security check on client groups
		INSERT INTO @tblClients
		SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId in (SELECT id FROM @tblClientGrps)
		-- if selected, include outlook addin clients
		IF @includeOutlookAddinClients > 0
			INSERT INTO @tblClients
			SELECT componentNameId FROM APP_ClientProp
			WHERE attrName = 'Outlook Addin Client' AND attrVal ='1' AND modified = 0
		SET @o_id = (SELECT COUNT(*) FROM @tblClients)
		DECLARE    @o_idgroup integer = 0
		SET @o_idgroup  = (SELECT COUNT(*) FROM @tblClientGrps)
		if ((@o_id =0) AND (@o_idgroup>0))
			SET @o_id =-1
	END
	ELSE
		BEGIN		--all clients selected
			IF @includeOutlookAddinClients > 0
				SET @o_id = 0					--all
			ELSE
				BEGIN		--remove outlookaddinclients
					INSERT INTO @tblOutlookAddinClients
					SELECT componentNameId FROM APP_ClientProp
					WHERE attrName = 'Outlook Addin Client' AND attrVal ='1' AND modified = 0
					SET @o_id = (SELECT COUNT(*) FROM @tblOutlookAddinClients)
					IF @o_id > 0
						INSERT INTO @tblClients
						SELECT id FROM APP_Client
						WHERE id NOT IN (SELECT clientId FROM @tblOutlookAddinClients)
				END
		END
--Lets do security Check Here...
EXEC sp_xml_removedocument @handle
--GET LIST OF CLIENT  on which user has admin/agent cap
IF object_id('tempdb.dbo.#LMGetClient_UserObjects') is not null DROP TABLE #LMGetClient_UserObjects
create table  #LMGetClient_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2009, 0, '#LMGetClient_UserObjects'
DECLARE @two bigint =2
DECLARE @CapNeeded bigint=POWER(@two,1 -1)|POWER(@two,2  -1)
DELETE FROM #LMGetClient_UserObjects
where capabilities&@CapNeeded=0
DECLARE @tblSecurity table( clientId integer, clientName  nvarchar(255) ,deleted integer ,rights integer)
SELECT DISTINCT id FROM @tblClients C JOIN #LMGetClient_UserObjects temp on ( C.Id=  temp.clientId OR ( temp.commCellId=2 AND temp.clientGroupId=0 AND temp.clientId=0 AND temp.appTypeId=0 AND temp.instanceId=0 AND temp.backupsetId=0 AND temp.subClientId=0 AND temp.mediaAgentId=0 AND temp.libraryId=0 AND temp.archGroupId=0 AND temp.vtContainerId=0 AND temp.vtPolicyId=0 AND temp.vtShelfId=0 AND temp.reviewSetId=0 AND temp.querySetId=0 AND temp.downloadSetId=0 AND temp.ermId=0 AND temp.legalHoldId=0 AND temp.tagId=0 AND temp.cdPolicyId=0 AND temp.complianceReportId=0 AND temp.taskId=0 AND temp.workflowId=0 AND temp.logMonitoringPolicyId=0 AND temp.arrayId=0 AND temp.cloudId=0 AND temp.userGroupId=0 AND temp.providerId=0 AND temp.entityId1=0 AND temp.entityId2=0 AND temp.entityId3=0 AND temp.entityId4=0 AND temp.entityId5=0									AND temp.entityId6=0 AND temp.entityId7=0 AND temp.entityId8=0 AND temp.entityId9=0 ))
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'rptOptGetClientsForLM')
	delete from GxQscripts where name = 'rptOptGetClientsForLM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOptGetClientsForLM')
	delete from GXDBVersions where aliasname = 'rptOptGetClientsForLM'
GO

insert into GXDBVersions values(2, 'rptOptGetClientsForLM',  '00010002008800020000', 'rptOptGetClientsForLM', '00010002008800020000')
GO

