

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptOneDaySLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptOneDaySLA.sp,v $ $Id: rptOneDaySLA.sp,v 1.28.2.86.4.2 2021/03/20 05:41:29 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptOneDaySLA')
BEGIN
	print '>>> Drop Stored Procedure: RptOneDaySLA <<<'
	drop procedure RptOneDaySLA
END
IF EXISTS (select * from GxQscripts where name='RptOneDaySLA')
	delete from GxQscripts where name = 'RptOneDaySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptOneDaySLA')
	delete from GXDBVersions where aliasname = 'RptOneDaySLA'
GO
print '... Creating Procedure: RptOneDaySLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptOneDaySLA
-- Stored Procedure Inputs
  @i_date DATETIME,
  @i_days INT = -1,
  @i_flags INT = 0 -- 1 for returning slaDays in #tempSLA and #tempSLAClient tables
AS
SET NOCOUNT ON
/* Caller will create table #tempSLA
(
	date			date,
	clientId		int,
	appId			int,
	fullJobsOnly	int,
	appTypeId		int,
	status			int,
	category		int,
	lastSeenTime	int,
	slaDays			int,
	slaDaysLevel	varchar(32)
)
Caller will create table #tempSLAClient
(
	date			date,
	days			int,
	fullJobsOnly	int,
	clientId		int,
	isProtected		int,
	category		int,
	slaDays			int
)
*/
/*	SLA status
1	Protected
2	Unprotected
3	Excluded
*/
/*	SLA category
	-- Protected
1	Protected
13  Nothing to Backup
	-- Unprotected
2	Failed
3	No Job Found
4	No Schedule
9	Filtered VM
12  Snap with No Backup Copy
	-- Excluded
5	Backup Activity Disabled
6	Longtime Offline
7	De-configured
8	Excluded From SLA Property
10  Recently installed with no finished job
11  Excluded Server Type
*/
--Skip weekend for 1, 2, 3 and 5 day SLA
--#define CV_COMPONENT_COMMCELL_SLA_SKIP_WEEKEND 3319
DECLARE @SkipWeekend INT = 0
SELECT	@SkipWeekend = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3319 AND modified = 0
--#define CV_COMPONENT_COMMCELL_SLA_COUNT_VSA_AND_IDAs 3324
DECLARE @CountVSAAndIDAs INT = 0
SELECT	@CountVSAAndIDAs = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3324 AND modified = 0
--#define CV_COMPONENT_COMMCELL_SNAP_JOBS_QUALIFY_SLA 3303
DECLARE @SnapJobsQualifySLA INT = 0
SELECT	@SnapJobsQualifySLA = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3303 AND modified = 0
--#define CV_COMPONENT_COMMCELL_SNAP_MET_SLA_IF_BKPCOPY_DISABLED 3312
DECLARE @SnapMetSLAIfBackupCopyDisabled INT = 0
SELECT	@SnapMetSLAIfBackupCopyDisabled = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3312 AND modified = 0
CREATE TABLE #SnapArchGroup (ArchGrpId INT, BackupCopyEnabled INT, SnapVaultExists INT)
IF	@SnapJobsQualifySLA = 0
BEGIN
	INSERT	INTO #SnapArchGroup
	SELECT	AG.id, ISNULL(S.enabled, 0), 0
	FROM	archGroup AG WITH (NOLOCK)
			LEFT OUTER JOIN archMaterializeSnapshotProp S WITH (NOLOCK) ON AG.id = S.archGroupId
	WHERE	AG.defaultSnapCopy > 1
	UPDATE	T SET SnapVaultExists = 1
	FROM	#SnapArchGroup T
			INNER JOIN (
				SELECT	AG.id
				FROM	archGroup AG WITH (NOLOCK)
						INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId
				WHERE	AGC.isActive = 1 AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 0 AND AGC.id <> AG.defaultSnapCopy
				GROUP BY AG.id
			) S ON T.ArchGrpId = S.id
END
--#define CV_COMPONENT_COMMCELL_EXCLUDE_CMDLINE_FROM_SLA 3308
DECLARE @ExcludeCmdlineSubclients INT = 0
SELECT	@ExcludeCmdlineSubclients = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3308 AND modified = 0
--#define CV_COMPONENT_COMMCELL_SLA_GRACE_PERIOD_DAYS 3309
DECLARE @GracePeriodDays INT = -1 -- CommCell SLA option Grace Period for New Clients is not enabled. Use SLA days settings.
DECLARE	@maxCreationTime INT = 0
SELECT	@GracePeriodDays = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3309 AND modified = 0
IF	@GracePeriodDays > 0
	SET	@maxCreationTime = dbo.GetUnixTime(DATEADD(DAY, -@GracePeriodDays, GETUTCDATE()))
--#define CV_COMPONENT_COMMCELL_SLA_MAX_OFFLINE_DAYS 3310
-- If the global parameter is set to -1, not excluded longtime offline clients.
-- If the global parameter is set to a positive integer N, excluded longtime offline clients by N days.
-- Otherwise, excluded longtime offline clients by SLA days.
DECLARE	@maxOfflineDays	INT = NULL
DECLARE	@minLastSeen	INT = 0
SELECT	@maxOfflineDays = longVal
FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3310 AND modified = 0
IF	@maxOfflineDays IS NULL
	SELECT	@maxOfflineDays = CAST(value AS INT)
	FROM	GXGlobalParam WITH (NOLOCK)
	WHERE	name = 'Maximum offline days for SLA'
IF	ISNULL(@maxOfflineDays, 0) > 0
	SET	@minLastSeen = dbo.GetUnixTime(DATEADD(DAY, -@maxOfflineDays, GETUTCDATE()))
-- Only for EDC cells or exclude all EDC cells. No mixture. One capture time for all EDC cells.
DECLARE	@IgnoreEDCCommCells	INT = 0
DECLARE	@EDCDumpCaptureTime	INT = 0
DECLARE	@IsEDC				INT = 0
SELECT	@IgnoreEDCCommCells = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'IgnoreEDCCellsForSLA'
IF	@IgnoreEDCCommCells = 0
BEGIN
	SELECT	@EDCDumpCaptureTime = CAST(value AS INT)
	FROM	GXGlobalParam WITH (NOLOCK)
	WHERE	name = 'EDCDumpCaptureTime'
	IF	@EDCDumpCaptureTime > 0
		SET @IsEDC = 1
END
DECLARE @TblCommCell TABLE (id INT)
IF @IsEDC > 0
	INSERT INTO @TblCommCell SELECT id FROM APP_CommCell WHERE type >=100
ELSE
IF EXISTS (SELECT 1 FROM APP_CommCell WHERE id > 2)
    INSERT INTO @TblCommCell
    SELECT  DISTINCT origCCId
    FROM    APP_Application A WITH (NOLOCK)
            INNER JOIN (SELECT DISTINCT appId FROM JMBkpStats WITH (NOLOCK) WHERE commCellId = 2) S ON A.id = S.appId
ELSE
	INSERT INTO @TblCommCell SELECT 2
DECLARE @csClientId		INT = 2
DECLARE @csTimeZoneName NVARCHAR(255) = ''
SELECT	@csTimeZoneName = dbo.GetClientTimeZone(2)
IF ISNULL(@csTimeZoneName, '') = ''
BEGIN
	SELECT  @csTimeZoneName = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	SELECT	@csTimeZoneName = TimeZoneStdName
	FROM	SchedTimeZone WITH (NOLOCK)
	WHERE   TimeZoneName = SUBSTRING(@csTimeZoneName, CHARINDEX(':', @csTimeZoneName, CHARINDEX(':', @csTimeZoneName, 0) + 1) + 1, 255)
END
DECLARE	@dtBegin	DATETIME = dbo.LocalToUTCTime(@i_date, @csTimeZoneName)
DECLARE	@dtEnd		DATETIME = DATEADD(DAY, 1, @dtBegin)
DECLARE	@utBegin	INT = dbo.GetUnixTime(@dtBegin)
DECLARE	@utEnd		INT = dbo.GetUnixTime(@dtEnd)
-- ClientType: 1 for Server, 2 for Laptop, 4 for VM
CREATE TABLE #tblClient	(ClientId INT, ClientType INT, vsaAppId INT,
		BackupScheduled INT, Deconfigured INT, Disabled INT, Status INT, Category INT, LastSeenTime INT)
CREATE TABLE #tblSubclient	(ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, ArchGrpId INT,
		BackupScheduled INT, Deconfigured INT, Disabled INT, nCompletedJobs INT, nFailedJobs INT, nCompletedFullJobs INT, nFailedFullJobs INT,
		nCompletedSnapJobs INT, nCompletedFullSnapJobs INT)
-- Only installed clients and active VMs are counted for SLA. All these clients and VMs should be shown as Met SLA or Missed SLA or Excluded.
-- Installed clients
INSERT	INTO #tblClient
SELECT	DISTINCT C.id, 1+(C.status&0x1000)/0x1000, 0, 0, 0, 0, 0, 0, 0
FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN @TblCommCell CC ON C.origCCId = CC.id
		INNER JOIN APP_IDAName I WITH (NOLOCK) ON C.id = I.clientId AND (I.status&(2|4) = 0 OR I.appTypeId = 106 OR @IsEDC > 0)
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON C.id = CP.componentNameId AND CP.attrName = 'PlatformDeleted 4' AND CP.attrVal = '1' AND CP.modified = 0
WHERE	C.id > 1 AND (C.specialClientFlags&1 <> 1 OR @IsEDC > 0) AND (CP.componentNameId IS NULL OR I.appTypeId = 106 OR @IsEDC > 0)
-- Delete the physical machine on the cluster CS
DELETE FROM #tblClient WHERE ClientId IN (SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK) WHERE VMClientId = 2)
-- Active VMs
INSERT	INTO #tblClient
SELECT	DISTINCT C.id, 4, 0, 0, 0, 0, 0, 0, 0
FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN (
			SELECT	DISTINCT Q.clientId
			FROM	JMQinetixUpdateStatus Q WITH (NOLOCK)
					INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = Q.jobId AND B.commCellId = Q.commCellId
							 AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
							 AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768)
					INNER JOIN @TblCommCell CC ON B.commCellId = CC.id
			) VM ON C.id = VM.clientId
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.id = CP.componentNameId
			AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
		LEFT OUTER JOIN (
			SELECT	DISTINCT componentNameId
			FROM	APP_ClientProp WITH (NOLOCK)
			WHERE	attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
		) T ON C.id = T.componentNameId
WHERE	T.componentNameId IS NULL
CREATE INDEX Idx_tblClient_ClientId ON #tblClient(ClientId)
UPDATE	T SET Status = 3, Category = E.category
FROM	#tblClient T INNER JOIN RptSLAExclusion E WITH (NOLOCK) ON T.ClientId = E.clientId
WHERE	(E.appTypeId = 0 OR E.appTypeId = 106 AND T.ClientType = 4) AND E.category NOT IN (6, 10)
IF @IsEDC = 0
BEGIN
	UPDATE	T SET Status = 3, Category = 6
	FROM	#tblClient T INNER JOIN APP_Client C WITH (NOLOCK) ON T.ClientId = C.id
	WHERE	T.ClientType IN (1, 2) AND C.clientDescription LIKE '%offline%'
	-- Only use LastOnlineTime. LastOfflineTime will be set only by CCRReadiness check.
	UPDATE	T SET LastSeenTime = CCR.LastOnlineTime
	FROM	#tblClient T INNER JOIN CCRClientToClient CCR WITH (NOLOCK) ON T.ClientId = ToClientID AND FromClientID = @csClientId
	WHERE	T.ClientType = 2
	UPDATE	#tblClient SET LastSeenTime = S.servEndDate
	FROM	(SELECT	L.ClientId, MAX(B.servStartDate) AS servEndDate
			FROM	JMBkpStats B WITH (NOLOCK)
					INNER JOIN APP_Application A WITH (NOLOCK) ON B.appId = A.id
						AND B.opType IN (4, 18, 30, 43, 59, 65, 76, 87, 91, 98, 101)
						AND B.BkpLevel IN (1, 2, 4, 256, 1024, 32768)
						AND B.status IN (1, 3, 14)
					INNER JOIN #tblClient L ON A.clientId = L.ClientId
			WHERE	B.totalUncompBytes > 0 AND L.ClientType = 2 AND L.LastSeenTime = 0
			GROUP BY L.ClientId
			) S
	WHERE	#tblClient.ClientId = S.ClientId AND #tblClient.LastSeenTime < S.servEndDate
	UPDATE	T SET LastSeenTime = S.creationTime
	FROM	#tblClient T INNER JOIN
			(SELECT	componentNameId, MIN(created) AS creationTime
			FROM	APP_ClientProp CP WITH (NOLOCK)
					INNER JOIN (SELECT clientId FROM #tblClient WHERE ClientType = 2 AND LastSeenTime = 0) S ON CP.componentNameId = S.clientId
			WHERE	created > 0
			GROUP BY componentNameId) S ON T.ClientId = S.componentNameId
END
DELETE	T
FROM	#tblClient T
		INNER JOIN RptSLAExclusion E WITH (NOLOCK) ON T.ClientId = E.clientId
WHERE	E.category IN (7, 11) AND (E.appTypeId = 0 OR E.appTypeId = 106 AND T.ClientType = 4)
-- VSA Discover Subclient ID is saved in APP_ClientProp for V2
UPDATE	T SET vsaAppId = S.vsaAppId
FROM	#tblClient T
		INNER JOIN (
		SELECT	CP.componentNameId AS ClientId, CAST(CP.attrVal AS INT) AS vsaAppId,
				ROW_NUMBER() OVER (PARTITION BY CP.componentNameId ORDER BY CP.id DESC) AS RowNo
		FROM	#tblClient C INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.ClientId = CP.componentNameId
			AND	CP.attrName = 'VSA Discover Subclient ID' AND CP.modified =0
		WHERE	C.ClientType = 4 AND C.vsaAppId = 0
		) S ON T.ClientId = S.ClientId
WHERE	RowNo = 1 AND T.ClientType = 4
-- For VMs discovered before V2
UPDATE	T SET vsaAppId = BKP.appId
FROM	#tblClient T
		INNER JOIN (
			SELECT	J.clientId, MAX(J.jobId) AS jobId, J.commCellId
			FROM	JMQinetixUpdateStatus J WITH (NOLOCK)
					INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
			GROUP BY J.clientId, J.commCellId
		) QUS ON T.ClientId = QUS.clientId
		INNER JOIN JMBkpStats BKP WITH (NOLOCK) ON BKP.jobId = QUS.jobId AND BKP.commCellId = QUS.commCellId
WHERE	T.ClientType = 4 AND T.vsaAppId = 0
INSERT	INTO #tblSubclient
SELECT	A.clientId, A.appTypeId, A.instance, A.backupSet, A.id,
		CASE WHEN A.dataArchGrpId > 1 THEN A.dataArchGrpId ELSE A.logArchGrpId END,
		CASE WHEN @IsEDC > 0 THEN 1 ELSE 0 END,
		CASE WHEN @IsEDC > 0 THEN 0
			 WHEN ((A.subclientStatus & 6) = 0 OR A.modified > @utEnd) THEN 0
			 ELSE 1
		END AS Deconfigured,
		0, 0, 0, 0, 0, 0, 0
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN #tblClient C ON A.clientId = C.ClientId AND C.ClientType IN (1, 2)
WHERE	A.appTypeId < 600
	AND A.appTypeId NOT IN (72, 85, 127, 84, 107, 121, 122, 136)
	AND (A.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR A.subClientStatus&8 = 0)
	AND A.subclientStatus&(16|32) = 0
	AND A.id NOT IN (
		SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK)
		WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
			AND cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'), CHECKSUM(N'SILO Copy ID')) )
CREATE INDEX Idx_tblSubclient_ClientId ON #tblSubclient(ClientId)
CREATE INDEX Idx_tblSubclient_AppId ON #tblSubclient(AppId)
-- Exclude instances of Migrated SRM Agent
DELETE	#tblSubclient
FROM	APP_InstanceName INST WITH (NOLOCK)
WHERE	#tblSubclient.InstanceId = INST.id AND (INST.status & 2048) <> 0
-- Exclude all dummy instances of UNIX DB agents
DELETE	#tblSubclient
FROM	APP_InstanceName INST WITH (NOLOCK)
WHERE	#tblSubclient.InstanceId = INST.id AND (INST.status & 16) <> 0
	AND #tblSubclient.AppTypeId IN (3,22,37,61,62,79,80,103,104,128,135)
-- Exclude all dummy backupsets of UNIX DB agents
DELETE	#tblSubclient
FROM	APP_BackupSetName BS WITH (NOLOCK)
WHERE	#tblSubclient.BackupsetId = BS.id AND (BS.status & 16) <> 0
	AND #tblSubclient.AppTypeId IN (3,22,37,61,62,79,80,103,104,128,135)
-- Exclude all hidden backupsets of SAP HANA agents
DELETE	#tblSubclient
FROM	APP_BackupSetName BS WITH (NOLOCK)
WHERE	#tblSubclient.BackupsetId = BS.id AND (BS.status & 32) <> 0
	AND #tblSubclient.AppTypeId = 135
-- Exclude subclients with no mailbox associated for new exchange agent (appType 137)
DELETE	T
FROM	#tblSubclient T
		LEFT OUTER JOIN APP_EmailConfigPolicyAssoc E WITH (NOLOCK) ON T.AppId = E.subClientId
WHERE	T.AppTypeId = 137 AND E.subClientId IS NULL
-- Exclude all subclients of de-configured agents
DELETE	T
FROM	#tblSubclient T
		INNER JOIN APP_iDAName I WITH (NOLOCK) ON T.ClientId = I.clientId AND T.AppTypeId = I.appTypeId
WHERE	I.status&(2|4) > 0 AND T.Deconfigured <> 1
DELETE	S
FROM	#tblSubclient S INNER JOIN #tblClient C ON S.ClientId = C.ClientId
WHERE	S.AppTypeId <> 106 AND C.ClientType <> 4 AND C.status = 3 AND C.category NOT IN (6, 10)
DELETE	S
FROM	#tblSubclient S INNER JOIN RptSLAExclusion E WITH (NOLOCK) ON S.ClientId = E.clientId
WHERE	E.appTypeId IN (0, S.AppTypeId) AND E.instanceId IN (0, S.InstanceId) AND E.appId IN (0, S.AppId)
	AND E.category NOT IN (6, 10)
-- Exclude clients that all subclients are excluded
DELETE	C
FROM	#tblClient C
		LEFT OUTER JOIN #tblSubclient S ON S.ClientId = C.ClientId AND S.AppTypeId <> 106
WHERE	C.ClientType <> 4 AND S.ClientId IS NULL
-- Add missing VSA subclients
INSERT	INTO #tblSubclient (ClientId, AppTypeId, InstanceId, BackupsetId, AppId, ArchGrpId, BackupScheduled)
SELECT	A.clientId, A.appTypeId, A.instance, A.backupset, A.id, 0, 0
FROM	APP_Application A WITH (NOLOCK)
		LEFT OUTER JOIN RptSLAExclusion E WITH (NOLOCK) ON A.ClientId = E.clientId AND E.category IN (5,7,8)
		LEFT OUTER JOIN #tblSubclient S ON A.id = S.appId AND A.clientId = S.clientId
WHERE	A.id IN (SELECT DISTINCT vsaAppId FROM #tblClient WHERE ClientType = 4)
	AND E.clientId IS NULL AND S.clientId IS NULL
-- UPDATE #tblSubclient SET BackupScheduled = 1 for subclients having backup scheduled
IF @IsEDC = 0
	EXEC RptBackupScheduledSubclients 0
-- Set BackupScheduled for VMs
UPDATE	C SET BackupScheduled = 1
FROM	#tblClient C
		INNER JOIN #tblSubclient S ON C.vsaAppId = S.AppId
WHERE	C.ClientType = 4 AND S.BackupScheduled = 1
UPDATE	#tblSubclient
SET		nCompletedJobs = T.nCompletedJobs, nFailedJobs = T.nFailedJobs, nCompletedFullJobs = T.nCompletedFullJobs, nFailedFullJobs = T.nFailedFullJobs
FROM	(SELECT	appId,
				SUM(CASE WHEN (status IN (1, 14) OR status = 3 AND isCWEjobValid = 1) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) THEN 1 ELSE 0 END) AS nCompletedJobs,
				SUM(CASE WHEN (status NOT IN (1, 3, 14) OR status = 3 AND isCWEjobValid = 0) THEN 1 ELSE 0 END) AS nFailedJobs,
				SUM(CASE WHEN (status IN (1, 14) OR status = 3 AND isCWEjobValid = 1) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) AND bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullJobs,
				SUM(CASE WHEN (status NOT IN (1, 3, 14) OR status = 3 AND isCWEjobValid = 0) AND bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nFailedFullJobs,
				SUM(CASE WHEN (status IN (1, 14) OR status = 3 AND isCWEjobValid = 1) AND opType IN (59, 65) THEN 1 ELSE 0 END) AS nCompletedSnapJobs,
				SUM(CASE WHEN (status IN (1, 14) OR status = 3 AND isCWEjobValid = 1) AND opType IN (59, 65) AND bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullSnapJobs
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN APP_iDAType I WITH (NOLOCK) ON B.appType = I.type
				INNER JOIN @TblCommCell CC ON B.commCellId = CC.id
		WHERE	servStartDate >= @utBegin AND servStartDate < @utEnd AND bkpLevel IN (1, 2, 4, 256, 1024, 32768)
			AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND failureErrorCode <> 8
		GROUP BY appId) T
WHERE	#tblSubclient.appId = T.appId AND (#tblSubclient.Deconfigured = 0 AND #tblSubclient.Disabled = 0 OR T.nCompletedJobs > 0)
-- Forever running jobs with optype 116 (STATELESS_BACKUP)
UPDATE	T SET nCompletedJobs = 1
FROM	#tblSubclient T
		INNER JOIN JMBkpJobInfo B WITH (NOLOCK) ON T.AppId = B.applicationId
		INNER JOIN JMJobInfo J WITH (NOLOCK) ON B.jobId = J.jobId AND B.commcellId = J.commCellId AND J.opType = 116
		LEFT OUTER JOIN APP_SubclientProp SP WITH (NOLOCK) ON B.applicationId = SP.componentNameId
			AND SP.attrName = 'Last Data Protected Time' AND SP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
			AND SP.modified = 0
WHERE	J.lastUpdateFromClient BETWEEN @utBegin AND @utEnd OR ISNULL(CAST(SP.attrVal AS INT), 0) BETWEEN @utBegin AND @utEnd
DELETE	#tblSubclient WHERE AppTypeId = 106
-- For running VSA backup jobs that the individual VM jobs are complete.
INSERT	INTO #tblSubclient
SELECT	T.ClientId, 106, 0, 0, T.vsaAppId, 0, T.BackupScheduled, T.Deconfigured, T.Disabled,
		ISNULL(nCompletedJobs, 0), ISNULL(nFailedJobs, 0), ISNULL(nCompletedFullJobs, 0), ISNULL(nFailedFullJobs, 0), ISNULL(nCompletedSnapJobs, 0), ISNULL(nCompletedFullSnapJobs, 0)
FROM	#tblClient T
		LEFT OUTER JOIN (
		SELECT	V.clientId,
				SUM(CASE WHEN V.status IN (0, 3) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) THEN 1 ELSE 0 END) AS nCompletedJobs,
				SUM(CASE WHEN V.status NOT IN (0, 3) THEN 1 ELSE 0 END) AS nFailedJobs,
				SUM(CASE WHEN V.status IN (0, 3) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) AND B.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullJobs,
				SUM(CASE WHEN V.status NOT IN (0, 3) AND B.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nFailedFullJobs,
				SUM(CASE WHEN V.status IN (0, 3) AND opType IN (59, 65) THEN 1 ELSE 0 END) AS nCompletedSnapJobs,
				SUM(CASE WHEN V.status IN (0, 3) AND opType IN (59, 65) AND bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullSnapJobs
		FROM	JMJobInfo J WITH (NOLOCK)
				INNER JOIN JMBkpJobInfo B WITH (NOLOCK) ON J.jobId = B.jobId AND J.commCellId = B.commcellId
				INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON V.jobId = B.jobId AND V.commCellId = B.commCellId
		WHERE	J.jobStartTime >= @utBegin AND J.jobStartTime < @utEnd AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768)
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		GROUP BY V.clientId
		) S ON T.ClientId = S.clientId
WHERE	T.ClientType = 4
INSERT	INTO #tblSubclient
SELECT	T.ClientId, 106, 0, 0, T.vsaAppId, 0, T.BackupScheduled, T.Deconfigured, T.Disabled,
		ISNULL(nCompletedJobs, 0), ISNULL(nFailedJobs, 0), ISNULL(nCompletedFullJobs, 0), ISNULL(nFailedFullJobs, 0), ISNULL(nCompletedSnapJobs, 0), ISNULL(nCompletedFullSnapJobs, 0)
FROM	#tblClient T
		LEFT OUTER JOIN (
		SELECT	V.clientId,
				SUM(CASE WHEN B.status IN (1, 3, 14) AND V.status IN (0, 3) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) THEN 1 ELSE 0 END) AS nCompletedJobs,
				SUM(CASE WHEN (B.status NOT IN (1, 3, 14) OR V.status NOT IN (0, 3)) THEN 1 ELSE 0 END) AS nFailedJobs,
				SUM(CASE WHEN B.status IN (1, 3, 14) AND V.status IN (0, 3) AND (opType NOT IN (59, 65) OR B.jobIdActedOn = B.jobId) AND B.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullJobs,
				SUM(CASE WHEN (B.status NOT IN (1, 3, 14) OR V.status NOT IN (0, 3)) AND B.bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nFailedFullJobs,
				SUM(CASE WHEN B.status IN (1, 3, 14) AND V.status IN (0, 3) AND opType IN (59, 65) THEN 1 ELSE 0 END) AS nCompletedSnapJobs,
				SUM(CASE WHEN B.status IN (1, 3, 14) AND V.status IN (0, 3) AND opType IN (59, 65) AND bkpLevel IN (1, 1024, 32768) THEN 1 ELSE 0 END) AS nCompletedFullSnapJobs
		FROM	JMBkpStats B WITH (NOLOCK)
				INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON V.jobId = B.jobId AND V.commCellId = B.commCellId
		WHERE	B.servStartDate >= @utBegin AND B.servStartDate < @utEnd AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768)
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND B.failureErrorCode <> 8
		GROUP BY V.clientId
		) S ON T.ClientId = S.clientId
		LEFT OUTER JOIN (SELECT DISTINCT ClientId FROM #tblSubclient WHERE AppTypeId = 106) R ON T.ClientId = R.ClientId
WHERE	T.ClientType = 4 AND R.ClientId IS NULL
UPDATE	S SET ArchGrpId = CASE WHEN A.dataArchGrpId > 1 THEN A.dataArchGrpId ELSE A.logArchGrpId END
FROM	#tblSubclient S
		INNER JOIN APP_Application A ON S.AppId = A.id
WHERE	S.AppTypeId = 106
-- Status/category 1 and 2 should be saved in RptSLA table even when the client is excluded by user in case the exclusion is cancelled later.
-- Excluded status/category should be returned in #tempSLA table.
-- Status column holds the values of category not considering user's exclusion from SLA
-- Category column holds the values of category considering user's exclusion from SLA
INSERT	INTO #tempSLA (date, clientId, appId, fullJobsOnly, appTypeId, status, category, lastSeenTime)
SELECT	@i_date, T.ClientId, T.AppId, 0, T.AppTypeId,
		CASE WHEN C.Status = 3 AND C.Category <> 10	THEN 3
			 WHEN T.nCompletedJobs > 0		THEN 1
			 WHEN T.nCompletedSnapJobs > 0	THEN 12
			 WHEN T.nFailedJobs > 0			THEN 2
			 WHEN T.Deconfigured > 0		THEN 7
			 WHEN T.Disabled > 0			THEN 5
			 WHEN T.BackupScheduled = 0		THEN 4
			 ELSE 3
		END,
		CASE WHEN C.Status = 3 AND C.Category <> 10	THEN C.Category
			 WHEN T.nCompletedJobs > 0		THEN 1
			 WHEN T.nCompletedSnapJobs > 0	THEN 12
			 WHEN T.nFailedJobs > 0			THEN 2
			 WHEN T.Deconfigured > 0		THEN 7
			 WHEN T.Disabled > 0			THEN 5
			 WHEN T.BackupScheduled = 0		THEN 4
			 ELSE 3
		END,
		C.LastSeenTime
FROM	#tblSubclient T
		INNER JOIN #tblClient C ON T.ClientId = C.ClientId
			AND (T.AppTypeId = 106 AND C.ClientType = 4 OR T.AppTypeId <> 106 AND C.ClientType <> 4)
INSERT	INTO #tempSLA (date, clientId, appId, fullJobsOnly, appTypeId, status, category, lastSeenTime)
SELECT	@i_date, T.ClientId, T.AppId, 1, T.AppTypeId,
		CASE WHEN C.Status = 3 AND C.Category <> 10	THEN 3
			 WHEN T.nCompletedFullJobs > 0	THEN 1
			 WHEN T.nCompletedFullSnapJobs > 0	THEN 12
			 WHEN T.nFailedFullJobs > 0		THEN 2
			 WHEN T.Deconfigured > 0		THEN 7
			 WHEN T.Disabled > 0			THEN 5
			 WHEN T.BackupScheduled = 0		THEN 4
			 ELSE 3
		END,
		CASE WHEN C.Status = 3 AND C.Category <> 10	THEN C.Category
			 WHEN T.nCompletedFullJobs > 0	THEN 1
			 WHEN T.nCompletedFullSnapJobs > 0	THEN 12
			 WHEN T.nFailedFullJobs > 0		THEN 2
			 WHEN T.Deconfigured > 0		THEN 7
			 WHEN T.Disabled > 0			THEN 5
			 WHEN T.BackupScheduled = 0		THEN 4
			 ELSE 3
		END,
		C.LastSeenTime
FROM	#tblSubclient T
		INNER JOIN #tblClient C ON T.ClientId = C.ClientId
			AND (T.AppTypeId = 106 AND C.ClientType = 4 OR T.AppTypeId <> 106 AND C.ClientType <> 4)
DELETE	T FROM #tblSubclient T
		INNER JOIN #tblClient C ON T.ClientId = C.ClientId AND C.Status = 3
			AND (T.AppTypeId = 106 AND C.ClientType = 4 OR T.AppTypeId <> 106 AND C.ClientType <> 4)
-- Ignore RestoreOnly agents of VMs
DELETE	#tempSLA
FROM	(SELECT DISTINCT clientId FROM #tempSLA WHERE appTypeId = 106) T
		INNER JOIN APP_Client C ON T.clientId = C.id AND (C.status & 2) = 2 AND (C.specialClientFlags & 2) = 0
WHERE	#tempSLA.clientId = T.clientId AND appTypeId <> 106
-- Ignore excluded agents if the VM is discovered by a VSA subclient
DELETE	#tempSLA
FROM	(SELECT DISTINCT clientId FROM #tempSLA WHERE appTypeId = 106) T
WHERE	#tempSLA.clientId = T.clientId AND #tempSLA.appTypeId <> 106 AND #tempSLA.category = 8
DELETE	C
FROM	#tblClient C
		INNER JOIN (
			SELECT DISTINCT clientId FROM #tempSLA WHERE appTypeId = 106 AND category IN (1,2,3,4,12)
		) T ON C.ClientId = T.clientId
WHERE	C.ClientType <> 4 AND C.Status = 3
-- calculate SLA for SLA Trend of all clients for 12 weeks
CREATE TABLE #tempSLASubclient (fullJobsOnly INT, clientId INT, isVM INT, appTypeId INT, appId INT, Protected INT, Category INT)
CREATE TABLE #tempDBSubclient (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, isCmdLineApp INT, neverBackedup INT)
CREATE TABLE #tempDefaultSLA (clientId INT, appId INT, fullJobsOnly INT, appTypeId INT, status INT, category INT, slaDays INT, slaDaysLevel VARCHAR(32))
CREATE TABLE #newClients (clientId INT)
CREATE TABLE #TempClientSLADays (clientId INT, clientGroupId INT, slaDays INT, slaDaysLevel VARCHAR(32))
CREATE TABLE #SubclientSLADays (appId INT, slaDays INT, slaDaysLevel VARCHAR(32))
DECLARE @CS_SLADays	INT
IF	@i_days = -1
BEGIN
	DECLARE	@ClientGroupSLADays TABLE (clientGroupId INT, slaDays INT)
	SELECT	@CS_SLADays = longVal
	FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0
	IF ISNULL(@CS_SLADays, 0) <= 0 SET @CS_SLADays = 30
	-- Subclients using plan level SLA option
	INSERT	INTO #SubclientSLADays
	SELECT	S.componentNameId AS appId, CAST(P.attrVal AS INT) AS slaDays, 'Subclient Plan'
	FROM	APP_PlanProp P WITH (NOLOCK)
			INNER JOIN APP_SubClientProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
AND S.cs_attrName = CHECKSUM(N'Associated Plan') AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)
	INSERT	INTO #SubclientSLADays
	SELECT	A.id AS appId, CAST(P.attrVal AS INT) AS slaDays, 'Backupset Plan'
	FROM	APP_PlanProp P WITH (NOLOCK)
			INNER JOIN APP_BackupsetProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
			INNER JOIN APP_Application A WITH (NOLOCK) ON S.componentNameId = A.backupset AND A.backupset > 1
			LEFT OUTER JOIN #SubclientSLADays T ON A.id = T.appId
WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)
			AND T.appId IS NULL
	-- Laptops using plan level SLA option
	INSERT INTO #TempClientSLADays
	SELECT	C.componentNameId AS clientId, 0, CAST(P.attrVal AS INT) AS slaDays, 'Client Plan'
	FROM	APP_PlanProp P WITH (NOLOCK)
			INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
WHERE	P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
AND C.attrName LIKE 'Associated Plan' AND C.modified = 0
AND EXISTS (SELECT 1 FROM APP_PlanProp WITH (NOLOCK) WHERE componentNameId = P.componentNameId AND attrName = 'SLA option' AND attrVal = '2' AND modified = 0)
	INSERT	INTO @ClientGroupSLADays
	SELECT	componentId, longVal
	FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 8 AND propertyTypeId = 3300 AND modified = 0
	DELETE	CG
	FROM	@ClientGroupSLADays CG
			INNER JOIN APP_ComponentProp CP WITH (NOLOCK)
			ON CG.clientGroupId = CP.componentId AND CP.componentType = 8
AND CP.propertyTypeId = 3327 AND CP.longVal = 1 AND CP.modified = 0
	IF EXISTS (SELECT * FROM @ClientGroupSLADays)
		INSERT INTO #TempClientSLADays
		SELECT	T.clientId, T.clientGroupId, T.slaDays, 'Client Group'
		FROM	(SELECT CG.slaDays, CGA.clientId, CGA.clientGroupId, ROW_NUMBER() OVER (PARTITION BY CGA.clientId ORDER BY CG.slaDays) AS rowId
				FROM	@ClientGroupSLADays CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CG.clientGroupId = CGA.clientGroupId) T
		WHERE	T.rowId = 1
	CREATE INDEX Idx_TempClientSLADays_clientId ON #TempClientSLADays(clientId)
END
DECLARE @AlwaysCountNewClients INT = 0
IF	EXISTS (SELECT * FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'AlwaysCountNewClientsForSLA' AND value = '1' AND modified = 0)
	SET @AlwaysCountNewClients = 1
DECLARE @CountNewClientsWithAnyJob INT = 0
IF	EXISTS (SELECT * FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CountNewClientsWithAnyJobForSLA' AND value = '1' AND modified = 0)
	SET @CountNewClientsWithAnyJob = 1
INSERT	INTO #tempDBSubclient
SELECT	A.clientId, A.AppTypeId, A.instance, A.backupSet, A.id, (A.subclientStatus & (64|4096)), 1
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_BackupSetName B WITH (NOLOCK) ON A.backupSet = B.id
		INNER JOIN APP_InstanceName I WITH (NOLOCK) ON A.instance = I.id
		INNER JOIN #tblSubclient S ON A.id = S.AppId AND S.Deconfigured = 0 AND S.Disabled = 0
WHERE	A.AppTypeId IN (3,22,37,61,62,79,80,103,104,128,135) AND (A.subclientStatus & 16) = 0 AND (B.status & 16) = 0 AND (I.status & 16) = 0
IF @ExcludeCmdlineSubclients > 0
BEGIN
	DELETE	S FROM #tempSLA S
			INNER JOIN #tempDBSubclient T ON S.appId = T.appId AND T.isCmdLineApp > 0
	DELETE	#tempDBSubclient WHERE isCmdLineApp > 0
END
-- Delete cmdline subclient with no job if the gui subclients have jobs
UPDATE	T SET neverBackedup = 0
FROM	#tempDBSubclient T INNER JOIN JMBkpStats B WITH (NOLOCK) ON T.appId = B.appId
WHERE	B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
UPDATE	T SET neverBackedup += 2
FROM	#tempDBSubclient T INNER JOIN
		(SELECT	DISTINCT clientId, appTypeId, instanceId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (3,5,22,61,79,80,104,128) AND isCmdLineApp = 0 AND neverBackedup = 0
		) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId
WHERE	isCmdLineApp > 0
UPDATE	T SET neverBackedup += 2
FROM	#tempDBSubclient T INNER JOIN
		(SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (37,62,103,135) AND isCmdLineApp = 0 AND neverBackedup = 0
		) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId AND T.backupsetId = S.backupsetId
WHERE	isCmdLineApp > 0
DELETE	S FROM #tempSLA S
		INNER JOIN #tempDBSubclient T ON S.appId = T.appId AND T.isCmdLineApp > 0 AND T.neverBackedup = 3
DELETE	#tempDBSubclient WHERE isCmdLineApp > 0 AND neverBackedup = 3
-- Delete all gui subclients if all have no job but the cmdline subclients have jobs
DELETE	S FROM #tempSLA S
		INNER JOIN #tempDBSubclient D ON S.appId = D.appId
		INNER JOIN
		(SELECT	clientId, appTypeId, instanceId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (3,5,22,61,79,80,104,128) AND isCmdLineApp > 0 AND neverBackedup = 0
		) T ON T.clientId = D.clientId AND T.appTypeId = D.appTypeId AND T.instanceId = D.instanceId
WHERE	D.isCmdLineApp = 0
DELETE	T FROM #tempDBSubclient T
		INNER JOIN
		(SELECT	clientId, appTypeId, instanceId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (3,5,22,61,79,80,104,128) AND isCmdLineApp > 0 AND neverBackedup = 0
		) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId
WHERE	T.isCmdLineApp = 0
DELETE	S FROM #tempSLA S
		INNER JOIN #tempDBSubclient D ON S.appId = D.appId
		INNER JOIN
		(SELECT	clientId, appTypeId, instanceId, backupsetId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (37,62,103,135) AND isCmdLineApp > 0 AND neverBackedup = 0
		) T ON T.clientId = D.clientId AND T.appTypeId = D.appTypeId AND T.instanceId = D.instanceId AND T.backupsetId = D.backupsetId
WHERE	D.isCmdLineApp = 0
DELETE	T FROM #tempDBSubclient T
		INNER JOIN
		(SELECT	clientId, appTypeId, instanceId, backupsetId
		FROM	#tempDBSubclient
		WHERE	AppTypeId IN (37,62,103,135) AND isCmdLineApp > 0 AND neverBackedup = 0
		) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId AND T.backupsetId = S.backupsetId
WHERE	T.isCmdLineApp = 0
-- Check "Nothing to Backup" time stamp for server and laptop subclients
CREATE TABLE #LastCheckTime (appId INT, checkTime INT)
INSERT	INTO #LastCheckTime
SELECT	SP.componentNameId, CAST(SP.attrVal AS INT)
FROM	APP_SubclientProp SP WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT appId FROM #tempSLA WHERE appTypeId <> 106 AND status NOT IN (1, 12, 13)) S ON SP.componentNameId = S.appId
WHERE	SP.attrName = 'Nothing to backup' AND SP.cs_attrName = CHECKSUM(N'Nothing to backup')
	AND SP.modified = 0 AND CAST(SP.attrVal AS INT) BETWEEN @utBegin AND @utEnd
UPDATE	S SET status = 13, category = CASE WHEN S.category IN (3, 4) THEN 13 ELSE S.category END, lastSeenTime = P.checkTime
FROM	#tempSLA S
		INNER JOIN #LastCheckTime P ON S.appId = P.appId
		INNER JOIN APP_SubclientProp SP WITH (NOLOCK) ON P.appId = SP.componentNameId
WHERE	SP.attrName = 'Last Data Protected Time' AND SP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
	AND SP.modified = 0 AND CAST(SP.attrVal AS INT) <= P.checkTime
	AND S.status NOT IN (1, 12, 13)
DROP TABLE #LastCheckTime
-- Change No Schedule to No Run for db command line subclients
UPDATE	#tempSLA SET category = 3
FROM	#tempSLA S INNER JOIN #tempDBSubclient D
	ON	S.appId = D.appId AND S.category = 4
		AND (D.isCmdLineApp = 64 OR D.isCmdLineApp = 4096 AND D.appTypeId <> 135)
IF	 @IsEDC = 0 AND DATEDIFF(DAY, @i_date, GetDate()) <= 84
  OR @IsEDC = 1 AND DATEDIFF(DAY, @i_date, dbo.GetDateTime(@EDCDumpCaptureTime)) <= 84
BEGIN
	DECLARE @tblRange TABLE (days INT)
	DECLARE	@fromDate DATETIME
	DECLARE	@fromTime  INT
	DECLARE	@rangeDays INT
	DECLARE	@skipDays  INT
	IF @i_days >= 0
		INSERT	INTO @tblRange SELECT @i_days
	ELSE
		INSERT	INTO @tblRange
		SELECT	1  UNION
		SELECT	2  UNION
		SELECT	3  UNION
		SELECT	5  UNION
		SELECT	7  UNION
		SELECT	14 UNION
		SELECT	30 UNION
		SELECT	longVal
		FROM	APP_ComponentProp WITH (NOLOCK)
		WHERE	(componentType = 1 AND componentId = 2 OR componentType = 8)
AND propertyTypeId = 3300 AND modified = 0
	DECLARE CurRange CURSOR FOR
	SELECT	days
	FROM	@tblRange
	OPEN	CurRange
	FETCH	CurRange INTO @rangeDays
	WHILE   @@FETCH_STATUS = 0
	BEGIN
		IF @SkipWeekend > 0 AND @rangeDays < 7
		BEGIN
			SET @skipDays = CASE DATEPART(DW, @i_date) WHEN 7 THEN 1 ELSE 2 END
				SET @fromDate = DATEADD(DAY, -(@rangeDays+@skipDays), @i_date)
		END
		ELSE
			SET @fromDate = DATEADD(DAY, -@rangeDays, @i_date)
		WHILE	dbo.IsInvalidTimeManaged(@fromDate, @csTimeZoneName) = 1
		BEGIN
				SET @fromDate = DATEADD(HOUR, 1, @fromDate)
		END
		SET @fromTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@fromDate, @csTimeZoneName))
		IF	@GracePeriodDays = -1 --use SLA days
			SET	@maxCreationTime = @fromTime
		IF	ISNULL(@maxOfflineDays, 0) = 0 --use SLA days
			SET @minLastSeen = @fromTime
		IF  @IsEDC = 0 AND @GracePeriodDays <> 0
		BEGIN
			INSERT	INTO #newClients
			SELECT	componentNameId
			FROM	APP_ClientProp CP WITH (NOLOCK)
					INNER JOIN (SELECT DISTINCT clientId FROM #tempSLA WHERE appTypeId <> 106) S ON CP.componentNameId = S.clientId
			WHERE	created > 0
			GROUP BY componentNameId
			HAVING MIN(created) > @maxCreationTime
		END
		INSERT	INTO #tempSLASubclient
		SELECT	T.fullJobsOnly, T.clientId, (CASE WHEN V.ClientId IS NULL THEN 0 ELSE 1 END), T.appTypeId, T.appId,
				CASE WHEN T.status IN (1,13) OR ISNULL(S.status,3) IN (1,13) THEN 1 ELSE 0 END,
				CASE WHEN T.status = 1 OR ISNULL(S.status,3) = 1 THEN 1
					 WHEN T.status = 13 OR ISNULL(S.status,3) = 13 THEN 13
					 WHEN T.status = 12 OR ISNULL(S.status,3) = 12 THEN 12
					 WHEN T.category = 2 OR ISNULL(S.status,3) = 2 THEN 2 ELSE T.category END
		FROM	#tempSLA T
			LEFT OUTER JOIN (SELECT DISTINCT ClientId FROM #tblClient WHERE ClientType&4 = 4) V ON T.clientId = V.ClientId
			LEFT OUTER JOIN
				(SELECT	fullJobsOnly, clientId, appTypeId, CASE WHEN appTypeId = 106 THEN 0 ELSE appId END AS appId,
						CASE WHEN MIN(status) = 1 THEN 1 ELSE MAX(status) END AS status
				FROM	RptSLA WITH (NOLOCK)
				WHERE	date >= @fromDate AND date <= @i_date AND appId > 0 AND status IN (1, 2, 12, 13)
				GROUP BY fullJobsOnly, clientId, appTypeId, CASE WHEN appTypeId = 106 THEN 0 ELSE appId END
				) AS S ON T.fullJobsOnly = S.fullJobsOnly AND T.clientId = S.clientId AND T.appTypeId = S.appTypeId
						AND (CASE WHEN T.appTypeId = 106 THEN 0 ELSE T.appId END) = S.appId
		WHERE	T.appId > 0 AND T.Category IN (1, 2, 3, 4, 12, 13)
		IF	@SnapJobsQualifySLA = 1
			UPDATE #tempSLASubclient SET Protected = 1, category = 1 WHERE category = 12
		ELSE
		IF	@SnapMetSLAIfBackupCopyDisabled = 1
			UPDATE T SET Protected = 1, category = 1
			FROM	#tempSLASubclient T
					INNER JOIN #tblSubclient S ON T.clientId = S.ClientId AND T.appId = S.AppId
					INNER JOIN #SnapArchGroup AG ON S.ArchGrpId = AG.ArchGrpId
			WHERE	T.category = 12 AND AG.BackupCopyEnabled = 0 AND AG.SnapVaultExists = 0
		DELETE	T FROM #tempSLASubclient T
				INNER JOIN (SELECT clientId, appId, fullJobsOnly FROM #tempSLASubclient WHERE Protected = 1) S
					ON T.clientId = S.clientId AND T.appId = S.appId AND T.fullJobsOnly = S.fullJobsOnly
		WHERE	T.Protected = 0
		IF  @IsEDC = 0 AND @AlwaysCountNewClients = 0
		BEGIN
			IF	@CountNewClientsWithAnyJob = 1
				DELETE NC FROM #newClients NC
					INNER JOIN (SELECT DISTINCT clientId FROM #tempSLASubclient WHERE category IN (1, 2, 12)) T ON NC.clientId = T.clientId
			ELSE -- Only count protected new clients
				DELETE	NC FROM #newClients NC
					INNER JOIN (SELECT	S1.clientId, COUNT(DISTINCT appId) AS nTotal
								FROM	#tempSLASubclient S1 INNER JOIN #newClients C1 ON S1.clientId = C1.clientId
								WHERE	category IN (1, 2, 3, 4, 12)
								GROUP BY S1.clientId) T ON NC.clientId = T.clientId
					INNER JOIN (SELECT	S2.clientId, COUNT(DISTINCT appId) AS nProtected
								FROM	#tempSLASubclient S2 INNER JOIN #newClients C2 ON S2.clientId = C2.clientId
								WHERE	category IN (1, 12)
								GROUP BY S2.clientId) P ON NC.clientId = P.clientId
				WHERE	T.nTotal = P.nProtected
			INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
			SELECT	@i_date, @rangeDays, 0, clientId, 3, 10
			FROM	#newClients
			UNION
			SELECT	@i_date, @rangeDays, 1, clientId, 3, 10
			FROM	#newClients
		END
	-- For Informix, SyBase, Oracle, SAP for Oracle, Oracle for SAP DB and Oracle RAC
		-- Skip cmdline subclient that has no job when the gui subclients have jobs
		;WITH DBInstanceProtectedByGuiSubclients (fullJobsOnly, clientId, appTypeId, instanceId) AS
		(
			SELECT	A.fullJobsOnly, A.clientId, B.appTypeId, B.instanceId
			FROM	#tempSLASubclient A
					INNER JOIN #tempDBSubclient B ON A.appId = B.appId AND isCmdLineApp = 0 AND Category IN (1, 2, 12)
			WHERE	B.AppTypeId IN (3,5,22,61,79,80,104,128)
		)
		DELETE	#tempSLASubclient
		FROM	(SELECT	G.fullJobsOnly, S.appId
				FROM	#tempDBSubclient S
						INNER JOIN DBInstanceProtectedByGuiSubclients G
					ON S.clientId = G.clientId AND S.appTypeId = G.appTypeId AND S.instanceId = G.instanceId
					AND S.isCmdLineApp > 0
				) T
		WHERE	#tempSLASubclient.fullJobsOnly = T.fullJobsOnly AND #tempSLASubclient.appId = T.appId AND #tempSLASubclient.Category NOT IN (1, 2, 12)
		-- Skip gui subclients that have no job when the command line subclient is protected
		;WITH DBInstanceProtectedByCmdLine (fullJobsOnly, clientId, appTypeId, instanceId) AS
		(
			SELECT	A.fullJobsOnly, A.clientId, B.appTypeId, B.instanceId
			FROM	#tempSLASubclient A
					INNER JOIN #tempDBSubclient B ON A.appId = B.appId AND isCmdLineApp > 0 AND Category IN (1, 12)
			WHERE	B.AppTypeId IN (3,5,22,61,79,80,104,128)
		)
		DELETE	#tempSLASubclient
		FROM	(SELECT	C.fullJobsOnly, S.appId
				FROM	#tempDBSubclient S
						INNER JOIN DBInstanceProtectedByCmdLine C
					ON S.clientId = C.clientId AND S.appTypeId = C.appTypeId AND S.instanceId = C.instanceId
					AND S.isCmdLineApp = 0
				) T
		WHERE	#tempSLASubclient.fullJobsOnly = T.fullJobsOnly AND #tempSLASubclient.appId = T.appId AND #tempSLASubclient.Category <> 2
		-- For DB2, UNIX DB2, DB2 DPF and SAP HANA
		-- Skip cmdline subclient that has no job when the gui subclients have jobs
		;WITH DB2BackupsetProtectedByGuiSubclients (fullJobsOnly, clientId, appTypeId, instanceId, backupsetId) AS
		(
			SELECT	A.fullJobsOnly, A.clientId, B.appTypeId, B.instanceId, B.backupsetId
			FROM	#tempSLASubclient A
					INNER JOIN #tempDBSubclient B ON A.appId = B.appId AND Category IN (1, 2, 12)
			WHERE	B.AppTypeId IN (37,62,103,135)
				AND B.isCmdLineApp = 0
		)
		DELETE	#tempSLASubclient
		FROM	(SELECT	G.fullJobsOnly, S.appId
				FROM	#tempDBSubclient S
						INNER JOIN DB2BackupsetProtectedByGuiSubclients G
					ON S.clientId = G.clientId AND S.appTypeId = G.appTypeId AND S.instanceId = G.instanceId AND S.backupsetId = G.backupsetId
					AND S.isCmdLineApp > 0
				) T
		WHERE	#tempSLASubclient.fullJobsOnly = T.fullJobsOnly AND #tempSLASubclient.appId = T.appId AND #tempSLASubclient.Category NOT IN (1, 2, 12)
		-- Skip gui subclients that have no job when the command line subclient is protected
		;WITH DB2BackupsetProtectedByCmdLine (fullJobsOnly, clientId, appTypeId, instanceId, backupsetId) AS
		(
			SELECT	A.fullJobsOnly, A.clientId, B.appTypeId, B.instanceId, B.backupsetId
			FROM	#tempSLASubclient A
					INNER JOIN #tempDBSubclient B ON A.appId = B.appId AND Category IN (1, 12)
			WHERE	B.AppTypeId IN (37,62,103,135)
				 AND (isCmdLineApp = 64 OR isCmdLineApp = 4096 AND B.appTypeId <> 135)
		)
		DELETE	#tempSLASubclient
		FROM	(SELECT	C.fullJobsOnly, S.appId
				FROM	#tempDBSubclient S
						INNER JOIN DB2BackupsetProtectedByCmdLine C
					ON S.clientId = C.clientId AND S.appTypeId = C.appTypeId AND S.instanceId = C.instanceId AND S.backupsetId = C.backupsetId
					AND (S.isCmdLineApp = 0 OR S.isCmdLineApp = 4096 AND S.appTypeId = 135)
				) T
		WHERE	#tempSLASubclient.fullJobsOnly = T.fullJobsOnly AND #tempSLASubclient.appId = T.appId AND #tempSLASubclient.Category <> 2
		IF @CountVSAAndIDAs = 0
		BEGIN
			-- Ignore other agents if VMs are protected by VSA
			DELETE	T FROM #tempSLASubclient T
					INNER JOIN (
						SELECT DISTINCT fullJobsOnly, clientId FROM #tempSLASubclient WHERE isVM = 1 AND appTypeId = 106 AND category = 1
					) S ON T.fullJobsOnly = S.fullJobsOnly AND T.clientId = S.clientId
			WHERE	T.isVM = 1 AND T.appTypeId <> 106 AND T.category > 1
			-- Ignore VSA if VMs are protected by other agents
			DELETE	T FROM #tempSLASubclient T
					INNER JOIN (
						SELECT fullJobsOnly, clientId, COUNT(DISTINCT appId) AS nSub FROM #tempSLASubclient WHERE isVM = 1 AND appTypeId <> 106 AND category = 1 GROUP BY fullJobsOnly, clientId
					) S ON T.fullJobsOnly = S.fullJobsOnly AND T.clientId = S.clientId
					INNER JOIN (
						SELECT fullJobsOnly, clientId, COUNT(DISTINCT appId) AS nSub FROM #tempSLASubclient WHERE isVM = 1 AND appTypeId <> 106 AND category IN (1, 2, 3, 4, 12) GROUP BY fullJobsOnly, clientId
					) A ON T.fullJobsOnly = A.fullJobsOnly AND T.clientId = A.clientId
			WHERE	T.isVM = 1 AND T.appTypeId = 106 AND S.nSub = A.nSub AND S.nSub > 0 AND T.category > 1
		END
		INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
		SELECT	@i_date, @rangeDays, 0, ClientId, 3, 6 FROM #tblClient WHERE ClientType = 2 AND LastSeenTime < @minLastSeen AND ClientId NOT IN (SELECT clientId FROM #newClients)
		UNION
		SELECT	@i_date, @rangeDays, 1, ClientId, 3, 6 FROM #tblClient WHERE ClientType = 2 AND LastSeenTime < @minLastSeen AND ClientId NOT IN (SELECT clientId FROM #newClients)
		INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
		SELECT	@i_date, @rangeDays, T.fullJobsOnly, T.clientId,
				CASE WHEN T.Protected > 0 AND T.Missed = 0 THEN 1 ELSE 0 END,
				CASE WHEN T.Protected > 0 AND T.Missed = 0 THEN 1 ELSE T.Category END
		FROM	(SELECT	V.fullJobsOnly, V.clientId,
						SUM(CASE WHEN V.Protected > 0 THEN 1 ELSE 0 END) AS Protected,
						SUM(CASE WHEN V.Protected = 0 THEN 1 ELSE 0 END) AS Missed,
						MIN(CASE WHEN V.Protected > 0 THEN 100 ELSE V.Category END) AS Category
				FROM	#tempSLASubclient V
				GROUP BY V.fullJobsOnly, V.clientId) T
				LEFT OUTER JOIN (SELECT ClientId FROM #tblClient WHERE ClientType = 2 AND LastSeenTime < @minLastSeen) U ON T.clientId = U.ClientId
				LEFT OUTER JOIN #newClients NC ON T.clientId = NC.ClientId
		WHERE	U.ClientId IS NULL AND NC.ClientId IS NULL
		IF	@i_days = -1
		BEGIN
			IF @rangeDays = @CS_SLADays
				INSERT	INTO #tempDefaultSLA
				SELECT	S.clientId, S.appId, S.fullJobsOnly, S.appTypeId, CASE WHEN S.Protected = 1 THEN 1 ELSE 2 END, S.Category, @rangeDays, 'CommCell'
				FROM	#tempSLASubclient S LEFT OUTER JOIN #TempClientSLADays D ON S.clientId = D.clientId
						LEFT OUTER JOIN #SubclientSLADays P ON S.appId = P.appId
				WHERE	S.Category IN (1, 2, 3, 4, 12, 13) AND D.clientId IS NULL AND P.appId IS NULL
			INSERT	INTO #tempDefaultSLA
			SELECT	S.clientId, S.appId, S.fullJobsOnly, S.appTypeId, CASE WHEN S.Protected = 1 THEN 1 ELSE 2 END, S.Category, @rangeDays,
					CASE WHEN ISNULL(P.slaDays, 0) = @rangeDays THEN P.slaDaysLevel ELSE D.slaDaysLevel END
			FROM	#tempSLASubclient S LEFT OUTER JOIN #TempClientSLADays D ON S.clientId = D.clientId
					LEFT OUTER JOIN #SubclientSLADays P ON S.appId = P.appId
			WHERE	S.Category IN (1, 2, 3, 4, 12, 13) AND ISNULL(P.slaDays, D.slaDays) = @rangeDays
		END
		TRUNCATE TABLE #tempSLASubclient
		TRUNCATE TABLE #newClients
		FETCH	CurRange INTO @rangeDays
	END
	CLOSE	CurRange
	DEALLOCATE CurRange
	INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
	SELECT	@i_date, 0, 0, EC.ClientId, 3, MAX(EC.category)
	FROM	#tblClient EC LEFT OUTER JOIN #tempSLAClient C ON EC.clientId = C.clientId
	WHERE	EC.Status = 3 AND C.clientId IS NULL
	GROUP BY EC.ClientId
END
IF	@i_days = -1
BEGIN
	IF @i_flags&1 = 1
	BEGIN
		UPDATE	S SET status = D.status, category = D.category, slaDays = D.slaDays, slaDaysLevel = D.slaDaysLevel
		FROM	#tempSLA S INNER JOIN #tempDefaultSLA D
				ON S.clientId = D.clientId AND S.appId = D.appId AND S.fullJobsOnly = D.fullJobsOnly AND S.appTypeId = D.appTypeId
		UPDATE	S SET slaDays = ISNULL(D.slaDays, @CS_slaDays), slaDaysLevel = D.slaDaysLevel
		FROM	#tempSLA S LEFT OUTER JOIN #TempClientSLADays D ON S.clientId = D.clientId
		WHERE	S.slaDays IS NULL
	END
	ELSE
		UPDATE	S SET status = D.status, category = D.category
		FROM	#tempSLA S INNER JOIN #tempDefaultSLA D
				ON S.clientId = D.clientId AND S.appId = D.appId AND S.fullJobsOnly = D.fullJobsOnly AND S.appTypeId = D.appTypeId
	INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
	SELECT	@i_date, -1, C.fullJobsOnly, C.clientId, 3, C.category
	FROM	#tempSLAClient C LEFT OUTER JOIN #TempClientSLADays D ON C.clientId = D.clientId
	WHERE	C.days = ISNULL(D.slaDays, @CS_slaDays) AND C.category IN (6, 10)
	INSERT	INTO #tempSLAClient (date, days, fullJobsOnly, clientId, isProtected, category)
	SELECT	@i_date, -1, D.fullJobsOnly, D.clientId,
			CASE WHEN MAX(D.status) = 2 THEN 0 ELSE MAX(D.status) END,
			MIN(CASE WHEN D.category IN (1,13) THEN 101 ELSE D.category END)%100
	FROM	#tempDefaultSLA D LEFT OUTER JOIN #tempSLAClient C ON D.clientId = C.clientId AND C.days = -1 AND C.category IN (6, 10)
	WHERE	C.clientId IS NULL
	GROUP BY D.fullJobsOnly, D.clientId
	IF @i_flags&1 = 1
	BEGIN
		UPDATE	S SET slaDays = ISNULL(D.slaDays, @CS_slaDays)
		FROM	#tempSLAClient S LEFT OUTER JOIN #TempClientSLADays D ON S.clientId = D.clientId
		WHERE	S.slaDays IS NULL
	END
END
IF	EXISTS (SELECT 1 FROM #tempSLA WHERE appTypeId = 106 AND category IN (3, 4))
BEGIN
	CREATE TABLE #tblVSASubclient (appId INT)
	CREATE TABLE #tblVSAFilter (vsaAppId INT, filter XML)
	CREATE TABLE #tblFilteredVM (clientId INT)
	INSERT	INTO #tblVSASubclient
	SELECT	DISTINCT CP.attrVal
	FROM	APP_ClientProp CP WITH(NOLOCK)
			INNER JOIN #tempSLA S ON CP.componentNameId = S.clientId
	WHERE	CP.attrName = 'Last Backup Subclient' AND CP.modified = 0 AND ISNUMERIC(CP.attrVal) = 1
		AND S.appTypeId = 106 AND S.Category IN (3, 4)
	INSERT INTO #tblVSAFilter
	SELECT	SP.componentNameId, CAST(CAST(SP.attrVal AS VARCHAR(MAX)) AS XML)
	FROM	APP_SubClientProp SP WITH(NOLOCK)
			INNER JOIN #tblVSASubclient VSA ON SP.componentNameId = VSA.appId
	WHERE	SP.attrName = 'Virtual Server Filters' AND SP.modified = 0
		AND SP.cs_attrName = CHECKSUM(N'Virtual Server Filters')
	INSERT	INTO #tblFilteredVM
	SELECT	DISTINCT CP.componentNameId
	FROM	#tblVSAFilter SP
			CROSS APPLY filter.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c)
			INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON T.c.value('@name', 'NVARCHAR(1024)') = CP.attrVal
			AND CP.attrName = 'Virtual Machine Instance UUID' AND CP.modified = 0
	WHERE	T.c.value('@type', 'NVARCHAR(1024)') = '9'
	UPDATE S SET Category = 9
	FROM	#tempSLA S INNER JOIN #tblFilteredVM D ON S.clientId = D.clientId
	WHERE	S.appTypeId = 106 AND S.Category IN (3, 4)
	UPDATE S SET Category = 9
	FROM	#tempSLAClient S INNER JOIN #tblFilteredVM D ON S.clientId = D.clientId
	WHERE	S.Category IN (3, 4)
	DROP TABLE #tblVSASubclient
	DROP TABLE #tblVSAFilter
	DROP TABLE #tblFilteredVM
END
DROP TABLE #newClients
DROP TABLE #TempClientSLADays
DROP TABLE #tempDBSubclient
DROP TABLE #tempSLASubclient
DROP TABLE #tempDefaultSLA
DROP TABLE #tblSubclient
DROP TABLE #tblClient
DROP TABLE #SnapArchGroup
DROP TABLE #SubclientSLADays
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptOneDaySLA')
	delete from GxQscripts where name = 'rptOneDaySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptOneDaySLA')
	delete from GXDBVersions where aliasname = 'rptOneDaySLA'
GO

insert into GXDBVersions values(2, 'rptOneDaySLA',  'v1.28.2.86.4.2', 'rptOneDaySLA', 'v1.28.2.86.4.2')
GO

