

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetUserCapabilityRptInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetUserCapabilityRptInfo.sp,v $ $Id: rptGetUserCapabilityRptInfo.sp,v 1.1.2.4 2018/03/20 00:45:21 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE : "rptGetUserCapabilityRptInfo"						|
--	|																		|
--	| Gets the URL for the Users and User Permissions custom report			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptGetUserCapabilityRptInfo <<<'

IF EXISTS (select * from sysobjects where name='rptGetUserCapabilityRptInfo')
	drop procedure rptGetUserCapabilityRptInfo
IF EXISTS (select * from GxQscripts where name='rptGetUserCapabilityRptInfo')
	delete from GxQscripts where name = 'rptGetUserCapabilityRptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetUserCapabilityRptInfo')
	delete from GXDBVersions where aliasname = 'rptGetUserCapabilityRptInfo'
GO
print '... Creating Procedure: rptGetUserCapabilityRptInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetUserCapabilityRptInfo
AS
  DECLARE @o_reportName NVARCHAR(255)
  DECLARE @o_url NVARCHAR(255);
  DECLARE @o_errorCode INT;
  DECLARE @o_errorMessage NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @webConsoleUrl	nvarchar(max)
DECLARE @reportName		NVARCHAR(255) = ''
DECLARE @url			NVARCHAR(255) = ''
DECLARE @errorCode		INT = 0
DECLARE @errorMessage	NVARCHAR(255) = ''
DECLARE @reportId		INT
SELECT @webConsoleUrl = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'WebConsoleURL' and modified = 0
IF @webConsoleUrl IS NULL
BEGIN
	SELECT @errorCode = 5001
	SELECT @errorMessage = 'Web Console URL not found'
	GOTO PROC_EXIT
END
SELECT @reportId = reportId, @reportName = name FROM APP_Reports WITH (NOLOCK) WHERE GUID = '2530e3e4-33d1-44a0-e24d-c0d3d2fba0d1'
IF @reportId IS NULL
BEGIN
	SELECT @errorCode = 5002
	SELECT @errorMessage = 'User and User Group Permissions Custom Report not found'
	GOTO PROC_EXIT
END
SELECT @webConsoleUrl = REPLACE(@webConsoleUrl, 'webconsole/', 'webconsole/^')
SELECT @webConsoleUrl = SUBSTRING(@webConsoleUrl, 0, CHARINDEX('^',@webConsoleUrl))
SELECT @url = CONCAT(@webConsoleUrl, 'reportsplus/reportViewer.jsp?reportId=', CAST(@reportId AS varchar(10)))
PROC_EXIT:
	SELECT @reportName AS reportName , @url AS url, @errorCode AS errorCode, @errorMessage AS errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetUserCapabilityRptInfo')
	delete from GxQscripts where name = 'rptGetUserCapabilityRptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetUserCapabilityRptInfo')
	delete from GXDBVersions where aliasname = 'rptGetUserCapabilityRptInfo'
GO

insert into GXDBVersions values(2, 'rptGetUserCapabilityRptInfo',  '00010001000200040000', 'rptGetUserCapabilityRptInfo', '00010001000200040000')
GO

