

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetSubClientsWithNoSchedule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		July 08, 2009: Converted to SP for performance/debugging  -SKatz
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSubClientsWithNoSchedule.sp,v $ $Id: rptGetSubClientsWithNoSchedule.sp,v 1.3.2.3 2018/11/18 03:50:55 skatz Exp $";
-- 	+---------------------------------------------------------------------------+
--	| 						Stored Proc: "rptGetSubClientsWithNoSchedule"								|
--	|																			|
--  |Gets the list of subclients with no DM schedule set.		|
-- 	+---------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetSubClientsWithNoSchedule')
BEGIN
	print '>>> Drop Stored Procedure: rptGetSubClientsWithNoSchedule <<<'
	drop procedure rptGetSubClientsWithNoSchedule
END
IF EXISTS (select * from GxQscripts where name='rptGetSubClientsWithNoSchedule')
	delete from GxQscripts where name = 'rptGetSubClientsWithNoSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSubClientsWithNoSchedule')
	delete from GXDBVersions where aliasname = 'rptGetSubClientsWithNoSchedule'
GO
print '... Creating Procedure: rptGetSubClientsWithNoSchedule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetSubClientsWithNoSchedule
AS
SET NOCOUNT ON
DECLARE @subclientsWithoutSchedules TABLE
(subClientId INT, lastBackUpJob INT)
DECLARE @subtaskId INT, @taskId INT
DECLARE     scheduleCursor CURSOR
FOR
	SELECT DISTINCT ST.subTaskId, ST.taskId
	FROM TM_SubTask ST WITH (NOLOCK)
	INNER JOIN TM_Task T WITH (NOLOCK) ON ST.taskId = T.taskId
	WHERE ST.subTaskType = 2 -- Backups
	AND T.taskType IN (2, 4) -- Schedules and Schedule Policies
	AND T.deleted = 0 AND T.uninstalled = 0 AND T.disabled = 0
DECLARE @entityTbl TABLE
(appId INT, appTypeId INT, clientId INT, instanceId INT, backupSetId INT, status INT, bkpLevel INT)
OPEN scheduleCursor
FETCH NEXT from scheduleCursor INTO @subtaskId, @taskId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO @entityTbl
	EXEC TM_GetBackupEntity  @taskId, @subtaskId, NULL
	NEXT_ROW:
		FETCH NEXT from scheduleCursor INTO @subtaskId, @taskId
END
CLOSE       scheduleCursor
DEALLOCATE  scheduleCursor
INSERT INTO @subclientsWithoutSchedules
SELECT APP.id, 0
FROM APP_Application APP
LEFT OUTER JOIN @entityTbl E ON E.appId = APP.id
WHERE APP.appTypeId < 1000 AND App.appTypeId NOT BETWEEN 600 AND 700 -- Real apptypes
AND APP.subclientStatus & 4214 = 0 -- CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN, CV_STATUS_CMD_LINE, CV_STATUS_LOGCMD_LINE
AND E.appId IS NULL
--delete all entries if backup activity is disabled on CS
IF EXISTS(
SELECT * FROM JMJobAction
WHERE clientId = 1 AND appId = 1 AND appType = 0 AND opType = 4 AND action = 1 )
BEGIN
	DELETE from @subclientsWithoutSchedules
END
ELSE
BEGIN
	--delete sub client entries if backup activity is disabled on client level
	DELETE FROM @subclientsWithoutSchedules WHERE subClientId IN (
		SELECT A.id FROM APP_Application A
		INNER JOIN APP_Client C ON A.clientId = C.id
		INNER JOIN JMJobAction JA ON C.id = JA.clientId AND JA.appType = 0
		WHERE JA.opType = 4 AND JA.action = 1
	)
	--delete sub client entries if backup activity is disabled on IDA level
	DELETE FROM @subclientsWithoutSchedules WHERE subClientId IN (
		SELECT A.id FROM APP_Application A
		INNER JOIN APP_Client C ON A.clientId = C.id
		INNER JOIN JMJobAction JA ON C.id = JA.clientId AND JA.appType = A.appTypeId
		WHERE JA.opType = 4 AND JA.action = 1
	)
	--delete sub client entries if backup activity is disabled on sub client level
	DELETE FROM @subclientsWithoutSchedules WHERE subClientId IN(
		SELECT appId FROM JMJobAction
		WHERE appId <> 1 AND opType = 4 AND action = 1
	)
	--delete all non default sub client entries for CDR and workstation
	DELETE @subclientsWithoutSchedules FROM @subclientsWithoutSchedules
	INNER JOIN APP_Application A (NOLOCK) ON
	subClientId =A.id
AND A.appTypeId IN (84, 107) AND ((subclientStatus & 8) <> 8)
END
UPDATE @subclientsWithoutSchedules
SET lastBackUpJob = ISNULL((SELECT TOP 1 jobId
						   FROM JMBkpStats BKP
						   WHERE BKP.appId = subClientId
						   AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						   AND opType <> 14 -- Exclude SYNTHFULL
						   ORDER BY servEndDate DESC), 0)
SELECT CC.aliasName "Commcell Name",
CL.displayName "Client",
CG.ClientGroups "Client Groups",
IDA.name "Agent",
INS.name "Instance",
BSET.name "Backupset",
APP.subclientName "Subclient",
SUB.lastBackUpJob "Last Backup Job ID",
dbo.getdatetime(BKP.servEndDate ) "Last Backup Time"
FROM @subclientsWithoutSchedules SUB
INNER JOIN APP_Application APP ON SUB.subClientId = APP.id
INNER JOIN APP_Client CL ON CL.id = APP.clientId
INNER JOIN APP_iDAType IDA ON IDA.type = APP.appTypeId AND IDA.type < 600
INNER JOIN APP_InstanceName INS ON INS.id = APP.instance
INNER JOIN APP_BackupSetName BSET ON BSET.id = APP.backupSet
LEFT OUTER JOIN JMBkpStats BKP ON SUB.subClientId = BKP.appId AND SUB.lastBackUpJob = BKP.jobId
LEFT OUTER JOIN ClientGroupsStringView CG ON CG.clientId = CL.id
LEFT OUTER JOIN APP_CommCell CC on CC.id = CL.origCCId
ORDER BY CC.aliasName, CL.displayName, CG.ClientGroups, IDA.name, INS.name, BSET.name, APP.subclientName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetSubClientsWithNoSchedule')
	delete from GxQscripts where name = 'rptGetSubClientsWithNoSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSubClientsWithNoSchedule')
	delete from GXDBVersions where aliasname = 'rptGetSubClientsWithNoSchedule'
GO

insert into GXDBVersions values(2, 'rptGetSubClientsWithNoSchedule',  '00010003000200030000', 'rptGetSubClientsWithNoSchedule', '00010003000200030000')
GO

