

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetStorageSpaceUtils.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetStorageSpaceUtils.sp,v $ $Id: rptGetStorageSpaceUtils.sp,v 1.1.4.9 2020/07/10 21:14:06 nbirru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetStorageSpaceUtils')
BEGIN
	print '>>> Drop Stored Procedure: rptGetStorageSpaceUtils <<<'
	drop procedure rptGetStorageSpaceUtils
END
IF EXISTS (select * from GxQscripts where name='rptGetStorageSpaceUtils')
	delete from GxQscripts where name = 'rptGetStorageSpaceUtils'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetStorageSpaceUtils')
	delete from GXDBVersions where aliasname = 'rptGetStorageSpaceUtils'
GO
print '... Creating Procedure: rptGetStorageSpaceUtils'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetStorageSpaceUtils
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @UserName NVARCHAR(255),
  @TopN INT,
  @Summary INT,
  @DashBoardType VARCHAR(25)=NULL
-----------------------------------------------------------
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @DiskLibraryInfo table(DiskLibrary nvarchar(100))
 IF object_id('tempdb.dbo.#tmpDiskLibraryList') IS NOT NULL
  INSERT @DiskLibraryInfo SELECT DiskLibrary FROM #tmpDiskLibraryList
DECLARE @i_CommServUniqueID INT = 0
SELECT @i_CommServUniqueId = CC.ID FROM APP_CommCell C INNER JOIN CVCloud..cf_CommcellIdNameMap CC ON C.id = 2 AND C.csGUID = CC.CommServGUID
DECLARE @i_QueryId BIGINT = 96
DECLARE @strGood VARCHAR(10) = 'Good'
DECLARE @strInfo VARCHAR(10) = 'Info'
DECLARE @strwarning VARCHAR(10) = 'Warning'
DECLARE @strCritical VARCHAR(10) = 'Critical'
DECLARE @strUnknown VARCHAR(10) = 'Unknown'
DECLARE @criticalThreshold int
DECLARE @warningThreshold int
SELECT	@warningThreshold = WarningThreshold, @criticalThreshold =CriticalThreshold FROM CVCloud..cf_SurveyHealthParam where queryId = @i_QueryId
--Never value should be lower than (N/A), to get sorting like Date->Never->N/A order
DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
DECLARE @showHiddenLibConfig INT
SELECT @showHiddenLibConfig = value FROM MMConfigs WITH (NOLOCK) WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
BEGIN TRY
IF NOT EXISTS (SELECT TOP 1 1 FROM @DiskLibraryInfo)
BEGIN
	DECLARE @userId INT
	SELECT @userId = id FROM UMUsers WITH(NOLOCK) WHERE login = @UserName
	DECLARE @isUserAdmin INT = 0
	EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
	DECLARE @isViewAll INT = 0
	IF @isUserAdmin <> 1
	BEGIN
		   IF object_id('tempdb.dbo.#tmpSecurityClientList') IS NOT NULL
		   DROP TABLE #tmpSecurityClientList
		   create table  #tmpSecurityClientList
		   ([capabilities]  bigint NOT null,
		   [flag] int NOT null default 0,
		   [commCellId]  int   NOT null default 2,
		   [clientGroupId] int NOT null default 0,
			[clientId]      int NOT null default 0,
		   [appTypeId]     int NOT null default 0,
			[instanceId]    int NOT null default 0,
		   [backupsetId]   int NOT null default 0,
			[subClientId]   int NOT null default 0,
			[mediaAgentId]  int NOT null default 0,
			[libraryId]     int NOT null default 0,
			[archGroupId]   int NOT null default 0,
			[vtContainerId] int NOT null default 0,
		   [vtPolicyId]    int NOT null default 0,
			[vtShelfId]     int NOT null default 0,
		   [reviewSetId]   int NOT null default 0,
			[querySetId]   int  NOT null default 0,
		   [downloadSetId] int NOT null default 0,
			[ermId]        int  NOT null default 0,
			[legalHoldId]   int NOT null default 0,
			[tagId]               int  NOT null default 0,
			[cdPolicyId]    int NOT null default 0,
			[complianceReportId]   int NOT null default 0,
		   [taskId]        int NOT null default 0,
			[workflowId]    int NOT null default 0,
			[logMonitoringPolicyId] int      NOT null default 0,
			[arrayId]       int NOT null default 0,
			[cloudId]       int NOT null default 0,
			[userGroupId]   int NOT null default 0,
			[providerId]    int NOT null default 0,
			[entityId1]     int NOT null default 0,
			[entityId2]     int NOT null default 0,
			[entityId3]     int NOT null default 0,
			[entityId4]     int NOT null default 0,
			[entityId5]     int NOT null default 0,
		   [entityId6]     int NOT null default 0,
			[entityId7]     int NOT null default 0,
		   [entityId8]     int NOT null default 0,
		   [entityId9]     int NOT null default 0  )
		   EXEC sec_getUserObjects @userId,2049,0,'#tmpSecurityClientList'
		   IF EXISTS (SELECT * FROM #tmpSecurityClientList WHERE libraryId = 0)
				  SET @isViewAll = 1
	END
	IF (@isUserAdmin = 1 OR @isViewAll = 1)
	BEGIN
			IF ISNULL(@DashBoardType,'')='appliance'
		   	INSERT INTO @DiskLibraryInfo
			SELECT DISTINCT	L.AliasName
			FROM	MMLibrary L WITH(NOLOCK)
				INNER JOIN MMMountPath MP ON MP.LibraryId = L.LibraryId
					AND MP.MountPathTypeId <> 7 AND MountPathName <> 'CVDiskFolder' --Exclude cloud library and cv disk folder
			WHERE	L.LibraryId > 0
				AND ((ExtendedAttributes & 33554432) = 0 OR @showHiddenLibConfig = 1)
AND MP.Attribute & 64 = 64
	   ELSE
		INSERT INTO @DiskLibraryInfo
		SELECT DISTINCT	L.AliasName
		FROM	MMLibrary L WITH(NOLOCK)
			INNER JOIN MMMountPath MP ON MP.LibraryId = L.LibraryId
				AND MP.MountPathTypeId <> 7 AND MountPathName <> 'CVDiskFolder' --Exclude cloud library and cv disk folder
		WHERE	L.LibraryId > 0 AND ((ExtendedAttributes & 33554432) = 0 OR @showHiddenLibConfig = 1)
	END
	ELSE
	BEGIN
			IF ISNULL(@DashBoardType,'')='appliance'
			INSERT INTO @DiskLibraryInfo
			SELECT DISTINCT	L.AliasName
			FROM	MMLibrary L WITH(NOLOCK)
				INNER JOIN #tmpSecurityClientList SC
					ON L.LibraryId = SC.libraryId
				INNER JOIN MMMountPath MP
					ON MP.LibraryId = L.LibraryId
					AND MP.MountPathTypeId <> 7 AND MountPathName <> 'CVDiskFolder' --Exclude cloud library and cv disk folder
			WHERE	L.LibraryId > 0
				AND ((ExtendedAttributes & 33554432) = 0 OR @showHiddenLibConfig = 1)
AND MP.Attribute & 64 = 64
		ELSE
			INSERT INTO @DiskLibraryInfo
			SELECT DISTINCT	L.AliasName
			FROM	MMLibrary L WITH(NOLOCK)
				INNER JOIN #tmpSecurityClientList SC
					ON L.LibraryId = SC.libraryId
				INNER JOIN MMMountPath MP
					ON MP.LibraryId = L.LibraryId
					AND MP.MountPathTypeId <> 7 AND MountPathName <> 'CVDiskFolder' --Exclude cloud library and cv disk folder
			WHERE	L.LibraryId > 0
				AND ((ExtendedAttributes & 33554432) = 0 OR @showHiddenLibConfig = 1)
	END
	IF object_id('tempdb.dbo.#tmpSecurityClientList') IS NOT NULL
	DROP TABLE #tmpSecurityClientList
END
DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from CVCloud..cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
IF object_id('tempdb.dbo.#Summary') is not null DROP TABLE #Summary
CREATE TABLE #Summary (
	CommservUniqueId INT,
	LibraryId INT,
	LibraryName NVARCHAR(256),
	TotalSpaceMB BIGINT,
	TotalFreeSpaceMB BIGINT,
	TotalReserveSpaceMB BIGINT,
	LogDateUTC DATE,
	CurrMonthSizeMB BIGINT,
	PrevMonthSizeMB BIGINT,
	Pre2MonthSizeMB BIGINT,
	MonthlyGrowthMB FLOAT,
	DaysToBeFull INT,
	TotalDataWrittenGB FLOAT,
	TotalAppSizeGB FLOAT,
	[6MonthsGrowth] BIGINT, [12MonthsGrowth] BIGINT, [18MonthsGrowth] BIGINT)
INSERT	INTO #Summary
SELECT	D.CommServUniqueId, D.LibraryId, D.LibraryName,
		ISNULL(totalSpaceGB*1024, -1), ISNULL(totalFreeSpaceGB*1024, -1), ISNULL(totalReserveSpaceMB, -1),
		D.LogDateUTC, NULL, NULL, NULL,
		NULL, NULL, D.totalDataWrittenGB, D.totalAppSizeGB,NULL, NULL, NULL
FROM	CVCloud..cf_Survey96DiskLibDetails D WITH (NOLOCK)
		INNER JOIN CVCloud..cf_CommservSurveyResults AS result
			ON result.CommservSurveyResults_ID = D.SurveyResultId
			AND result.QueryID = @i_QueryId
			AND result.CommcellIdNameMap_ID = @i_CommServUniqueId
			AND result.Flags = 1
		INNER JOIN @DiskLibraryInfo DL
			ON D.LibraryName = DL.DiskLibrary
IF @useStoredPrediction = 0
BEGIN
    IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
    CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
    IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
    CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
    INSERT INTO #GrowthData
    SELECT  S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), ISNULL(S.UsedSpaceMB, -1),
            ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
    FROM    CVCloud..cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
            INNER JOIN #Summary T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.LibraryId
    WHERE   S.MonthStart >= @FirstMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.TotalSpaceMB > 0
	UPDATE  #Summary SET CurrMonthSizeMB = F.Y
	FROM    #GrowthData F
    WHERE   #Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
        AND F.X = 0 AND F.Y > 0
	UPDATE  #Summary SET PrevMonthSizeMB = F.Y
	FROM    #GrowthData F
	WHERE   #Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
    AND F.X = -1 AND F.Y > 0
    UPDATE  #Summary SET Pre2MonthSizeMB = F.Y
    FROM    #GrowthData F
    WHERE   #Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
        AND F.X = -2 AND F.Y > 0
	EXEC CVCloud..GetLinearGrowthRate 0
	UPDATE  S SET MonthlyGrowthMB = T.GrowthRate
    FROM    #Summary S
            INNER JOIN #GrowthRate T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.EntityId
	DROP TABLE #GrowthData
    DROP TABLE #GrowthRate
	UPDATE  #Summary
    SET     DaysToBeFull = CASE
                WHEN 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB) > MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
                ELSE 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
    WHERE   ABS(ISNULL(MonthlyGrowthMB, 0)) > 0.001 AND (TotalFreeSpaceMB-TotalReserveSpaceMB) > 0
	UPDATE  #Summary
    SET     DaysToBeFull = 0
    WHERE   (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 AND TotalFreeSpaceMB >= 0
	UPDATE  #Summary
    SET [6MonthsGrowth] = ISNULL(MonthlyGrowthMB*6, -1),
        [12MonthsGrowth] = ISNULL(MonthlyGrowthMB*12, -1),
        [18MonthsGrowth] = ISNULL(MonthlyGrowthMB*18, -1)
END
ELSE
BEGIN
    -- Use stored prediction from DiskLibraryPrediction
    UPDATE S
    SET S.DaysToBeFull = P.DaysToBeFull,
        S.MonthlyGrowthMB = P.MonthlyGrowthRate,
        S.[6MonthsGrowth] = P.[6MonthsGrowth],
        S.[12MonthsGrowth] = P.[12MonthsGrowth],
        S.[18MonthsGrowth] = P.[18MonthsGrowth]
    FROM #Summary S
    INNER JOIN (
        SELECT CommServUniqueId, LibraryId, MAX(LogDateUTC) AS LogDate
        FROM CVCloud..DiskLibraryPrediction
        GROUP BY CommServUniqueId, LibraryId) AS P0
        ON S.CommservUniqueId = P0.CommServUniqueId AND S.LibraryId = P0.LibraryId
	   INNER JOIN CVCloud..DiskLibraryPrediction P
    ON P.CommServUniqueId = P0.CommServUniqueId AND P.LibraryId = P0.LibraryId AND P.LogDateUTC = P0.LogDate
END
If @Summary =1
BEGIN
ALTER TABLE #Summary ADD DateToBeFULL BIGINT
ALTER TABLE #Summary ADD SortOrder INT
UPDATE S
SET DateToBeFULL =
	CASE WHEN ISNULL(S.DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			WHEN S.DaysToBeFull > 9999 THEN @Never -- For Never
			ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
	END
FROM #Summary  S
DECLARE @CCTotalDataWrittenGB FLOAT
DECLARE @CCTotalAppSizeGB FLOAT
DECLARE @CCTotalSavingsPercentage DECIMAL(32,2)
SELECT
    @CCTotalDataWrittenGB = SUM(Smry.totalDataWrittenGB),
    @CCTotalAppSizeGB = SUM(Smry.totalAppSizeGB),
    @CCTotalSavingsPercentage = CASE WHEN SUM(Smry.totalAppSizeGB) > 0 and SUM(Smry.totalDataWrittenGB) < SUM(Smry.totalAppSizeGB) THEN CAST((1-(SUM(Smry.totalDataWrittenGB)/SUM(Smry.totalAppSizeGB))) * 100 AS DECIMAL(32,2)) ELSE 0 END
    FROM
    (SELECT     D.LibraryId ,MAX(D.totalDataWrittenGB) AS totalDataWrittenGB ,MAX(D.totalAppSizeGB) as totalAppSizeGB
        FROM MMMountPath MP  WITH(NOLOCK)
        inner join MMMediaSide MS WITH(NOLOCK) on MP.MountPathId > 0 and MP.MediaSideId = MS.MediaSideId
        inner join MMLibrary ML WITH(NOLOCK) on MP.LibraryId = ML.LibraryId
        inner join @DiskLibraryInfo DL on ML.AliasName = DL.DiskLibrary
        inner join MMMountPathToStorageDevice MPSD WITH(NOLOCK) on MP.MountPathId = MPSD.MountPathId
        LEFT OUTER JOIN #Summary D  ON D.LibraryId = ML.LibraryId
        WHERE MS.TotalSpaceMB <> 0
		GROUP BY D.LibraryId) Smry
select TOP (@topN) ML.LibraryId 'DiskLibraryId',
      ML.AliasName as 'DiskLibrary',
      CAST(SUM(MS.TotalSpaceMB)  as numeric(20,2)) 'TotalSpaceMB',
	  CAST(SUM(MS.FreeBytesMB) as numeric(20,2)) 'TotalFreeSpaceMB',
	  CASE WHEN SUM(MS.TotalSpaceMB) <= 0 THEN 0 ELSE CAST(SUM(MS.FreeBytesMB)*100.0/SUM(MS.TotalSpaceMB) as numeric(20,2)) END as 'FreeSpacePercentage',
	  CASE WHEN ISNULL(MAX(DaysToBeFull), -1) < 0 THEN @NA -- For N/A
				WHEN MAX(DaysToBeFull) > 9999 THEN @Never -- For Never
				ELSE dbo.getUnixtimebig(DATEADD(DAY, MAX(DaysToBeFull), GETUTCDATE()))
		END AS 'Date to be Full',
		CASE WHEN SUM(S.TotalSpaceMB) = -1024 AND sum(S.TotalFreeSpaceMB) = -1024 THEN @strInfo
				WHEN ISNULL(SUM(S.TotalSpaceMB), -1) <= 0 THEN @strInfo
				WHEN ISNULL(MAX(DaysToBeFull), -1) >= 0 AND MAX(DaysToBeFull) < @criticalThreshold THEN @strCritical
				WHEN ISNULL(MAX(DaysToBeFull), -1) >= 0 AND MAX(DaysToBeFull) >= @criticalThreshold AND MAX(DaysToBeFull) <= @warningThreshold THEN @strwarning
				ELSE @strGood
		END AS 'HealthStatus',
		@CCTotalDataWrittenGB AS 'CCTotalDataWrittenGB',
		@CCTotalAppSizeGB AS 'CCTotalAppSizeGB',
		@CCTotalSavingsPercentage AS 'CCTotalSavingsPercentage'
FROM   MMMountPath MP  WITH(NOLOCK)
		inner join MMMediaSide MS WITH(NOLOCK) on MP.MountPathId > 0 and MP.MediaSideId = MS.MediaSideId
		inner join MMLibrary ML WITH(NOLOCK) on MP.LibraryId = ML.LibraryId
		inner join @DiskLibraryInfo DL on ML.AliasName = DL.DiskLibrary
		inner join MMMountPathToStorageDevice MPSD WITH(NOLOCK) on MP.MountPathId = MPSD.MountPathId
		LEFT OUTER JOIN #Summary S
			ON S.LibraryId = ML.LibraryId
 WHERE MS.TotalSpaceMB <> 0
 GROUP BY ML.LibraryId,ML.AliasName
 ORDER By    [Date to be Full], [FreeSpacePercentage]
END
ELSE
BEGIN
SELECT  DISTINCT
		MP.MountPathId,
		ML.LibraryId,
		ML.AliasName as 'Library',
 		 STUFF(
        (SELECT ' ' + CL.name + Case when len(MPDC.Folder)>0  then' ('+ ISNULL(MPDC.Folder, '') + ')'+char(10)  else '' end
        FROM APP_Client CL WITH(NOLOCK)
        inner join MMDeviceController MPDC WITH(NOLOCK) on MPSD.DeviceId = MPDC.DeviceId
		 WHERE MPDC.ClientId = CL.id  AND CL.origCCId = 2
        FOR XML PATH(''))
        ,1,1,N'')   as 'Media Agent  (Mount Path Location)',
 		CASE MP.MountPathTypeId
			WHEN 1 /* MOUNT_PATH_CENTERA */
			THEN ISNULL(
					(SELECT TOP 1 A.FriendlyName
						FROM MMCenteraInfo A WITH (READUNCOMMITTED) INNER JOIN MMMountPathToStorageDevice B WITH (READUNCOMMITTED)
						ON A.CenteraId = B.CenteraId
						WHERE B.MountPathId = MP.MountPathId),
					'Unavailable')
			ELSE ISNULL((
				SELECT TOP 1 '['+C.name+'] '+DC.Folder
				FROM MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED), MMDeviceController DC WITH (READUNCOMMITTED), APP_Client C WITH (READUNCOMMITTED)
				WHERE DC.Folder <> '' AND MSD.MountPathId = MP.MountPathId AND DC.DeviceId=MSD.DeviceId AND C.id = DC.ClientId
				ORDER BY
				(CASE WHEN DC.DeviceAccessType & 14 = 14 /* 14 = (PREFERRED_DEVICEACCESS|READWRITE_DEVICEACCESS)*/ THEN 0
					WHEN DC.DeviceAccessType & 2 = 2  /* 2 = (WRITE_DEVICEACCESS)*/ THEN 1
					ELSE 2 END),
				DC.DeviceControllerEnabled DESC, DC.DeviceControllerId ASC), MP.MountPathName )
 		END AS 'Mount Path',
		(select  TOP 1 CASE WHEN DC.DeviceAccessible = 1 THEN 'Yes' ELSE 'No' END
			FROM MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED)
			ON  MSD.MountPathId = MP.MountPathId AND DC.DeviceId=MSD.DeviceId) AS 'Device Accessible',
		CASE WHEN MP.IsOffline = 0 AND MD.DeviceEnabled = 1 then 'Online' ELSE 'Offline' END as 'Status',
		CASE ML.LibraryEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS LibraryEnabled,
		CAST(MS.TotalSpaceMB * 1024.0 * 1024.0 as numeric(20,2)) as 'Total Capacity',
		CAST((MS.TotalSpaceMB-MS.FreeBytesMB)* 1024.0 * 1024.0 as numeric(20,2)) as 'Used Space',
		CAST(MS.FreeBytesMB * 1024.0 * 1024.0 as numeric(20,2)) as 'Free Space',
		CASE WHEN MS.TotalSpaceMB <= 0 THEN 0 ELSE CAST(MS.FreeBytesMB*100.0/MS.TotalSpaceMB as numeric(20,2)) END as 'Free Space (%)',
		(select ISNULL(SUM(appSizeFreedBytes), 0) from MMDeletedAF where MountPathId = MP.MountPathId ) AS [Application size to be pruned],
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
				WHEN DaysToBeFull > 9999 THEN @Never -- For Never
				ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
		END AS 'Previous Month Change(MB)',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Previous Month Change(%)',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE (CurrMonthSizeMB-PrevMonthSizeMB)
		END AS 'Current Month Change(MB)',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Current Month Change(%)',
		S.[6MonthsGrowth]  AS '6 Month Growth(MB)',
		S.[12MonthsGrowth] AS '12 Month Growth(MB)',
		S.[18MonthsGrowth] AS '18 Month Growth(MB)',
		CASE WHEN S.TotalSpaceMB = -1024 AND S.TotalFreeSpaceMB = -1024 THEN @strInfo
				WHEN ISNULL(S.TotalSpaceMB, -1) <= 0 THEN @strInfo
				WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull < @criticalThreshold THEN @strCritical
				WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
				ELSE @strGood
		END AS 'HealthStatus',
		S.TotalDataWrittenGB AS 'DataWrittenGB',
		S.TotalAppSizeGB AS 'AppSizeGB'
FROM   MMMountPath MP  WITH(NOLOCK)
		inner join MMMediaSide MS WITH(NOLOCK) on MP.MountPathId > 0 and MP.MediaSideId = MS.MediaSideId
		inner join MMLibrary ML WITH(NOLOCK) on MP.LibraryId = ML.LibraryId
		inner join @DiskLibraryInfo DL on ML.AliasName = DL.DiskLibrary
		inner join MMMountPathToStorageDevice MPSD WITH(NOLOCK) on MP.MountPathId = MPSD.MountPathId
		inner join MMDevice MD ON MD.DeviceId = MPSD.DeviceId
		LEFT OUTER JOIN #Summary S
			ON S.LibraryId = ML.LibraryId
 WHERE MS.TotalSpaceMB <> 0 --AND CL.origCCId = 2
 order by [Date to be Full]
 END
 IF object_id('tempdb.dbo.#Summary') is not null DROP TABLE #Summary
 END TRY
	BEGIN CATCH
			DECLARE  @ErrorMsg VARCHAR(max)
            SELECT    @ErrorMsg ='ERROR:'+ CAST(ERROR_NUMBER() AS VARCHAR(20))+' ErrNo '+
											CAST(ERROR_SEVERITY() AS VARCHAR(3))+' Severity '+
											CAST(ERROR_STATE() AS VARCHAR(3))+' SP '+
											CAST(ISNULL(ERROR_PROCEDURE(),'') AS VARCHAR(25))+' Line '+
											CAST(ERROR_LINE()AS VARCHAR(10))+' Msg '+
											CAST(ERROR_MESSAGE() AS VARCHAR(210));
	        THROW 51000,@ErrorMsg,1;
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetStorageSpaceUtils')
	delete from GxQscripts where name = 'rptGetStorageSpaceUtils'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetStorageSpaceUtils')
	delete from GXDBVersions where aliasname = 'rptGetStorageSpaceUtils'
GO

insert into GXDBVersions values(2, 'rptGetStorageSpaceUtils',  '00010001000400090000', 'rptGetStorageSpaceUtils', '00010001000400090000')
GO

