

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetSLAByVSA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSLAByVSA.sp,v $ $Id: rptGetSLAByVSA.sp,v 1.1.2.5 2020/07/05 02:44:11 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetSLAByVSA')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSLAByVSA <<<'
	drop procedure RptGetSLAByVSA
END
IF EXISTS (select * from GxQscripts where name='RptGetSLAByVSA')
	delete from GxQscripts where name = 'RptGetSLAByVSA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAByVSA')
	delete from GXDBVersions where aliasname = 'RptGetSLAByVSA'
GO
print '... Creating Procedure: RptGetSLAByVSA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetSLAByVSA
  @i_UserId INT = 1,
  @i_ClientId INT = 0,
  @i_AppId INT = 0,
  @i_SLADays INT = -1,
  @i_FullJobsOnly INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- This procedure is only for @i_SLADays = -1
IF	@i_SLADays <> -1
	SET @i_SLADays = -1
/* Temp tables created by caller if needed
CREATE TABLE #SLA_Summary (metSLA INT, missedSLA INT, excluded INT)
CREATE TABLE #VSA_Subclient (appId INT, metSLA INT, missedSLA INT, excluded INT)
*/
DECLARE @returnDetails INT = 1
IF	OBJECT_ID('tempdb.dbo.#SLA_Details') IS NULL
	CREATE TABLE #SLA_Details (vmClientId INT, vsaAppId INT, status INT, category INT, slaDays INT)
ELSE
	SET @returnDetails = 0
IF @i_AppId > 0
	INSERT  INTO #VSA_Subclient (appId)
	SELECT  @i_AppId
ELSE
	INSERT  INTO #VSA_Subclient (appId)
	SELECT  id
	FROM	APP_Application
	WHERE	clientId = @i_ClientId AND appTypeId = 106
DECLARE @isUserAdmin INT = 1
IF	@i_UserId > 0
	EXEC sec_isUserAdmin @i_UserId, @isUserAdmin OUTPUT
IF	@isUserAdmin = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#visibleClient') IS NOT NULL DROP TABLE #visibleClient
	CREATE TABLE #visibleClient
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
EXEC sec_getIdaObjectsForUser @i_UserId, 3, 0, 0, #visibleClient
	INSERT	INTO #SLA_Details
	SELECT	DISTINCT C.clientId, S.appId, C.status, C.category, C.days
	FROM	RptSLAClient C
			INNER JOIN RptSLASubclient S ON C.clientId = S.clientId AND S.appTypeId = 106
			INNER JOIN #VSA_Subclient T ON S.appId = T.appId
			INNER JOIN #visibleClient V ON S.clientId = V.clientId
	WHERE	C.fullJobsOnly = @i_FullJobsOnly AND C.days = @i_SLADays AND C.status IN (1,2)
	INSERT	INTO #SLA_Details
	SELECT	DISTINCT E.clientId, 0, 3, E.category, E.slaDays
	FROM	RptSLAExclusion E
			INNER JOIN APP_ClientProp CP ON E.clientId = CP.componentNameId
				AND	CP.attrName = 'VSA Discover Subclient ID' AND CP.modified =0
			INNER JOIN #VSA_Subclient T ON CP.attrVal = CAST(T.appId AS NVARCHAR(12))
			INNER JOIN #visibleClient V ON E.clientId = V.clientId
	WHERE	E.appTypeId = 0 OR E.appTypeId = 106 AND CP.componentNameId IS NOT NULL
END
ELSE
BEGIN
	INSERT	INTO #SLA_Details
	SELECT	DISTINCT C.clientId, S.appId, C.status, C.category, C.days
	FROM	RptSLAClient C
			INNER JOIN RptSLASubclient S ON C.clientId = S.clientId AND S.appTypeId = 106
			INNER JOIN #VSA_Subclient T ON S.appId = T.appId
	WHERE	C.fullJobsOnly = @i_FullJobsOnly AND C.days = @i_SLADays AND C.status IN (1,2)
	INSERT	INTO #SLA_Details
	SELECT	DISTINCT E.clientId, 0, 3, E.category, E.slaDays
	FROM	RptSLAExclusion E
			INNER JOIN APP_ClientProp CP ON E.clientId = CP.componentNameId
				AND	CP.attrName = 'VSA Discover Subclient ID' AND CP.modified =0
			INNER JOIN #VSA_Subclient T ON CP.attrVal = CAST(T.appId AS NVARCHAR(12))
	WHERE	E.appTypeId = 0 OR E.appTypeId = 106 AND CP.componentNameId IS NOT NULL
END
IF OBJECT_ID('tempdb.dbo.#SLA_Summary') IS NOT NULL
BEGIN
	INSERT	INTO #SLA_Summary
	SELECT	SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
	FROM	#SLA_Details
END
DELETE  FROM #VSA_Subclient
INSERT	INTO #VSA_Subclient
SELECT	vsaAppId, SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
FROM	#SLA_Details
GROUP BY vsaAppId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetSLAByVSA')
	delete from GxQscripts where name = 'rptGetSLAByVSA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSLAByVSA')
	delete from GXDBVersions where aliasname = 'rptGetSLAByVSA'
GO

insert into GXDBVersions values(2, 'rptGetSLAByVSA',  '00010001000200050000', 'rptGetSLAByVSA', '00010001000200050000')
GO

