

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetSLAByDBAgent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSLAByDBAgent.sp,v $ $Id: rptGetSLAByDBAgent.sp,v 1.1.2.2 2020/06/30 10:26:52 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetSLAByDBAgent')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSLAByDBAgent <<<'
	drop procedure RptGetSLAByDBAgent
END
IF EXISTS (select * from GxQscripts where name='RptGetSLAByDBAgent')
	delete from GxQscripts where name = 'RptGetSLAByDBAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAByDBAgent')
	delete from GXDBVersions where aliasname = 'RptGetSLAByDBAgent'
GO
print '... Creating Procedure: RptGetSLAByDBAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetSLAByDBAgent
  @i_UserId INT = 1,
  @i_AppTypeId INT = 0,
  @i_SLADays INT = -1,
  @i_FullJobsOnly INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- This procedure is only for @i_SLADays = -1
IF	@i_SLADays <> -1
	SET @i_SLADays = -1
/* Temp tables created by caller if needed */
-- CREATE TABLE #SLA_Summary (metSLA INT, missedSLA INT)
DECLARE @returnSubclients INT = 1
IF	OBJECT_ID('tempdb.dbo.#SLA_Subclient') IS NULL
	CREATE TABLE #SLA_Subclient (clientId INT, appTypeId INT, appId INT, status INT, category INT, slaDays INT)
ELSE
	SET @returnSubclients = 0
IF	OBJECT_ID('tempdb.dbo.#SLA_Details') IS NULL
	CREATE TABLE #SLA_Details (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, metSLA INT, missedSLA INT)
DECLARE @isUserAdmin INT = 1
IF	@i_UserId > 0
	EXEC sec_isUserAdmin @i_UserId, @isUserAdmin OUTPUT
IF	@isUserAdmin = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#visibleClient') IS NOT NULL DROP TABLE #visibleClient
	CREATE TABLE #visibleClient
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
EXEC sec_getIdaObjectsForUser @i_UserId, 3, 0, 0, #visibleClient
	INSERT	INTO #SLA_Subclient
	SELECT	DISTINCT C.clientId, S.appTypeId, S.appId, C.status, C.category, C.days
	FROM	RptSLAClient C
			INNER JOIN RptSLASubclient S ON C.clientId = S.clientId AND S.appTypeId = @i_AppTypeId
			INNER JOIN #visibleClient V ON S.clientId = V.clientId
	WHERE	C.fullJobsOnly = @i_FullJobsOnly AND C.days = @i_SLADays AND C.status IN (1,2)
END
ELSE
	INSERT	INTO #SLA_Subclient
	SELECT	DISTINCT C.clientId, S.appTypeId, S.appId, C.status, C.category, C.days
	FROM	RptSLAClient C
			INNER JOIN RptSLASubclient S ON C.clientId = S.clientId AND S.appTypeId = @i_AppTypeId
	WHERE	C.fullJobsOnly = @i_FullJobsOnly AND C.days = @i_SLADays AND C.status IN (1,2)
IF @i_AppTypeId IN (37,62,103,135)
	INSERT	INTO #SLA_Details
	SELECT	A.clientId, A.appTypeId, A.Instance, A.backupSet,
			SUM(CASE S.status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE S.status WHEN 2 THEN 1 ELSE 0 END)
	FROM	#SLA_Subclient S
			INNER JOIN APP_Application A ON S.appId = A.id
	GROUP BY A.clientId, A.appTypeId, A.Instance, A.backupSet
ELSE
--IF @i_AppTypeId IN (3,5,22,61,79,80,81,104,128)
	INSERT	INTO #SLA_Details
	SELECT	A.clientId, A.appTypeId, A.Instance, 0,
			SUM(CASE S.status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE S.status WHEN 2 THEN 1 ELSE 0 END)
	FROM	#SLA_Subclient S
			INNER JOIN APP_Application A ON S.appId = A.id
	GROUP BY A.clientId, A.appTypeId, A.Instance
IF OBJECT_ID('tempdb.dbo.#SLA_Summary') IS NOT NULL
BEGIN
	INSERT	INTO #SLA_Summary
	SELECT	SUM(CASE WHEN metSLA > 0 AND missedSLA = 0 THEN 1 ELSE 0 END), SUM(CASE WHEN missedSLA > 0 THEN 1 ELSE 0 END)
	FROM	#SLA_Details
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetSLAByDBAgent')
	delete from GxQscripts where name = 'rptGetSLAByDBAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSLAByDBAgent')
	delete from GXDBVersions where aliasname = 'rptGetSLAByDBAgent'
GO

insert into GXDBVersions values(2, 'rptGetSLAByDBAgent',  '00010001000200020000', 'rptGetSLAByDBAgent', '00010001000200020000')
GO

