

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSLA.sp,v $ $Id: rptGetSLA.sp,v 1.1.4.13.16.1 2021/04/20 11:23:06 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetSLA')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSLA <<<'
	drop procedure RptGetSLA
END
IF EXISTS (select * from GxQscripts where name='RptGetSLA')
	delete from GxQscripts where name = 'RptGetSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLA')
	delete from GXDBVersions where aliasname = 'RptGetSLA'
GO
print '... Creating Procedure: RptGetSLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetSLA
  @i_UserId INT = 1,
  @i_SLADays INT = -1,
  @i_ClientGroupId INT = 0,
  @i_FullJobsOnly INT = 0,
  @o_DateAsOf DATETIME OUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* Temp tables created by caller if needed */
IF	OBJECT_ID('tempdb.dbo.#SLA_Clients') IS NULL
	CREATE TABLE #SLA_Clients (clientId INT, clientType INT, status INT, category INT, slaDays INT)
/*
CREATE TABLE #SLA_Summary (clientType VARCHAR(32), metSLA INT, missedSLA INT, excluded INT)
CREATE TABLE #SLA_Details (clientId INT, appTypeId INT, appId INT, status INT, category INT, slaDays INT)
*/
DECLARE @isUserAdmin INT = 1
IF	@i_UserId > 0
	EXEC sec_isUserAdmin @i_UserId, @isUserAdmin OUTPUT
IF	@isUserAdmin = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#visibleClient') IS NOT NULL DROP TABLE #visibleClient
	CREATE TABLE #visibleClient
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
EXEC sec_getIdaObjectsForUser @i_UserId, 3, 0, 0, #visibleClient
	INSERT	INTO #SLA_Clients
	SELECT	DISTINCT S.clientId, 0, S.status, S.category, days
	FROM	RptSLAClient S INNER JOIN #visibleClient V ON S.clientId = V.clientId
	WHERE	fullJobsOnly = @i_FullJobsOnly AND days = @i_SLADays AND status IN (1,2)
	INSERT	INTO #SLA_Clients
	SELECT	DISTINCT E.clientId, 0, 3, E.category, E.slaDays
	FROM	RptSLAExclusion E
			INNER JOIN #visibleClient V ON E.clientId = V.clientId
			LEFT OUTER JOIN APP_ClientProp CP ON E.clientId = CP.componentNameId
				AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
	WHERE	E.appTypeId = 0 OR E.appTypeId = 106 AND CP.componentNameId IS NOT NULL
END
ELSE
BEGIN
	INSERT	INTO #SLA_Clients
	SELECT	DISTINCT S.clientId, 0, S.status, S.category, days
	FROM	RptSLAClient S
	WHERE	fullJobsOnly = @i_FullJobsOnly AND days = @i_SLADays AND status IN (1,2)
	INSERT	INTO #SLA_Clients
	SELECT	DISTINCT E.clientId, 0, 3, E.category, E.slaDays
	FROM	RptSLAExclusion E
			LEFT OUTER JOIN APP_ClientProp CP ON E.clientId = CP.componentNameId
				AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
	WHERE	E.appTypeId = 0 OR E.appTypeId = 106 AND CP.componentNameId IS NOT NULL
END
IF	@i_ClientGroupId > 0
	DELETE	S FROM #SLA_Clients S
			LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON S.clientId = CGA.clientId AND CGA.clientGroupId = @i_ClientGroupId
	WHERE	CGA.clientId IS NULL
UPDATE	S SET clientType = 1+(C.status&0x1000)/0x1000
FROM	#SLA_Clients S
		INNER JOIN APP_Client C ON S.clientId = C.id
UPDATE	S SET clientType = 4
FROM	#SLA_Clients S
		INNER JOIN APP_ClientProp CP ON S.clientId = CP.componentNameId
			AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
IF OBJECT_ID('tempdb.dbo.#SLA_Summary') IS NOT NULL
BEGIN
	INSERT	INTO #SLA_Summary
	SELECT	'All', SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
	FROM	#SLA_Clients
	UNION ALL
	SELECT	'Server', SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
	FROM	#SLA_Clients
	WHERE	clientType = 1
	UNION ALL
	SELECT	'Laptop', SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
	FROM	#SLA_Clients
	WHERE	clientType = 2
	UNION ALL
	SELECT	'VM', SUM(CASE status WHEN 1 THEN 1 ELSE 0 END), SUM(CASE status WHEN 2 THEN 1 ELSE 0 END), SUM(CASE status WHEN 3 THEN 1 ELSE 0 END)
	FROM	#SLA_Clients
	WHERE	clientType = 4
END
IF OBJECT_ID('tempdb.dbo.#SLA_Details') IS NOT NULL
BEGIN
	INSERT	INTO #SLA_Details (clientId, appTypeId, appId, status, category, slaDays)
	SELECT	S.clientId, S.appTypeId, S.appId,
			CASE WHEN C.status = 3 THEN C.status ELSE S.status END,
			CASE WHEN C.status = 3 THEN C.category ELSE S.category END, S.slaDays
	FROM	RptSLASubclient S
			INNER JOIN #SLA_Clients C ON S.clientId = C.clientId
	WHERE	S.fullJobsOnly = @i_FullJobsOnly
END
SET	@o_DateAsOf = (SELECT TOP 1 date FROM RptSLAClient)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetSLA')
	delete from GxQscripts where name = 'rptGetSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSLA')
	delete from GXDBVersions where aliasname = 'rptGetSLA'
GO

insert into GXDBVersions values(2, 'rptGetSLA',  'v1.1.4.13.16.1', 'rptGetSLA', 'v1.1.4.13.16.1')
GO

