

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetOSType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetOSType.sp,v $ $Id: rptGetOSType.sp,v 1.1.2.1 2020/02/21 09:59:19 bzhu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetOSType')
BEGIN
	print '>>> Drop Stored Procedure: rptGetOSType <<<'
	drop procedure rptGetOSType
END
IF EXISTS (select * from GxQscripts where name='rptGetOSType')
	delete from GxQscripts where name = 'rptGetOSType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetOSType')
	delete from GXDBVersions where aliasname = 'rptGetOSType'
GO
print '... Creating Procedure: rptGetOSType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetOSType
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_ccid INTEGER
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @name NCHAR(255)
  DECLARE @commcellId INTEGER
  DECLARE @hostName NCHAR(255)
  DECLARE @simOSId INTEGER
  DECLARE @simOSName CHAR(64)
  DECLARE @simOSRelease CHAR(64)
  DECLARE @simOSVersion CHAR(64)
  DECLARE @simOSType INTEGER
  DECLARE @release CHAR(255)
  DECLARE @buildId CHAR(255)
  DECLARE @ipAddress NCHAR(255)
  DECLARE @smtpServer NCHAR(255)
  DECLARE @ERUser NCHAR(255)
  DECLARE @installDir NCHAR(255)
  DECLARE @isAllEnabled INTEGER
  DECLARE @isBkpEnabled INTEGER
  DECLARE @isRstEnabled INTEGER
  DECLARE @isPruneEnabled INTEGER
  DECLARE @isAuxCopyEnabled INTEGER
  DECLARE @isSchedEnabled INTEGER
  DECLARE @isOnlineCIEnabled INTEGER
  DECLARE @isOfflineCIEnabled INTEGER
  DECLARE @DRPolicy NVARCHAR(255)
  DECLARE @description NVARCHAR(MAX)
  DECLARE @displayName NCHAR(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @allEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(1 /* All */,       1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @backupEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(4 /* Backup */,     1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @restoreEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(5 /* Restore */,   1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @pruneEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(10 /* Prune */,  1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @auxCopyEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(13 /* AuxCopy */,  1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @scheduleEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(28 /* Schedule */,    1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @onlineCIEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(57 /* OnlineCI */,    1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	DECLARE @offlineCIEnabled INTEGER =  ISNULL(CASE dbo.JMIsOpTypeEnabled(53 /* OfflineCI */,  1 /* COMMCELL_ENTITY */, default, default) WHEN 1 THEN 2 ELSE 1 END, 0)
	SELECT cl.displayName as name, (SELECT TOP 1 CommCellId FROM LicCsl WITH (NOLOCK) ORDER BY id DESC), cl.net_hostname, O.id, O.name, dbo.GetClientOSRelease(@i_ccId, NULL), dbo.GetClientOSVersion(@i_ccId, NULL), 0, --O.type,
	--  (select TOP 1 SR.release from simClientAppsV2 A, simProdMapV2 M, simPackageV2 P, simAppTypeLicTypeMap L, simAllGalaxyRel SR
	--      where A.clientId=cl.id and A.simProdMapId=M.id and M.simPackageId=P.id
	--      and P.simAppTypeLicTypeMapId=L.id and L.appTypeId=1000 and SR.id=A.releaseId ORDER BY SR.release DESC),
	--  (select TOP 1 A.buildId from simClientAppsV2 A, simProdMapV2 M, simPackageV2 P, simAppTypeLicTypeMap L
	--      where A.clientId=cl.id and A.simProdMapId=M.id and M.simPackageId=P.id
	--      and P.simAppTypeLicTypeMapId=L.id and L.appTypeId=1000 order by installTime DESC),
		(select TOP 1 SR.release from LicUsage A, simAllGalaxyRel SR
			where A.CId = cl.id AND A.LicType NOT IN (71, 10, 26) AND A.OpType='Install' AND
			A.appType = 1000 and SR.id = A.releaseId ORDER BY SR.release DESC),
		(select TOP 1 A.Build from LicUsage A, simAllGalaxyRel SR
			where A.CId = cl.id AND A.OpType='Install' AND
			A.appType = 1000 and SR.id = A.releaseId ORDER BY SR.release DESC),
		cc.ipAddress, cc.smtpServer, cc.userName, pl.install_dir,
		@allEnabled,
		@backupEnabled,
		@restoreEnabled,
		@pruneEnabled,
		@auxCopyEnabled,
		@scheduleEnabled,
		@onlineCIEnabled,
		@offlineCIEnabled,
		(select G.name from ArchGroup G, APP_Application A where A.appTypeId=1000 and A.clientId=cl.id and A.dataArchGrpId=G.id),
		ISNULL((select value from GxGlobalParam where name = N'User Description'), N''),
		cl.displayName
	FROM APP_Client cl, simOperatingSystem O, APP_CommCell cc, APP_Platform pl
	WHERE cl.simOperatingSystemId=O.id AND cc.id=@i_ccId AND cl.id=pl.clientId and pl.platformType=1 AND cc.clientId = cl.id
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetOSType')
	delete from GxQscripts where name = 'rptGetOSType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetOSType')
	delete from GXDBVersions where aliasname = 'rptGetOSType'
GO

insert into GXDBVersions values(2, 'rptGetOSType',  '00010001000200010000', 'rptGetOSType', '00010001000200010000')
GO

