

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetIDAList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetIDAList.sp,v $ $Id: rptGetIDAList.sp,v 1.1.6.6 2019/04/05 01:56:04 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Cursor: "rptGetIDAList"				|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetIDAList')
BEGIN
	print '>>> Drop Stored Procedure: rptGetIDAList <<<'
	drop procedure rptGetIDAList
END
IF EXISTS (select * from GxQscripts where name='rptGetIDAList')
	delete from GxQscripts where name = 'rptGetIDAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetIDAList')
	delete from GXDBVersions where aliasname = 'rptGetIDAList'
GO
print '... Creating Procedure: rptGetIDAList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetIDAList
  @iDAList varchar(max),
  @i_clientId integer,
  @i_userId integer
AS
  DECLARE @clientId integer
  DECLARE @appTypeId integer
  DECLARE @clientName nchar(255)
  DECLARE @appTypeName char(255)
  DECLARE @release nchar(255)
  DECLARE @bkpEnabled integer
  DECLARE @rstEnabled integer
  DECLARE @opIgnore integer
  DECLARE @deleted integer
  DECLARE @installTime integer
  DECLARE @buildId char(255)
  DECLARE @userGroups nvarchar(max)
  DECLARE @o_description nvarchar(max)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 IF object_id('tempdb.dbo.#TEMP_IDA_LIST') IS NOT NULL DROP TABLE #TEMP_IDA_LIST
 IF object_id('tempdb.dbo.#TEMP2') IS NOT NULL DROP TABLE #TEMP2
DECLARE @clId 			integer
DECLARE @appTypeId1		integer
CREATE TABLE #TEMP_IDA_LIST(clientId integer, appTypeId integer, opIgnore integer, deleted integer, groupList text, description nchar(2048), origCCId integer)
DECLARE @SQLString nvarchar(MAX)
set @SQLString ='INSERT INTO #TEMP_IDA_LIST
SELECT distinct A.clientId, A.appTypeId,
	ISNULL((select attrVal from APP_IDAProp
		where componentNameId=I.id and attrName=''Ignore commcell operation rule'' and modified=0),0),
	(case when ((I.status & 4)=0 and (I.status & 2)=0) then 0 else 1 end), '''',
	(select attrVal from APP_IDAProp
		where componentNameId=I.id and attrName=''IDA Description'' and modified=0),
	(select origCCId from APP_Client where id = A.clientId)
FROM	APP_Application A, APP_IDAName I
WHERE  '+ @iDAList +' A.appTypeId < 1000 and A.clientId=I.clientId and A.appTypeId=I.appTypeId and A.clientId ='+cast( @i_clientId as nvarchar(max))
EXECUTE sp_executesql @SQLString;
IF object_id('tempdb.dbo.#entityGroupTable') is not null
	drop table #entityGroupTable
create table #entityGroupTable
(
	entityId int
)
IF object_id('tempdb.dbo.#usergroups') is not null
	drop table #usergroups
CREATE table #usergroups (name nvarchar(max),clientId INT )
IF object_id('tempdb.dbo.#tempUserGroupList') is not null   DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList(clId integer, groupList text)
-- USER SECURITY CHECK FOR THIS USER
exec sec_getUserGroupsForThisUser '#entityGroupTable', @i_userId
DECLARE @entityType1 INT = 3
IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
--get list of user UMGroups that have permissions on each SP
DECLARE iDAUserGroupList CURSOR FOR
	SELECT clientId, appTypeId FROM #TEMP_IDA_LIST
OPEN iDAUserGroupList
FETCH NEXT FROM iDAUserGroupList INTO @clId, @appTypeId1
WHILE @@FETCH_STATUS = 0
BEGIN
    DECLARE @i_entityList XML
    SET @i_entityList = (SELECT
3  as '@entityType1',
    @clId  as '@entityId1',
4 as '@entityType2',
	@appTypeId1  as '@entityId2'
    for xml path('entity'),root('entityList') )
--  THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
    TRUNCATE TABLE #tgroupObjects
    exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,@entityType1, @i_entityList,0,0,0,0
	TRUNCATE TABLE #usergroups
    INSERT INTO #usergroups
        select distinct UG.name,t.entityId1
    FROM    UMGroups UG INNER JOIN #tgroupObjects t ON
    UG.id = t.userORGroupId and t.isUSer = 0
    INNER JOIN #entityGroupTable E ON
    UG.id = E.entityId
    TRUNCATE TABLE #tempUserGroupList
    INSERT INTO #tempUserGroupList
    Select distinct cg2.clientId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #usergroups cg1
            Where cg1.clientId = cg2.clientId
            ORDER BY cg1.clientId
            For XML PATH ('')
        ), 2, 1000) [groups]
    From #usergroups cg2
	update #TEMP_IDA_LIST set groupList = (select groupList from #tempUserGroupList g	where
		G.clId = @clId ) where clientId = @clId and apptypeId = @appTypeId1
	FETCH NEXT FROM iDAUserGroupList INTO @clId, @appTypeId1
END
CLOSE iDAUserGroupList
DEALLOCATE iDAUserGroupList
drop table #entityGroupTable
DROP TABLE #usergroups
IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
SELECT clId=T.clientId, appId=T.appTypeId, buildid = C.build, installTime=dbo.GetUnixTime( C.opTimeUTC )  INTO #TEMP2
FROM	#TEMP_IDA_LIST T	INNER JOIN LicUsage C ON C.CId = T.clientId AND C.LicType NOT IN (71, 10, 26) AND C.appType = T.appTypeId	AND C.OpType='Install'
--Ignoring the Metrics Reporting Server for CommCell Console client which is having the Server as a hard dependency
IF @i_clientId = 2
	DELETE IL
	FROM #TEMP_IDA_LIST IL
		LEFT JOIN #TEMP2 AS T ON IL.appTypeId = T.appId
	WHERE T.appId IS NULL AND IL.appTypeId = 121
SELECT T.clientId, T.appTypeId,
	clientName=(select displayName from APP_Client where id=T.clientId),
	appTypeName=(select case when (type = 90 ) then 'Notes Data Archiver' else name end from APP_iDAType where type=T.appTypeId),
	release = CASE WHEN EXISTS (select * from APP_CommCell where type = 100 and id = T.origCCId)
				   THEN ISNULL((select attrVal from APP_ClientProp where componentNameId = T.clientId and attrName = 'Foreign Client Version' and modified =0), '')
				   ELSE ISNULL((select TOP 1 SR.release from LicUsage LU, simAllGalaxyRel SR
								where LU.cid = T.clientId AND LU.LicType NOT IN (71, 10, 26) and
								SR.id = LU.releaseId and LU.optype='Install' ORDER BY SR.release DESC),'') END,
	bkpEnabled=(select action from JMJobAction
		where clientId=T.clientId and appType=T.appTypeId and mediaAgentId=1 and opType=4),
	rstEnabled=(select action from JMJobAction
		where clientId=T.clientId and appType=T.appTypeId and mediaAgentId=1 and opType=5),
	T.opIgnore, T.deleted,
	(select max(installTime) from #TEMP2 where clId=clientId and appId=appTypeId),
	(select TOP 1 buildId from #TEMP2 where clId=clientId and appId=appTypeId order by installTime DESC),
	T.groupList userGroups,
	T.description
 FROM #TEMP_IDA_LIST T
 ORDER BY appTypeName
 DROP TABLE #TEMP_IDA_LIST
 DROP TABLE #TEMP2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetIDAList')
	delete from GxQscripts where name = 'rptGetIDAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetIDAList')
	delete from GXDBVersions where aliasname = 'rptGetIDAList'
GO

insert into GXDBVersions values(2, 'rptGetIDAList',  '00010001000600060000', 'rptGetIDAList', '00010001000600060000')
GO

