

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetFirewallInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetFirewallInfo.sp,v $ $Id: rptGetFirewallInfo.sp,v 1.1.6.6 2018/11/18 03:52:16 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						CURSOR : "testit"								|
--	|																		|
--  | DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION		|
--	| AND RETURNING RESULTS													|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetFirewallInfo')
BEGIN
	print '>>> Drop Stored Procedure: rptGetFirewallInfo <<<'
	drop procedure rptGetFirewallInfo
END
IF EXISTS (select * from GxQscripts where name='rptGetFirewallInfo')
	delete from GxQscripts where name = 'rptGetFirewallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetFirewallInfo')
	delete from GXDBVersions where aliasname = 'rptGetFirewallInfo'
GO
print '... Creating Procedure: rptGetFirewallInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetFirewallInfo
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_jobId integer
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @clientId integer
  DECLARE @clientName nchar(255)
  DECLARE @clientGroupId integer
  DECLARE @restrictionType integer
  DECLARE @tunnelconnectionPort integer
  DECLARE @foreceSSL integer
  DECLARE @keepAliveSeconds integer
  DECLARE @tunnelInitSeconds integer
  DECLARE @lockDown integer
  DECLARE @bindOpenPortsOnly integer
  DECLARE @data_ports nchar(255)
  DECLARE @connectionProtocol integer
  DECLARE @routeType integer
  DECLARE @viaProxyName nchar(255)
  DECLARE @allowed_tppms nchar(255)
  DECLARE @isRoamingClient integer
  DECLARE @extendedProp XML
 set nocount on
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  BEGIN
		DECLARE @data_ports1 varchar(max)
		DECLARE @allowed_tppms1 varchar(max)
		DECLARE @rowCount integer
		DECLARE @xmlText XML = (SELECT dbo.GetXMLJobOptions(@i_jobid))
		DECLARE @includeAll INT = (SELECT TOP 1 TMMsg.n.value('@includeAll','INT') FROM @xmlText.nodes('TMMsg_JobOption/adminOpts/reportOption/computerSelectionList') TMMsg(n))
		DECLARE @clientSelLst TABLE (clientId INT)
		DECLARE @clientGrpSelLst TABLE (clientGrpId INT)
DECLARE @userId INT = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
		IF @includeAll = 0
		BEGIN
			INSERT INTO @clientSelLst(clientId)
			SELECT TMMsg.n.value('@clientId','INT') FROM @xmlText.nodes('TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientList') TMMsg(n)
			INSERT INTO @clientGrpSelLst(clientGrpId)
			SELECT TMMsg.n.value('@clientGroupId','INT') FROM @xmlText.nodes('TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList') TMMsg(n)
			INSERT INTO @clientSelLst(clientId)
			SELECT DISTINCT clientId FROM APP_ClientGroupAssoc INNER JOIN @clientGrpSelLst ON clientGroupId=clientGrpId
		END
		SET @rowCount = (SELECT COUNT(*) FROM APP_FIREWALL)
		IF(@rowCount > 0)
		BEGIN
			SET @data_ports1=''
			SET @allowed_tppms1=''
			SELECT @data_ports1=
				@data_ports1+  ', ' +
				CASE
					WHEN (pr.startPort = pr.endPort) THEN
						CAST(pr.startPort AS varchar(8))
					ELSE CAST(pr.startPort AS varchar(8)) + '-' + cast(pr.endPort AS varchar(8))
				END
			FROM APP_FWPortRange as pr  WITH (READUNCOMMITTED) WHERE clientId = 2
			SET @data_ports1 = STUFF(@data_ports1, 1, 1, '')
			SELECT @allowed_tppms1 = @allowed_tppms1 + CAST(toPortNumber AS varchar(10)) + ',' FROM APP_FirewallTPPM WHERE tppmParams = ''
			IF @allowed_tppms1 IS NOT NULL AND LEN(@allowed_tppms1) > 0
			BEGIN
				SELECT @allowed_tppms1 = SUBSTRING(@allowed_tppms1,1,LEN(@allowed_tppms1) -1)
			END
			IF object_id('tempdb.dbo.#outtable') is not null	DROP TABLE #outtable
			SELECT
				f.forClientId AS forClientId,
				CASE
					WHEN f.forClientId = 0 THEN
					f.forClientGroupId
					ELSE
					f.forClientId
					END AS clientId,
				CASE
					WHEN f.forClientId <> 0 THEN
					(SELECT Top 1 displayName as name from APP_Client  WITH (READUNCOMMITTED) where id = f.forClientId)
					ELSE
					(SELECT Top 1 name from APP_ClientGroup  WITH (READUNCOMMITTED) where id = f.forClientGroupId)
					END AS clientName,
				fo.clientGroupId AS clientGroupId,
				ISNULL(f.restrictionType, -1) AS restrictionType,
				fo.tunnelconnectionPort,
				fo.foreceSSL,
				fo.keepAliveSeconds,
				fo.tunnelInitSeconds,
				fo.lockDown,
				fo.bindOpenPortsOnly,
				@data_ports1 AS data_ports,
				ISNULL((CASE
					WHEN f.forClientId = 0 THEN
						(SELECT TOP 1
							dx.c.value('@connectionProtocol', 'integer')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') AS dx(c)
						WHERE clientGroupId = f.forClientGroupId AND ogr.forClientId = 0)
					ELSE
						(SELECT TOP 1
							dx.c.value('@connectionProtocol', 'integer')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') AS dx(c)
						WHERE clientId = f.forClientId AND ogr.forClientId = 2)
					END), -1) AS connectionProtocol,
				ISNULL((CASE
					WHEN f.forClientId = 0 THEN
						(SELECT Top 1
							dx.c.value('@routeType', 'integer')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') AS dx(c)
						WHERE clientId = f.forClientGroupId AND ogr.forClientId = 0)
					ELSE
						(SELECT Top 1
							dx.c.value('@routeType', 'integer')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') AS dx(c)
						WHERE clientId = f.forClientId AND ogr.forClientId = 2)
					END), -1) AS routeType,
				ISNULL((CASE
					WHEN f.forClientId = 0 THEN
						(SELECT Top 1
							dx.c.value('@clientGroupName', 'varchar(255)')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') AS dx(c)
						WHERE clientId = f.clientId and ogr.forClientGroupId = f.forClientGroupId)
					ELSE
						(SELECT Top 1
							dx.c.value('@clientName', 'varchar(255)')
						FROM App_FWOutGoingRoutes as ogr WITH (READUNCOMMITTED)
						CROSS APPLY ogr.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') AS dx(c)
						WHERE clientId = f.ClientId and ogr.forClientId = f.forClientId)
					END), '') AS viaProxyName,
					@allowed_tppms1 AS allowed_tppms,
				fo.isRoamingClient,
				ISNULL( fo.extendedProperties , '<App_FirewallExtendedProperties defaultOutgoingProtocol="0"/>' ) AS extendedProp
				into #outtable
			FROM APP_Firewall AS f  WITH (READUNCOMMITTED)
			LEFT OUTER JOIN App_FirewallOptions AS fo  WITH (READUNCOMMITTED)
			ON
			f.clientId = 2
				AND
				(
					(f.forClientId = fo.clientId AND f.forClientGroupId = fo.clientGroupId AND f.forClientId = 0 )
					OR
					(f.clientId = fo.clientId AND f.clientGroupId = fo.clientGroupId AND f.forClientId <> 0 AND (@includeAll = 1 OR f.forClientId IN (SELECT clientId FROM @clientSelLst)))
				)
				WHERE  ((f.forClientId = 0 AND @includeAll = 1 OR f.forClientGroupId IN (SELECT clientGrpId FROM @clientGrpSelLst))
						OR (f.forClientId <> 0 AND @includeAll = 1 OR f.forClientId IN (SELECT clientId FROM @clientSelLst)))
			SET @rowCount = (SELECT COUNT(*) FROM #outtable)
			IF(@rowCount <1 )
				GOTO NODataFound
			IF @userId > 1 --SECURITY
			BEGIN
				IF object_id('tempdb.dbo.#tmpObjByUser') IS NOT NULL DROP TABLE #tmpObjByUser
create table  #tmpObjByUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,2009,0,'#tmpObjByUser' --CLIENT_ITEM->client
				--If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
IF NOT EXISTS(SELECT * FROM #tmpObjByUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
				delete from #outtable
				where clientId not in (select clientId from #tmpObjByUser T where clientId > 0)
				 AND  forClientId <> 0
				drop table #tmpObjByUser
				IF object_id('tempdb.dbo.#RptGetRegistryKeyInfo_userObjects') is not null 		DROP TABLE #RptGetRegistryKeyInfo_userObjects
create table  #RptGetRegistryKeyInfo_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,2572,0,'#RptGetRegistryKeyInfo_userObjects'
IF NOT EXISTS(SELECT * FROM #RptGetRegistryKeyInfo_userObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
				delete from #outtable
				where (clientGroupId not in (select clientGroupId from #RptGetRegistryKeyInfo_userObjects T where clientGroupId > 0) or clientGroupId is null)
				 AND  forClientId = 0
				 DROP TABLE #RptGetRegistryKeyInfo_userObjects
			END
			SET @rowCount = (SELECT COUNT(*) FROM #outtable)
			IF(@rowCount <1 )
				GOTO NODataFound
			SELECT clientId,clientName,clientGroupId,restrictionType,tunnelconnectionPort, foreceSSL, keepAliveSeconds, tunnelInitSeconds, lockDown, bindOpenPortsOnly,data_ports ,connectionProtocol ,routeType ,viaProxyName ,allowed_tppms ,isRoamingClient,extendedProp from #outtable
			DROP TABLE #outtable
			return
		END
NODataFound:
		SELECT
			-1 AS clientId,
			'' AS clientName,
			-1 AS clientGroupId,
			-1 AS restrictionType,
			0 AS tunnelconnectionPort,
			-1 AS foreceSSL,
			0 AS keepAliveSeconds,
			0 AS tunnelInitSeconds,
			0 AS lockDown,
			0 AS bindOpenPortsOnly,
			'' AS data_ports,
			-1 AS connectionProtocol,
			-1 AS routeType,
			'' AS viaProxyName,
			'' AS allowed_tppms,
			0 AS isRoamingClient,
			'<App_FirewallExtendedProperties defaultOutgoingProtocol="0"/>'   AS extendedProp
  END
   set nocount off
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetFirewallInfo')
	delete from GxQscripts where name = 'rptGetFirewallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetFirewallInfo')
	delete from GXDBVersions where aliasname = 'rptGetFirewallInfo'
GO

insert into GXDBVersions values(2, 'rptGetFirewallInfo',  '00010001000600060000', 'rptGetFirewallInfo', '00010001000600060000')
GO

