

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetDuplicateBarCodeForSlot.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDuplicateBarCodeForSlot.sp,v $ $Id: rptGetDuplicateBarCodeForSlot.sp,v 1.1.2.4 2018/03/20 00:38:44 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       STORED PROCEDURE : "rptGetDuplicateBarCodeForSlot"              |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptGetDuplicateBarCodeForSlot <<<'

IF EXISTS (select * from sysobjects where name='rptGetDuplicateBarCodeForSlot')
	drop procedure rptGetDuplicateBarCodeForSlot
IF EXISTS (select * from GxQscripts where name='rptGetDuplicateBarCodeForSlot')
	delete from GxQscripts where name = 'rptGetDuplicateBarCodeForSlot'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDuplicateBarCodeForSlot')
	delete from GXDBVersions where aliasname = 'rptGetDuplicateBarCodeForSlot'
GO
print '... Creating Procedure: rptGetDuplicateBarCodeForSlot'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetDuplicateBarCodeForSlot
AS
  DECLARE @barCode char(255)
  DECLARE @location NVARCHAR(255)
  DECLARE @library NVARCHAR(255)
  DECLARE @libraryId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
--          FETCH ALL THE DUPLICATE BARCODE LIST FROM SLOT TABLE
--          -------------------------------------------------------
BEGIN
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#GDBCFS_TMP') IS NOT NULL DROP TABLE #GDBCFS_TMP
		CREATE TABLE #GDBCFS_TMP(Barcode VARCHAR(256), MediaId INT)
	INSERT INTO #GDBCFS_TMP
	SELECT BarCode, MAX(MediaId)
	FROM MMSlot WHERE BarCode <> '' AND SlotType = 1
	GROUP BY BarCode
	HAVING COUNT(BarCode) > 1
--            NOW DELETE ITEMS THAT ARE IN RSM LIB
--           ------------------------------------------------------
    DELETE #GDBCFS_TMP
		FROM #GDBCFS_TMP, MMMedia AS M
    WHERE #GDBCFS_TMP.MediaId <> 0 AND #GDBCFS_TMP.BarCode=M.BarCode AND M.ExternalGUID <> ''
--          FINALLY, RETURN THE ROWS TO THE CALLER
--          -------------------------------------------------------
    SELECT distinct S.BarCode, S.SlotName, L.AliasName, L.LibraryId
    FROM #GDBCFS_TMP AS F, MMSlot AS S, MMBay AS B, MMLibrary AS L
    WHERE F.BarCode=S.BarCode AND S.BayId=B.BayId AND B.LibraryId=L.LibraryId
    ORDER BY S.BarCode
    IF OBJECT_ID('tempdb.dbo.#GDBCFS_TMP') IS NOT NULL DROP TABLE #GDBCFS_TMP
    SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetDuplicateBarCodeForSlot')
	delete from GxQscripts where name = 'rptGetDuplicateBarCodeForSlot'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDuplicateBarCodeForSlot')
	delete from GXDBVersions where aliasname = 'rptGetDuplicateBarCodeForSlot'
GO

insert into GXDBVersions values(2, 'rptGetDuplicateBarCodeForSlot',  '00010001000200040000', 'rptGetDuplicateBarCodeForSlot', '00010001000200040000')
GO

