

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetDeduplicationRates.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDeduplicationRates.sp,v $ $Id: rptGetDeduplicationRates.sp,v 1.3.86.2 2018/03/20 00:37:08 jiechen Exp $";
-- 	+---------------------------------------------------------------------------+
--	| 						Stored Proc: "rptGetDeduplicationRates"								|
--	|																			|
--  |Gets the list of subclients with no DM schedule set.		|
-- 	+---------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptGetDeduplicationRates <<<'

IF EXISTS (select * from sysobjects where name='rptGetDeduplicationRates')
	drop procedure rptGetDeduplicationRates
IF EXISTS (select * from GxQscripts where name='rptGetDeduplicationRates')
	delete from GxQscripts where name = 'rptGetDeduplicationRates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDeduplicationRates')
	delete from GXDBVersions where aliasname = 'rptGetDeduplicationRates'
GO
print '... Creating Procedure: rptGetDeduplicationRates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetDeduplicationRates
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_nCommcellSummary int = 0
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @o_commcellName NVARCHAR(255);
DECLARE @o_SIDBStoreName NVARCHAR(255);
DECLARE @o_policyName NVARCHAR(255);
DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_sizeOfApplicationGB DECIMAL(20,2);
  DECLARE @o_dataWrittenGB DECIMAL(20,2);
  DECLARE @o_deduplicationRatioInPercentage DECIMAL(20,2);
  DECLARE @o_dedupRatio NVARCHAR(20);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE  #SIDedupRates(
  policyId integer,
policyName NVARCHAR(255),
  copyId integer,
copyName NVARCHAR(255),
  copyFlags integer,
  dedupeFlags integer,
  SIDBStoreId integer,
SIDBStoreName NVARCHAR(255),
  NumOfPartitions integer,
clientName  NVARCHAR(255),
accessPath  varchar(255),
  SIDBStoreFlags integer,
  CreatedTime integer,
  LastDDBBackupJobId integer,
  LastDDBBackupTime integer,
  LastRecoveryTime integer,
  SealedTime integer,
  SealedReason integer,
  sizeOfApplication bigint,
  sizeOfStore bigint,
  sizeOfNotSiloedData bigint,
  sizeOfSiloedData bigint,
  sizeOffDisk bigint,
  sizeOfSIDB bigint,
  retainUntil bigint,
  retainedByJobId integer,
  SizeForBaseline bigint,
  AppSizeToBeFreed bigint
 )
INSERT INTO #SIDedupRates
exec RptGetSIStore ''
DECLARE @CommCellName NVARCHAR(256)
SELECT @CommCellName = (SELECT aliasName FROM APP_CommCell Where clientId = 2)
IF @i_nCommcellSummary = 1
BEGIN
SELECT	@CommCellName AS 'Commcell',
		CAST(ISNULL(SUM(T.sizeOfApplication)/1024.0/1024.0/1024.0/1024.0, 0) AS DECIMAL(20,2)) AS 'Application Size(TB)',
		CAST(ISNULL(SUM(T.sizeOfStore)/1024.0/1024.0/1024.0/1024.0, 0) AS DECIMAL(20,2)) AS 'Data Written(TB)',
		ISNULL(CASE WHEN SUM(T.SIDBStoreId) = 0 OR SUM(T.sizeOfApplication) = 0 OR SUM(T.sizeOfApplication) < SUM(T.sizeOfStore) THEN 0
					ELSE CAST((100.0*(SUM(T.SizeOfApplication) - SUM(T.sizeOfStore))/SUM(T.sizeOfApplication)) AS DECIMAL(20,2)) END, 0) AS 'Deduplication Ratio (%)',
				CASE
					WHEN SUM(T.sizeOfStore) < = 0 OR SUM(T.sizeOfApplication) < SUM(T.sizeOfStore) THEN 'N/A'
				 	ELSE CAST (CAST ((SUM(T.sizeOfApplication)/SUM(T.sizeOfStore) +0.5) AS BIGINT) AS NVARCHAR(MAX))+': 1'
				END AS 'Dedup Ratio'
FROM	(SELECT DISTINCT sizeOfApplication, sizeOfStore, SIDBStoreId
		FROM #SIDedupRates) T
END
ELSE
BEGIN
SELECT
		(SELECT TOP 1 aliasName FROM APP_CommCell WHERE id = (SELECT TOP 1 CommCellId FROM archCopySIDBStore WHERE SIDBStoreId = T.SIDBStoreId)) AS 'CommCell',
		T.SIDBStoreName AS 'DDB Store',
		CAST(ISNULL(T.sizeOfApplication/1024.0/1024.0/1024.0, 0) AS DECIMAL(20,2)) AS 'Application Size(GB)',
		CAST(ISNULL(T.sizeOfStore/1024.0/1024.0/1024.0, 0) AS DECIMAL(20,2)) AS 'Data Written(GB)',
		ISNULL(CASE WHEN (T.SIDBStoreId) = 0 OR (T.sizeOfApplication) = 0 OR (T.sizeOfApplication) < (T.sizeOfStore) THEN 0
					ELSE CAST(100.0*((T.SizeOfApplication) - (T.sizeOfStore))/(T.sizeOfApplication) AS DECIMAL(20,2)) END, 0) AS 'Deduplication Ratio (%)',
				CASE
					WHEN (T.sizeOfStore) < = 0 OR (T.sizeOfApplication) < (T.sizeOfStore) THEN 'N/A'
				 	ELSE CAST (CAST (( (T.sizeOfApplication)/(T.sizeOfStore) +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
				END AS 'Dedup Ratio'
FROM	(SELECT DISTINCT SIDBStoreName, sizeOfApplication, sizeOfStore, SIDBStoreId
		FROM #SIDedupRates) T
ORDER BY [Deduplication Ratio (%)] DESC
END
DROP TABLE #SIDedupRates
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetDeduplicationRates')
	delete from GxQscripts where name = 'rptGetDeduplicationRates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDeduplicationRates')
	delete from GXDBVersions where aliasname = 'rptGetDeduplicationRates'
GO

insert into GXDBVersions values(2, 'rptGetDeduplicationRates',  '00010003008600020000', 'rptGetDeduplicationRates', '00010003008600020000')
GO

