

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetDataOnCopySummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDataOnCopySummary.sp,v $ $Id: rptGetDataOnCopySummary.sp,v 1.7.80.8 2020/02/14 19:14:06 samrutkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetDataOnCopySummary')
BEGIN
	print '>>> Drop Stored Procedure: rptGetDataOnCopySummary <<<'
	drop procedure rptGetDataOnCopySummary
END
IF EXISTS (select * from GxQscripts where name='rptGetDataOnCopySummary')
	delete from GxQscripts where name = 'rptGetDataOnCopySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDataOnCopySummary')
	delete from GXDBVersions where aliasname = 'rptGetDataOnCopySummary'
GO
print '... Creating Procedure: rptGetDataOnCopySummary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetDataOnCopySummary
  @i_rptJobId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @ArchGroupId INT
  DECLARE @ArchGroupName NVARCHAR(255)
  DECLARE @CopyId INT
  DECLARE @CopyName NVARCHAR(255)
  DECLARE @CopyType INT
  DECLARE @JobsOnCopy INT
  DECLARE @BytesOnCopy BIGINT
  DECLARE @BytesOnMedia BIGINT
  DECLARE @JobsToCopy INT
  DECLARE @BytesToCopy BIGINT
  DECLARE @BytesOfThroughput BIGINT
  DECLARE @SecondsOfThroughput INT
  DECLARE @LastAuxCopyJobId INT
  DECLARE @LastAuxCopyJobStartTime INT
  DECLARE @LastAuxCopyJobStatus INT
  DECLARE @LastAuxCopyJobState INT
-- CopyType
-- 0: Primary
-- 1: Synchronous
-- 2: Selective
-- 3: Primary Snap
-- 4: Snap Mirror
-- 5: Snap Vault
-- 6: SILO
-- 7: Secondary SILO
SET NOCOUNT ON
DECLARE	@SPCopyOpt		INT = 0
DECLARE	@clientOpt		INT = 0
DECLARE	@jobTypeOpt		INT = 0
DECLARE @bkpLevelOpt	INT = 0
DECLARE @startTime		INT = 0
DECLARE @endTime		INT = 0
DECLARE @includeAged	INT = 0
DECLARE @CopiedSizeIsAppSize INT = 0
SET     @CopiedSizeIsAppSize = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMS2_CONFIG_STRING_AUXCOPY_DETAILS_IN_APPLICATION_SIZE'), 0)
IF (@CopiedSizeIsAppSize < 0)
    SET @CopiedSizeIsAppSize = 0
CREATE TABLE #TblOptClients		(clientId INT)
CREATE TABLE #TblSubclients		(appId INT)
CREATE TABLE #TblOptSPCopies	(policyId INT, copyId INT)
CREATE TABLE #TblSPCopies		(id INT, archGroupId INT, primaryCopyId INT, sourceCopyId INT, dedupeFlags INT, PRIMARY KEY (id))
CREATE TABLE #TblJobsOnCopy		(jobId INT, commCellId INT, archGrpCopyId INT, appSize BIGINT, sizeOnMedia BIGINT)
CREATE TABLE #TblJobsToCopy		(jobId INT, commCellId INT, archGrpCopyId INT,
								totalAppSize BIGINT, totalBackupSize BIGINT, physicalSize BIGINT, disabled INT)
CREATE TABLE #TblSizeToCopy		(archGrpCopyId INT, jobsToCopy INT, bytesToCopy BIGINT, partialSize BIGINT, partialSizeOnMedia BIGINT)
CREATE TABLE #TblLastAuxCopyJob (archGrpCopyId INT,	jobId INT, PRIMARY KEY (archGrpCopyId))
CREATE TABLE #TblCopySummary	(archGrpId INT, archGrpCopyId INT, jobsOnCopy INT, bytesOnCopy BIGINT, bytesOnMedia BIGINT,
								jobsToCopy INT, bytesToCopy BIGINT, bytes BIGINT, seconds INT,
								AuxCopyJobId INT, AuxCopyStartTime INT, AuxCopyStatus INT, AuxCopyState INT)
IF @i_rptJobId > 0
BEGIN
	INSERT INTO #TblOptSPCopies
	EXEC rptOptGetStoragePolicies @i_rptJobId, @SPCopyOpt OUTPUT
	INSERT INTO #TblOptClients
	EXEC rptOptGetClients @i_rptJobId, @clientOpt OUTPUT
	EXEC RptOptGetTime @i_rptJobId, @startTime OUTPUT, @endTime OUTPUT
SET @jobTypeOpt  = dbo.GetJobOption(@i_rptJobId, 1917819217)
	SET @bkpLevelOpt = CASE @jobTypeOpt WHEN 3 THEN 4 WHEN 4 THEN (64|128) ELSE @jobTypeOpt END
SET @includeAged = dbo.GetJobOption(@i_rptJobId, 1394728741)
END
IF	@endTime = 0
	SET @endTime = 0x7FFFFFFF
IF @clientOpt > 0
	INSERT	INTO #TblSubclients
	SELECT	A.id
	FROM	APP_Application A INNER JOIN #TblOptClients C ON A.clientId = C.clientId
ELSE
	INSERT	INTO #TblSubclients
	SELECT	A.id
	FROM	APP_Application A
IF	@SPCopyOpt > 0
	INSERT	INTO #TblSPCopies
	SELECT	AGC.id, AG.id, AG.defaultCopy, CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultCopy END,
			AGC.dedupeFlags
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #TblOptSPCopies T
	WHERE	AGC.archGroupId = AG.id
		AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0
		AND AG.id = T.policyId AND (T.copyId = 0 OR AGC.id = T.copyId)
ELSE
	INSERT	INTO #TblSPCopies
	SELECT	AGC.id, AG.id, AG.defaultCopy, CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId ELSE AG.defaultCopy END,
			AGC.dedupeFlags
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.archGroupId = AG.id AND AG.type IN (1, 2)
		AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0
DROP TABLE #TblOptClients
DROP TABLE #TblOptSPCopies
INSERT	INTO #TblJobsToCopy
SELECT	J.jobId, J.commCellId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize, SUM(J.sizeOnMedia), MAX(J.disabled & 1)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		INNER JOIN (SELECT id FROM #TblSPCopies WHERE id <> primaryCopyId) C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON J.appId = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (@includeAged > 0 OR (J.disabled & 256) = 0)
	AND	(@bkpLevelOpt = 0 OR (@bkpLevelOpt & B.bkpLevel) > 0) AND B.totalBackupSize > 0
	AND B.servStartDate BETWEEN @startTime AND @endTime
GROUP BY J.jobId, J.commCellId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize
HAVING MAX(J.status) IN (101, 102, 103)
INSERT	INTO #TblJobsToCopy
SELECT	J.jobId, J.commCellId, J.archGrpCopyId, A.totalBackupSize, A.totalBackupSize, SUM(J.sizeOnMedia), MAX(J.disabled & 1)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON A.jobId = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN (SELECT id FROM #TblSPCopies WHERE id <> primaryCopyId) C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON J.appId = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (@includeAged > 0 OR (J.disabled & 256) = 0)
	AND	(@bkpLevelOpt = 0 OR (@bkpLevelOpt & A.ER_BkpLevel) > 0) AND A.totalBackupSize > 0
	AND A.servStart BETWEEN @startTime AND @endTime
GROUP BY J.jobId, J.commCellId, J.archGrpCopyId, A.totalBackupSize
HAVING MAX(J.status) IN (101, 102, 103)
UPDATE	P SET physicalSize = T.physicalSize
FROM	#TblJobsToCopy P
		INNER JOIN
		(
		SELECT	J.jobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS physicalSize
		FROM	#TblJobsToCopy J
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
				INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
		WHERE	J.physicalSize > 0
		GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
		) T ON P.jobId = T.jobId AND P.commCellId = T.commCellId AND P.archGrpCopyId = T.archGrpCopyId
INSERT	INTO #TblSizeToCopy
SELECT	archGrpCopyId, COUNT(DISTINCT jobId),
		CASE WHEN @CopiedSizeIsAppSize = 0 THEN SUM(totalBackupSize - physicalSize)
			 ELSE SUM((1.0*(totalBackupSize - physicalSize)/totalBackupSize)*totalAppSize) END,
		CASE WHEN @CopiedSizeIsAppSize = 0 THEN SUM(physicalSize)
			 ELSE SUM((1.0*physicalSize/totalBackupSize)*totalAppSize) END,
		SUM(physicalSize)
FROM	#TblJobsToCopy
WHERE	disabled = 0
GROUP BY archGrpCopyId
DROP TABLE #TblJobsToCopy
INSERT	INTO #TblJobsOnCopy
SELECT	J.jobId, J.commCellId, J.archGrpCopyId, B.totalUncompBytes, SUM(J.sizeOnMedia)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		INNER JOIN #TblSPCopies C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON J.appId = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (@includeAged > 0 OR (J.disabled & 256) = 0)
	AND	(@bkpLevelOpt = 0 OR (@bkpLevelOpt & B.bkpLevel) > 0) AND B.totalBackupSize > 0
	AND B.servStartDate BETWEEN @startTime AND @endTime
GROUP BY J.jobId, J.commCellId, J.archGrpCopyId, B.totalUncompBytes
HAVING MAX(J.status) = 100 AND MIN(J.status) = 100
INSERT	INTO #TblJobsOnCopy
SELECT	J.jobId, J.commCellId, J.archGrpCopyId, A.totalBackupSize, SUM(J.sizeOnMedia)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON A.jobId = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN #TblSPCopies C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON J.appId = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (@includeAged > 0 OR (J.disabled & 256) = 0)
	AND	(@bkpLevelOpt = 0 OR (@bkpLevelOpt & A.ER_BkpLevel) > 0) AND A.totalBackupSize > 0
	AND A.servStart BETWEEN @startTime AND @endTime
GROUP BY J.jobId, J.commCellId, J.archGrpCopyId, A.totalBackupSize
HAVING MAX(J.status) = 100 AND MIN(J.status) = 100
DROP TABLE #TblSubclients
INSERT	INTO #TblCopySummary
SELECT	C.archGroupId, C.id, ISNULL(SUM(T.nJobs), 0), ISNULL(SUM(T.sizeOnCopy), 0), ISNULL(SUM(T.sizeOnMedia), 0), 0, 0, 0, 0, 0, 0, -1, -1
FROM	#TblSPCopies C LEFT OUTER JOIN
		(SELECT	archGrpCopyId, COUNT(DISTINCT jobId) AS nJobs,
				CASE WHEN @CopiedSizeIsAppSize = 0 THEN SUM(sizeOnMedia) ELSE SUM(appSize) END AS sizeOnCopy,
				SUM(sizeOnMedia) AS sizeOnMedia
		FROM	#TblJobsOnCopy
		GROUP BY archGrpCopyId
		) T	ON C.id = T.archGrpCopyId
GROUP BY C.archGroupId, C.id
UPDATE	#TblCopySummary
SET		bytesOnCopy += T.bytesOnCopy, bytesOnMedia += T.bytesOnMedia, jobsToCopy += T.jobsToCopy, bytesToCopy += T.bytesToCopy
FROM	#TblCopySummary S,
		(SELECT	archGrpCopyId, SUM(partialSize) AS bytesOnCopy, SUM(partialSizeOnMedia) AS bytesOnMedia,
				SUM(jobsToCopy) AS jobsToCopy, SUM(bytesToCopy) AS bytesToCopy
		FROM	#TblSizeToCopy
		GROUP BY archGrpCopyId) T
WHERE	S.archGrpCopyID = T.archGrpCopyId
DROP TABLE #TblSizeToCopy
-- Calculate bytesOnMedia of dedup copies using the average dedup ratio.
CREATE TABLE #DedupeCopy (
	archGrpCopyId INT, activeStoreId INT, dedupeFlags INT,
	dataRead BIGINT, dataWritten BIGINT,
	dedupRatio FLOAT, dedupSaving DECIMAL(10,2)
)
INSERT INTO #DedupeCopy
SELECT	id, 0, dedupeFlags, 0, 0, 0, 0
FROM	#TblSPCopies
WHERE	(dedupeFlags & (268435456|262144)) = 262144
EXEC DedupCopySaving 0
UPDATE	#TblCopySummary
SET		bytesOnMedia = bytesOnCopy*dedupRatio
FROM	#DedupeCopy
WHERE	#TblCopySummary.archGrpCopyId = #DedupeCopy.archGrpCopyId
UPDATE  #TblCopySummary
SET     bytesOnMedia = subQ.sumSizeOnMedia
FROM    #TblCopySummary S,
            (SELECT SUM(ACM.physicalSize) sumSizeOnMedia, t.archGrpCopyId
                  FROM archChunkMapping ACM WITH (READUNCOMMITTED)
                  INNER JOIN #TblJobsOnCopy t ON ACM.jobId = t.jobId AND ACM.commCellId = t.commCellId AND ACM.archcopyid = t.archGrpCopyId
                  INNER JOIN #TblSPCopies sc ON sc.id = t.archGrpCopyId
WHERE sc.dedupeFlags & 262144 = 0
        GROUP BY t.archGrpCopyId ) subQ
WHERE s.archGrpCopyID = subQ.archGrpCopyId
DROP TABLE #TblJobsOnCopy
DROP TABLE #DedupeCopy
CREATE INDEX Idx_TblCopySummary_CopyId ON #TblCopySummary (archGrpCopyID)
UPDATE	#TblCopySummary
SET		bytes = T.BytesXferred, seconds = T.mediaUsageTime
FROM	#TblCopySummary A,
		(SELECT	C.archGrpCopyID, C.BytesXferred, C.mediaUsageTime
		FROM	(SELECT	S.archGrpCopyId, MAX(D.jobId) AS jobId
				FROM	#TblCopySummary S, JMDataCopiedStatsTable D WITH (NOLOCK)
				WHERE	D.archGrpCopyID = S.archGrpCopyId AND D.mediaUsageTime > 0
				GROUP BY S.archGrpCopyId) B,
				JMDataCopiedStatsTable C WITH (NOLOCK)
		WHERE	C.jobId = B.jobId AND C.archGrpCopyID = B.archGrpCopyId) T
WHERE	A.archGrpCopyId = T.archGrpCopyId
INSERT	INTO #TblLastAuxCopyJob
SELECT	S.id, MAX(J.jobId)
FROM	#TblSPCopies S, JMAdminJobInfoTable J WITH (NOLOCK)
WHERE	J.archGrpID = S.archGroupId AND J.archGrpCopyID IN (0, S.id) AND J.opType IN (13, 104)
GROUP BY S.id
UPDATE	#TblCopySummary
SET		AuxCopyJobId = B.jobId, AuxCopyStartTime = B.jobStartTime, AuxCopyStatus = 0, AuxCopyState = B.state
FROM	#TblCopySummary S,
		(SELECT	A.archGrpCopyId, J.jobId, J.jobStartTime, J.state
		FROM	#TblLastAuxCopyJob A, JMJobInfo J WITH (NOLOCK)
		WHERE	J.jobId = A.jobId) B
WHERE	S.archGrpCopyId = B.archGrpCopyId
INSERT	INTO #TblLastAuxCopyJob
SELECT	S.id, MAX(J.jobId)
FROM	#TblSPCopies S, JMAdminJobStatsTable J WITH (NOLOCK)
WHERE	J.archGrpID = S.archGroupId AND J.archGrpCopyID IN (0, S.id) AND J.opType IN (13, 104)
	AND S.id NOT IN (SELECT archGrpCopyId FROM #TblLastAuxCopyJob)
GROUP BY S.id
DROP TABLE #TblSPCopies
UPDATE	#TblCopySummary
SET		AuxCopyJobId = B.jobId, AuxCopyStartTime = B.servStart, AuxCopyStatus = B.status
FROM	#TblCopySummary S,
		(SELECT	A.archGrpCopyId, J.jobId, J.servStart, J.status
		FROM	#TblLastAuxCopyJob A, JMAdminJobStatsTable J WITH (NOLOCK)
		WHERE	J.jobId = A.jobId) B
WHERE	S.archGrpCopyId = B.archGrpCopyId
DROP TABLE #TblLastAuxCopyJob
SELECT	AG.id		AS StoragePolicyId,
		AG.name		AS StoragePolicyName,
		AGC.id		AS CopyId,
		AGC.name	AS CopyName,
		CASE WHEN AGC.id = AG.defaultCopy THEN 0
			 WHEN AGC.id = AG.defaultSnapCopy THEN 3
			 WHEN AGC.isSnapCopy = 1 THEN (CASE WHEN AGC.isMirrorCopy = 1 THEN 4 ELSE 5 END)
WHEN (AGC.flags & 524288) > 0 THEN 6
WHEN (AGC.extendedFlags & 8) > 0 THEN 7
WHEN AGC.type = 2 THEN 2
			 ELSE 1
		END				AS CopyType,
		T.jobsOnCopy	AS JobsOnCopy,
		T.bytesOnCopy	AS BytesOnCopy,
		T.bytesOnMedia	AS BytesOnMedia,
		T.jobsToCopy	AS JobsToCopy,
		T.bytesToCopy	AS BytesToCopy,
		T.bytes			AS BytesOfThroughput,
		T.seconds		AS SecondsOfThroughput,
		T.AuxCopyJobId		AS LastAuxCopyJobId,
		T.AuxCopyStartTime	AS LastAuxCopyJobStartTime,
		T.AuxCopyStatus		AS LastAuxCopyJobStatus,
		T.AuxCopyState		AS LastAuxCopyJobState
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #TblCopySummary T
WHERE	AG.id = T.archGrpId AND AGC.id = T.archGrpCopyId
ORDER BY AG.name, CopyType, AGC.name
DROP TABLE #TblCopySummary
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetDataOnCopySummary')
	delete from GxQscripts where name = 'rptGetDataOnCopySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDataOnCopySummary')
	delete from GXDBVersions where aliasname = 'rptGetDataOnCopySummary'
GO

insert into GXDBVersions values(2, 'rptGetDataOnCopySummary',  '00010007008000080000', 'rptGetDataOnCopySummary', '00010007008000080000')
GO

