

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetBackupVms.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetBackupVms.sp,v $ $Id: rptGetBackupVms.sp,v 1.15.64.14 2020/12/11 19:27:06 samrutkar Exp $";
-- 	+---------------------------------------------------+
--	| 			PROCEDURE : "rptGetBackupVMs"			|
-- 	+---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='rptGetBackupVMs')
BEGIN
	print '>>> Drop Stored Procedure: rptGetBackupVMs <<<'
	drop procedure rptGetBackupVMs
END
IF EXISTS (select * from GxQscripts where name='rptGetBackupVMs')
	delete from GxQscripts where name = 'rptGetBackupVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetBackupVMs')
	delete from GXDBVersions where aliasname = 'rptGetBackupVMs'
GO
print '... Creating Procedure: rptGetBackupVMs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure rptGetBackupVMs
  @i_rptJobId INTEGER,
  @i_bkpJobId INTEGER,
  @i_commcellId INTEGER
AS
  DECLARE @o_type INTEGER;
  DECLARE @o_jobId INTEGER;
  DECLARE @o_commCellId INTEGER;
  DECLARE @o_vmClientId INTEGER;
  DECLARE @o_vmName NVARCHAR(510);
  DECLARE @o_vmHardwareVersion NVARCHAR(1024);
  DECLARE @o_vmBackupType INTEGER;
  DECLARE @o_vmTransportMode NVARCHAR(1024);
  DECLARE @o_vmCBTStatus NVARCHAR(1024);
  DECLARE @o_vmSize BIGINT;
  DECLARE @o_usedSpace BIGINT;
  DECLARE @o_vmBkpStartTime INTEGER;
  DECLARE @o_vmBkpEndTime INTEGER;
  DECLARE @o_vmStatus INTEGER;
  DECLARE @o_instanceType INTEGER;
  DECLARE @o_vmStubStatus INTEGER;
  DECLARE @o_guestSize BIGINT;
  DECLARE @o_poweredOff INTEGER;
  DECLARE @o_proxyAgent NVARCHAR(510);
  DECLARE @o_operatingSystem NVARCHAR(510);
  DECLARE @o_owners NVARCHAR(MAX);
  DECLARE @o_failureReason NVARCHAR(MAX);
  DECLARE @o_toolsVersion NVARCHAR(MAX);
  DECLARE @o_host NVARCHAR(MAX);
  DECLARE @o_appAwareStatus NVARCHAR(MAX);
  DECLARE @o_vmJobId INTEGER;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @jobId				INTEGER
DECLARE @subClientOpt		INTEGER
DECLARE @clOpt				INTEGER
DECLARE @tblClients			TABLE (t_clId INT)
DECLARE @proxyClientId		INTEGER
SET @jobId			= dbo.GetOptionInt(127117398, @i_rptJobId, 0, 0)
SET @subClientOpt	= dbo.GetOptionInt(1880827487, @i_rptJobId, 0, 0)
INSERT INTO @tblClients EXEC rptOptGetClients @i_rptJobId, @clOpt OUTPUT
SET @proxyClientId = ISNULL((SELECT clientId FROM APP_Application A, JMBkpStats J WHERE A.id = J.appId AND J.jobId = @i_bkpJobId and J.commCellId = @i_commcellId), 0)
IF (@proxyClientId = 0)
      SET @proxyClientId = ISNULL((SELECT clientId FROM APP_Application A, JMBkpJobInfo J WHERE A.id = J.applicationId AND J.jobId = @i_bkpJobId and J.commCellId = @i_commcellId), 0)
DECLARE     @tblJob TABLE(jobid INT, commcellId INT, appId INT, servStartDate INT)
INSERT INTO @tblJob
SELECT jobid, commCellId, appid, servStartDate FROM JMBkpStats WHERE jobId = @i_bkpJobId AND commcellId = @i_commcellId
UNION
SELECT B.jobId, B.commcellId, B.applicationId, J.jobStartTime FROM JMBkpJobInfo B, JMJobInfo J WHERE J.jobId = B.jobId AND J.commCellId = B.commcellId AND B.jobId = @i_bkpJobId AND B.commcellId = @i_commcellId
IF object_id('tempdb.dbo.#VMList') IS NOT NULL
	DROP TABLE #VMList
DECLARE @releaseId INT
DECLARE @servStartDate INT
SELECT @servStartDate = servStartDate FROM @tblJob
SELECT @releaseId = ISNULL(MAX(ReleaseId), 15) FROM LicUsageHistory WHERE CId = @proxyClientId AND OpTimeUTC <= dbo.GetDateTime(@servStartDate)  AND AppType = 106
CREATE TABLE #VMList
(
	type					INT,		-- 1 - old job, 2 - Job after reporting changes, 3 - VM reporting not applicable
	jobId					INT,
	commcellId				INT,
	vmClientId				INT,
	vmName					NVARCHAR(510),
	vmHardwareVersion		NVARCHAR(1024),
	vmBackupType			INT,
	vmTransportMode			NVARCHAR(1024),
	vmCBTStatus				NVARCHAR(1024),
	vmSize					BIGINT,
	vmUsedSpace				BIGINT,
	vmBkpStartTime			INTEGER,
	vmBkpEndTime			INTEGER,
	vmStatus				INTEGER,
	instanceType			INTEGER,
	vmStubStatus			INTEGER,
	vmGuestSize				BIGINT,
	poweredOff				INTEGER,
	vmProxyAgent			NVARCHAR(510),
	operatingSystem			NVARCHAR(510),
	owners					NVARCHAR(MAX),
	failureReason			NVARCHAR(MAX),
	toolsVersion			NVARCHAR(MAX),
	host					NVARCHAR(MAX),
	appAwareStatus			NVARCHAR(MAX),
	vmJobId					INT
)
DECLARE @backupLevelView INT
SET @backupLevelView = (SELECT	TOP 1 CAST(attrVal AS INT)
						FROM	APP_SubClientProp S, @tblJob J
						WHERE	S.attrName = 'Virtual Server Backup Level View'
							AND J.jobId = @i_bkpJobId AND J.commCellId = @i_commcellId
							AND S.componentNameId = J.appId
							AND S.created <= J.servStartDate
							AND (S.modified = 0 OR S.modified > J.servStartDate))
IF @releaseId < 14
BEGIN
	INSERT INTO #VMList VALUES (3, 0, 0, 0, N'', N'', 0, N'', N'', -1, 0, 0, 0, 0, 0, 0, 0, 0, N'', N'', N'', N'', N'',N'',N'',0)
	GOTO END_OF_SP
END
IF @jobId > 0 OR @subClientOpt > 0 OR @clOpt = 0
BEGIN
	INSERT	INTO #VMList
	SELECT	1, Q.jobId, Q.commcellId, Q.clientId, Q.clientName, N'', 0, N'', N'', -1, 0, 0, 0, Q.status, 0, 0, 0, 0, N'', N'', N'', N'', N'',N'',N'',0
	FROM	JMQinetixUpdateStatus Q
	WHERE	Q.jobId = @i_bkpJobId
		AND	Q.commcellId = @i_commcellId
END
ELSE
BEGIN
	INSERT	INTO #VMList
	SELECT	1, Q.jobId, Q.commcellId, Q.clientId, Q.clientName, N'', 0, N'', N'', -1, 0, 0, 0, Q.status, 0, 0, 0, 0, N'', N'', N'', N'', N'',N'',N'',0
	FROM	JMQinetixUpdateStatus Q
	WHERE	Q.jobId = @i_bkpJobId
		AND	Q.commcellId = @i_commcellId
		AND (Q.clientId in (select t_clId from @tblClients) OR @proxyClientId IN (select t_clId from @tblClients))
END
UPDATE VL
set vmName = C.displayName
FROM #VMList VL
INNER JOIN APP_Client C
on VL.vmClientId = C.id
WHERE ISNULL(C.displayName, '') != ''
-- Now update the empty columns with the right values from APP_vmProp table
UPDATE	#VMList
SET		instanceType = (SELECT TOP 1 I.attrVal
						FROM @tblJob J, APP_Application A, APP_InstanceProp I
						WHERE J.appId = A.id AND A.instance = I.componentNameId
							AND I.attrName = 'Virtual Server Instance Type'
							AND I.created <= J.servStartDate
							AND (I.modified = 0 OR I.modified > J.servStartDate)
							AND J.jobId = @i_bkpJobId
							AND J.commCellId = @i_commcellId)
UPDATE	#VMList
SET		vmHardwareVersion	= ISNULL((SELECT attrVal	FROM App_Clientprop A WHERE V.vmClientId = A.componentNameId AND attrName = 'Virtual Machine Hardware Version' AND A.modified = 0), N'')
, vmBackupType		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupType'), 9)
, vmTransportMode	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmTransportMode'), N'')
, vmCBTStatus		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmCBTStatus'), N'')
, vmSize			= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmSize'), 0)
, vmUsedSpace		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmUsedSpace'), 0)
, vmBkpStartTime	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupStartTime'), 0)
, vmBkpEndTime		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupEndTime'), 0)
, vmStatus			= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmStatus'), 0)
, vmStubStatus		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmStubStatus'), 0)
, vmGuestSize		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmGuestSize'), 0)
, poweredOff		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmIsPoweredOffByCurrJob'), 0)
, vmProxyAgent		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmAgent'), 0)
		, operatingSystem	= ISNULL((SELECT attrVal 	FROM app_clientprop A WITH (NOLOCK)where attrname = 'Operating System Name' and modified = 0 and A.componentNameId = V.vmClientId), N'')
, failureReason		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmFailureReason'), N'')
		, toolsVersion		= ISNULL((SELECT attrVal 	FROM app_clientprop A WITH (NOLOCK) where attrname = 'Virtual Machine Tools Version' and modified = 0 and A.componentNameId = V.vmClientId), N'')
, host				= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmHost'), N'')
		, owners			= ISNULL(dbo.getclientowners(V.vmClientId), N'')
, appAwareStatus	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE V.jobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmApplJobDetails'), N'')
		, type				= 2
FROM	#VMList V
WHERE	EXISTS(SELECT * FROM APP_VMProp WHERE jobId = @i_bkpJobId AND commCellId = @i_commcellId)
-- For V1 we do not have entry in JMJobDataLink
-- For V2 we have to fetch data from APP_VMProp using the child job id.
UPDATE V
SET
 vmBackupType		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupType'), 9)
, vmTransportMode	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmTransportMode'), N'')
, vmCBTStatus		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmCBTStatus'), N'')
, vmSize			= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmSize'), 0)
, vmUsedSpace		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmUsedSpace'), 0)
, vmBkpStartTime	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupStartTime'), 0)
, vmBkpEndTime		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmBackupEndTime'), 0)
, vmStatus			= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmStatus'), 0)
, vmStubStatus		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmStubStatus'), 0)
, vmGuestSize		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmGuestSize'), 0)
, poweredOff		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmIsPoweredOffByCurrJob'), 0)
, vmProxyAgent		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmAgent'), 0)
, failureReason		= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmFailureReason'), N'')
, host				= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmHost'), N'')
		, owners			= ISNULL(dbo.getclientowners(V.vmClientId), N'')
, appAwareStatus	= ISNULL((SELECT attrVal	FROM APP_vmProp A WHERE DL.childJobId = A.jobId AND V.commCellId = A.commCellId AND V.vmClientId = A.VMclientId AND attrName = 'vmApplJobDetails'), N'')
		, type				= 2
FROM #VMList V
INNER JOIN JMJobDataLink DL ON DL.parentjobid = V.jobid AND DL.linkType = 7 AND DL.commCellId = V.commcellId
INNER JOIN APP_VMProp VM ON VM.jobid = DL.childJobId AND VM.commCellId = V.commCellId and VM.VMclientId = V.vmClientId AND VM.attrName = 'vmStatus'
Where V.type = 1
UPDATE	#VMList
SET		vmSize = (CASE WHEN @backupLevelView IN (1, 2) THEN -1 ELSE vmSize END)
		, vmUsedSpace = (CASE WHEN @backupLevelView = 1 THEN -1 ELSE vmUsedSpace END)
		, vmCBTStatus = (CASE WHEN @backupLevelView IN (1, 2) THEN 'N/A' ELSE vmCBTStatus  END)
UPDATE V
SET failureReason = dbo.JMGetLocalizedMessageFunc(0, B.failureReason)
FROM #VMList V INNER JOIN JMBkpStats B ON V.jobId = B.jobId AND V.commcellId = B.commCellId
WHERE V.vmStatus = 1 --VMClientBkupStatus_failed
	AND (V.failureReason IS NULL OR V.failureReason = N'')
	AND B.status = 9 AND B.failureErrorCode = 8 --Failed to start because another instance of the same job is running (MAXINSTANCESRUNNING)
--Update the per VM Job IDs
UPDATE V
SET vmJobId = J.JobId
FROM #VMList V
INNER JOIN JMBkpStats J WITH(NOLOCK)  INNER JOIN JMJobDataLink jLink ON J.jobID = jLink.childJobId AND J.commcellId = jLink.commCellId AND jLink.linkType = 7
	ON V.JobId = jLink.parentJobId AND V.CommCellId = J.CommCellId AND V.vmClientId = J.targetClientId
WHERE bkpAttributesEx & 0x4000000 <> 0
END_OF_SP:
SELECT * FROM #VMList ORDER BY vmJobId, vmName
IF object_id('tempdb.dbo.#VMList') IS NOT NULL
	DROP TABLE #VMList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetBackupVms')
	delete from GxQscripts where name = 'rptGetBackupVms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetBackupVms')
	delete from GXDBVersions where aliasname = 'rptGetBackupVms'
GO

insert into GXDBVersions values(2, 'rptGetBackupVms',  '00010015006400140000', 'rptGetBackupVms', '00010015006400140000')
GO

