

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptGetAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetAlerts.sp,v $ $Id: rptGetAlerts.sp,v 1.3.14.2 2018/03/27 09:05:38 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Cursor: "rptGetAlerts"				|
--	|									|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptGetAlerts <<<'

IF EXISTS (select * from sysobjects where name='rptGetAlerts')
	drop procedure rptGetAlerts
IF EXISTS (select * from GxQscripts where name='rptGetAlerts')
	delete from GxQscripts where name = 'rptGetAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetAlerts')
	delete from GXDBVersions where aliasname = 'rptGetAlerts'
GO
print '... Creating Procedure: rptGetAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetAlerts
  @userId integer
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @alertId integer
  DECLARE @alertNotifType integer
  DECLARE @reportingOptions integer
  DECLARE @delayTimeSeconds integer
  DECLARE @persistTimeSeconds integer
  DECLARE @alertCategoryNameId integer
  DECLARE @alertTypeNameId integer
  DECLARE @alertCriteriaNameId integer
  DECLARE @criteriaParamType integer			
  DECLARE @criteriaParamValue integer			
  DECLARE @criteriaParamUnit integer
  DECLARE @status integer	
  DECLARE @xmlEntityList nvarchar(MAX)
  DECLARE @alertName nvarchar(MAX)
  DECLARE @alertCreator nvarchar(MAX)
  DECLARE @alertCategoryName nvarchar(MAX)
  DECLARE @alertType nvarchar(MAX)
  DECLARE @alertCriteria nvarchar(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
declare @i_userId int
set @i_userId = @userId
declare @hasRights int
set @hasRights=0
IF object_id('tempdb.dbo.#alertListTmp') is not null
                    DROP TABLE #alertListTmp
create table  #alertListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userID, 2018, 2, '#alertListTmp'
declare @capabilitiesWant bigint
set @capabilitiesWant = POWER(2, (18-1))--18 -> EV_MANAGE_ALERTS
IF EXISTS (SELECT 1 FROM #alertListTmp sec WHERE (capabilities & @capabilitiesWant) <> 0 and
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
	SET @hasRights = 1
DROP TABLE #alertListTmp
IF object_id('tempdb.dbo.#tempResTab') is not null
    DROP TABLE #tempResTab
SELECT	N.id, N.notifType,
	S.reportingOptions, S.delayTimeSeconds, S.persistTimeSeconds,
	C.nameId, T.nameId alertTypeNameId, Cr.nameId alertCriteriaNameId,
	P.type, P.value, P.unit, N.status, N.xmlEntityList,
	N.notificationName, (select login from UMUsers where id=N.notifOwner) login, convert(nvarchar(max),C.name) as name,
	convert(nvarchar(max),T.name) alertType, convert(nvarchar(max),Cr.name) alertCriteria
into #tempResTab
FROM	NTNotificationRule N	INNER JOIN NTCategory C ON N.categoryId=C.id
				INNER JOIN NTAlertType T ON N.alertTypeId=T.id and C.id= T.categoryId
				LEFT JOIN NTSelCriteria S ON N.id=S.ruleId AND S.esclationLevel=1
				LEFT JOIN NTCriteria Cr ON S.availCriteriaId=Cr.id
				LEFT JOIN NTSelCriteriaParams P ON P.selCriteriaId=S.id
WHERE	N.revision > 0 AND (N.notifOwner = @i_userId or @hasRights = 1 )
	AND N.status & 32 <> 32 --SRM Based alerts
	AND N.status & 64 <> 64 --ROMS Alerts
insert into #tempResTab
SELECT	N.id, N.notifType,
	S.reportingOptions, S.delayTimeSeconds, S.persistTimeSeconds,
	C.nameId,T.nameId alertTypeNameId, Cr.nameId alertCriteriaNameId,
	P.type, P.value, P.unit, N.status,N.xmlEntityList,
	N.notificationName, (select login from UMUsers where id=notifOwner) login,
	C.name,  T.name alertType,Cr.name alertCriteria
FROM NTnotificationsByUserView V
		JOIN NTNotificationRule N ON V.NTnotificationId = N.id
		INNER JOIN NTCategory C ON N.categoryId=C.id
		INNER JOIN NTAlertType T ON N.alertTypeId=T.id and C.id= T.categoryId
		LEFT JOIN NTSelCriteria S ON N.id=S.ruleId AND S.esclationLevel=1
		LEFT JOIN NTCriteria Cr ON S.availCriteriaId=Cr.id
		LEFT JOIN NTSelCriteriaParams P ON P.selCriteriaId=S.id
WHERE (userId=@i_userId or @hasRights = 1) and N.id not in(select id from #tempResTab)
	AND N.status & 32 <> 32 --SRM Based alerts
	AND N.status & 64 <> 64 --ROMS Alerts
-- Generate temp table with alertId, alarmId and report Criteria and update that in the temp #tempResTab table
declare @alarmCriteria table
(
	alertId int,
	alarmId int,
	reportCriteria nvarchar(max),
	reportName nvarchar(max)
)
Insert into @alarmCriteria
select null,alarmID,extendedprops.value('(/alarmProps/@description)[1]','nvarchar(max)'),null
from CustomAlarmProps
update AlarmCriteria
set alertId =NTNotificationQueryMapping.NTNotificationId,
reportName = NTqueryList.queryname
from @alarmCriteria AlarmCriteria, NTNotificationQueryMapping , NTQueryList
where AlarmCriteria.alarmId =
IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0)
and NTQueryList.queryId=NTNotificationQueryMapping.QueryId
and IsNull(convert(xml,NTqueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)=2
Update #tempResTab
set alertCriteria = dbo.fn_WeedOutHtmlTags(AlarmCriteria.reportCriteria),
alertType = AlarmCriteria.reportName
from @alarmCriteria AlarmCriteria
where AlarmCriteria.alertId = id
Update #tempResTab
set name = dbo.NTGetCategoryName(id,0)
select*from #tempResTab
ORDER BY id
drop table #tempResTab
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'rptGetAlerts')
	delete from GxQscripts where name = 'rptGetAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetAlerts')
	delete from GXDBVersions where aliasname = 'rptGetAlerts'
GO

insert into GXDBVersions values(2, 'rptGetAlerts',  '00010003001400020000', 'rptGetAlerts', '00010003001400020000')
GO

