

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/rptClientAuxCopySummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptClientAuxCopySummary.sp,v $ $Id: rptClientAuxCopySummary.sp,v 1.7.36.8.20.1 2021/02/05 23:27:04 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='rptClientAuxCopySummary')
BEGIN
	print '>>> Drop Stored Procedure: rptClientAuxCopySummary <<<'
	drop procedure rptClientAuxCopySummary
END
IF EXISTS (select * from GxQscripts where name='rptClientAuxCopySummary')
	delete from GxQscripts where name = 'rptClientAuxCopySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptClientAuxCopySummary')
	delete from GXDBVersions where aliasname = 'rptClientAuxCopySummary'
GO
print '... Creating Procedure: rptClientAuxCopySummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure rptClientAuxCopySummary
  @i_rptJobId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @ClientGroupId INT
  DECLARE @ClientGroupName NVARCHAR(255)
  DECLARE @ClientId INT
  DECLARE @ClientName NVARCHAR(255)
  DECLARE @JobsOnPrimary INT
  DECLARE @BytesOnMedia BIGINT
  DECLARE @BytesOfAFs BIGINT
  DECLARE @JobsCopied INT
  DECLARE @BytesCopied BIGINT
  DECLARE @JobsToCopy INT
  DECLARE @BytesToCopy BIGINT
  DECLARE @RestorableFromAuxCopy INT
SET NOCOUNT ON
DECLARE @CopiedSizeIsAppSize INT = 0
SET     @CopiedSizeIsAppSize = ISNULL((SELECT TOP 1 value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_STRING_AUXCOPY_DETAILS_IN_APPLICATION_SIZE'), 0)
IF (@CopiedSizeIsAppSize < 0)
    SET @CopiedSizeIsAppSize = 0
DECLARE	@SPCopyOpt		INT = 0
CREATE TABLE #TblOptSPCopies (policyId INT, copyId INT)
IF @i_rptJobId > 0
	INSERT	INTO #TblOptSPCopies
	EXEC	rptOptGetStoragePolicies @i_rptJobId, @SPCopyOpt OUTPUT
DECLARE	@ClientOpt		INT = 0
CREATE TABLE #TblOptClients	(clientId INT)
IF @i_rptJobId > 0
BEGIN
	INSERT	INTO #tblOptClients
	EXEC	rptOptGetClients @i_rptJobId, @ClientOpt OUTPUT
END
CREATE TABLE #TblAuxCopy
		(id INT, archGroupId INT, sourceCopyId INT,
		PRIMARY KEY (id))
IF	@SPCopyOpt > 0
	INSERT	INTO #TblAuxCopy
	SELECT	AGC.id, AG.id, AG.defaultCopy
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #TblOptSPCopies T
	WHERE	AGC.archGroupId = AG.id
		AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0 AND AGC.id <> AG.defaultCopy
		AND (AGC.sourceCopyId = 0 OR AGC.sourceCopyId = AG.defaultCopy)
	AND AG.id = T.policyId AND (T.copyId = 0 OR AGC.id = T.copyId)
ELSE
	INSERT	INTO #TblAuxCopy
	SELECT	AGC.id, AG.id, AG.defaultCopy
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.archGroupId = AG.id
		AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0 AND AGC.id <> AG.defaultCopy
		AND (AGC.sourceCopyId = 0 OR AGC.sourceCopyId = AG.defaultCopy)
DROP TABLE #TblOptSPCopies
CREATE TABLE #TblSubclients	(appId INT, clientId INT, appTypeId INT, instanceId INT, subclientStatus INT, isVSA2Parent INT)
CREATE TABLE #TblClient
		(ClientGroupId INT, ClientGroupName NVARCHAR(512), ClientId INT, ClientName NVARCHAR(512),
		PRIMARY KEY (ClientId))
IF	@ClientOpt > 0
	INSERT	INTO #TblClient
	SELECT	ISNULL(G.id, 0), ISNULL(G.name, ''), C.id, C.displayName
	FROM	APP_Client C WITH (NOLOCK)
			INNER JOIN #tblOptClients T ON C.id = T.clientId
			LEFT OUTER JOIN
			(SELECT	clientId, MIN(clientGroupId) AS clientGroupId
			FROM	APP_ClientGroupAssoc WITH (NOLOCK)
			GROUP BY  clientId) AS A ON C.id = A.clientId
			LEFT OUTER JOIN APP_ClientGroup G WITH (NOLOCK) ON A.clientGroupId = G.id
ELSE
	INSERT	INTO #TblClient
	SELECT	ISNULL(G.id, 0), ISNULL(G.name, ''), C.id, C.displayName
	FROM	APP_Client C WITH (NOLOCK)
			LEFT OUTER JOIN
			(SELECT	clientId, MIN(clientGroupId) AS clientGroupId
			FROM	APP_ClientGroupAssoc WITH (NOLOCK)
			GROUP BY  clientId) AS A ON C.id = A.clientId
			LEFT OUTER JOIN APP_ClientGroup G WITH (NOLOCK) ON A.clientGroupId = G.id
INSERT	INTO #TblSubclients
SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, 0
FROM	APP_Application A WITH (NOLOCK) INNER JOIN #TblClient C ON A.clientId = C.clientId
DROP TABLE #TblOptClients
CREATE	INDEX TblSubclients_appId ON #TblSubclients (appId)
UPDATE	S SET isVSA2Parent = 1
FROM	#TblSubclients S
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = S.instanceId
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = S.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	S.appTypeId = 106
CREATE TABLE #TblSummaryByApp (
	appId INT, nJobs INT, bytesOnMedia BIGINT, bytesOfAFs BIGINT,
	nJobsCopied INT, bytesCopied BIGINT, nJobsToCopy INT, bytesToCopy BIGINT
)
CREATE TABLE #TblAuxCopyJobs (jobId INT, commCellId INT, appId INT, archGrpCopyId INT, totalUncompBytes BIGINT, totalBackupSize BIGINT,
		minStatus INT, maxStatus INT, disabled INT, sizeToCopy BIGINT)
INSERT	INTO #TblAuxCopyJobs
SELECT	J.jobId, J.commCellId, B.appId, J.archGrpCopyId,
		CASE WHEN S.isVSA2Parent = 1 THEN B.totalBackupSize ELSE B.totalUncompBytes END, B.totalBackupSize,
		MIN(J.status), MAX(J.status), MAX(J.disabled & 1),
		CASE WHEN @CopiedSizeIsAppSize = 0 THEN B.totalBackupSize ELSE B.totalUncompBytes END
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		INNER JOIN #TblAuxCopy C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON B.appId = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (J.disabled & (1|256)) = 0
GROUP BY J.jobId, J.commCellId, B.appId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize, S.isVSA2Parent
INSERT	INTO #TblAuxCopyJobs
SELECT	J.jobId, J.commCellId, A.appID, J.archGrpCopyId, A.totalBackupSize, A.totalBackupSize, MIN(J.status), MAX(J.status), MAX(J.disabled & 1), A.totalBackupSize
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON A.jobId = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN #TblAuxCopy C ON J.archGrpCopyId = C.id
		INNER JOIN #TblSubclients S ON A.appID = S.appId
WHERE	J.status IN (100, 101, 102, 103) AND (J.disabled & (1|256)) = 0
GROUP BY J.jobId, J.commCellId, A.appID, J.archGrpCopyId, A.totalBackupSize
UPDATE	P SET sizeToCopy -= T.sizeCopied
FROM	#TblAuxCopyJobs P
		INNER JOIN
		(
		SELECT	J.jobId, J.commCellId, J.archGrpCopyId, SUM(AFC.physicalSize) AS sizeCopied
		FROM	#TblAuxCopyJobs J
				INNER JOIN archFile AF WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
				INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
		WHERE	maxStatus > 101 OR minStatus = 100 AND maxStatus = 101
		GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
		) T ON P.jobId = T.jobId AND P.commCellId = T.commCellId AND P.archGrpCopyId = T.archGrpCopyId
WHERE	P.sizeToCopy > T.sizeCopied
IF @CopiedSizeIsAppSize = 1
	UPDATE	#TblAuxCopyJobs SET sizeToCopy = (1.0*sizeToCopy/totalBackupSize)*totalUncompBytes
	WHERE	maxStatus > 100 and totalBackupSize > 0 AND sizeToCopy <= totalBackupSize
INSERT	INTO #TblSummaryByApp
SELECT	appId, 0, 0, 0,
		SUM(CASE WHEN maxStatus = 100 THEN 1 ELSE 0 END),
		SUM(CASE WHEN maxStatus = 100 THEN (CASE WHEN @CopiedSizeIsAppSize = 0 THEN totalBackupSize ELSE totalUncompBytes END) ELSE 0 END),
		SUM(CASE WHEN maxStatus > 100 AND disabled = 0 THEN 1 ELSE 0 END),
		SUM(CASE WHEN maxStatus > 100 AND disabled = 0 THEN sizeToCopy ELSE 0 END)
FROM	#TblAuxCopyJobs
GROUP BY appId
DROP TABLE #TblAuxCopyJobs
CREATE TABLE #TblPrimaryJobs (jobId INT, commCellId INT, appId INT, archGrpCopyId INT, totalUncompBytes BIGINT, totalBackupSize BIGINT, sizeOnMedia BIGINT)
INSERT	INTO #TblPrimaryJobs
SELECT	J.jobId, J.commCellId, B.appId, J.archGrpCopyId,
		CASE WHEN S.isVSA2Parent = 1 THEN B.totalBackupSize ELSE B.totalUncompBytes END, B.totalBackupSize,
		SUM(J.sizeOnMedia)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		INNER JOIN #TblAuxCopy C ON J.archGrpCopyId = C.sourceCopyId
		INNER JOIN #TblSubclients S ON B.appId = S.appId
WHERE	J.status = 100 AND (J.disabled & 256) = 0
GROUP BY J.jobId, J.commCellId, B.appId, J.archGrpCopyId, B.totalUncompBytes, B.totalBackupSize, S.isVSA2Parent
INSERT	INTO #TblPrimaryJobs
SELECT	J.jobId, J.commCellId, A.appID, J.archGrpCopyId, A.totalBackupSize, A.totalBackupSize, SUM(J.sizeOnMedia)
FROM	JMJobDataStats J WITH (NOLOCK)
		INNER JOIN JMAdminJobStatsTable A WITH (NOLOCK) ON A.jobId = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN #TblAuxCopy C ON J.archGrpCopyId = C.sourceCopyId
		INNER JOIN #TblSubclients S ON A.appID = S.appId
WHERE	J.status = 100 AND (J.disabled & 256) = 0
GROUP BY J.jobId, J.commCellId, A.appID, J.archGrpCopyId, A.totalBackupSize
INSERT	INTO #TblSummaryByApp
SELECT	appId, COUNT(*), SUM(sizeOnMedia), CASE WHEN @CopiedSizeIsAppSize = 0 THEN SUM(totalBackupSize) ELSE SUM(totalUncompBytes) END,
		0, 0, 0, 0
FROM	#TblPrimaryJobs
GROUP BY appId
DROP TABLE #TblPrimaryJobs
CREATE TABLE #TblSummaryByClient
		(clientId INT, nJobs INT, bytesOnMedia BIGINT, bytesOfAFs BIGINT, nJobsCopied INT, bytesCopied BIGINT, nJobsToCopy INT, bytesToCopy BIGINT,
		PRIMARY KEY (clientId))
INSERT	INTO #TblSummaryByClient
SELECT	A.clientId, SUM(T.nJobs), SUM(T.bytesOnMedia), SUM(T.bytesOfAFs), SUM(T.nJobsCopied), SUM(T.bytesCopied), SUM(T.nJobsToCopy), SUM(T.bytesToCopy)
FROM	#TblSummaryByApp T, APP_Application A WITH (NOLOCK)
WHERE	T.appId = A.id
GROUP BY A.clientId
DROP TABLE #TblSummaryByApp
-- Exclude deconfigured, deleted and Backup Activity disabled subclients for calculating the latest restore point of each client
DELETE	S
FROM	#TblSubclients S
		INNER JOIN JMJobAction J WITH (NOLOCK)
			ON	J.opType IN (4, 76) AND J.action = 1
			AND (J.clientId = S.clientId AND J.appType IN (S.appTypeId, 0)
				OR J.instanceId = S.instanceId AND J.instanceId > 1
				OR J.appId = S.appId)
DELETE	S
FROM	#TblSubclients S
		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.clientId = CGA.clientId
		INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
			AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
			AND J.opType IN (4, 76) AND J.action = 1
DELETE	#TblSubclients
WHERE	subclientStatus&(2|4) > 0 OR dbo.IsSubClientValid(appTypeId, subclientStatus, 0) = 0
CREATE TABLE #TblBaselineByApp
		(clientId INT, appTypeId INT, appId INT, startTime INT, fullCycleNum INT, PRIMARY KEY (appId))
INSERT	INTO #TblBaselineByApp
SELECT	A.clientId, A.appTypeId, B.appId, MAX(B.servStartDate), 0
FROM	JMBkpStats B WITH (NOLOCK)
		INNER JOIN #TblSubclients A ON B.appId = A.appId
		INNER JOIN JMJobDataStats J WITH (NOLOCK) ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		INNER JOIN #TblAuxCopy C ON J.archGrpCopyId = C.id
WHERE	J.status = 100 AND (J.disabled & 256) = 0
	AND B.status IN (1, 3, 14) AND B.bkpLevel IN (1, 64, 128, 1024, 32768)
GROUP BY A.clientId, A.appTypeId, B.appId
DROP TABLE #TblSubclients
UPDATE	#TblBaselineByApp
SET		fullCycleNum = B.fullCycleNum
FROM	#TblBaselineByApp A, JMBkpStats B WITH (NOLOCK)
WHERE	B.appId = A.appId AND B.servStartDate =  A.startTime
CREATE TABLE #TblLastCopiedCycle
		(appId INT, jobId INT, commCellId INT, startTime INT, backpuLevel INT, copied INT,
		PRIMARY KEY (jobId, commCellId))
INSERT	INTO #TblLastCopiedCycle
SELECT	B.appId, B.jobId, B.commCellId, B.servStartDate, B.bkpLevel, 0
FROM	#TblBaselineByApp A, JMBkpStats B WITH (NOLOCK)
WHERE	B.appId = A.appId AND B.fullCycleNum = A.fullCycleNum
	AND B.status IN (1, 3, 14)
UPDATE	#TblLastCopiedCycle
SET		copied = 1
FROM	#TblLastCopiedCycle B, JMJobDataStats J WITH (NOLOCK), #TblAuxCopy C
WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND J.archGrpCopyId = C.id
	AND J.status = 100 AND (J.disabled & 256) = 0
DROP TABLE #TblAuxCopy
UPDATE	#TblBaselineByApp
SET		startTime = B.startTime
FROM	#TblBaselineByApp A,
		(SELECT appId, MAX(startTime) AS startTime FROM #TblLastCopiedCycle WHERE backpuLevel = 4 AND copied = 1 GROUP BY appId) B
WHERE	A.appId = B.appId AND A.startTime < B.startTime
DELETE	#TblLastCopiedCycle
FROM	#TblLastCopiedCycle A,
		(SELECT	X.appId, MIN(X.startTime) AS startTime
		FROM	#TblLastCopiedCycle X, #TblBaselineByApp Y
		WHERE	X.appId = Y.appId AND X.copied = 0 AND X.startTime > Y.startTime
		GROUP BY X.appId) B
WHERE	A.appId = B.appId AND A.startTime >= B.startTime
UPDATE	#TblBaselineByApp
SET		startTime = B.startTime
FROM	#TblBaselineByApp A,
		(SELECT appId, MAX(startTime) AS startTime FROM #TblLastCopiedCycle GROUP BY appId) B
WHERE	A.appId = B.appId AND A.startTime < B.startTime
DROP TABLE #TblLastCopiedCycle
CREATE TABLE #TblBaselineByClient
		(clientId INT, startTime INT, PRIMARY KEY (clientId))
INSERT	INTO #TblBaselineByClient
SELECT	clientId, MIN(startTime)
FROM	#TblBaselineByApp
GROUP BY clientId
DROP TABLE #TblBaselineByApp
SELECT	C.ClientGroupId			AS ClientGroupId,
		C.ClientGroupName		AS ClientGroupName,
		C.ClientId				AS ClientId,
		C.ClientName			AS ClientName,
		S.nJobs					AS JobsPrimary,
		S.bytesOnMedia			AS BytesOnMedia,
		S.bytesOfAFs			AS BytesOfAFs,
		S.nJobsCopied			AS JobsCopied,
		S.bytesCopied			AS BytesCopied,
		S.nJobsToCopy			AS JobsToCopy,
		S.bytesToCopy			AS BytesToCopy,
		ISNULL(B.startTime, 0)	AS RestorableFromAuxCopy
FROM	#TblClient C
		INNER JOIN #TblSummaryByClient S ON S.clientId = C.ClientId
		LEFT JOIN #TblBaselineByClient B ON B.clientId = C.ClientId
ORDER BY C.ClientGroupName, C.ClientName
DROP TABLE #TblClient
DROP TABLE #TblSummaryByClient
DROP TABLE #TblBaselineByClient
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'rptClientAuxCopySummary')
	delete from GxQscripts where name = 'rptClientAuxCopySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptClientAuxCopySummary')
	delete from GXDBVersions where aliasname = 'rptClientAuxCopySummary'
GO

insert into GXDBVersions values(2, 'rptClientAuxCopySummary',  'v1.7.36.8.20.1', 'rptClientAuxCopySummary', 'v1.7.36.8.20.1')
GO

