

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneSQLLockDetectionTables.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneSQLLockDetectionTables.sp,v $ $Id: pruneSQLLockDetectionTables.sp,v 1.6.52.1 2018/03/20 19:48:17 jiechen Exp $";
--
--  +=================================================================================+
--  | Stored Procedure: pruneSQLLockDetectionTables()
--  |
--  | Description:  Deletes all rows from GxSQLLockDetection and GxSQLLockedObjects
--	|								tables that are older than days specified in MMConfigs table.
--	|								Default is 7 days.
--  +=================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneSQLLockDetectionTables <<<'

IF EXISTS (select * from sysobjects where name='pruneSQLLockDetectionTables')
	drop procedure pruneSQLLockDetectionTables
IF EXISTS (select * from GxQscripts where name='pruneSQLLockDetectionTables')
	delete from GxQscripts where name = 'pruneSQLLockDetectionTables'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneSQLLockDetectionTables')
	delete from GXDBVersions where aliasname = 'pruneSQLLockDetectionTables'
GO
print '... Creating Procedure: pruneSQLLockDetectionTables'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneSQLLockDetectionTables
AS
  DECLARE @o_RetVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION
	/* Lock GxSQLGroupInfo (which is the first table to be locked in CV_LogLockingQueries) to avoid deadlock with CV_LogLockingQueries as the natural order in which tables are locked in these procs is different.*/
	DECLARE @dummyLockHelper INTEGER
	SELECT @dummyLockHelper = 0 FROM GxSQLGroupInfo WITH (TABLOCKX)
	DECLARE	@DaysToKeep		INTEGER
	DECLARE @DateToKeep		DATETIME
	DECLARE	@retVal				INTEGER
	DECLARE @groupIDLstTbl TABLE(groupId  integer)
	SET			@DaysToKeep = 7
	SET			@retVal = -1
	SELECT @DaysToKeep = isnull(value, 7)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_SQL_LOCK_DETECTION_TABLE_ENTRIES'
	SELECT	@DateToKeep = DATEADD(DAY, (-1 * @DaysToKeep), GETDATE())
	/******************** Prune the SQL Lock Detection table entries V1 ***********************/
			DELETE GxSQLLockDetection
			WHERE timedetected < @DateToKeep
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE GxSQLLockedObjects
			WHERE timedetected < @DateToKeep
			IF @@ERROR <> 0 GOTO CX_EXIT
			INSERT INTO @groupIDLstTbl
			SELECT groupid
			FROM  GxSQLGroupInfo WHERE Detectiontime < @DateToKeep
	      /*Deleting all rows of group though they are of different
	      instance since all statements in a group start time is allmost equal */
			DELETE GxSQLLockedObjectsForSPID
			FROM GxSQLLockedObjectsForSPID
			INNER JOIN @groupIDLstTbl GID ON GxSQLLockedObjectsForSPID.groupid = GID.groupid
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE GxSQLGroupToSPID
			FROM GxSQLGroupToSPID
			INNER JOIN @groupIDLstTbl GID ON GxSQLGroupToSPID.groupid = GID.groupid
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE GxSQLSPID_Info
			FROM GxSQLSPID_Info
			INNER JOIN @groupIDLstTbl GID ON GxSQLSPID_Info.originalGroupId = GID.groupid
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE GxSQLGroupInfo
			FROM GxSQLGroupInfo
			INNER JOIN @groupIDLstTbl GID ON GxSQLGroupInfo.GroupId = GID.groupid
			IF @@ERROR <> 0 GOTO CX_EXIT
			SELECT 	@retVal = @@ERROR
	/******************** Prune the SQL Lock Detection table entries V1 ***********************/
	/******************** Start: Prune the SQL Lock Detection table entries V2 ***********************/
	-- Make sure the DB and lock tables are there.
	If DB_ID ('Troubleshooting') is not null and
	   OBJECT_ID ('Troubleshooting..GxSQLGroupInfo') is not null
	Begin
		-- Lock detection V2 parameters.
		-- Any value > 1 day should ensure there is atleast 1 DR backup with the diagnostic data.
		Declare @DefaultDaysToKeepV2 int = 2
		Declare @DaysToKeepV2 int = @DefaultDaysToKeepV2
		Declare @DateToKeepV2 datetime
		-- Keep V2 code away from V1. Querying MMConfigs again is no big harm.
		Select
			@DaysToKeepV2 = ISNULL(value, @DaysToKeepV2)
		From
			MMConfigs
		Where
			name = 'DA_CONFIG_DAYS_TO_KEEP_SQL_LOCK_DETECTION_V2_TABLE_ENTRIES'
		Set @DateToKeepV2 = DATEADD(DAY, (-1 * @DaysToKeepV2), GETDATE ())
		-- Find out if pruning is required - if DB is a at a very low size and
		-- prune older stuff - this is no much gain. So, why invite the trouble
		-- of asking older DR backups for troubleshooting?
		-- Prune troubleshooting DB only if it's at more than 25% of its maximum size.
		Declare @DBSizeThreshold int = 0
		If exists (
				  Select *
				  from
				      sys.master_files
				  where
					  database_id = DB_ID('troubleshooting') and
					  -- Just the data file.
					  type = 0 and
					  -- 25%.
					  CAST (size as float)/max_size > 0.25
				   )
			Set @DBSizeThreshold = 1
		-- Now delete - just from group table, FK will clean up other tables.
		Delete from
			Troubleshooting..GxSQLGroupInfo
		where
			@DBSizeThreshold = 1 and
			log_time < @DateToKeepV2
		If @@ERROR <> 0
		Begin
			Set @retVal = @@ERROR
			Goto CX_EXIT
		End
	End
	/******************** End: Prune the SQL Lock Detection table entries V2 ***********************/
CX_EXIT:
	IF @retVal = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
	SELECT @retVal
	RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'pruneSQLLockDetectionTables')
	delete from GxQscripts where name = 'pruneSQLLockDetectionTables'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneSQLLockDetectionTables')
	delete from GXDBVersions where aliasname = 'pruneSQLLockDetectionTables'
GO

insert into GXDBVersions values(2, 'pruneSQLLockDetectionTables',  '00010006005200010000', 'pruneSQLLockDetectionTables', '00010006005200010000')
GO

