

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneGRCForeignJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneGRCForeignJobs.sp,v $ $Id: pruneGRCForeignJobs.sp,v 1.2.200.3 2018/03/20 19:42:04 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Procedure: pruneGRCForeignJobs()
--  |
--  | Description:  Mark jobs in table DAForeignJobsToBeMarkedAged as aged which
--	|								will be populated at end of GRC import job based on the
--	|								jobs status in source commcell
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneGRCForeignJobs <<<'

IF EXISTS (select * from sysobjects where name='pruneGRCForeignJobs')
	drop procedure pruneGRCForeignJobs
IF EXISTS (select * from GxQscripts where name='pruneGRCForeignJobs')
	delete from GxQscripts where name = 'pruneGRCForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneGRCForeignJobs')
	delete from GXDBVersions where aliasname = 'pruneGRCForeignJobs'
GO
print '... Creating Procedure: pruneGRCForeignJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneGRCForeignJobs
  @i_dummy integer
AS
  DECLARE @o_RetVal integer;
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@retVal	INTEGER
	SET			@retVal = -1
	DECLARE @rowCnt INTEGER
	SET @rowCnt = 0
	DECLARE	@magneticBytes	bigint
	DECLARE @jobsToBeAged table(jobId integer, commcellId integer, copyId int, archGroupId INT, dataType int)
	/*
	I'm populating jobs into a local table before processing them
	because actual table might get filled up by ccm while we are processing here causing issue
	*/
	INSERT INTO @jobsToBeAged
	SELECT distinct jobId, commcellId, copyId, archGroupId, dataType
	FROM DAForeignJobsToBeMarkedAged WITH (NOLOCK) INNER JOIN archGroupCopy WITH (NOLOCK) ON CopyId = id
WHERE processed = 0 AND statusChange in (4, 5)
	CREATE TABLE #ToBeAgedJob (
  jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
  PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
  DECLARE	@l_now INT
  SET @l_now = dbo.GetUnixTime(GETUTCDATE())
  --Populate the table on which archSetJobsAgedViaTable will operate
  INSERT INTO #ToBeAgedJob
  SELECT distinct a.jobId, AF.archGroupId, a.copyId, a.dataType, a.commcellId
  FROM @jobsToBeAged a inner join ArchFile AF on a.jobId = AF.jobId AND a.dataType = AF.fileType AND a.commcellId = AF.commcellId AND a.archGroupId = AF.archGroupId
  SELECT @retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF @retVal <> 0 OR @rowCnt = 0 GOTO CX_EXIT
	DECLARE @retCode int = 0
	--Call the stored proc that markes the jobs as aged
	IF EXISTS (SELECT * FROM #ToBeAgedJob)
EXEC @retCode = archSetJobsAgedViaTable 536870912, @l_now
  SET	@retVal = @@ERROR
  IF	@retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0 GOTO CX_EXIT
	-- Set the processed rows
	UPDATE DAForeignJobsToBeMarkedAged SET processed = 1, modifiedTime = @l_now
	FROM DAForeignJobsToBeMarkedAged a WITH (NOLOCK) inner join @jobsToBeAged b
	ON a.jobId = b.jobId AND a.commcellId = b.commcellId AND a.copyId = b.copyId AND a.dataType = b.dataType
	inner join JMJobDataStats c WITH (NOLOCK)
	ON b.jobId = c.jobId AND b.commcellId = c.commcellId AND b.copyId = c.archGrpCopyId AND b.dataType = c.dataType
WHERE a.statusChange = 4 AND a.processed = 0 AND (c.disabled & 256) > 0
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	DELETE FROM @jobsToBeAged
	DROP TABLE #ToBeAgedJob
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	INSERT INTO @jobsToBeAged
	SELECT distinct jobId, commcellId, copyId, archGroupId, dataType
	FROM DAForeignJobsToBeMarkedAged WITH (NOLOCK) INNER JOIN archGroupCopy WITH (NOLOCK) ON CopyId = id
WHERE processed = 0 AND statusChange = 5
	CREATE TABLE #ToBeAgedAFC (
  archFileId INT, commCellId INT, archCopyId INT,
  PRIMARY KEY (archFileId, commCellId, archCopyId))
  SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	--Populate the table on which archFileDeleteViaTable will operate
	INSERT INTO #ToBeAgedAFC
	SELECT distinct a.Id, a.commcellId, b.copyId
	FROM archFile a WITH (NOLOCK) inner join @jobsToBeAged b ON a.jobId = b.jobId AND a.commcellId = b.commcellId AND a.fileType = b.dataType AND a.archGroupId = b.archGroupId
	SELECT @retVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF @retVal <> 0 OR @rowCnt = 0 GOTO CX_EXIT
	--Call the stored proc that deletes the archive entries for jobs that are media deleted
	IF EXISTS (SELECT * FROM #ToBeAgedAFC)
		EXEC @retCode  = archFileDeleteViaTable 0, @magneticBytes OUTPUT
	SET	@retVal = @@ERROR
  IF	@retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0 GOTO CX_EXIT
	--Update the status to media deleted after successfully executing archFileDeleteViaTable
	UPDATE JMJobDataStats SET status = 1000, mediaDeletedTime = @l_now, modifiedTime = @l_now
	FROM JMJobDataStats jds inner join @jobsToBeAged daf
	ON jds.jobId = daf.jobId AND jds.CommcellId = daf.CommcellId AND jds.archGrpCopyId = daf.copyId AND jds.dataType = daf.dataType
	-- Set the processed rows
	UPDATE DAForeignJobsToBeMarkedAged SET processed = 1, modifiedTime = @l_now
	FROM DAForeignJobsToBeMarkedAged a WITH (NOLOCK) inner join @jobsToBeAged b
	ON a.jobId = b.jobId AND a.commcellId = b.commcellId AND a.copyId = b.copyId AND a.dataType = b.dataType
WHERE a.statusChange = 5 AND a.processed = 0
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	DELETE FROM @jobsToBeAged
	DROP TABLE #ToBeAgedAFC
	CX_EXIT:
	IF object_id('tempdb.dbo.#ToBeAgedJob') is not null
		DROP TABLE #ToBeAgedJob
	IF object_id('tempdb.dbo.#ToBeAgedAFC') is not null
		DROP TABLE #ToBeAgedAFC
	SELECT @retVal
	RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'pruneGRCForeignJobs')
	delete from GxQscripts where name = 'pruneGRCForeignJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneGRCForeignJobs')
	delete from GXDBVersions where aliasname = 'pruneGRCForeignJobs'
GO

insert into GXDBVersions values(2, 'pruneGRCForeignJobs',  '00010002020000030000', 'pruneGRCForeignJobs', '00010002020000030000')
GO

