

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneDelayedMag.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneDelayedMag.sp,v $ $Id: pruneDelayedMag.sp,v 1.39.66.2 2018/03/20 20:06:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneDelayedMag <<<'

IF EXISTS (select * from sysobjects where name='pruneDelayedMag')
	drop procedure pruneDelayedMag
IF EXISTS (select * from GxQscripts where name='pruneDelayedMag')
	delete from GxQscripts where name = 'pruneDelayedMag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneDelayedMag')
	delete from GXDBVersions where aliasname = 'pruneDelayedMag'
GO
print '... Creating Procedure: pruneDelayedMag'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneDelayedMag
  @inLibraryId integer,
  @inSpaceToFree bigint
AS
  DECLARE @physicalSpaceFreed bigint;
  DECLARE @logicalSpaceFreed bigint;
  DECLARE @stillChunkToPrune integer;
  DECLARE @retVal integer;
SET NOCOUNT ON
BEGIN TRANSACTION DelayedMagTran
	DECLARE @currDateTime	DATETIME
	DECLARE @currentTime	INTEGER
	SET @currDateTime	= GETUTCDATE()
	SET @currentTime	= dbo.GetUnixTime(@currDateTime)
	DECLARE @numRow			integer
	DECLARE @retCode		integer
	DECLARE @retErr			integer
	SET		@physicalSpaceFreed = 0
	SET		@logicalSpaceFreed = 0
	SET		@stillChunkToPrune = 0
/****************************************************************************************/
	CREATE TABLE #ToBeAgedAFC (
		archFileId INT, commCellId INT, archCopyId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	DECLARE @tblChunkMapping TABLE(
			acCommCellId int, archChunkId bigint, afCommCellId int, archFileId int, copyId int, libraryId int,
			fileType int, jobId int, dataType int,
			physicalSize bigint, cTime int, toBeAged int,
			primary key (acCommCellId, archChunkId, afCommCellId, archFileId, copyId) )
	DECLARE @tblJobCopy TABLE(
			jobId int, copyId int, dataType int, commCellId int,
			physicalSize bigint, cTime int, toBeAged int,
			primary key (jobId, copyId, dataType, commCellId) )
/****************************************************************************************/
	-- Do not prune job from copy with data aging disabled
	DELETE	ArchMagAFToBeAged
	FROM	ArchMagAFToBeAged a, archAgingRule b with (NOLOCK)
	WHERE	a.copyId = b.copyId
	AND		b.flags & 4 > 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not prune manually retained job, aged or pruned job
	DELETE	ArchMagAFToBeAged
	FROM	ArchMagAFToBeAged a, JMJobDataStats b with (NOLOCK)
	WHERE	b.jobId = a.jobId
	AND		b.archGrpCopyId = a.copyId
	AND		b.dataType = a.fileType
	AND		b.commCellId = a.commCellId
AND		(b.disabled & 2 > 0 or b.disabled & 256 > 0 or b.status = 1000)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO @tblChunkMapping
	SELECT	b.chunkCommCellId, b.archChunkId, b.commCellId, b.archFileId, b.archCopyId, a.libraryId,
			a.fileType, a.jobId, a.dataType, b.physicalSize, a.ctime, 0
	FROM	ArchMagAFToBeAged a, archChunkMapping b with (NOLOCK)
	WHERE	a.archFileId = b.archFileId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.archCopyId
	AND		(a.libraryId = @inLibraryId or a.libraryId = 0)
	SELECT 	@retVal = @@ERROR, @numRow = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numRow = 0
			GOTO	CX_EXIT
	INSERT	INTO @tblJobCopy
	SELECT	jobId, copyId, dataType, afCommCellId,
			sum(physicalSize), min(cTime), 0
	FROM	@tblChunkMapping
	WHERE	libraryId = @inLibraryId
	GROUP	BY jobId, copyId, dataType, afCommCellId
	DECLARE	@commCellId integer
	DECLARE	@copyId integer
	DECLARE	@jobId integer
	DECLARE	@dataType integer
	DECLARE	@physicalSize bigint
	DECLARE	@cTime integer
	DECLARE	@toBeAged integer
	SET		@commCellId = 0
	SET		@copyId = 0
	SET		@jobId = 0
	SET		@dataType = 0
	SET		@physicalSize = 0
	SET		@cTime = 0
	SET		@toBeAged = 0
	DECLARE @spaceToBeFreed	bigint
	SET		@spaceToBeFreed = 0
	-- Prune the oldest chunk first
	DECLARE	mag_prune_cur CURSOR FOR
			SELECT	* FROM @tblJobCopy
			WHERE	toBeAged = 0
			ORDER	BY cTime ASC
	OPEN	mag_prune_cur
	FETCH	NEXT
	FROM	mag_prune_cur
	INTO	@jobId, @copyId, @dataType, @commCellId,
			@physicalSize, @cTime, @toBeAged
	-- Stop checking space to free is enough
	WHILE	@@FETCH_STATUS = 0 AND @spaceToBeFreed < @inSpaceToFree
	BEGIN
			UPDATE	@tblJobCopy SET toBeAged = 1
			FROM	@tblJobCopy
			WHERE	jobId = @jobId
			AND		copyId = @copyId
			AND		dataType = @dataType
			AND		commCellId = @commCellId
			SET		@spaceToBeFreed = @spaceToBeFreed + @physicalSize
			FETCH	mag_prune_cur
			INTO	@jobId, @copyId, @dataType, @commCellId,
					@physicalSize, @cTime, @toBeAged
	END
	CLOSE		mag_prune_cur
	DEALLOCATE	mag_prune_cur
	-- Make @tblJobCopy only contain toBeAged (job, copy, dataType)
	DELETE	@tblJobCopy
	WHERE	toBeAged = 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
	-------------------------------------------------------------------
	--- Get archive files of prunable jobs including tape if any
	-------------------------------------------------------------------
	INSERT	INTO #ToBeAgedAFC
	SELECT	a.archFileId, a.commCellId, b.copyId
	FROM	ArchMagAFToBeAged a WITH (NOLOCK), @tblJobCopy b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
	AND		a.dataType = b.dataType
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	EXEC @retErr = archFileDeleteViaTable 0, @physicalSpaceFreed OUTPUT
	SELECT	@retVal = @@ERROR
	IF	@retVal = 0 SET @retVal = @retErr
	IF	@retVal <> 0 GOTO CX_EXIT
	-------------------------------------------------------------------
	-- Data in @tblChunkPrunable is accumulated through each round of checking
	-- @physicalSpaceFreed is set via procedure archFileDeleteViaTable
	SET		@logicalSpaceFreed = @spaceToBeFreed
	---------------------------------------------------------------------------
	UPDATE	JMJobDataStats
SET		status = 1000, disabled = (disabled | 256), agedBy = (agedBy | 65536),
			agedTime = @currentTime, mediaDeletedTime = @currentTime, modifiedTime = @currentTime
	FROM	JMJobDataStats a, @tblJobCopy b, ArchMagAFToBeAged c WITH (NOLOCK)
	WHERE	a.jobId = c.jobId
	AND		a.commCellId = c.commCellId
	AND		a.archGrpCopyId = c.copyId
	AND		a.dataType = c.fileType
	AND		b.jobId = c.jobId
	AND		b.commCellId = c.commCellId
	AND		b.copyId = c.copyId
	AND		b.dataType = c.dataType
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	DELETE	ArchMagAFToBeAged
	FROM	ArchMagAFToBeAged a, @tblJobCopy b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.copyId
	AND		a.dataType = b.dataType
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Set dataStatus = 2 when a job has been deleted from media from all copies
	DELETE	@tblJobCopy
	FROM	JMJobDataStats A WITH (NOLOCK), @tblJobCopy B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
		AND A.status <> 1000
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMBkpStats WITH (PAGLOCK)
	SET		dataStatus = 2, agedTime = @currentTime, mediaDeletedTime = @currentTime, modifiedTime = @currentTime
	FROM	JMBkpStats J, (SELECT DISTINCT jobId, commCellId FROM @tblJobCopy) T
	WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
		AND J.dataStatus <> 2
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	UPDATE	JMAdminJobStatsTable WITH (PAGLOCK)
	SET		dataStatus = 2
	FROM	JMAdminJobStatsTable J, (SELECT DISTINCT jobId, commCellId FROM @tblJobCopy) T
	WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
		AND J.dataStatus <> 2
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	IF	EXISTS (SELECT * FROM ArchMagAFToBeAged WHERE libraryId = @inLibraryId)
		SET	@stillChunkToPrune = 1
/****************************************************************************************/
CX_EXIT:
	COMMIT TRANSACTION DelayedMagTran
	SELECT	@physicalSpaceFreed, @logicalSpaceFreed, @stillChunkToPrune, 0
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION DelayedMagTran
	SELECT	0, 0, 0, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'pruneDelayedMag')
	delete from GxQscripts where name = 'pruneDelayedMag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneDelayedMag')
	delete from GXDBVersions where aliasname = 'pruneDelayedMag'
GO

insert into GXDBVersions values(2, 'pruneDelayedMag',  '00010039006600020000', 'pruneDelayedMag', '00010039006600020000')
GO

