

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneCCR.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneCCR.sp,v $ $Id: pruneCCR.sp,v 1.4.186.3 2020/04/30 16:29:06 samrutkar Exp $";
--  +========================================================================+
--  | Stored Proc:  pruneCCR()
--  |
--  | Description:  Prune CCR entries older than the last current entry for a subclient
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='pruneCCR')
BEGIN
	print '>>> Drop Stored Procedure: pruneCCR <<<'
	drop procedure pruneCCR
END
IF EXISTS (select * from GxQscripts where name='pruneCCR')
	delete from GxQscripts where name = 'pruneCCR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneCCR')
	delete from GXDBVersions where aliasname = 'pruneCCR'
GO
print '... Creating Procedure: pruneCCR'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneCCR
AS
  DECLARE @out_errCode INTEGER
SET NOCOUNT ON
	IF OBJECT_ID('tempdb..#CCRIdByClient') IS NOT NULL DROP TABLE #CCRIdByClient
	CREATE TABLE #CCRIdByClient (CCRId INT, ClientId INT)
	CREATE CLUSTERED INDEX #CCRIdByClient_IDX on #CCRIdByClient (CCRId, ClientId)
	IF OBJECT_ID('tempdb..#tempMaxCCRTimeByClient') IS NOT NULL DROP TABLE #tempMaxCCRTimeByClient
	CREATE TABLE #tempMaxCCRTimeByClient ( ClientId INT,EndTime BIGINT)
	INSERT INTO #tempMaxCCRTimeByClient
	select sc.clientId, MAX(ccr.CCREndTime) maxTime from CCRToSubClient sc (NOLOCK)
		INNER JOIN CCRCommCellReadiness ccr (NOLOCK) ON sc.CCRId=ccr.CCRId group by sc.ClientId
	INSERT INTO #CCRIdByClient
	select DISTINCT sc.CCRId, sc.clientId  from CCRToSubClient sc (NOLOCK)
		 INNER JOIN CCRCommCellReadiness ccr (NOLOCK) ON sc.CCRId=ccr.CCRId
		INNER JOIN #tempMaxCCRTimeByClient lastCCRTime ON sc.clientId=lastCCRTime.clientId
    where ccr.CCREndTime<lastCCRTime.EndTime
	DELETE ccrs
	FROM CCRToSubClient ccrs INNER JOIN #CCRIdByClient C on ccrs.CCRID = C.CCRID and ccrs.clientId = C.clientId
	DELETE CCRed
	FROM CCRCommCellReadiness CCRed
		LEFT OUTER JOIN ccrToSubClient (NOLOCK) CCRSub ON CCRed.CCRId = CCRSub.CCRId
		where CCRSub.CCRId IS NULL and CCRed.CCRId != 1
	IF OBJECT_ID('tempdb..#CCRIdByClient') IS NOT NULL DROP TABLE #CCRIdByClient
	IF OBJECT_ID('tempdb..#tempMaxCCRTimeByClient') IS NOT NULL DROP TABLE #tempMaxCCRTimeByClient
	IF @@error = 0
		select 0
	ELSE
		select 1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'pruneCCR')
	delete from GxQscripts where name = 'pruneCCR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneCCR')
	delete from GXDBVersions where aliasname = 'pruneCCR'
GO

insert into GXDBVersions values(2, 'pruneCCR',  '00010004018600030000', 'pruneCCR', '00010004018600030000')
GO

