

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneBkpFailedKilled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneBkpFailedKilled.sp,v $ $Id: pruneBkpFailedKilled.sp,v 1.72.34.3 2019/02/16 00:07:07 hkapadia Exp $";
--
--  +========================================================================+
--  | Stored Precedure: pruneBkpFailedKilled()
--  |
--  | Description:  Delete all jobs that have no valid data,
--  |			such as failed, killed, partially copied and disabled job.
--	|			Delete invalid archive files of valid job that
--	|			are older than inTime.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='pruneBkpFailedKilled')
BEGIN
	print '>>> Drop Stored Procedure: pruneBkpFailedKilled <<<'
	drop procedure pruneBkpFailedKilled
END
IF EXISTS (select * from GxQscripts where name='pruneBkpFailedKilled')
	delete from GxQscripts where name = 'pruneBkpFailedKilled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneBkpFailedKilled')
	delete from GXDBVersions where aliasname = 'pruneBkpFailedKilled'
GO
print '... Creating Procedure: pruneBkpFailedKilled'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure pruneBkpFailedKilled
  @inTime integer
AS
  DECLARE @o_RetVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @retVal	INT
DECLARE @nRows	INT
DECLARE	@l_now	INT
DECLARE @l_dateTime	datetime
DECLARE	@magneticBytes	bigint
DECLARE @DaysToKeepInvalidSnapAF 	INT
SET			@DaysToKeepInvalidSnapAF 	= 2
SELECT @DaysToKeepInvalidSnapAF = isnull(value, 2)
FROM mmconfigs
WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_INVALID_SNAP_ARCHIVES_FOR_VALID_JOBS'
SET	@l_dateTime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @TimeToPruneInvalidSnapAF 		INT
SET			@TimeToPruneInvalidSnapAF 	= (@l_now - @DaysToKeepInvalidSnapAF * 24 * 3600)
DECLARE @DAJobId INTEGER
SET			@DAJobId = 0
DECLARE 	@ARCHIVE_GROUP_COPY_ITEM	INTEGER
SET				@ARCHIVE_GROUP_COPY_ITEM	=	8015
DECLARE		@SUB_CLIENT_ITEM	INTEGER
SET				@SUB_CLIENT_ITEM	= 2013
/******************** Begin ** Prune failed/killed jobs ***************************/
IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null
	DROP TABLE #ToBeAgedJob
CREATE TABLE #ToBeAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT, appId INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
	DROP TABLE #tblEntityInfo
CREATE TABLE #tblEntityInfo
(
		EntityTypeId			INTEGER,
		EntityId				 	INTEGER
)
CREATE INDEX Idx_tblEntityInfo_1 ON #tblEntityInfo (EntityTypeId, EntityId)
--Get the selected entities for pruning
SELECT TOP 1 @DAJobId = JobId
FROM JMAdminJobInfoTable WITH (NOLOCK)
WHERE opType = 10
IF @@ERROR <> 0 GOTO CX_ERROR_EXIT
EXEC @o_retVal = daGetGranularSelection @DAJobId
SELECT	@retVal = @@ERROR
IF @retVal = 0 SET @retVal = @o_retVal
IF @retVal <> 0 GOTO CX_ERROR_EXIT
IF EXISTS (SELECT * FROM #tblEntityInfo WHERE EntityTypeId = -1)
	GOTO CX_ERROR_EXIT
BEGIN TRANSACTION TRAN_FAILED_KILLED
	-- Get failed/killed job copy
	-- JMJobDataStats status: 2 = NODATA (no Archfile table entry), 3 = INVALIDDATA (All entries in archFile table are invalid.)
	-- JMBkpStats status: 2 = Failed, 4 = Killed
	INSERT	INTO #ToBeAgedJob
	SELECT JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.appId
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBK WITH (NOLOCK)
	WHERE	JDS.jobId = JBK.jobId
	AND		JDS.commCellId = JBK.commCellId
	AND		(JDS.status IN (2, 3) OR JBK.status IN (2, 4))
AND 	JDS.disabled & 256 = 0
	UNION
	SELECT JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.appId
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JAS WITH (NOLOCK)
	WHERE	JDS.jobId = JAS.jobId
	AND		JDS.commCellId = JAS.commCellId
	AND		(JDS.status IN (2, 3) OR JAS.status IN (2, 4))
AND 	JDS.disabled & 256 = 0
	SELECT	@retVal = @@ERROR, @nRows = @@ROWCOUNT
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	-- Do Not process failed/killed jobs if currently being processed by running aux copy job(s)
	DELETE	#ToBeAgedJob
	FROM #ToBeAgedJob T, archChunkToReplicate AC WITH (NOLOCK), JMAdminJobInfoTable JM WITH (NOLOCK)
	WHERE T.jobId = AC.BackupJobId
	AND 	T.commCellId = AC.CommCellId
	AND		AC.AdminJobId = JM.JobId
	AND 	JM.opType = 104
AND		AC.status in (0, 1)
	SELECT @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	-- Do Not process failed/killed jobs on SP Copy/Subclients not selected or not associated for current user
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#ToBeAgedJob
		WHERE appId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM)
		SELECT @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	END
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#ToBeAgedJob
		WHERE archGrpCopyId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM)
		SELECT @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	END
	-- DO NOT PROCESS ANY FOREIGN JOBS
	DELETE	#ToBeAgedJob
	FROM	#ToBeAgedJob A, APP_CommCell C WITH (NOLOCK)
	WHERE	A.commCellId = C.id
	AND		C.type > 1
	SELECT @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	-- DO NOT Prune Failed/Killed SILO Tape Backup Job if any archive file is still referenced in archFileSiloVolume table
	DELETE #ToBeAgedJob
	FROM	#ToBeAgedJob TMP, archFile AF WITH (NOLOCK), archFileSiloVolume AFSV WITH (NOLOCK)
	WHERE	TMP.jobId = AF.jobId
	AND TMP.commCellId = AF.commCellId
	AND	AF.id = AFSV.archFileId
	AND	AF.commCellId = AFSV.commCellId
	SELECT @retVal = @@ERROR
	SELECT @nRows = COUNT(*) FROM #ToBeAgedJob
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
EXEC @o_retVal = archSetJobsAgedViaTable 16384, @l_now
	SELECT	@retVal = @@ERROR
	IF @retVal = 0 SET @retVal = @o_retVal
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	-- DELETE ALL Failed/Killed SILO Tape Jobs
	DELETE 	#ToBeAgedJob
	FROM 		#ToBeAgedJob T,JMJobDataStats JDS WITH (NOLOCK)
	WHERE 	T.JobId = JDS.JobId
	AND 		T.archGrpId = JDS.archGrpId
	AND			T.archGrpCopyId = JDS.archGrpCopyId
	AND 		T.commCellId = JDS.commCellId
	AND 		JDS.appId NOT IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	SELECT	@retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	CREATE TABLE #ToBeAgedAFC (
		archFileId INT, commCellId INT, archCopyId INT, jobId INT,
		PRIMARY KEY (archFileId, commCellId, archCopyId))
	IF EXISTS (SELECT * FROM #ToBeAgedJob)
	BEGIN
		-- Get archive files of prunable jobs
		INSERT	INTO #ToBeAgedAFC
		SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.jobId
		FROM	#ToBeAgedJob T, archFile AF WITH(NOLOCK), archFileCopy AFC WITH (NOLOCK)
		WHERE	AF.id = AFC.archFileId
		AND		AF.commCellId = AFC.commCellId
		AND		AF.jobId = T.jobId
		AND 	AF.commCellId = T.commCellId
		AND 	AF.fileType = T.dataType
		AND 	AF.archGroupId = T.archGrpId
		AND		AFC.archCopyId = T.archGrpCopyId
		SELECT	@retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_ERROR_EXIT1
		EXEC @o_retVal = archFileDeleteViaTable 0, @magneticBytes	OUTPUT
		SELECT	@retVal = @@ERROR
		IF @retVal = 0 SET @retVal = @o_retVal
		IF @retVal <> 0 GOTO CX_ERROR_EXIT1
		UPDATE	JMJobDataStats WITH(PAGLOCK)
		SET		status = 1000, mediaDeletedTime = @l_now, modifiedTime = @l_now
		FROM	JMJobDataStats JDS, #ToBeAgedJob T
		WHERE	JDS.jobId = T.jobId
		AND 	JDS.dataType = T.dataType
		AND 	JDS.archGrpCopyId = T.archGrpCopyId
		AND 	JDS.commCellId = T.commCellId
		AND 	JDS.status <> 1000
AND 	(JDS.disabled & 256) <> 0
		SELECT	@retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_ERROR_EXIT1
	END
CX_ERROR_EXIT1:
	IF @retVal = 0
		COMMIT TRANSACTION TRAN_FAILED_KILLED
	ELSE
		ROLLBACK TRANSACTION TRAN_FAILED_KILLED
	DROP TABLE #ToBeAgedJob
	TRUNCATE TABLE #ToBeAgedAFC
	IF @retVal <> 0 GOTO CX_ERROR_EXIT
/******************** End **** Prune failed/killed jobs ***************************/
BEGIN TRANSACTION
	SET		@retVal = -1
	DECLARE @archFileCTime	INTEGER
	DECLARE @tempAF TABLE( id int, commCellId int, jobId int, isValid int )
	DECLARE @tempJobCopy TABLE( jobId int, archGrpCopyId int, dataType int, commCellId int )
	DECLARE @DanglingArchFiles TABLE( id int, commCellId int, cTime int, AFJobId int, jobId int )
/******************** Cleanup of dangling archive files ***********************/
			-- We are deleting dangling archive files, those for which archfile entries
			-- exist but for which no jmjobdatastats entries exist and the job has
			-- completed.
			-- this does not cause a problem for auxcopies as to auxcopy a job,
			--  the job needs to be present on at least one copy - so we must have
			-- a JMJobDataStats entry for the archive file, so the job will not be dangling.
			-- Any dangling archfile created before 7 days can be deleted
			select  @archFileCTime = (@l_now - 7 * 24 * 60 * 60)
			-- Get all archfiles whose createJobId_l does not exist in the JMJobDataStats table
			insert into @DanglingArchFiles
			select af.id, af.commCellId, af.cTime, af.JobId, jds.jobId
			from archFile af WITH (NOLOCK)
			left outer join JMJobDataStats jds
			on af.commcellid = jds.commcellid
			and af.jobId = jds.jobId
			where jds.jobId is null
			IF @@ERROR <> 0 GOTO CX_EXIT
			-- Do not delete those archive files which are for running jobs
			delete @DanglingArchFiles
			from @DanglingArchFiles daf, JMJobInfo jit WITH (NOLOCK)
			where daf.AFJobId = jit.jobId
			and daf.commCellId = jit.commCellId
			-- fix race condition in the case that the job just completed after inserting
			-- into temp table
			delete @DanglingArchFiles
			from @DanglingArchFiles daf INNER JOIN JMJobDataStats jds
			on daf.commcellid = jds.commcellid
			and daf.jobId = jds.jobId
			IF @@ERROR <> 0 GOTO CX_EXIT
			-- Do not delete those dangling archive files which still has some associated chunks
			delete @DanglingArchFiles
			from @DanglingArchFiles daf, archChunkMapping acm WITH (NOLOCK)
			where daf.id = acm.archFileId
			and daf.commCellId = acm.commCellId
			IF @@ERROR <> 0 GOTO CX_EXIT
			-- Do not delete those dangling archive files which are not older than 7 days
			delete @DanglingArchFiles
			where cTime >= @archFileCTime
			IF @@ERROR <> 0 GOTO CX_EXIT
			--Delete archive files from archVSAAppAFLink table before deleting from archFile table
			DELETE	archVSAAppAFLink
			FROM	archVSAAppAFLink AFL, @DanglingArchFiles DAF
			WHERE	AFL.childAFId = DAF.id
			AND 	AFL.commCellId = DAF.commcellId
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE	archVSAAppAFLink
			FROM	archVSAAppAFLink AFL, @DanglingArchFiles DAF
			WHERE	AFL.ParentIndexAFId = DAF.id
			AND 	AFL.commCellId = DAF.commcellId
			IF @@ERROR <> 0 GOTO CX_EXIT
			DELETE archFile
			FROM @DanglingArchFiles daf, archfile af
			WHERE af.commcellId = daf.commcellId
			AND af.id = daf.id
			IF @@ERROR <> 0 GOTO CX_EXIT
/******************** End Cleanup of dangling archive files ***********************/
/******************** Begin ** Prune invalid archive files of successful jobs *****/
-- The following section handles invalid/failed/killed archive files
-- and archive files marked invalid and uncommitted log archive files
-- (log backup is last step of db backup, if log backup not closed, it is regarded invalid)
-- (DATODO: check with JM team if a non-closed log archfile can really be pruned)
-- for inline copy, if sec copy fails and primary completes, jobmgr would set set secondary copy
-- status to one of 101 = (to be copied),102 = (have at least one chunk),103 (= at least one valid archfile)
-- so either all copies have (2,3) or no copies have (2,3) for a job, so following code is OK.
	-- Get invalid non Snap archive files
	INSERT	INTO @tempAF
	SELECT	id, commcellid, jobId, isValid
	FROM	archfile WITH (NOLOCK)
	WHERE	(isvalid = -1
OR		filetype = 4 AND isvalid = 0)
	AND		cTime < @inTime
AND		flags & 2 = 0
	AND		appId NOT IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	IF @@ERROR <> 0 GOTO CX_EXIT
	-- Get invalid Snap archive files
	INSERT	INTO @tempAF
	SELECT	id, commcellid, jobId, isValid
	FROM	archfile WITH (NOLOCK)
	WHERE	(isvalid = -1
OR		filetype = 4 AND isvalid = 0)
	AND		cTime < @TimeToPruneInvalidSnapAF
AND		flags & 2 > 0
	AND		appId NOT IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	IF @@ERROR <> 0 GOTO CX_EXIT
	-- Remove archive files from running job
	DELETE	@tempAF
	FROM	@tempAF a, JMJobInfo b WITH (NOLOCK)
	WHERE	a.commCellId = 2 AND a.jobId = b.jobId
	IF @@ERROR <> 0 GOTO CX_EXIT
	-- Remove archive files selected already (see comment above regarding status 2,3 and multiple copies)
	DELETE	@tempAF
	FROM	@tempAF a, JMJobDataStats b
	WHERE	a.commCellId = b.commCellId AND a.jobId = b.jobId
		AND b.status in (2, 3)
	IF @@ERROR <> 0 GOTO CX_EXIT
	-- Get prunable archive file copy
	INSERT	INTO #ToBeAgedAFC
	SELECT	a.id, a.commCellId, b.archCopyId, a.jobId
	FROM	@tempAF a, archFileCopy b WITH (NOLOCK)
	WHERE	a.id = b.archFileId
	AND		a.commCellId = b.commCellId
AND		b.flags & 256 = 0
	IF @@ERROR <> 0 GOTO CX_EXIT
EXEC @retVal = archFileSetAgedViaTable 16384, @l_now
	IF @@ERROR <> 0 OR @retVal <> 0 GOTO CX_EXIT
/******************** End **** Prune invalid archive files of successful jobs *****/
	COMMIT TRANSACTION
	DROP TABLE #ToBeAgedAFC
	SELECT 0
	RETURN 0;
CX_EXIT:
	ROLLBACK TRANSACTION
	DROP TABLE #ToBeAgedAFC
CX_ERROR_EXIT:
	SELECT -1
	RETURN -1;
GO


IF EXISTS (select * from GxQscripts where name = 'pruneBkpFailedKilled')
	delete from GxQscripts where name = 'pruneBkpFailedKilled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneBkpFailedKilled')
	delete from GXDBVersions where aliasname = 'pruneBkpFailedKilled'
GO

insert into GXDBVersions values(2, 'pruneBkpFailedKilled',  '00010072003400030000', 'pruneBkpFailedKilled', '00010072003400030000')
GO

