

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneBackupToBePruned.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneBackupToBePruned.sp,v $ $Id: pruneBackupToBePruned.sp,v 1.53.50.3 2019/11/16 23:12:30 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='pruneBackupToBePruned')
BEGIN
	print '>>> Drop Stored Procedure: pruneBackupToBePruned <<<'
	drop procedure pruneBackupToBePruned
END
IF EXISTS (select * from GxQscripts where name='pruneBackupToBePruned')
	delete from GxQscripts where name = 'pruneBackupToBePruned'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneBackupToBePruned')
	delete from GXDBVersions where aliasname = 'pruneBackupToBePruned'
GO
print '... Creating Procedure: pruneBackupToBePruned'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneBackupToBePruned
  @dummy integer
AS
  DECLARE @retVal INTEGER;
  DECLARE @numJobAged INTEGER;
SET NOCOUNT ON
DECLARE @numRow 			INTEGER
DECLARE @currentTime 	INTEGER
DECLARE @agedJobCnt 	INTEGER
DECLARE @MOUNT_PATH_EXTERNAL_REMOTE_HOST INTEGER
SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
SET @agedJobCnt = 0
SET @MOUNT_PATH_EXTERNAL_REMOTE_HOST = 7
/********************** Create temparary tables **********************************/
	-- FileType is flag in archfile table, can be 1, 2, 3, 4, 5
	-- DataType is flag in ArchJobCopyToBeAged table, can be 0, 4, 5
	if object_id('tempdb.dbo.#ToBeAgedJob') is not null DROP TABLE #ToBeAgedJob
	CREATE TABLE #ToBeAgedJob (
			jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
			PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
	if object_id('tempdb.dbo.#tblJustInTimeCopy') is not null DROP TABLE #tblJustInTimeCopy
	CREATE TABLE #tblJustInTimeCopy (copyId int)
	if object_id('tempdb.dbo.#tblMagVol') is not null DROP TABLE #tblMagVol
	CREATE TABLE #tblMagVol (
			volumeId int, libraryId int,
			primary key (volumeId))
	if object_id('tempdb.dbo.#tblJobJustInTime') is not null DROP TABLE #tblJobJustInTime
	CREATE TABLE #tblJobJustInTime (
			jobId int, copyId int, dataType int, commCellId int,
			primary key (jobId, copyId, dataType, commCellId) )
	if object_id('tempdb.dbo.#tblArchFileCopy') is not null DROP TABLE #tblArchFileCopy
	CREATE TABLE #tblArchFileCopy (
			archFileId int, commCellId int, fileType int, ctime int,
			jobId int, archGroupId int, copyId int, dataType int,
			libraryId int, justInTime int,
			primary key (archFileId, commCellId, copyId) )
	if object_id('tempdb.dbo.#tblBCDIndexAF') is not null DROP TABLE #tblBCDIndexAF
	CREATE TABLE #tblBCDIndexAF (
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	if object_id('tempdb.dbo.#tblJobsWithBCDIndex') is not null DROP TABLE #tblJobsWithBCDIndex
	CREATE TABLE #tblJobsWithBCDIndex (
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	if object_id('tempdb.dbo.#tblSpoolCopyJobs') is not null DROP TABLE #tblSpoolCopyJobs
	CREATE TABLE #tblSpoolCopyJobs (
			commCellId int, JobId int, spoolCopyId int)
	if object_id('tempdb.dbo.#tblSpoolCopyJobsNotCopied') is not null DROP TABLE #tblSpoolCopyJobsNotCopied
	CREATE TABLE #tblSpoolCopyJobsNotCopied (
			commCellId int, JobId int)
	if object_id('tempdb.dbo.#tblJobCopyBeingCopied') is not null DROP TABLE #tblJobCopyBeingCopied
	CREATE TABLE #tblJobCopyBeingCopied (
			JobId 				INTEGER,
			CommcellId 		INTEGER,
			SourceCopyId 	INTEGER,
			DestCopyId 		INTEGER,
			FileType			INTEGER
	)
	CREATE INDEX Idx_tmptblJobCopyBeingCopied_1 ON #tblJobCopyBeingCopied (JobId, CommcellId, SourceCopyId, DestCopyId, FileType)
	DECLARE @tblRetVal TABLE (errorCode int)
BEGIN TRANSACTION
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune job from copy with data aging disabled
	-----------------------------------------------------------------
	DELETE	ArchJobCopyToBeAged
	FROM	ArchJobCopyToBeAged a, archAgingRule b with (NOLOCK)
	WHERE	a.copyId = b.copyId
	AND		b.flags & 4 > 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune manually retained job
	-----------------------------------------------------------------
	DELETE	ArchJobCopyToBeAged
	FROM	ArchJobCopyToBeAged a, JMJobDataStats b with (NOLOCK)
	WHERE	a.jobId = b.jobId
	AND		a.copyId = b.archGrpCopyId
	AND		((a.dataType IN (0, 512)) OR (a.dataType = b.dataType))
	AND		a.commCellId = b.commCellId
	AND		b.disabled & 2 > 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune those jobs with primary copy as spool copy
	-- if jobs are not yet successfully copied on secondary copy
	-----------------------------------------------------------------
	-- Get all spool copy jobs selected for pruning
	INSERT	INTO #tblSpoolCopyJobs
	SELECT	DISTINCT AJC.commCellId, AJC.JobId, AJC.copyId
	FROM	ArchJobCopyToBeAged AJC, archAppCopyToBeAged AC
	WHERE	AJC.appId = AC.appId
	AND	AJC.copyId = AC.CopyId
	AND 	AC.retentionDays = 0
	AND 	AC.retentionCycles = 0
	AND	AC.copyIsSpool != 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO #tblSpoolCopyJobsNotCopied
	SELECT	DISTINCT SCJ.commCellId, SCJ.jobId
	FROM	#tblSpoolCopyJobs SCJ LEFT OUTER JOIN JMJobDataStats JD
						ON 	JD.jobId = SCJ.JobId
								AND JD.commCellId = SCJ.commCellId
								AND JD.status = 100
								AND JD.archGrpCopyId <> SCJ.spoolCopyId
	WHERE	JD.jobId is null
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not prune job from spool copy if job is not yet copied
	Delete	ArchJobCopyToBeAged
	from	ArchJobCopyToBeAged AJC, #tblSpoolCopyJobsNotCopied SCJ
	Where	AJC.commCellId = SCJ.commCellId
	AND 	AJC.jobId = SCJ.jobId
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------------------
	-- Safe check
	-- Do not prune those jobs on source and destination copy
	-- for which chunks are sent to MA for Auxcopy
	-----------------------------------------------------------------
	INSERT INTO #tblJobCopyBeingCopied
	SELECT BackupJobId, CommCellId, SrcCopyId, DestCopyId, FileType
	FROM archChunkToReplicate WITH (NOLOCK)
	WHERE EXISTS (SELECT jobId FROM JMJobInfo WITH (NOLOCK) WHERE jobId = adminJobId)
AND		status = 1
	GROUP BY BackupJobId, CommCellId, SrcCopyId, DestCopyId, FileType
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	--Do not age jobs on source copy that are currently being copied
	DELETE ArchJobCopyToBeAged
	FROM ArchJobCopyToBeAged T1, #tblJobCopyBeingCopied T2
	WHERE T1.jobId = T2.jobId
	AND 	T1.commCellId = T2.commCellId
	AND 	(T1.copyId = T2.SourceCopyId OR T1.copyId = T2.destCopyId)
	AND		(T1.dataType = T2.FileType or T1.dataType = 0)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-----------------------------------------------------------------
	-- Start to prune jobs
	-- Move jobs in just-in-time library to ArchMagAFToBeAged table
	-- Prune the rest of jobs the clean ArchJobCopyToBeAged table
	-----------------------------------------------------------------
	-- BCD Index Archive Files
	INSERT INTO #tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), ArchJobCopyToBeAged b WITH (NOLOCK)
	WHERE		JDS.jobId = b.jobId
	AND			JDS.commCellId = b.commCellId
AND 		JDS.dataType IN (6)
	AND			b.dataType <> 0
	AND			JDS.archGrpCopyId = b.copyId
	UNION
	-- Regular Index Archive Files after movement to media
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), ArchJobCopyToBeAged b WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE		JDS.jobId = b.jobId
	AND			JDS.commCellId = b.commCellId
	AND			JDS.archGrpCopyId = b.copyId
	AND			JDS.jobId = AF.jobId
	AND			JDS.commCellId = AF.commCellId
	AND			JDS.dataType = AF.fileType
AND 		JDS.dataType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
	AND			b.dataType <> 0
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tblJobsWithBCDIndex
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		JMJobDataStats JDS WITH (NOLOCK), #tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0 GOTO CX_ERROR_EXIT
	UPDATE  #tblJobsWithBCDIndex
	SET 		flags = 256
	FROM 		#tblJobsWithBCDIndex TT, ArchJobCopyToBeAged b WITH (NOLOCK)
	WHERE		TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND 		((b.dataType IN (0, 512)) OR (b.dataType = TT.fileType))
	AND			TT.copyId = b.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0 GOTO CX_ERROR_EXIT
	UPDATE  #tblBCDIndexAF
	SET 		flags = ISNULL(b.flags, 256)
	FROM 		#tblBCDIndexAF TT LEFT OUTER JOIN (SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
																							FROM #tblJobsWithBCDIndex
																							GROUP BY jobId, commCellId, copyId) b
	ON			TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND			TT.copyId = b.copyId
	SELECT 	@retVal = @@ERROR
	IF		@retVal <> 0 GOTO CX_ERROR_EXIT
	-- Get Prunable archive files
	INSERT	INTO #tblArchFileCopy
	SELECT	DISTINCT a.id, a.commCellId, a.fileType, a.ctime,
			b.jobId, a.archGroupId, b.copyId, b.dataType, 0, 0
	FROM	archFile a WITH (NOLOCK), ArchJobCopyToBeAged b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK)
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
AND 	((b.dataType IN (0, 512)) OR (b.dataType = 1 AND a.fileType NOT IN (4, 6)) OR (b.dataType = 4 AND a.fileType = 4))
	AND		a.archGroupId = c.archGroupId
	AND		b.copyId = c.id
	SELECT 	@retVal = @@ERROR, @numRow = @numRow - @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numRow = 0	GOTO CX_EXIT
	-- DO NOT Prune Regular Index Archive File created after Snap movement to media, if either Data or Log is NOT Aged
	DELETE #tblArchFileCopy
	FROM #tblArchFileCopy TT, #tblBCDIndexAF BCD
	WHERE TT.jobId = BCD.jobId
	AND TT.commCellId = BCD.commCellId
	AND TT.fileType = BCD.fileType
	AND TT.copyId = BCD.copyId
	--AND (BCD.flags & 256) = 0
	SELECT 	@retVal = @@ERROR, @numRow = @numRow - @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numRow = 0	GOTO CX_EXIT
	-- Get prunable BCD/Regular Index Archive File created after Snap movement to media
	INSERT	INTO #tblArchFileCopy
	SELECT	DISTINCT a.id, a.commCellId, a.fileType, a.ctime,
			b.jobId, a.archGroupId, b.copyId, b.fileType, 0, 0
	FROM	archFile a WITH (NOLOCK), #tblBCDIndexAF b, archGroupCopy c WITH (NOLOCK)
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.fileType = b.fileType
	AND		a.archGroupId = c.archGroupId
	AND		b.copyId = c.id
	AND		(b.flags & 256) = 256
	SELECT 	@retVal = @@ERROR, @numRow = @numRow + @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numRow = 0	GOTO CX_EXIT
	-- Get copies with Managed Disk Space Enabled
	INSERT	INTO #tblJustInTimeCopy
	SELECT	a.copyId
	FROM	archAgingRule a WITH (NOLOCK),
			(SELECT DISTINCT copyId
			FROM	ArchJobCopyToBeAged) b
	WHERE	a.copyId = b.copyId
	AND		a.flags & 8 > 0
	SELECT 	@retVal = @@ERROR, @numRow = @@ROWCOUNT
	IF		@retVal <> 0 GOTO CX_ERROR_EXIT
	IF		@numRow > 0
	BEGIN
		-- Get all magnetic volumes
		-- Filter out the magnetic volumes on cloud library
		INSERT	INTO #tblMagVol
		SELECT	DISTINCT v.volumeId, m.libraryId
		FROM	#tblJustInTimeCopy c, archStream s WITH (NOLOCK), MMVolume v WITH (NOLOCK),
					MMMedia m WITH (NOLOCK), MMMountPath mp WITH (NOLOCK)
		WHERE	s.archGroupCopyId = c.copyId
		AND		v.mediaGroupId = s.mediaGroupId
		AND		m.mediaId = v.mediaId
		AND 	m.mediaTypeId = 10001
		AND		v.mediaSideId = mp.mediaSideId
		AND		mp.MountPathTypeId <> @MOUNT_PATH_EXTERNAL_REMOTE_HOST
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		UPDATE	#tblArchFileCopy SET libraryId = d.libraryId, justInTime = 1
		FROM	#tblArchFileCopy a, archChunkMapping b WITH (NOLOCK), archChunk c WITH (NOLOCK), #tblMagVol d
		WHERE	b.archFileId = a.archFileId
		AND		b.commCellId = a.commCellId
		AND		b.archCopyId = a.copyId
		AND		c.id = b.archChunkId
		AND		c.commCellId = b.chunkCommCellId
		AND		c.volumeId = d.volumeId
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		INSERT	INTO #tblJobJustInTime
		SELECT	DISTINCT jobId, copyId, dataType, commCellId
		FROM	#tblArchFileCopy
		WHERE	justInTime = 1
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-------------------------------------------------------------------
		-- Move justInTime jobs to ArchMagAFToBeAged
		-- These jobs will be pruned in pruneDelayedMag.sp later
		-------------------------------------------------------------------
		INSERT	INTO ArchMagAFToBeAged
		SELECT	a.archFileId, a.fileType, a.cTime, a.jobId, a.copyId, a.dataType, a.commCellId, a.libraryId
		FROM	#tblArchFileCopy a, #tblJobJustInTime b
		WHERE	a.jobId = b.jobId
		AND		a.copyId = b.copyId
		AND		a.dataType = b.dataType
		AND		a.commCellId = b.commCellId
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		DELETE	#tblArchFileCopy
		FROM	#tblArchFileCopy a, #tblJobJustInTime b
		WHERE	a.jobId = b.jobId
		AND		a.copyId = b.copyId
		AND		a.dataType = b.dataType
		AND		a.commCellId = b.commCellId
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	INSERT	INTO #ToBeAgedJob
	SELECT	DISTINCT jobId, archGroupId, copyId, fileType, commCellId
	FROM	#tblArchFileCopy
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	SELECT @agedJobCnt = COUNT(*)
	FROM (SELECT DISTINCT jobId, archGrpCopyId, commCellId
			FROM #ToBeAgedJob) AS TMP
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO @tblRetVal
EXEC archSetJobsAgedViaTable 512, @currentTime
	SELECT @retVal = ISNULL(errorCode, -1) FROM @tblRetVal
	IF	@retVal <> 0 GOTO CX_ERROR_EXIT
	DELETE	FROM ArchJobCopyToBeAged
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
CX_EXIT:
	COMMIT	TRANSACTION
	DROP	TABLE #ToBeAgedJob
	SELECT	0, ISNULL(@agedJobCnt, 0)
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION
	DROP	TABLE #ToBeAgedJob
	SELECT	-1, 0
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'pruneBackupToBePruned')
	delete from GxQscripts where name = 'pruneBackupToBePruned'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneBackupToBePruned')
	delete from GXDBVersions where aliasname = 'pruneBackupToBePruned'
GO

insert into GXDBVersions values(2, 'pruneBackupToBePruned',  '00010053005000030000', 'pruneBackupToBePruned', '00010053005000030000')
GO

