

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneArchTablesPruningLogs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneArchTablesPruningLogs.sp,v $ $Id: pruneArchTablesPruningLogs.sp,v 1.14.2.10 2020/04/18 04:41:16 pankajkumar Exp $";
--
--  +========================================================================+
--  | Stored Procedure: pruneArchTablesPruningLogs()
--  |
--  | Description:  Deletes all rows from ArchFilePruningLogs, ArchChunkPruningLogs
--	|								ArchFileCopyPruningLogs and ArchcHunkMappingPruningLogs tables
--	|								that are older than days specified in MMConfigs table. Default
--	|								is 7 days.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='pruneArchTablesPruningLogs')
BEGIN
	print '>>> Drop Stored Procedure: pruneArchTablesPruningLogs <<<'
	drop procedure pruneArchTablesPruningLogs
END
IF EXISTS (select * from GxQscripts where name='pruneArchTablesPruningLogs')
	delete from GxQscripts where name = 'pruneArchTablesPruningLogs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneArchTablesPruningLogs')
	delete from GXDBVersions where aliasname = 'pruneArchTablesPruningLogs'
GO
print '... Creating Procedure: pruneArchTablesPruningLogs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneArchTablesPruningLogs
AS
  DECLARE @o_RetVal integer;
  DECLARE @o_noRowsDeleted integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE	@DaysToKeepPruningLogs	INTEGER
	DECLARE @TimeToKeepPruningLogs	INTEGER
	DECLARE	@retVal									INTEGER
	DECLARE @minJobId	INTEGER = 0
	SET			@DaysToKeepPruningLogs = 7
	SET			@retVal = 0
	SELECT @DaysToKeepPruningLogs = isnull(value, 7)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_ARCH_TABLE_PRUNING_LOGS'
	SELECT  @TimeToKeepPruningLogs = (dbo.getunixtime(GETUTCDATE()) - @DaysToKeepPruningLogs * 24 * 3600)
	DECLARE @maxJobsToPruneInBatch 	INTEGER
	SET			@maxJobsToPruneInBatch	= 2000
	SELECT @maxJobsToPruneInBatch = isnull(value, 2000)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
	DECLARE	@DaysToKeepArchCopyDataSummary	INTEGER = 10
	DECLARE @TimeToKeepArchCopyDataSummary	INTEGER
	SELECT @DaysToKeepArchCopyDataSummary = value
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_ARCHCOPYDATASUMMARY_TABLE'
	SELECT  @TimeToKeepArchCopyDataSummary = (dbo.getunixtime(GETUTCDATE()) - @DaysToKeepArchCopyDataSummary * 24 * 3600)
	DECLARE @errVal INTEGER = 0
	DECLARE @rowCnt INTEGER = 0
	DECLARE @TotalRowsPruned INTEGER = 0
	DECLARE @RunningJobIds TABLE (JobId INTEGER, PRIMARY KEY(JobID))
	IF OBJECT_ID('tempDb.dbo.#CompletedJobIds') IS NOT NULL DROP TABLE #CompletedJobIds
	CREATE TABLE #CompletedJobIds (JobId INTEGER, PRIMARY KEY(JobId))
	/******************** Prune the Arch Tables Pruning Logs ***********************/
		WHILE (1 = 1)
	    BEGIN
	        DELETE TOP (@maxJobsToPruneInBatch) ArchFilePruningLogs
	        WHERE pruneTime < @TimeToKeepPruningLogs
	        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	        IF @errVal != 0
	        BEGIN
	            SET @retVal = @errVal
	            BREAK
	        END
	        IF @rowCnt = 0
	            BREAK
	    END
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
	    BEGIN
	        DELETE TOP (@maxJobsToPruneInBatch) ArchFileCopyPruningLogs
	        WHERE pruneTime < @TimeToKeepPruningLogs
	        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	        IF @errVal != 0
	        BEGIN
	            SET @retVal = @errVal
	            BREAK
	        END
	        IF @rowCnt = 0
	            BREAK
	    END
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
	    BEGIN
	        DELETE TOP (@maxJobsToPruneInBatch) ArchChunkMappingPruningLogs
	        WHERE pruneTime < @TimeToKeepPruningLogs
	        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	        IF @errVal != 0
	        BEGIN
	            SET @retVal = @errVal
	            BREAK
	        END
	        IF @rowCnt = 0
	            BREAK
	    END
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
	    BEGIN
	        DELETE TOP (@maxJobsToPruneInBatch) ArchChunkPruningLogs
	        WHERE pruneTime < @TimeToKeepPruningLogs
	        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	        IF @errVal != 0
	        BEGIN
	            SET @retVal = @errVal
	            BREAK
	        END
	        IF @rowCnt = 0
	            BREAK
	    END
		IF @retVal != 0 GOTO CX_EXIT
		DELETE FROM @RunningJobIds
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		INSERT INTO @RunningJobIds
		SELECT	JobId
		FROM	JMAdminJobInfoTable WITH (NOLOCK)
		WHERE	OpType = 80 --DEDUPDBSYNC
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) archChunkToSyncDDBHistory
			WHERE	modifiedTime < @TimeToKeepPruningLogs
					AND adminJobId NOT IN (SELECT JobID FROM @RunningJobIds)
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal != 0 GOTO CX_EXIT
		DELETE FROM #CompletedJobIds
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
		FROM	archChunkToCopyHistory
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		INSERT INTO #CompletedJobIds
		SELECT	JobId
		FROM	JMAdminJobStatsTable WITH (NOLOCK)
		WHERE	jobId >= @minJobId
				AND CommCellId = 2
				AND OpType IN (13, 74) --AUXCOPY, MEDIAREFRESHING
				AND servEnd < @TimeToKeepPruningLogs
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) archChunkToCopyHistory
			FROM	archChunkToCopyHistory H, #CompletedJobIds J
			WHERE	H.adminJobId = J.JobId
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal != 0 GOTO CX_EXIT
		DELETE FROM #CompletedJobIds
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
		FROM	archChunkToVerifyHistory
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		INSERT INTO #CompletedJobIds
		SELECT	JobId
		FROM	JMAdminJobStatsTable WITH (NOLOCK)
		WHERE	jobId >= @minJobId
				AND CommCellId = 2
				AND OpType = 31 --ARCHIVECHECK
				AND servEnd < @TimeToKeepPruningLogs
		SET @retVal = @@ERROR
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) archChunkToVerifyHistory
			FROM	archChunkToVerifyHistory H, #CompletedJobIds J
			WHERE	H.adminJobId = J.JobId
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal != 0 GOTO CX_EXIT
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) A
			FROM archFileCopyDedupVerifyHistory A, JMAdminJobStatsTable J
			WHERE	A.jobId = J.jobId AND A.commCellId = J.commCellId
			AND  J.servEnd < @TimeToKeepPruningLogs
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal != 0 GOTO CX_EXIT
		--Prune entries from table HistoryDB..archContentIndexingAFHistory
		WHILE (1 = 1)
		BEGIN
			IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..archContentIndexingAFHistory') IS NOT NULL)
			BEGIN
				DELETE TOP (@maxJobsToPruneInBatch) HistoryDB..archContentIndexingAFHistory
				WHERE	modifiedTime < @TimeToKeepPruningLogs
				SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
				IF @errVal != 0
				BEGIN
					SET @retVal = @errVal
					BREAK
				END
				IF @rowCnt = 0
					BREAK
			END
		END
		IF @retVal != 0 GOTO CX_EXIT
	/******************** Arch Tables Pruning Logs deleted ***********************/
	/******************** MMVolReconChunkList Table Pruning Logs ***********************/
	/*
		VACStatus = 1  -  Volumes which are present in both MountPath & CSDB
		VACStatus = 2  -  Volumes which are present only in MountPath
		VACStatus = 3  -  Volumes which are present only in CSDB
		PruneStatus = 100 - Volumes are pruned
		PruneStatus = 102 - Chunks are pruned and Volume in use
		PruneStatus = 200 - Volumes prune Failed
	*/
		WHILE (1 = 1)
	    BEGIN
	        DELETE TOP (@maxJobsToPruneInBatch) MMVolReconChunkList
	        WHERE pruneTime < @TimeToKeepPruningLogs AND (VACStatus = 1 OR PruneStatus = 100)
	        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	        IF @errVal != 0
	        BEGIN
	            SET @retVal = @errVal
	            BREAK
	        END
	        IF @rowCnt = 0
	            BREAK
	    END
		IF @retVal != 0 GOTO CX_EXIT
	/******************** MMVolReconChunkList Table Pruning Logs deleted ***********************/
	/******************** Prune Arch Tables Content Indexing Pruning Logs ***********************/
	DECLARE @noRowsDeleted INT = 0
	SET @DaysToKeepPruningLogs = 90
	SELECT @DaysToKeepPruningLogs = isnull(value, 90)
	FROM MMConfigs
	WHERE name = 'MMCONFIG_CONTENT_INDEXING_PRUN_DAYS'
	SELECT  @TimeToKeepPruningLogs = (dbo.getunixtime(GETUTCDATE()) - @DaysToKeepPruningLogs * 24 * 3600)
	SET @noRowsDeleted = ISNULL((SELECT COUNT(*) FROM archContentIndexingAgedPruningLogs WHERE pruneTime < @TimeToKeepPruningLogs), 0)
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) archContentIndexingAgedPruningLogs
			WHERE	pruneTime < @TimeToKeepPruningLogs
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal != 0 GOTO CX_EXIT
	/******************** Arch Tables Content Indexing Pruning Logs deleted ***********************/
	/******************** Prune Snap Mgr dataset and member history ***********************/
	SELECT	@DaysToKeepPruningLogs = isnull(value, 7)
    FROM	MMConfigs
    WHERE	name = 'MMS2_CONFIG_SNAP_HISTORY_INFO_DAYS_TO_KEEP'
	SELECT  @TimeToKeepPruningLogs = (dbo.getunixtime(GETUTCDATE()) - @DaysToKeepPruningLogs * 24 * 3600)
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) SMSnapToDatasetMemberMapHistory
	    WHERE pruneTime < @TimeToKeepPruningLogs
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) SMSnapToDatasetMapHistory
	    WHERE pruneTime < @TimeToKeepPruningLogs
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) SMDataSetMemberHistory
	    WHERE pruneTime < @TimeToKeepPruningLogs
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) SMDataSetToSubClientMapHistory
	    WHERE pruneTime < @TimeToKeepPruningLogs
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) SMDataSetHistory
	    WHERE pruneTime < @TimeToKeepPruningLogs
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxJobsToPruneInBatch) ArchCopyDataSummary
	    WHERE generateTime < @TimeToKeepArchCopyDataSummary
	    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	    IF @errVal != 0
	    BEGIN
	        SET @retVal = @errVal
	        BREAK
	    END
	    IF @rowCnt = 0
	        BREAK
	END
	IF @retVal != 0 GOTO CX_EXIT
	/******************** Snap Mgr dataset and member history deleted ***********************/
CX_EXIT:
	IF OBJECT_ID('tempDb.dbo.#CompletedJobIds') IS NOT NULL DROP TABLE #CompletedJobIds
	SELECT @retVal, @noRowsDeleted
	RETURN	@retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'pruneArchTablesPruningLogs')
	delete from GxQscripts where name = 'pruneArchTablesPruningLogs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneArchTablesPruningLogs')
	delete from GXDBVersions where aliasname = 'pruneArchTablesPruningLogs'
GO

insert into GXDBVersions values(2, 'pruneArchTablesPruningLogs',  '00010014000200100000', 'pruneArchTablesPruningLogs', '00010014000200100000')
GO

