

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneArchFailedKilledJobInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneArchFailedKilledJobInfo.sp,v $ $Id: pruneArchFailedKilledJobInfo.sp,v 1.2.274.2 2018/03/20 20:04:09 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Procedure: pruneArchFailedKilledJobInfo()
--  |
--  | Description:  Deletes rows from ArchFailedKilledJobInfo tables
--	|								based on extended retention criteria on SP
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneArchFailedKilledJobInfo <<<'

IF EXISTS (select * from sysobjects where name='pruneArchFailedKilledJobInfo')
	drop procedure pruneArchFailedKilledJobInfo
IF EXISTS (select * from GxQscripts where name='pruneArchFailedKilledJobInfo')
	delete from GxQscripts where name = 'pruneArchFailedKilledJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneArchFailedKilledJobInfo')
	delete from GXDBVersions where aliasname = 'pruneArchFailedKilledJobInfo'
GO
print '... Creating Procedure: pruneArchFailedKilledJobInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneArchFailedKilledJobInfo
  @i_dummy integer
AS
  DECLARE @o_RetVal integer;
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@retVal	INTEGER
	SET			@retVal = -1
	if object_id('tempdb.dbo.#DAOldestFullOnSP') is not null DROP TABLE #DAOldestFullOnSP
	CREATE	TABLE #DAOldestFullOnSP (
			archGrpId							INTEGER,
			appId									INTEGER,
			OldestFullStartTime		INTEGER
			)
	/********************** Prune the ArchFailedKilledJobInfo *************************/
	INSERT INTO #DAOldestFullOnSP
	SELECT JBS.dataArchGrpId, JBS.appId, MIN(JBS.ServStartDate)
	FROM JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBS WITH (NOLOCK)
	WHERE	JDS.jobId = JBS.jobId
	AND		JDS.commCellId = JBS.commCellId
AND		(JDS.disabled & 256) = 0
	AND		JBS.status IN (1, 3, 14)
	GROUP BY JBS.dataArchGrpId, JBS.appId
	UNION
	SELECT JAS.archGrpID, JAS.appId, MIN(JAS.ServStart)
	FROM JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JAS WITH (NOLOCK)
	WHERE	JDS.jobId = JAS.jobId
	AND		JDS.commCellId = JAS.commCellId
AND		(JDS.disabled & 256) = 0
	AND		JAS.status IN (1, 3, 14)
	GROUP BY JAS.archGrpID, JAS.appId
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	-- Delete Foreign discovered Failed/Killed jobs since no retention honored on them
	DELETE ArchFailedKilledJobInfo
	FROM ArchFailedKilledJobInfo AF, APP_CommCell C WITH (NOLOCK)
	WHERE AF.commCellId = C.id
	AND		C.type > 1
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	-- Keep Failed/Killed jobs on SP that are 50 days older than the oldest FULL on SP
	-- If Grace days criteria is enabled then it will be correctly honored if Failed/Killed
	-- Job info is retained.
	DELETE ArchFailedKilledJobInfo
	FROM ArchFailedKilledJobInfo FKJI LEFT OUTER JOIN #DAOldestFullOnSP TMP
	ON 		FKJI.archGrpId = TMP.archGrpId
	AND		FKJI.appId = TMP.appId
	WHERE FKJI.servStartDate < (ISNULL(TMP.OldestFullStartTime, dbo.GetUnixTime(GetUTCDate())) - (50 * 24 * 3600))
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT
	/*********************** ArchFailedKilledJobInfo deleted **************************/
CX_EXIT:
	SELECT @retVal
	RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'pruneArchFailedKilledJobInfo')
	delete from GxQscripts where name = 'pruneArchFailedKilledJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneArchFailedKilledJobInfo')
	delete from GXDBVersions where aliasname = 'pruneArchFailedKilledJobInfo'
GO

insert into GXDBVersions values(2, 'pruneArchFailedKilledJobInfo',  '00010002027400020000', 'pruneArchFailedKilledJobInfo', '00010002027400020000')
GO

