

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneAppIdByTime.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneAppIdByTime.sp,v $ $Id: pruneAppIdByTime.sp,v 1.81.274.1 2018/03/20 19:46:22 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: pruneAppIdByTime()
--  |
--  | Description:  Delete all non-full jobs older than inUnPruneStatusTime for given appId.
--  |				inUnPruneStatusTime is the oldest unprunable job (OUJ) creation time.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneAppIdByTime <<<'

IF EXISTS (select * from sysobjects where name='pruneAppIdByTime')
	drop procedure pruneAppIdByTime
IF EXISTS (select * from GxQscripts where name='pruneAppIdByTime')
	delete from GxQscripts where name = 'pruneAppIdByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneAppIdByTime')
	delete from GXDBVersions where aliasname = 'pruneAppIdByTime'
GO
print '... Creating Procedure: pruneAppIdByTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneAppIdByTime
  @inAppId integer,
  @inCopyId integer,
  @inFileType integer,
  @inAppFlags integer,
  @inUnPruneStatusTime integer,
  @inCurrentTime integer
AS
  DECLARE @o_dummy integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION pruneByTime
	-------------------------------------------------------------------------------
	DECLARE @retVal						integer
	DECLARE @numJob						integer
	-------------------------------------------------------------------------------
	-- Declare constants
	DECLARE	@AGED						integer
	SET		@AGED						= 256
	DECLARE	@FULL						integer
	SET		@FULL						= 1
	DECLARE	@AP_APP_FLAG_LOG			integer
	set		@AP_APP_FLAG_LOG			= 4
	DECLARE	@AP_APP_FLAG_NOEXTRET		integer
	SET		@AP_APP_FLAG_NOEXTRET		= 8
	DECLARE @tblArchFile TABLE( commCellId int, archFileId int, isValid int, JobId int, policyId int, fileType int, bkpLevel int, cTime int )
	DECLARE @tblAFileCopy TABLE( commCellId int, archFileId int, isValid int, JobId int, copyId int, fileType int, bkpLevel int, cTime int )
	DECLARE @tblJobDataStats TABLE(
			commCellId int, jobId int, copyId int, dataType int,
			dataStatus int, disabled int, retained int )
	DECLARE @tblJobHistory TABLE(
			CommCellId int, JobId int, BkpLevel int,
			StartTime int, EndTime int )
	DECLARE @tblJobCopy TABLE(
			commCellId int, JobId int, bkpLevel int,
			copyId int, startTime int, endTime int,
			dataStatus int, disabled int, retained int,
			retentionDays int, copyType int, isActive int, pruneStatus int)
	---------------------- Get archive files for appId ----------------------
	INSERT	INTO @tblArchFile
	SELECT	commCellId, id, isValid, jobId, archGroupId, fileType, backupLevel, cTime
	FROM	archFile WITH (NOLOCK)
	WHERE	appId = @inAppId AND isValid <> -1
	AND		(@inFileType = 0 OR fileType = @inFileType)
	SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
	IF		@retVal != 0
			GOTO CX_ERROR_EXIT
	IF		@numJob = 0 GOTO CX_EXIT
	DELETE	@tblArchFile
	FROM	@tblArchFile a, JMJobInfo b WITH (NOLOCK)
	WHERE	a.jobId = b.jobId and a.commCellId = b.commCellId
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	---------------------- Get archive file copy for appId ----------------------
	INSERT	INTO @tblAFileCopy
	SELECT	a.commCellId, a.archFileId, a.isValid, a.JobId, b.archCopyId, a.fileType, a.bkpLevel, a.cTime
	FROM	@tblArchFile a, archFileCopy b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId
	AND		(b.flags & @AGED) = 0
	AND		(@inCopyId = 0 OR b.archCopyId = @inCopyId)
	SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
	IF		@retVal != 0
			GOTO CX_ERROR_EXIT
	IF		@numJob = 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	---------------- Get JMJobDataStats for given appId -------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblJobDataStats
	SELECT	commCellId, jobId, archGrpCopyId,
			dataType, status, disabled &1, disabled & 2
	FROM	JMJobDataStats WITH (NOLOCK)
	WHERE	appId = @inAppId AND (disabled & @AGED) = 0
	AND		status <> 1000
	AND		dataType = @inFileType
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	---------------- Get Job Histories for given appId -------------------------
	-------------------------------------------------------------------------------
	-- Get job histories
	INSERT	INTO @tblJobHistory
	SELECT	CommCellId, jobId, BkpLevel, ServStartDate, ServEndDate
	FROM	JMBkpStats WITH (NOLOCK)
	WHERE	AppId = @inAppId AND Status in (1, 3, 14)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	---------------------- Get jobcopy list for appId ----------------------
	INSERT	INTO @tblJobCopy
	SELECT	commCellId, JobId, 2, copyId, MIN(cTime), 0, 102, 0, 0, 0, 0, 0, 0
	FROM	@tblAFileCopy
	GROUP	BY commCellId, JobId, copyId
	SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
	IF		@retVal != 0
			GOTO CX_ERROR_EXIT
	IF		@numJob = 0 GOTO CX_EXIT
	UPDATE	@tblJobCopy
	SET		bkpLevel = b.bkpLevel,
			startTime = b.startTime,
			endTime = b.endTime
	FROM	@tblJobCopy a, @tblJobHistory b
	WHERE	a.commCellId = b.commCellId
	AND		a.jobId = b.jobId
	UPDATE	@tblJobCopy
	SET		dataStatus = b.dataStatus,
			disabled = b.disabled,
			retained = b.retained
	FROM	@tblJobCopy a, @tblJobDataStats b
	WHERE	a.commCellId = b.commCellId
	AND		a.jobId = b.jobId
	AND		(@inCopyId = 0 OR b.copyId = @inCopyId)
	AND		b.dataStatus in (100, 102, 103)
	--***************************************************************************--
	--***************************************************************************--
	--***************************************************************************--
START_PRUNE:
	-- Job end time has to be used due to job manager queue which may cause early job to finish late
	IF		(@inAppFlags & @AP_APP_FLAG_LOG) <> @AP_APP_FLAG_LOG
	BEGIN
		IF	(@inAppFlags & @AP_APP_FLAG_NOEXTRET) = @AP_APP_FLAG_NOEXTRET
			UPDATE	@tblJobCopy SET pruneStatus = 1
			WHERE	endTime < @inUnPruneStatusTime
			AND		retained = 0
		ELSE
			UPDATE	@tblJobCopy SET pruneStatus = 1
			WHERE	endTime < @inUnPruneStatusTime
			AND		retained = 0
			AND		bkpLevel != @FULL
	END
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	jobId, copyId, @inFileType, commCellId, @inAppId
	FROM	@tblJobCopy
	WHERE	pruneStatus = 1
	IF @@ERROR != 0 GOTO CX_ERROR_EXIT
	IF		(@inAppFlags & @AP_APP_FLAG_LOG) = @AP_APP_FLAG_LOG
	BEGIN
			DECLARE	@tblLogJobRetention TABLE(CommCellId int, JobId int, retentionDays int)
			DECLARE	@tblLogJobCanBeCopied TABLE(CommCellId int, JobId int, copyId int, destCopyId int)
			DECLARE	@tblLogJobToBeCopied TABLE(CommCellId int, JobId int, copyId int)
			-- Get all logs, assume they are prunable
			-- Then apply each rules to make some of them unprunable
			UPDATE	@tblJobCopy
			SET		retentionDays = b.retentionDays, copyType = c.type,
					isActive = c.isActive, pruneStatus = 1
			FROM	@tblJobCopy a, archAgingRule b, archGroupCopy c
			WHERE	a.copyId = b.copyId AND a.copyId = c.id
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Logs are not prunable if not reach retention days
			UPDATE	@tblJobCopy
			SET		pruneStatus = 0
			WHERE	endTime >= @inCurrentTime - retentionDays * 86400
			OR		retentionDays = -1
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Set infinite retention to max int
			UPDATE	@tblJobCopy
			SET		retentionDays = 2147483647
			WHERE	retentionDays = -1
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Get max retention days of valid log on sync copies
			INSERT	INTO @tblLogJobRetention
			SELECT	CommCellId, JobId, max(retentionDays)
			FROM	@tblJobCopy
			WHERE	copyType = 1 AND dataStatus = 100 AND disabled = 0
			GROUP	BY CommCellId, JobId
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Valid log on copy with max retentionDays are not prunable
			UPDATE	@tblJobCopy
			SET		pruneStatus = 0
			FROM	@tblJobCopy a, @tblLogJobRetention b
			WHERE	a.CommCellId = b.CommCellId and a.JobId = b.JobId
			AND		a.retentionDays = b.retentionDays
			AND		a.endTime >= @inUnPruneStatusTime
			AND		a.pruneStatus <> 0
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Get max retention days among all log on sync copies
			DELETE	FROM @tblLogJobRetention
			INSERT	INTO @tblLogJobRetention
			SELECT	a.CommCellId, a.JobId, max(a.retentionDays)
			FROM	@tblJobCopy a
			GROUP	BY a.CommCellId, a.JobId
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Log on copy with max retentionDays are not prunable
			UPDATE	@tblJobCopy
			SET		pruneStatus = 0
			FROM	@tblJobCopy a, @tblLogJobRetention b
			WHERE	a.CommCellId = b.CommCellId and a.JobId = b.JobId
			AND		a.retentionDays = b.retentionDays
			AND		a.endTime >= @inUnPruneStatusTime
			AND		a.pruneStatus <> 0
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			DECLARE	@tblDestCopy TABLE (policyId int, destCopyId int, sourceCopyId int)
			INSERT	INTO @tblDestCopy
			SELECT	archGroupId, id, sourceCopyId
			FROM	archGroupCopy WITH (NOLOCK)
			WHERE	isactive > 0
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			UPDATE	@tblDestCopy
			SET		sourceCopyId = b.defaultCopy
			FROM	@tblDestCopy a, archgroup b WITH (NOLOCK)
			WHERE	a.policyId = b.id
			and		a.destCopyId <> b.defaultCopy
			and		a.sourceCopyId = 0
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			DELETE	FROM @tblDestCopy
			WHERE	sourceCopyId = 0
			-- Get can be copied log
			INSERT	INTO @tblLogJobCanBeCopied
			SELECT	a.CommCellId, a.JobId, a.copyId, b.destCopyId
			FROM	@tblJobCopy a, @tblDestCopy b
			WHERE	a.dataStatus = 100 AND a.disabled = 0
			AND	a.copyId = b.sourceCopyId
			-- Get to be copied log
			INSERT	INTO @tblLogJobToBeCopied
			SELECT	distinct b.CommCellId, b.JobId, b.copyId
			FROM	@tblJobDataStats a, @tblLogJobCanBeCopied b
			WHERE	a.CommCellId = b.CommCellId and a.JobId = b.JobId
			AND		a.copyId = b.destCopyId
			AND		a.dataStatus in (101, 102, 103)
			AND		a.disabled = 0
			-- Logs on source copy that need to be copied are not prunable
			UPDATE	@tblJobCopy
			SET		pruneStatus = 0
			FROM	@tblJobCopy a, @tblLogJobToBeCopied b
			WHERE	a.CommCellId = b.CommCellId and a.JobId = b.JobId or retained <> 0
			AND		a.copyId = b.copyId
			-- Do not prune jobs in @tblJobCopy where pruneStatus = 0
			DELETE	FROM @tblJobCopy
			WHERE	pruneStatus = 0 or retained <> 0
			DECLARE @tblJobDataLink TABLE( commCellId int, parentJobId int, childJobId int, copyId int )
			-- If we are pruning log, then do not prune jobs linked to existing selective online full
			INSERT	INTO @tblJobDataLink
			SELECT	b.commCellId, b.parentJobId, b.childJobId, a.copyId
			FROM	@tblJobCopy a, JMJobDataLink b WITH (NOLOCK)
			WHERE	a.JobId = b.childJobId AND a.commCellId = b.commCellId
			SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
			IF		@retVal != 0
					GOTO CX_ERROR_EXIT
			IF		@numJob > 0
			BEGIN
					DECLARE @tblJobDataLinkParent TABLE( commCellId int, jobId int, copyId int )
					INSERT	INTO @tblJobDataLinkParent
					SELECT	a.commCellId, b.parentJobId, a.archGrpCopyId
					FROM	JMJobDataStats a, @tblJobDataLink b
					WHERE	a.jobId = b.parentJobId
					AND		a.commCellId = b.commCellId
					AND		a.dataType = 1
					AND		a.status <> 1000 AND (a.disabled & @AGED) = 0
					AND		a.archGrpCopyId = b.copyId
					IF @@ERROR != 0 GOTO CX_ERROR_EXIT
					-- All log jobs where parent data exist on the same copy are not prunable
					DELETE	@tblJobCopy
					FROM	@tblJobCopy a, @tblJobDataLink b, @tblJobDataLinkParent c
					WHERE	a.JobId = b.childJobId AND a.commCellId = b.commCellId
					AND		a.copyId = b.copyId
					AND		c.JobId = b.parentJobId AND c.commCellId = b.commCellId
					AND		c.copyId = b.copyId
			END
			INSERT	INTO ArchJobCopyToBeAged
			SELECT	jobId, copyId, @inFileType, commCellId, @inAppId
			FROM	@tblJobCopy
	END
CX_EXIT:
	/* AppId is pruned successfully */
	COMMIT	TRANSACTION pruneByTime
	SELECT @@ERROR
	RETURN
CX_ERROR_EXIT:
	/* Failed to prune AppId */
	ROLLBACK	TRANSACTION pruneByTime
	SELECT @@ERROR
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'pruneAppIdByTime')
	delete from GxQscripts where name = 'pruneAppIdByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneAppIdByTime')
	delete from GXDBVersions where aliasname = 'pruneAppIdByTime'
GO

insert into GXDBVersions values(2, 'pruneAppIdByTime',  '00010081027400010000', 'pruneAppIdByTime', '00010081027400010000')
GO

