

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/pruneAppIdByRules.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/pruneAppIdByRules.sp,v $ $Id: pruneAppIdByRules.sp,v 1.119.274.1 2018/03/20 20:02:19 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  pruneAppIdByRules()
--  |
--  | Description:  Prune all jobs older than the oldest unprunable job (OUJ)
--  |				by basic copy aging rules and filter out full jobs for extended pruning.
--  |				inCurrentTime is current time.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: pruneAppIdByRules <<<'

IF EXISTS (select * from sysobjects where name='pruneAppIdByRules')
	drop procedure pruneAppIdByRules
IF EXISTS (select * from GxQscripts where name='pruneAppIdByRules')
	delete from GxQscripts where name = 'pruneAppIdByRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneAppIdByRules')
	delete from GXDBVersions where aliasname = 'pruneAppIdByRules'
GO
print '... Creating Procedure: pruneAppIdByRules'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure pruneAppIdByRules
  @inAppId INTEGER,
  @inAppType INTEGER,
  @inFileType INTEGER,
  @inAppFlags INTEGER,
  @inCopyId INTEGER,
  @inPolicyId INTEGER,
  @inPrimaryCopyId INTEGER,
  @inFullPolicyId INTEGER,
  @inIncrPolicyId INTEGER,
  @inRetentionCycles INTEGER,
  @inRetentionDays INTEGER,
  @inCurrentTime INTEGER
AS
  DECLARE @o_CommCellId INTEGER
  DECLARE @o_JobId INTEGER
  DECLARE @o_StartTime INTEGER
  DECLARE @o_EndTime INTEGER
  DECLARE @o_JobStatus INTEGER
  DECLARE @o_DataStatus INTEGER
  DECLARE @o_DataDisabled INTEGER
  DECLARE @o_OldJobFlag INTEGER
SET NOCOUNT ON
BEGIN TRANSACTION pruneByRule
	-------------------------------------------------------------------------------
	-- Declare variables
	DECLARE @oldestJobTimeNotCopied		INTEGER
	DECLARE @oldestJobTimeToBeCopied	INTEGER
	DECLARE @oldestJobTimeByCycle		INTEGER
	DECLARE @oldestJobTimeByTime		INTEGER
	DECLARE @oldestJobLevelByTime		INTEGER
	DECLARE @oldestUnprunableJobTime	INTEGER
	DECLARE @numCycles					INTEGER
	DECLARE @numFullCycles				INTEGER
	DECLARE @numDestCopies				INTEGER
	DECLARE @sourceCopy					INTEGER
	DECLARE @retVal						INTEGER
	DECLARE @numJob						INTEGER
	DECLARE @numRunningJob				INTEGER
	DECLARE @selectiveOnline			INTEGER
	DECLARE	@oldestDataTime				INTEGER
	DECLARE @selectiveOnlineExtended	INTEGER
	DECLARE @selectivePrune				INTEGER
	SET		@selectivePrune = 0
	-------------------------------------------------------------------------------
	-- Declare constants
	DECLARE @CV_APPTYPE_COMMSRVMGMT		INTEGER
	SET		@CV_APPTYPE_COMMSRVMGMT		= 1000
	DECLARE	@AP_APP_FLAG_NOEXTRET		INTEGER
	SET		@AP_APP_FLAG_NOEXTRET		= 8
	DECLARE	@AP_APP_FLAG_ASR			INTEGER
	SET		@AP_APP_FLAG_ASR			= 512
	DECLARE	@AP_APP_FLAG_SELFULL		INTEGER
	SET		@AP_APP_FLAG_SELFULL		= 1024
	DECLARE	@AP_APP_FLAG_SQLDEF			INTEGER
	SET		@AP_APP_FLAG_SQLDEF			= 2048
	DECLARE	@AP_APP_FLAG_ARCHIVER		INTEGER
	SET		@AP_APP_FLAG_ARCHIVER		= 4096
	DECLARE	@AP_APP_FLAG_SQLDB			INTEGER
	SET		@AP_APP_FLAG_SQLDB			= 8192
	DECLARE @AGED						INTEGER
	SET		@AGED						= 256
	DECLARE	@FULL						INTEGER
	SET		@FULL						= 1
	DECLARE	@SYNTHETIC_FULL				INTEGER
	SET		@SYNTHETIC_FULL				= 64
	DECLARE	@SYNTHETIC_FULL_AND_INCR	INTEGER
	SET		@SYNTHETIC_FULL_AND_INCR	= 128
	DECLARE	@ASR						INTEGER
	SET		@ASR						= 512
	DECLARE	@SEL_OFFLINE_FULL			INTEGER
	SET		@SEL_OFFLINE_FULL			= 1024
	DECLARE	@SEL_ONLINE_FULL			INTEGER
	SET		@SEL_ONLINE_FULL			= 32768
	DECLARE	@AP_PRUNE_INFINITE			INTEGER
	SET		@AP_PRUNE_INFINITE			= 4
	DECLARE	@AP_PRUNE_CYCLES			INTEGER
	SET		@AP_PRUNE_CYCLES			= 8
	DECLARE	@AP_PRUNE_DAYS				INTEGER
	SET		@AP_PRUNE_DAYS				= 16
	DECLARE	@AP_PRUNE_NOTCOPIED			INTEGER
	SET		@AP_PRUNE_NOTCOPIED			= 32
	DECLARE @AP_APPID_NODATA			INTEGER
	SET		@AP_APPID_NODATA			= -3301
	DECLARE @AP_APPID_OLDESTDATATIME	INTEGER
	SET		@AP_APPID_OLDESTDATATIME	= -3303
	-- @AP_PRUNE_NOTCOPIED:	Oldest to be copied job on other copies
	-- @AP_PRUNE_CYCLES:	Oldest full job in cycle equal or less than @inRetentionCycles
	-- @AP_PRUNE_DAYS:		Oldest full job with cycle data created after @oldestUnprunableJobTime
	-------------------------------------------------------------------------------
	DECLARE @tblArchFile TABLE(
			archFileId int, commCellId int,
			isValid int, JobId int,
			policyId int, bkpLevel int, cTime int,
			primary key (archFileId, commCellId) )
	DECLARE @tblAFileCopy TABLE(
			archFileId int, commCellId int,
			isValid int, JobId int, bkpLevel int, cTime int,
			primary key (archFileId, commCellId) )
	DECLARE @tblOldestJob TABLE(
			commCellId int, JobId int, oldestTime int, flag int )
	DECLARE @tblExtendedJob TABLE(
			commCellId int, JobId int,
			startTime int, endTime int, jobStatus int,
			dataStatus int, disabled int, flag int,
			primary key (commCellId, jobId, flag) )
	DECLARE @tblJobDataStats TABLE(
			commCellId int, jobId int, copyId int, dataType int,
			dataStatus int, disabled int, retained int, policyId int,
			primary key (commCellId, jobId, copyId, dataType) )
	DECLARE @tblJobHistory TABLE(
			CommCellId int, JobId int, BkpLevel int,
			StartTime int, EndTime int, jobStatus int,
			primary key (commCellId, jobId) )
	DECLARE @tblJobCopy TABLE(
			commCellId int, JobId int, bkpLevel int,
			startTime int, endTime int,
			jobStatus int, dataStatus int, disabled int,
			retained int, prunable int,
			primary key (commCellId, jobId) )
	DECLARE @tblFullJob TABLE(
			commCellId int, JobId int, bkpLevel int, startTime int,
			policyId int, jobStatus int, dataStatus int, disabled int,
			primary key (commCellId, jobId) )
	DECLARE @tblJobPolicy TABLE(
			commCellId int, JobId int, bkpLevel int,
			startTime int, endTime int, policyId int,
			jobStatus int, dataStatus int, disabled int,
			primary key (commCellId, jobId) )
	DECLARE @tblCanBeCopiedJob TABLE(
			commCellId int, JobId int,
			startTime int, dataType int,
			primary key (commCellId, jobId, dataType) )
	DECLARE @tblToBeCopiedJob TABLE(
			commCellId int, JobId int,
			startTime int, dataType int,
			primary key (commCellId, jobId, dataType) )
	DECLARE @tblFullCycle TABLE(
			commCellId int, JobId int, startTime int,
			jobStatus int, dataStatus int, disabled int,
			primary key (commCellId, jobId) )
	DECLARE @tblTempCycle TABLE(
			commCellId int, JobId int, startTime int,
			primary key (commCellId, jobId) )
	DECLARE @tblRetentionDay TABLE(
			startTime int, bkpLevel int )
	DECLARE @tblJobDataLink TABLE(
			commCellId int, parentJobId int, childJobId int,
			parentStartTime int, childDataStatus int, childDisabled int )
	IF		(@inAppFlags & @AP_APP_FLAG_ASR) = @AP_APP_FLAG_ASR
			INSERT	INTO @tblArchFile
			SELECT	id, commCellId, isValid, jobId,
					archGroupId, backupLevel, cTime
			FROM	archFile WITH (NOLOCK)
			WHERE	appId = @inAppId AND isValid <> -1
			AND		backupLevel = @ASR
	ELSE IF	@inFileType = 0
			INSERT	INTO @tblArchFile
			SELECT	id, commCellId, isValid, jobId,
					archGroupId, backupLevel, cTime
			FROM	archFile WITH (NOLOCK)
			WHERE	appId = @inAppId AND isValid <> -1
			AND		backupLevel <> @ASR
	ELSE
			INSERT	INTO @tblArchFile
			SELECT	id, commCellId, isValid, jobId,
					archGroupId, backupLevel, cTime
			FROM	archFile WITH (NOLOCK, INDEX(arfl_idx2))
			WHERE	appId = @inAppId AND isValid <> -1
			AND		fileType = @inFileType
			AND		backupLevel <> @ASR
	SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numJob = 0
	BEGIN
			INSERT	INTO @tblOldestJob SELECT 0, 0, 0, @AP_APPID_NODATA
			GOTO	CX_EXIT
	END
	-------------------------------------------------------------------------------
	INSERT	INTO @tblAFileCopy
	SELECT	a.archFileId, a.commCellId, a.isValid,
			a.JobId, a.bkpLevel, a.cTime
	FROM	@tblArchFile a, archFileCopy b WITH (NOLOCK)
	WHERE	a.archFileId = b.archFileId
	AND		a.commCellId = b.commCellId
	AND		b.archCopyId = @inCopyId
	AND		(b.flags & @AGED) = 0
	SELECT 	@retVal = @@ERROR, @numJob = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	IF		@numJob = 0
	BEGIN
			INSERT	INTO @tblOldestJob SELECT 0, 0, 0, @AP_APPID_NODATA
			GOTO	CX_EXIT
	END
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	---------------- Get JMJobDataStats for given appId -------------------------
	-------------------------------------------------------------------------------
	IF		@inFileType = 0
			INSERT	INTO @tblJobDataStats
			SELECT	commCellId, jobId, archGrpCopyId, dataType,
					status, disabled & 1, disabled & 2, archGrpId
			FROM	JMJobDataStats WITH (NOLOCK)
			WHERE	appId = @inAppId
			AND		(disabled & @AGED) = 0
			AND		status <> 1000
	ELSE
			INSERT	INTO @tblJobDataStats
			SELECT	commCellId, jobId, archGrpCopyId, dataType,
					status, disabled & 1, disabled & 2, archGrpId
			FROM	JMJobDataStats WITH (NOLOCK)
			WHERE	appId = @inAppId
			AND		(disabled & @AGED) = 0
			AND		status <> 1000
			AND		dataType = @inFileType
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	---------------- Get Job Histories for given appId -------------------------
	-------------------------------------------------------------------------------
	-- Get job histories
	IF		(@inAppFlags & @AP_APP_FLAG_ASR) = @AP_APP_FLAG_ASR
			INSERT	INTO @tblJobHistory
			SELECT	CommCellId, JobId, BkpLevel,
					ServStartDate, ServEndDate, Status
			FROM	JMBkpStats WITH (NOLOCK)
			WHERE	AppId = @inAppId AND Status IN (1, 14)
			AND		BkpLevel = @ASR
	ELSE	IF (@inAppType = @CV_APPTYPE_COMMSRVMGMT)
			INSERT	INTO @tblJobHistory
			SELECT	CommCellId, JobId, ER_BkpLevel,
					ServStart, ServEnd, Status
			FROM	JMAdminJobStatsTable WITH (NOLOCK)
			WHERE	AppId = @inAppId AND OpType = 11 AND Status IN (1, 14)
	ELSE	IF (@inFileType = 5)
			INSERT	INTO @tblJobHistory
			SELECT	CommCellId, JobId, ER_BkpLevel,
					ServStart, ServEnd, Status
			FROM	JMAdminJobStatsTable WITH (NOLOCK)
			WHERE	AppId = @inAppId AND OpType = 44 AND Status IN (1, 14)
	ELSE
			INSERT	INTO @tblJobHistory
			SELECT	CommCellId, JobId, BkpLevel,
					ServStartDate, ServEndDate, Status
			FROM	JMBkpStats WITH (NOLOCK)
			WHERE	AppId = @inAppId AND Status in (1, 3, 14)
			AND		BkpLevel <> @ASR
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblJobHistory SET BkpLevel = @FULL
	WHERE	BkpLevel in (@SYNTHETIC_FULL, @SYNTHETIC_FULL_AND_INCR, @ASR)
	OR		(@inAppFlags & @AP_APP_FLAG_ARCHIVER) = @AP_APP_FLAG_ARCHIVER
	-------------------------------------------------------------------------------
	---------------- Get jobs for given appId on given copy --------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblJobCopy
	SELECT	commCellId, JobId, 2, min(ctime), 0, 0, 0, 1, 0, 0
	FROM	@tblAFileCopy
	GROUP	BY commCellId, JobId
	SELECT 	@numJob = @@ROWCOUNT
	IF		@numJob = 0
	BEGIN
			INSERT	INTO @tblOldestJob SELECT 0, 0, 0, @AP_APPID_NODATA
			GOTO	CX_EXIT
	END
	-------------------------------------------------------------------------------
	IF		@inFileType = 0
			UPDATE	@tblJobCopy
			SET		dataStatus = b.dataStatus,
					disabled = b.disabled,
					retained = b.retained
			FROM	@tblJobCopy a, @tblJobDataStats b
			WHERE	a.commCellId = b.commCellId
			AND		a.jobId = b.jobId
			AND		b.copyId = @inCopyId
	ELSE
			UPDATE	@tblJobCopy
			SET		dataStatus = b.dataStatus,
					disabled = b.disabled,
					retained = b.retained
			FROM	@tblJobCopy a, @tblJobDataStats b
			WHERE	a.commCellId = b.commCellId
			AND		a.jobId = b.jobId
			AND		b.copyId = @inCopyId
			AND		b.dataType = @inFileType
	UPDATE	@tblJobCopy
	SET		bkpLevel = b.bkpLevel,
			startTime = b.startTime,
			endTime = b.endTime,
			jobStatus = b.jobStatus
	FROM	@tblJobCopy a, @tblJobHistory b
	WHERE	a.commCellId = b.commCellId
	AND		a.jobId = b.jobId
	UPDATE	@tblJobCopy
	SET		endTime = startTime
	WHERE	endTime = 0
	-------------------------------------------------------------------------------
	---------------- Oldest data of given appId on given copy ----------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblOldestJob
	SELECT	TOP 1 commCellId, JobId, startTime, @AP_APPID_OLDESTDATATIME
	FROM	@tblJobCopy
	ORDER	BY startTime ASC
	-------------------------------------------------------------------------------
	---------------------- Infinite retention ----------------------
	-------------------------------------------------------------------------------
	IF		@inRetentionCycles = -1 or @inRetentionDays = -1
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	commCellId, JobId, oldestTime, @AP_PRUNE_INFINITE
			FROM	@tblOldestJob
			WHERE	flag = @AP_APPID_OLDESTDATATIME
			GOTO CX_EXIT
	END
	-------------------------------------------------------------------------------
	---------------------- Check Oracle Online Full Jobs ----------------------
	-------------------------------------------------------------------------------
	IF		(@inAppFlags & @AP_APP_FLAG_SELFULL) = @AP_APP_FLAG_SELFULL
			SET @selectiveOnline = ISNULL((SELECT TOP 1 bkpLevel FROM @tblJobCopy WHERE bkpLevel = @SEL_ONLINE_FULL), 0)
	ELSE
			SET @selectiveOnline = 0
	IF		(@inAppFlags & @AP_APP_FLAG_NOEXTRET) = 0 AND @selectiveOnline > 0
			SET @selectiveOnlineExtended = 1
	ELSE
			SET @selectiveOnlineExtended = 0
	-------------------------------------------------------------------------------
	------------------- 1: Oldest full by rentiontion days ----------------------
	-------------------------------------------------------------------------------
	SET	@oldestUnprunableJobTime = @inCurrentTime - @inRetentionDays * 24 * 60 * 60
	-- All jobs are within basic retention days
	IF		(SELECT top 1 oldestTime FROM @tblOldestJob WHERE FLAG = @AP_APPID_OLDESTDATATIME)
			 >= @oldestUnprunableJobTime
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	commCellId, JobId, oldestTime, @AP_PRUNE_DAYS
			FROM	@tblOldestJob
			WHERE	flag = @AP_APPID_OLDESTDATATIME
			IF		@selectiveOnlineExtended = 0
					GOTO SELECTIVE_PRUNE_JOB
			ELSE	SET	@selectivePrune = 1
	END
	-------------------------------------------------------------------------------
	---------------------- Get full jobs for appId ----------------------
	-------------------------------------------------------------------------------
	IF (@inAppFlags & @AP_APP_FLAG_SELFULL) = @AP_APP_FLAG_SELFULL
			INSERT	INTO @tblFullJob
			SELECT	commCellId, JobId, bkpLevel, startTime,
					@inPolicyId, jobStatus, dataStatus, disabled
			FROM	@tblJobCopy
			WHERE	bkpLevel IN (@FULL, @SEL_OFFLINE_FULL, @SEL_ONLINE_FULL)
	ELSE
			INSERT	INTO @tblFullJob
			SELECT	commCellId, JobId, bkpLevel, startTime,
					@inPolicyId, jobStatus, dataStatus, disabled
			FROM	@tblJobCopy
			WHERE	bkpLevel = @FULL
	-- Current policy is incr policy or is a full policy with incr policy defined
	-- Combine jobs on both full and incr policies
	IF		((@inPolicyId = @inFullPolicyId AND @inIncrPolicyId <> 0) OR (@inPolicyId = @inIncrPolicyId))
			AND @inFileType <> 5 AND (@inAppFlags & @AP_APP_FLAG_ASR) = 0
	BEGIN
			INSERT	INTO @tblJobPolicy
			SELECT	a.commCellId, a.jobId, a.bkpLevel,
					a.startTime, a.endTime, b.policyId,
					a.jobStatus, 100, MIN(b.disabled)
			FROM	@tblJobHistory a, @tblJobDataStats b
			WHERE	a.commCellId = b.commCellId
			AND		a.jobId = b.jobId
			AND		b.dataStatus = 100
			GROUP	BY a.commCellId, a.jobId, a.bkpLevel,
					a.startTime, a.endTime, b.policyId, a.jobStatus
			IF		@inPolicyId = @inIncrPolicyId
			BEGIN
					-- Current policy is an incr policy
					-- Combined with data on full policy to count cycles
					-- Get all full jobs on full policy (not current)
					IF (@inAppFlags & @AP_APP_FLAG_SELFULL) = @AP_APP_FLAG_SELFULL
							INSERT	INTO @tblFullJob
							SELECT	commCellId, JobId, bkpLevel, startTime,
									@inFullPolicyId, jobStatus, dataStatus, disabled
							FROM	@tblJobPolicy
							WHERE	policyId = @inFullPolicyId
							AND		bkpLevel IN (@FULL, @SEL_OFFLINE_FULL, @SEL_ONLINE_FULL)
					ELSE
							INSERT	INTO @tblFullJob
							SELECT	commCellId, JobId, bkpLevel, startTime,
									@inFullPolicyId, jobStatus, dataStatus, disabled
							FROM	@tblJobPolicy
							WHERE	policyId = @inFullPolicyId
							AND		bkpLevel = @FULL
			END
	END
	-------------------------------------------------------------------------------
	-------------------- 2: Oldest full by rentiontion days ----------------------
	-------------------------------------------------------------------------------
	-- Retention Days rule has been checked for this oracle subclient
	IF		@selectivePrune > 0
			GOTO RETENTION_CYCLES
	IF		((@inPolicyId = @inFullPolicyId AND @inIncrPolicyId <> 0) OR (@inPolicyId = @inIncrPolicyId))
			AND @inFileType <> 5 AND (@inAppFlags & @AP_APP_FLAG_ASR) = 0
	BEGIN
			-- Current policy is incr policy or is a full policy with incr policy defined
			-- Using job histories of given subclient on ALL POLICIES
			-- to get backup level of the oldest job right after @oldestUnprunableJobTime
			INSERT	INTO @tblRetentionDay
			SELECT	TOP 1 startTime, bkpLevel
			FROM	@tblJobPolicy
			WHERE	policyId in (@inFullPolicyId, @inIncrPolicyId)
			AND		endTime >= @oldestUnprunableJobTime
			ORDER	BY startTime ASC
	END
	ELSE
	BEGIN
			-- Get backup level of the oldest job right after @oldestUnprunableJobTime
			INSERT	INTO @tblRetentionDay
			SELECT	TOP 1 startTime, bkpLevel
			FROM	@tblJobCopy
			WHERE	endTime >= @oldestUnprunableJobTime
			ORDER	BY startTime ASC
	END
	SET		@oldestJobLevelByTime = ISNULL((SELECT TOP 1 bkpLevel FROM @tblRetentionDay), 0)
	SET		@oldestJobTimeByTime =  ISNULL((SELECT TOP 1 startTime FROM @tblRetentionDay), 0)
	-- All jobs are older than the retention days
	IF		@oldestJobLevelByTime = 0
			GOTO RETENTION_CYCLES
	-- Non-Full job is found right after @oldestUnprunableJobTime
	-- Get the lastest full job that started right before @oldestUnprunableJobTime
	IF		@oldestJobLevelByTime NOT IN (@FULL, @SEL_OFFLINE_FULL, @SEL_ONLINE_FULL)
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	TOP 1 commCellId, JobId, startTime, @AP_PRUNE_DAYS
			FROM	@tblFullJob
			WHERE	startTime <= @oldestJobTimeByTime
			ORDER	BY startTime DESC
			-- If no full job found, use the oldest job started at or after @oldestUnprunableJobTime
			IF		@@ROWCOUNT = 0
			BEGIN
					INSERT INTO @tblOldestJob
					SELECT	TOP 1 commCellId, JobId, startTime, @AP_PRUNE_DAYS
					FROM	@tblJobCopy
					WHERE	startTime >= @oldestJobTimeByTime
					ORDER	BY startTime ASC
			END
	END
	ELSE
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	TOP 1 commCellId, JobId, startTime, @AP_PRUNE_DAYS
			FROM	@tblJobCopy
			WHERE	startTime >= @oldestJobTimeByTime
			ORDER	BY startTime ASC
	END
	-- All jobs are within basic retention days
	IF		(SELECT top 1 oldestTime FROM @tblOldestJob WHERE FLAG = @AP_APPID_OLDESTDATATIME)
			 = (SELECT top 1 oldestTime FROM @tblOldestJob WHERE FLAG = @AP_PRUNE_DAYS)
	BEGIN
			IF		@selectiveOnlineExtended = 0
					GOTO SELECTIVE_PRUNE_JOB
			-- Oracle Online Full
			SET		@selectivePrune = 1
	END
	-------------------------------------------------------------------------------
	---------------------- Oldest full by rentiontion cycle ----------------------
	-------------------------------------------------------------------------------
RETENTION_CYCLES:
	IF		@inRetentionCycles = 0 AND @selectivePrune = 0
			GOTO NOT_COPIED
	-- Get all completed full jobs including disabled jobs and partially successful full
	-- If current policy is incr policy of another policy, get full jobs from both policies
	INSERT	INTO @tblFullCycle
	SELECT	commCellId, JobId, startTime, jobStatus, dataStatus, disabled
	FROM	@tblFullJob
	WHERE	dataStatus = 100
	SET		@numFullCycles = @@ROWCOUNT
	-- SELECTIVE ONLINE FULL can NOT be to counted as a valid cycle
	-- if its child jobs not exist or not valid on the same copy
	IF		@selectiveOnline > 0
	BEGIN
			-- Assume all linked jobs have the same start time as their corresponding full
			INSERT	INTO @tblJobDataLink
			SELECT	a.commCellId, b.parentJobId, b.childJobId, a.startTime, 0, 0
			FROM	@tblFullJob a, JMJobDataLink b WITH (NOLOCK)
			WHERE	a.JobId = b.parentJobId
			AND		a.commCellId = b.commCellId
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Get child log jobs for selective online full
			-- Logs on all copies are retrieved, needed by aux copy check
			INSERT	INTO @tblJobDataStats
			SELECT	a.commCellId, a.childJobId, b.archGrpCopyId, b.dataType,
					b.status, disabled & 1, disabled & 2, b.archGrpId
			FROM	@tblJobDataLink a, JMJobDataStats b WITH (NOLOCK)
			WHERE	b.jobId = a.childJobId
			AND		b.dataType = 4
			AND		b.commCellId = a.commCellId
			AND		b.status <> 1000
			AND		(b.disabled & @AGED) = 0
			IF @@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Remove valid log on given copy
			UPDATE	@tblJobDataLink SET childDataStatus = b.dataStatus, childDisabled = b.disabled
			FROM	@tblJobDataLink a, @tblJobDataStats b
			WHERE	a.childJobId = b.JobId AND a.commCellId = b.commCellId
			AND		b.dataType = 4
			AND		b.copyId = @inCopyId
			-- Full jobs linked to those logs are not valid full
			DELETE	@tblFullCycle
			FROM	@tblFullCycle a, @tblJobDataLink b
			WHERE	a.JobId = b.parentJobId
			AND		a.commCellId = b.commCellId
			AND		(b.childDataStatus <> 100 or b.childDisabled & 1 > 0)
			SET		@numFullCycles = @numFullCycles - @@ROWCOUNT
	END
	IF		@selectivePrune > 0
			GOTO SELECTIVE_PRUNE_JOB
	IF		@inRetentionCycles = 0 OR @numFullCycles = 0
			GOTO NOT_COPIED
	-----------------------------------------------------
	SET		ROWCOUNT @inRetentionCycles
	-----------------------------------------------------
			INSERT	INTO @tblTempCycle
			SELECT	commCellId, JobId, startTime
			FROM	@tblFullCycle
			WHERE	disabled = 0 AND jobStatus = 1
			ORDER	BY startTime DESC
			SELECT 	@numCycles = @@ROWCOUNT
	-----------------------------------------------------
	SET		ROWCOUNT 0
	-----------------------------------------------------
	-- Not enough valid cycles found, get more including disabled, partial cycles
	IF		@numCycles < @inRetentionCycles
	BEGIN
			SET		@oldestJobTimeByCycle = ISNULL((SELECT MIN(startTime) FROM @tblTempCycle), 0)
			SET		@numCycles = @inRetentionCycles - @numCycles
			-------------------------------
			SET		ROWCOUNT @numCycles
			-------------------------------
			INSERT	INTO @tblTempCycle
			SELECT	commCellId, JobId, startTime
			FROM	@tblFullCycle
			WHERE	(@oldestJobTimeByCycle = 0 OR startTime < @oldestJobTimeByCycle)
			ORDER	BY startTime DESC
			SELECT 	@numCycles = @@ROWCOUNT
			-------------------------------
			SET		ROWCOUNT 0
			-------------------------------
	END
	IF		@numCycles < @inRetentionCycles
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	commCellId, JobId, oldestTime, @AP_PRUNE_CYCLES
			FROM	@tblOldestJob
			WHERE	flag = @AP_APPID_OLDESTDATATIME
			GOTO SELECTIVE_PRUNE_JOB
	END
	ELSE
	BEGIN
			INSERT	INTO @tblOldestJob
			SELECT	TOP 1 commCellId, JobId, startTime, @AP_PRUNE_CYCLES
			FROM	@tblTempCycle
			ORDER	BY startTime ASC
	END
	-- All jobs are within basic retention cycles
	IF		(SELECT top 1 oldestTime FROM @tblOldestJob WHERE FLAG = @AP_APPID_OLDESTDATATIME)
			 = (SELECT top 1 oldestTime FROM @tblOldestJob WHERE FLAG = @AP_PRUNE_CYCLES)
	BEGIN
			GOTO SELECTIVE_PRUNE_JOB
	END
	-------------------------------------------------------------------------------
	------------------ Oldest not copied job -------------------
	-------------------------------------------------------------------------------
NOT_COPIED:
	IF 		(@inAppFlags & @AP_APP_FLAG_ASR) = @AP_APP_FLAG_ASR
			GOTO START_PRUNE
	DECLARE	@tblDestCopy TABLE (copyId int)
	INSERT	INTO @tblDestCopy
	SELECT	id
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	archGroupId = @inPolicyId
	AND		id != @inCopyId
	AND		id != @inPrimaryCopyId
	AND		isActive = 1
	AND		((@inCopyId = @inPrimaryCopyId AND sourceCopyId = 0)
			OR (sourceCopyId = @inCopyId))
	SELECT 	@retVal = @@ERROR, @numDestCopies = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	SET @sourceCopy = (SELECT sourceCopyId from archGroupCopy WHERE id = @inCopyId)
	if @sourceCopy = 0 AND @inCopyId <> @inPrimaryCopyId
		set @sourceCopy = @inPrimaryCopyId
	-- No destination copy AND no source copy
	IF		@numDestCopies = 0 AND @sourceCopy = 0
			GOTO START_PRUNE
	Set @oldestJobTimeNotCopied = 0
	Set @oldestJobTimeToBeCopied = 0
	IF		@numDestCopies > 0
	BEGIN
			-- Get all jobs that can be copied
			INSERT	INTO @tblCanBeCopiedJob
			SELECT	commCellId, jobId, startTime, @inFileType
			FROM	@tblJobCopy
			WHERE	disabled & 1 = 0
			-- Get all linked jobs that can be copied
			IF		@selectiveOnline > 0
			BEGIN
					INSERT	INTO @tblCanBeCopiedJob
					SELECT	commCellId, childJobId, parentStartTime, 4
					FROM	@tblJobDataLink
					WHERE	childDisabled & 1 = 0
			END
			-- Get the oldest needs to be copied job of given appId
			SET	@oldestJobTimeNotCopied = ISNULL((SELECT MIN(a.startTime)
					FROM	@tblCanBeCopiedJob a, @tblJobDataStats b
					WHERE	a.commCellId = b.commCellId AND a.JobId = b.JobId
					AND		b.copyId IN (SELECT copyId FROM @tblDestCopy)
					AND		(a.dataType = 0 or a.dataType = b.dataType)
					AND		b.dataStatus in (101, 102, 103)
					AND		b.disabled & 1 = 0), 0)
	END
	IF		@sourceCopy > 0
	BEGIN
			-- Get all jobs that to be copied
			INSERT	INTO @tblToBeCopiedJob
			SELECT	commCellId, jobId, startTime, @inFileType
			FROM	@tblJobCopy
			WHERE	dataStatus in (101, 102, 103) AND disabled & 1 = 0
			-- Get all linked jobs that to be copied
			IF		@selectiveOnline > 0
			BEGIN
					INSERT	INTO @tblToBeCopiedJob
					SELECT	commCellId, childJobId, parentStartTime, 4
					FROM	@tblJobDataLink
					WHERE	childDisabled & 1 = 0
					AND		childDataStatus in (101, 102, 103)
			END
			-- Get the oldest to be copied job of given appId
			SET	@oldestJobTimeToBeCopied = ISNULL((SELECT MIN(a.startTime)
					FROM	@tblToBeCopiedJob a, @tblJobDataStats b
					WHERE	a.commCellId = b.commCellId AND a.JobId = b.JobId
					AND		b.copyId = @sourceCopy
					AND		(a.dataType = 0 or a.dataType = b.dataType)
					AND		b.disabled & 1 = 0), 0)
	END
	IF		@oldestJobTimeNotCopied = 0 AND @oldestJobTimeToBeCopied = 0
			GOTO START_PRUNE
	ELSE IF		@oldestJobTimeNotCopied = 0 OR @oldestJobTimeToBeCopied <> 0 AND @oldestJobTimeNotCopied > @oldestJobTimeToBeCopied
			SET @oldestJobTimeNotCopied = @oldestJobTimeToBeCopied
	-- Get the latest job before the oldest to be copied job
	INSERT	INTO @tblOldestJob
	SELECT	TOP 1 commCellId, JobId, startTime, @AP_PRUNE_NOTCOPIED
	FROM	@tblJobCopy
	WHERE	startTime <= @oldestJobTimeNotCopied
	ORDER	BY startTime DESC
	-------------------------------------------------------------------------------
	-------------- Prune jobs according to retention rules ---------------------
	-------------------------------------------------------------------------------
START_PRUNE:
	-- Do not prune SQL here
	IF		(@inAppFlags & @AP_APP_FLAG_SQLDEF) = @AP_APP_FLAG_SQLDEF
			OR (@inAppFlags & @AP_APP_FLAG_SQLDB) = @AP_APP_FLAG_SQLDB
			GOTO SELECTIVE_PRUNE_JOB
	-- Do not prune jobs that do not atleast fulfill the Basic Retention Days
	-- Based on issue with TR-1-166885 (Premature pruning of Oracle commandline jobs)
	-- Update Request Form: 01040
	delete @tblJobCopy
	where startTime > @oldestUnprunableJobTime
	SET		@oldestDataTime = ISNULL((SELECT MIN(oldestTime) FROM @tblOldestJob WHERE flag != @AP_APPID_OLDESTDATATIME), @inCurrentTime)
	IF		(@inAppFlags & @AP_APP_FLAG_NOEXTRET) = @AP_APP_FLAG_NOEXTRET
	BEGIN
			INSERT	INTO ArchJobCopyToBeAged
			SELECT	jobId, @inCopyId, @inFileType, commCellId, @inAppId
			FROM	@tblJobCopy
			WHERE	startTime < @oldestDataTime
			AND		retained = 0
			GOTO CX_EXIT
	END
	IF		(@inAppFlags & @AP_APP_FLAG_SELFULL) = @AP_APP_FLAG_SELFULL
			UPDATE	@tblJobCopy
			SET		prunable = 1
			WHERE	startTime < @oldestDataTime
			AND		retained = 0
			AND		bkpLevel NOT IN (@SEL_OFFLINE_FULL, @SEL_ONLINE_FULL)
	ELSE
			UPDATE	@tblJobCopy
			SET		prunable = 1
			FROM	@tblJobCopy
			WHERE	startTime < @oldestDataTime
			AND		retained = 0
			AND		bkpLevel != @FULL
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	jobId, @inCopyId, @inFileType, commCellId, @inAppId
	FROM	@tblJobCopy
	WHERE	prunable = 1
	-------------------------------------------------------------------------------
	---------------------- Jobs for Extende Retention ----------------------
	-------------------------------------------------------------------------------
SELECTIVE_PRUNE_JOB:
	IF		(@inAppFlags & @AP_APP_FLAG_NOEXTRET) = @AP_APP_FLAG_NOEXTRET
			GOTO CX_EXIT
	IF		(@inAppFlags & @AP_APP_FLAG_SELFULL) = @AP_APP_FLAG_SELFULL
			INSERT	INTO @tblExtendedJob
			SELECT	commCellId, JobId, startTime, endTime, jobStatus, dataStatus, disabled, 0
			FROM	@tblJobCopy
			WHERE	bkpLevel IN (@SEL_OFFLINE_FULL, @SEL_ONLINE_FULL)
			AND		prunable = 0
	ELSE
			INSERT	INTO @tblExtendedJob
			SELECT	commCellId, JobId, startTime, endTime, jobStatus, dataStatus, disabled, 0
			FROM	@tblJobCopy
			WHERE	bkpLevel = @FULL
			AND		prunable = 0
	SET		@oldestDataTime = ISNULL((SELECT MIN(oldestTime) FROM @tblOldestJob WHERE flag != @AP_APPID_OLDESTDATATIME), @inCurrentTime)
	-- Assume all full within basic retention are fully copied when apply extended retention rules
	UPDATE	@tblExtendedJob SET dataStatus = 100
	WHERE	startTime >= @oldestDataTime
	-- Invalid cycle should not be considered as candidate of extended retention.
	-- Treat it as if it was disabled
	IF		@selectiveOnline > 0
	BEGIN
			UPDATE	@tblExtendedJob SET disabled = 1
			FROM	@tblExtendedJob a
			WHERE	NOT EXISTS (SELECT * FROM @tblFullCycle b
					WHERE a.JobId = b.JobId AND a.commCellId = b.commCellId)
			AND		startTime < @oldestDataTime
	END
	--***************************************************************************--
	--***************************************************************************--
	--***************************************************************************--
CX_EXIT:
	INSERT	INTO @tblExtendedJob
	SELECT	commCellId, JobId, oldestTime, 0, 0, 0, 0, flag
	FROM	@tblOldestJob
	COMMIT	TRANSACTION pruneByRule
	SELECT	* FROM @tblExtendedJob
	ORDER	BY startTime desc
	RETURN
CX_ERROR_EXIT:
	ROLLBACK	TRANSACTION pruneByRule
	DELETE FROM @tblExtendedJob
	SELECT	* FROM @tblExtendedJob
	RETURN
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'pruneAppIdByRules')
	delete from GxQscripts where name = 'pruneAppIdByRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='pruneAppIdByRules')
	delete from GXDBVersions where aliasname = 'pruneAppIdByRules'
GO

insert into GXDBVersions values(2, 'pruneAppIdByRules',  '00010119027400010000', 'pruneAppIdByRules', '00010119027400010000')
GO

