

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/patchUpdateDVDInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/patchUpdateDVDInfo.sp,v $ $Id: patchUpdateDVDInfo.sp,v 1.1.2.7 2020/12/19 05:07:50 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  patchUpdateDVDInfo()
--  |
--  | Description: Update the PatchSPVersion table using DVDInfo.xml
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='patchUpdateDVDInfo')
BEGIN
	print '>>> Drop Stored Procedure: patchUpdateDVDInfo <<<'
	drop procedure patchUpdateDVDInfo
END
IF EXISTS (select * from GxQscripts where name='patchUpdateDVDInfo')
	delete from GxQscripts where name = 'patchUpdateDVDInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='patchUpdateDVDInfo')
	delete from GXDBVersions where aliasname = 'patchUpdateDVDInfo'
GO
print '... Creating Procedure: patchUpdateDVDInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure patchUpdateDVDInfo
  @inDVDInfoXML XML,
  @inUseNewFormat INT,
  @inAllowPrivateBuild INT
AS
SET NOCOUNT ON
DECLARE @tmpDVDInfoTbl TABLE(ReleaseId INT, Version INT, Build INT, Major INT, Minor INT, TransactionId INT, Timestamp BIGINT, RevisionId INT, nLTSFlag INT, nBootstrapperDelay INT, nGUIDelay INT)
DECLARE @tmpIDs TABLE(SPVersionId INT, RevId INT)
DECLARE @staleDVDInfoTbl TABLE(ReleaseId INT, Build INT, Major INT, Minor INT, TS BIGINT, bIsShown INT)
DECLARE @CSInstalledSPMajor INT = 0
DECLARE @localVisibilityLevel INT = 0
SELECT @localVisibilityLevel = value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Patch Visibility Level' AND modified = 0
SELECT TOP 1 @CSInstalledSPMajor = P.SPMajor
FROM simInstalledPackages s WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON s.SPVersionId = P.id
WHERE s.clientid = 2
ORDER BY P.SPMajor DESC
INSERT INTO @tmpDVDInfoTbl(ReleaseId, Version, Build, Major, Minor, TransactionId, Timestamp, RevisionId, nLTSFlag, nBootstrapperDelay, nGUIDelay)
SELECT DISTINCT x.ref.value('(@ReleaseId)[1]', 'INT'),
		x.ref.value('(@Version)[1]', 'INT'),
		x.ref.value('(@Build)[1]', 'INT'),
		x.ref.value('(@Major)[1]', 'INT'),
		x.ref.value('(@Minor)[1]', 'INT'),
		x.ref.value('(@TransactionId)[1]', 'INT'),
		x.ref.value('(@Timestamp)[1]', 'BIGINT'),
		x.ref.value('(@RevisionId)[1]', 'INT'),
		ISNULL(x.ref.value('(@LTSRelease)[1]', 'INT'), 0),
		ISNULL(x.ref.value('(@BootstrapperDelayDays)[1]', 'INT'), 0),
		ISNULL(x.ref.value('(@GUIDownloadDelayDays)[1]', 'INT'), 0)
	FROM @inDVDInfoXML.nodes('/UpdatePatches_AvailableMedia/MediaSet/SPVersion') AS x(ref)
WHERE (@inUseNewFormat = 0 AND ((@inAllowPrivateBuild > 0) OR (x.ref.value('(@Major)[1]', 'INT') < (100))))
		OR (@inUseNewFormat <> 0 AND ((ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0) = 0) OR (@localVisibilityLevel & ISNULL(x.ref.value('(@VisibilityFlag)[1]', 'INT'), 0)) <> 0))
-- Update the revisionId 0 field
INSERT INTO @tmpIDs
SELECT S.Id, MAX(T.RevisionId) FROM PatchSPVersion S JOIN @tmpDVDInfoTbl T ON S.Release = T.ReleaseId AND S.Build = T.Build AND SPMajor = T.Major AND SPMinor = T.Minor AND S.TransactionId = T.TransactionId
WHERE S.RevisionID = 0 AND T.TransactionId > 0 AND T.RevisionId > 0
	AND NOT EXISTS (SELECT 1 FROM PatchSPVersion P WHERE P.Release = S.Release AND S.Build = P.Build AND S.SPMajor = P.SPMajor AND S.SPMinor = P.SPMinor AND S.TransactionId = P.TransactionId AND P.RevisionID > 0)
GROUP BY S.Id, T.RevisionId
UPDATE PatchSPVersion
SET RevisionID = RevId
FROM @tmpIDs WHERE Id = SPVersionId
-- Populate stale style DVDInfo table
INSERT INTO @staleDVDInfoTbl(ReleaseId, Build, Major, Minor, TS, bIsShown)
SELECT T.ReleaseId, T.Build, T.Major, T.Minor, MAX(T.Timestamp), CASE WHEN T.Major >= @CSInstalledSPMajor THEN 1 ELSE 0 END
FROM @tmpDVDInfoTbl T
GROUP BY T.ReleaseId, T.Build, T.Major, T.Minor
-- Clear all DVD present flags for both old and new style entries
UPDATE PatchSPVersion
SET bIsDVDPresent = 0, nCacheFlags = 0
-- Update LTSRelease and cloud controlled delays
UPDATE PatchSPVersion
SET nLTSFlag = T.nLTSFlag, nBootstrapperDelayDays = T.nBootstrapperDelay, nGUIDownloadDelayDays = T.nGUIDelay, Timestamp = T.Timestamp
FROM PatchSPVersion S JOIN @tmpDVDInfoTbl T
ON S.Release = T.ReleaseId AND S.Build = T.Build AND SPMajor = T.Major AND SPMinor = T.Minor AND S.TransactionId = T.TransactionId
-- Insert new entries
INSERT INTO PatchSPVersion (ReleaseStr,BuildIdString, DVDName, Build, Release,SPMajor, SPMinor, TransactionID, SPName, FriendlyName, Timestamp, bIsDVDPresent, bShowInGUI, nCacheFlags, nLTSFlag, RevisionID, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT '', '', '', Build, ReleaseId, Major, Minor, TransactionId, '', '', Timestamp, 0, 0, 0, nLTSFlag, RevisionId, nBootstrapperDelay, nGUIDelay
FROM @tmpDVDInfoTbl T
WHERE NOT EXISTS (SELECT 1 FROM PatchSPVersion S WHERE S.Release = T.ReleaseId AND S.Build = T.Build AND S.SPMajor = T.Major AND S.SPMinor = T.Minor AND S.RevisionId = T.RevisionId)
-- Reset cache flags for new style DVDInfo entries
UPDATE PatchSPVersion
SET nCacheFlags = 0x1
FROM @tmpDVDInfoTbl T
WHERE Release = T.ReleaseId AND PatchSPVersion.Build = T.Build AND SPMajor = T.Major AND SPMinor = T.Minor AND PatchSPVersion.TransactionId = T.TransactionId And PatchSPVersion.RevisionId = T.RevisionId
-- Update existing old stale DVDInfo entries
UPDATE PatchSPVersion
SET ReleaseStr = CAST((S.ReleaseId - 5) AS VARCHAR(255)) + '.0.0',
	BuildIdString = 'BUILD' + CAST(S.Build AS VARCHAR(255)),
	DVDName = 'SP' + CAST(S.Major AS VARCHAR(255)) + CASE WHEN S.Minor = 0 THEN '' ELSE CHAR(0x60 + S.Minor) END + 'DVD',
	SPName = 'SP' + CAST(S.Major AS VARCHAR(255)) + CASE WHEN S.Minor = 0 THEN '' ELSE CHAR(0x60 + S.Minor) END,
	Timestamp = S.TS,
	bIsDVDPresent = 1,
	bShowInGUI = S.bIsShown,
	FriendlyName = '',
	nCacheFlags = 0,
	nLTSFlag = 0,
	nBootstrapperDelayDays = 0,
	nGUIDownloadDelayDays = 0
FROM @staleDVDInfoTbl S
WHERE Release = S.ReleaseId AND
	PatchSPVersion.Build = S.Build AND
	SPMajor = S.Major AND
	SPMinor = S.Minor AND
	TransactionId = 0 AND
	RevisionId = 0 AND
	SPName <> ''
INSERT INTO PatchSPVersion (ReleaseStr,BuildIdString, DVDName, Build, Release,SPMajor, SPMinor, TransactionID, SPName, FriendlyName, Timestamp, bIsDVDPresent, bShowInGUI, nCacheFlags, nLTSFlag, RevisionID, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT CAST((S.ReleaseId - 5) AS VARCHAR(255)) + '.0.0',
	BuildIdString = 'BUILD' + CAST(S.Build AS VARCHAR(255)),
	DVDName = 'SP' + CAST(S.Major AS VARCHAR(255)) + CASE WHEN S.Minor = 0 THEN '' ELSE CHAR(0x60 + S.Minor) END + 'DVD',
	S.Build,
	S.ReleaseId,
	S.Major,
	S.Minor,
	0,
	SPName = 'SP' + CAST(S.Major AS VARCHAR(255)) + CASE WHEN S.Minor = 0 THEN '' ELSE CHAR(0x60 + S.Minor) END,
	'',
	S.TS,
	1,
	S.bIsShown,
	0,
	0,
	0,
	0,
	0
FROM @staleDVDInfoTbl S
WHERE NOT EXISTS (SELECT 1 FROM PatchSPVersion P WHERE P.Release = S.ReleaseId AND P.Build = S.Build AND P.SPMajor = S.Major AND P.SPMinor = S.Minor AND P.TransactionId = 0 AND P.RevisionId = 0 AND P.SPName <> '')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'patchUpdateDVDInfo')
	delete from GxQscripts where name = 'patchUpdateDVDInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='patchUpdateDVDInfo')
	delete from GXDBVersions where aliasname = 'patchUpdateDVDInfo'
GO

insert into GXDBVersions values(2, 'patchUpdateDVDInfo',  '00010001000200070000', 'patchUpdateDVDInfo', '00010001000200070000')
GO

