

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/markCopiedJobCopies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/markCopiedJobCopies.sp,v $ $Id: markCopiedJobCopies.sp,v 1.43.12.7 2020/05/09 00:45:10 kjaiswal Exp $";
--
--  +========================================================================+
--  | Stored Precedure: markCopiedJobCopies
--  |
--  | Description:
--  |  Mark status = 100 for fully copied jobs in JMJobDataStats table.
--  |  Mark status = 103 for partially copied jobs in JMJobDataStats table.
--  |  Mark status = 102 for jobs that has chunks but has no valid archive file.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jun Lu   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='markCopiedJobCopies')
BEGIN
	print '>>> Drop Stored Procedure: markCopiedJobCopies <<<'
	drop procedure markCopiedJobCopies
END
IF EXISTS (select * from GxQscripts where name='markCopiedJobCopies')
	delete from GxQscripts where name = 'markCopiedJobCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='markCopiedJobCopies')
	delete from GXDBVersions where aliasname = 'markCopiedJobCopies'
GO
print '... Creating Procedure: markCopiedJobCopies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure markCopiedJobCopies
  @i_commCellId integer,
  @i_archGroupId integer,
  @i_copyId integer,
  @i_auxCopyJobId integer,
  @i_now integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @retCode INTEGER = 0
DECLARE @l_copyId int
DECLARE @l_archGroupId int
DECLARE @l_sourceCopyId int
DECLARE @l_copyType int
DECLARE @isMagRefresh INT = 0;
IF EXISTS (SELECT 1 FROM JMJobDataStats WITH (READUNCOMMITTED) where archGrpCopyId = @i_copyId AND opType = 74 AND status = 101 AND disabled & 1 = 0)
	SET @isMagRefresh = 1
SET @retVal = 0
-- If copyId is > 0 means this is NOT called from MLMThread DASH Copy
-- In MLM Thread pass copyId as 0 for periodic updates.
IF @i_copyId <= 0
BEGIN
	IF object_id('tempdb.dbo.#tblInputCopiesAndJobs') IS NOT null DROP TABLE #tblInputCopiesAndJobs
	CREATE TABLE #tblInputCopiesAndJobs(commCellId  integer, archGroupId integer,copyId integer, sourceCopyId integer, auxCopyJobId integer, copyFlags integer, copyType integer, isSnapCopy integer, isMagRefresh integer)
END
IF @i_copyId > 0
BEGIN
	SELECT	@l_archGroupId = AGC.archGroupId, @l_copyType = AGC.type,
			@l_sourceCopyId = (CASE WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId > 0)
										THEN AGC.sourceCopyId
									WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId = 0)
										THEN AG.defaultSnapCopy
									WHEN AGC.sourceCopyId = 0
										THEN AG.defaultCopy
									ELSE AGC.sourceCopyId
								END)
	FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_copyId
IF	(@isMagRefresh = 1 OR @l_copyType <> 5)
	BEGIN
		SET @retCode = 0
		EXEC @retCode = archJobCopyStatsUpdate @i_commCellId, @l_archGroupId, @i_copyId, @l_sourceCopyId, @i_auxCopyJobId, @i_now
		IF @retVal = 0
			SELECT @retVal = @retCode
	END
END
ELSE IF @i_archGroupId > 0 -- Pass archGroupId as 0 in MLMThread for DASH Copy perodic updates. auxcopymgr passes non-zero archGrpId
BEGIN
	INSERT INTO #tblInputCopiesAndJobs
	SELECT	@i_commCellId, @i_archGroupId, AGC.id, (CASE WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId > 0)
							THEN AGC.sourceCopyId
						  WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId = 0)
							THEN AG.defaultSnapCopy
						  WHEN AGC.sourceCopyId = 0
							THEN AG.defaultCopy
						  ELSE AGC.sourceCopyId
					 END), @i_auxCopyJobId, AGC.flags, AGC.type, AGC.isSnapCopy, 0
	FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE	AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
		AND (@l_archGroupId = 0 OR AG.id = @l_archGroupId)
AND (@isMagRefresh = 1 OR AGC.type <> 5)
	SET @retCode = 0
	EXEC @retCode = archJobCopyStatsUpdate @i_commCellId, @i_archGroupId, @l_copyId, @l_sourceCopyId, @i_auxCopyJobId, @i_now
END
ELSE IF @i_auxCopyJobId > 0 -- Called from JM at the end of attempt
BEGIN
	SELECT	@l_archGroupId = archGrpID
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED)
	WHERE	J.JobId = @i_auxCopyJobId
	INSERT INTO #tblInputCopiesAndJobs
	SELECT	@i_commCellId, @l_archGroupId,archGrpCopyID, srcCopyId,@i_auxCopyJobId, AGC.flags, AGC.type, AGC.isSnapCopy, 0
	FROM	JMDataCopiedStatsTable J WITH (READUNCOMMITTED),archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE	J.jobId = @i_auxCopyJobId AND AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
				AND (AG.id = @l_archGroupId)
AND (@isMagRefresh = 1 OR AGC.type <> 5)
				AND AGC.id = J.archGrpCopyID
	SET @retCode = 0
	EXEC @retCode = archJobCopyStatsUpdate @i_commCellId, @i_archGroupId, @l_copyId, @l_sourceCopyId, @i_auxCopyJobId, @i_now
END
ELSE
	BEGIN
		-- Get DASH Copy Jobs from JMAdminJobInfoTable with opType 80
		-- For each destination copy update job stats with archJobCopyStatsUpdate.sp
		-- If
		DECLARE @l_commCellId INTEGER
		DECLARE @l_archGrpCopyId INTEGER
		DECLARE @l_jobid         INTEGER
		INSERT INTO #tblInputCopiesAndJobs
		SELECT  JI.commcellid, JI.archGrpID, AGC.id, (CASE WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId > 0)
											THEN AGC.sourceCopyId
										  WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId = 0)
											THEN AG.defaultSnapCopy
										  WHEN AGC.sourceCopyId = 0
											THEN AG.defaultCopy
										  ELSE AGC.sourceCopyId
									 END), JI.JobId, AGC.flags, AGC.type, AGC.isSnapCopy, 0
		FROM JMAdminJobInfoTable JI WITH (READUNCOMMITTED),archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
		WHERE opType IN ( 104 ) -- DASH copy
				AND AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
				AND (AG.id = JI.archGrpID)
AND (@isMagRefresh = 1 OR AGC.type <> 5)
				AND AGC.id = JI.archGrpCopyID
		INSERT INTO #tblInputCopiesAndJobs
		SELECT  JI.commcellid, JI.archGrpID, AGC.id, (CASE WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId > 0)
											THEN AGC.sourceCopyId
										  WHEN (AGC.isSnapCopy = 1) AND (AGC.sourceCopyId = 0)
											THEN AG.defaultSnapCopy
										  WHEN AGC.sourceCopyId = 0
											THEN AG.defaultCopy
										  ELSE AGC.sourceCopyId
									 END), JI.JobId, AGC.flags, AGC.type, AGC.isSnapCopy, 0
		FROM JMAdminJobInfoTable JI WITH (READUNCOMMITTED),archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
		WHERE opType IN ( 104 ) -- DASH copy
				AND AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy AND AGC.id <> AG.defaultSnapCopy
				AND (AG.id = JI.archGrpID)
AND (@isMagRefresh = 1 OR AGC.type <> 5)
				AND JI.archGrpCopyID  = 0
				AND NOT EXISTS (SELECT 1 FROM  #tblInputCopiesAndJobs  t WHERE copyId = AGC.Id)
		SET @retCode = 0
		EXEC @retCode = archJobCopyStatsUpdate @l_commCellId, @l_archGroupId, @l_copyId, @l_sourceCopyId, @l_jobid, @i_now
	END
SELECT   @retVal
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'markCopiedJobCopies')
	delete from GxQscripts where name = 'markCopiedJobCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='markCopiedJobCopies')
	delete from GXDBVersions where aliasname = 'markCopiedJobCopies'
GO

insert into GXDBVersions values(2, 'markCopiedJobCopies',  '00010043001200070000', 'markCopiedJobCopies', '00010043001200070000')
GO

