

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/licDisableCellLevelLicenseProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/licDisableCellLevelLicenseProps.sp,v $ $Id: licDisableCellLevelLicenseProps.sp,v 1.3.60.3 2019/08/19 14:47:46 leiwang Exp $";
--
--  +========================================================================+
--  |	Procedure:  licDisableCellLevelLicenseProps
--	|
--  |	input parameter - i_flag (It is the bit mask of the excluded cell level licenses (which has associated data in other tables))
--  |					  1st bit is used for SIM_CSL_AT_V2_DATA_ENCRYPTION.
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       hmishra  Updates the associated misc tables (apart from clientprop table)
--  |             based on what cell level features are excluded in the license key
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='licDisableCellLevelLicenseProps')
BEGIN
	print '>>> Drop Stored Procedure: licDisableCellLevelLicenseProps <<<'
	drop procedure licDisableCellLevelLicenseProps
END
IF EXISTS (select * from GxQscripts where name='licDisableCellLevelLicenseProps')
	delete from GxQscripts where name = 'licDisableCellLevelLicenseProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='licDisableCellLevelLicenseProps')
	delete from GXDBVersions where aliasname = 'licDisableCellLevelLicenseProps'
GO
print '... Creating Procedure: licDisableCellLevelLicenseProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure licDisableCellLevelLicenseProps
  @i_flag integer
AS
  DECLARE @o_errorCode integer
  DECLARE @o_infoString nvarchar(255)
SET NOCOUNT ON
BEGIN TRY
SET @o_infoString	=  ''
SET @o_errorCode    =  0
-- case (1) => DATA Encryption (SIM_CSL_AT_V2_DATA_ENCRYPTION)
IF ((@i_flag & 1) = 1 )
BEGIN
	-- Updating subclientprop table.
Update app_subclientprop set modified = dbo.getunixtime(GETUTCDATE()) where attrname = 'Encrypt: encryption'
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @o_errorCode = ERROR_NUMBER()
		set @o_infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message ['
		+ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_errorCode, @o_infoString
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'licDisableCellLevelLicenseProps')
	delete from GxQscripts where name = 'licDisableCellLevelLicenseProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='licDisableCellLevelLicenseProps')
	delete from GXDBVersions where aliasname = 'licDisableCellLevelLicenseProps'
GO

insert into GXDBVersions values(2, 'licDisableCellLevelLicenseProps',  '00010003006000030000', 'licDisableCellLevelLicenseProps', '00010003006000030000')
GO

