

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/isValidSocialLoginUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/isValidSocialLoginUser.sp,v $ $Id: isValidSocialLoginUser.sp,v 1.3.60.2 2018/03/20 00:34:30 jiechen Exp $";
-- =======================================================================
-- Author:      Rohit Iyer
-- Create date: 05/01/2014
-- Description: Check if a particular user is a valid social sign in user
-- =======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: isValidSocialLoginUser <<<'

IF EXISTS (select * from sysobjects where name='isValidSocialLoginUser')
	drop procedure isValidSocialLoginUser
IF EXISTS (select * from GxQscripts where name='isValidSocialLoginUser')
	delete from GxQscripts where name = 'isValidSocialLoginUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidSocialLoginUser')
	delete from GXDBVersions where aliasname = 'isValidSocialLoginUser'
GO
print '... Creating Procedure: isValidSocialLoginUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure isValidSocialLoginUser
  @providerName VARCHAR(255),
  @userEmail VARCHAR(255),
  @localeId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId 			integer = 0
DECLARE @userGUID 			NVARCHAR(255)	=''
DECLARE @login 				NVARCHAR(255)	=''
DECLARE @displayName		NVARCHAR(255)	=''
DECLARE @errorString		VARCHAR(255)
DECLARE @errorCode 			INT = 0
DECLARE @isUserEnabled 		INT = 0
--1. Fetch the details based on the inputs provided [provider , userEmail]
--2. Check for the validity of the following conditions : [User Record , Enabled/Diabled , Social Sign In]
--3. Based on the above checks , return back the corresponding error info and user info.
SELECT  @userId			=	id,
		@displayName	=	name,
		@login			=	login,
		@userGUID		=	userGuid,
		@isUserEnabled	=	enabled
FROM 	UMUsers
WHERE 	login	=	@providerName + '-' + @userEmail		--compare userName by appending the 2 strings[provider, userEmail]
IF(	@userId = 0)			--1. Check if user exists
BEGIN
	SET @errorString 		= 'Username/Password are incorrect'
	SET @errorCode		 	= 1116 		--INVALID_COMMCELL_LOGIN
END
ELSE IF(@isUserEnabled=0)	--2. Check if user is enabled
BEGIN
	SET @errorString 		= 'Account Disabled'
	SET @errorCode 			=  1131 	--LOGIN_ERROR_CODES(ERROR_ACCOUNT_DISABLED)
END
ELSE IF NOT EXISTS( SELECT 1 FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'SSI Provider' AND  attrVal = @providerName) --3. Check if user has appropriate FLAGS SET for SOCIAL SIGN IN
BEGIN
	 SET @errorString 		= 'Account is not eligible for Social Sign In'
	 SET @errorCode 		=  1116
END
SET NOCOUNT OFF
--Send back the response contaning user information(along with error information)
SELECT 	@errorCode 		AS [errorCode],
		@errorString 	AS [errorString],
		@userId 		AS [userId],
		@login 			AS [login] ,
		@displayName 	AS [displayName],
		@userGUID 		AS [userGuid]
GO

IF EXISTS (select * from GxQscripts where name = 'isValidSocialLoginUser')
	delete from GxQscripts where name = 'isValidSocialLoginUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidSocialLoginUser')
	delete from GXDBVersions where aliasname = 'isValidSocialLoginUser'
GO

insert into GXDBVersions values(2, 'isValidSocialLoginUser',  '00010003006000020000', 'isValidSocialLoginUser', '00010003006000020000')
GO

