

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/isValidSAMLUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =======================================================================
-- Author:      Rohit Iyer
-- Create date: 05/01/2014
-- Description: Check if a particular user is a valid SAML User
-- =======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: isValidSAMLUser <<<'

IF EXISTS (select * from sysobjects where name='isValidSAMLUser')
	drop procedure isValidSAMLUser
IF EXISTS (select * from GxQscripts where name='isValidSAMLUser')
	delete from GxQscripts where name = 'isValidSAMLUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidSAMLUser')
	delete from GXDBVersions where aliasname = 'isValidSAMLUser'
GO
print '... Creating Procedure: isValidSAMLUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure isValidSAMLUser
  @userName VARCHAR(255),
  @localeId INT = 0,
  @appKey NVARCHAR(20)
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId 			integer = 0
DECLARE @userGUID 			NVARCHAR(255)	=''
DECLARE @login 				NVARCHAR(255)	=''
DECLARE @displayName		NVARCHAR(255)	=''
DECLARE @errorString		VARCHAR(255)
DECLARE @providerName		VARCHAR(255)
DECLARE @errorCode 			INT = 0
DECLARE @isUserEnabled 		INT = 0
DECLARE @isSamlAssociationsEnabledViaApp TABLE (ISALLOWED INT)
--1. Fetch the details based on the inputs provided [userName]
--2. Check for the validity of the following conditions : [User Record , Enabled/Diabled , SAML flag]
--3. Based on the above checks , return back the corresponding error info and user info.
SELECT  @userId			=	id,
		@displayName	=	name,
		@login			=	login,
		@userGUID		=	userGuid,
		@isUserEnabled	=	enabled
FROM 	UMUsers
WHERE 	login	=	@userName
IF LEN(@appKey) = 15 --Third Party App key length.
BEGIN
	--Get AppId from App_thirdParty table
	Declare @temp INT
	select @temp = id from App_ThirdPartyApp where appKey = @appKey
	INSERT INTO @isSamlAssociationsEnabledViaApp EXEC MCC_ComputeMulticcappUserAssoc @userId,@temp
END
IF(	@userId = 0)			--1. Check if user exists
BEGIN
	SET @errorString 		= 'Incorrect SAML Username'
	SET @errorCode		 	= 1116 		--INVALID_COMMCELL_LOGIN
END
ELSE IF(@isUserEnabled=0)	--2. Check if user is enabled
BEGIN
	SET @errorString 		= 'Account Disabled'
	SET @errorCode 			=  1131 	--LOGIN_ERROR_CODES(ERROR_ACCOUNT_DISABLED)
END
ELSE IF NOT EXISTS( SELECT 1 FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'Is SAML User' AND attrType = 2 AND attrVal = '1') --3. Check if user has appropriate FLAGS SET for SAML
BEGIN
	IF LEN(@appKey)<>15 OR (SELECT ISALLOWED FROM @isSamlAssociationsEnabledViaApp) = 0
	BEGIN
	 SET @errorString 		= 'Account is not eligible for SAML Login'
	 SET @errorCode 		=  1116
	END
END
SET NOCOUNT OFF
--Send back the response contaning user information(along with error information)
SELECT 	@errorCode 		AS [errorCode],
		@errorString 	AS [errorString],
		@userId 		AS [userId],
		@login 			AS [login] ,
		@displayName 	AS [displayName],
		@userGUID 		AS [userGuid]
GO

IF EXISTS (select * from GxQscripts where name = 'isValidSAMLUser')
	delete from GxQscripts where name = 'isValidSAMLUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidSAMLUser')
	delete from GXDBVersions where aliasname = 'isValidSAMLUser'
GO

insert into GXDBVersions values(2, 'isValidSAMLUser',  '00000000000000000000', 'isValidSAMLUser', '00000000000000000000')
GO

