

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/isValidAutoLoginUserXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =======================================================================
-- Create date: 08/15/2016
-- Description: Check if a particular user is a valid Auto Login User
-- =======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='isValidAutoLoginUserXML')
BEGIN
	print '>>> Drop Stored Procedure: isValidAutoLoginUserXML <<<'
	drop procedure isValidAutoLoginUserXML
END
IF EXISTS (select * from GxQscripts where name='isValidAutoLoginUserXML')
	delete from GxQscripts where name = 'isValidAutoLoginUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidAutoLoginUserXML')
	delete from GXDBVersions where aliasname = 'isValidAutoLoginUserXML'
GO
print '... Creating Procedure: isValidAutoLoginUserXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure isValidAutoLoginUserXML
  @i_xml XML
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userName  NVARCHAR(255) = (SELECT ref.value('@userName', 'VARCHAR(MAX)') FROM @i_xml.nodes ('App_AutoLoginUserValidationReq') R(ref))
DECLARE @localeId  INT                            = (SELECT ref.value('@localeId',  'INT')          FROM @i_xml.nodes ('App_AutoLoginUserValidationReq') R(ref))
DECLARE @loginType INT                            = (SELECT ref.value('@loginType', 'INT')          FROM @i_xml.nodes ('App_AutoLoginUserValidationReq') R(ref))
DECLARE @appKey    NVARCHAR(64)                   = (SELECT ref.value('@appKey',    'VARCHAR(64)')  FROM @i_xml.nodes ('App_AutoLoginUserValidationReq') R(ref))
DECLARE @companyNameFromSamlResponse   NVARCHAR(255) = (SELECT ref.value('@companyNameFromSamlResponse ', 'VARCHAR(MAX)') FROM @i_xml.nodes ('App_AutoLoginUserValidationReq') R(ref))
-- -- SP BODY BEGIN : IsValidAutoLoginUser.spb -------------------------------------------------------------------------------------------------------------------------------------
DECLARE @userId 			integer = 0
DECLARE @userGUID 			NVARCHAR(255)	=''
DECLARE @login 				NVARCHAR(255)	=''
DECLARE @displayName		NVARCHAR(255)	=''
DECLARE @errorString		VARCHAR(255)
DECLARE @errorCode 			INT = 0
DECLARE @isUserEnabled 		INT = 0
DECLARE @isSamlAssociationsEnabledViaApp TABLE (ISALLOWED INT)
DECLARE @count int = 0
--1. Fetch the details based on the inputs provided [userName]
--2. Check for the validity of the following conditions : [User Record , Enabled/Diabled , Association with a AutoLogin Provider, will vary according to AppType]
--3. Based on the above checks , return back the corresponding error info and user info.
SELECT  @userId			=	id,
		@displayName	=	name,
		@login			=	login,
		@userGUID		=	userGuid,
		@isUserEnabled	=	enabled
FROM 	UMUsers
WHERE 	login	=	@userName							--compare userName by appending the 2 strings[provider, userEmail]
IF(@loginType = 4 AND (@userId = 0 OR @isUserEnabled = 0))
BEGIN
	SELECT @count = count(*) FROM 	UMUsers U JOIN UMDSProviders P
		ON U.UMDSProviderId = P.Id
		WHERE 	(U.login	like	CONCAT('%\',@userName) OR U.email = @userName) AND  (P.ServiceType = 5 or P.serviceType = 2) AND P.Enabled = 1-- Org
	IF(@count = 1)
	BEGIN
		SELECT  @userId			=	U.id,
			@displayName	=	U.name,
			@login			=	U.login,
			@userGUID		=	U.userGuid,
			@isUserEnabled	=	U.enabled
		FROM 	UMUsers U JOIN UMDSProviders P
		ON U.UMDSProviderId = P.Id
		WHERE 	(U.login	like	CONCAT('%\',@userName) OR U.email = @userName) AND  (P.ServiceType = 5 or P.serviceType = 2) AND P.Enabled = 1					--compare userName by appending the 2 strings[provider, userEmail]
	END
	ELSE IF(@count > 1)
	BEGIN
		SET @errorString 		= 'Multiple users with same username exist in different domains'
		SET @errorCode		 	= 1153 		--INVALID_COMMCELL_LOGIN
	END
END
IF(	@userId = 0)			--1. Check if user exists
BEGIN
	SET @errorString 		= 'Incorrect Auto Login User'
	SET @errorCode		 	= 1116 		--INVALID_COMMCELL_LOGIN
END
ELSE IF(@isUserEnabled=0)	--2. Check if user is enabled
BEGIN
	SET @errorString 		= 'Account Disabled'
	SET @errorCode 			=  1131 	--LOGIN_ERROR_CODES(ERROR_ACCOUNT_DISABLED)
END
--For OIDC Applications, we will check if the user has a valid OIDC application associated with the given user
if(@loginType = 4)	--OAUTH/OIDC
BEGIN
	DECLARE @TPIDS TABLE (TPIDS INT)
	--Now check if the user has association with some currently enabled OIDC Client
	DECLARE @AppID INT
	DECLARE @doAllowAccess TABLE(ISAllowed INT)
	DECLARE TPLIST CURSOR FOR SELECT ID FROM App_ThirdPartyApp WHERE isEnabled = 1 AND APPTYPE = 5	--OpenId Connect App Type
	--Check against each application if its user association mapping has this particular user in it
	OPEN TPLIST
	FETCH NEXT FROM TPLIST INTO @AppID
	WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @doAllowAccess EXEC DBO.MCC_ComputeMulticcappUserAssoc @userId, @AppID
			IF(SELECT ISAllowed FROM @doAllowAccess) = 1
				BEGIN
				INSERT INTO @TPIDS VALUES (@AppID)
				END
			FETCH NEXT FROM TPLIST INTO @AppID
			DELETE FROM @doAllowAccess
		END
	CLOSE TPLIST
	DEALLOCATE TPLIST
	DECLARE @AppListCnt integer
	SET @AppListCnt = (SELECT COUNT(*) FROM @TPIDS)
	if(@AppListCnt <= 0)
	BEGIN
		SET @errorString 		= 'Account not associated with any valid OIDC Application'
		SET @errorCode 			=  1116
	END
END
ELSE if (@loginType = 3) -- SAML
BEGIN
	IF NOT EXISTS( SELECT 1 FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'Is SAML User' AND attrType = 2 AND attrVal = '1') --3. Check if user has appropriate FLAGS SET for SAML
	BEGIN
		IF LEN(@appKey) = 15 --Third Party App key length.
			BEGIN
				Declare @temp INT
				exec dbo.IsSAMLAutoRedirectRuleEnableForUser @userName,'',@appKey, @companyNameFromSamlResponse, @temp OUTPUT, @o_errorString = @errorString OUTPUT, @o_errorCode = @errorCode OUTPUT
				IF(@temp <> 1)
				BEGIN
					--If Rule based assoc is not set, check for classic associations!
					--Get AppId from App_thirdParty table
					select @temp = id from App_ThirdPartyApp where appKey = @appKey
					INSERT INTO @isSamlAssociationsEnabledViaApp EXEC MCC_ComputeMulticcappUserAssoc @userId,@temp
					IF(ISNULL((SELECT TOP 1 ISALLOWED FROM @isSamlAssociationsEnabledViaApp), 0) <> 1)
					BEGIN
						SET @errorString 		= 'Account is not eligible for SAML Login'
						SET @errorCode 		=  1116
					END
					ELSE
					BEGIN
						-- clear the errorCode or errorString if any, set in the IsSAMLAutoRedirectRuleEnableForUser.sp.
						SET @errorCode = 0
						SET @errorString = ''
					END
				END
				--ELSE -- Rule based associations is enabled. Allow them SAML Login.
			END
	END
END
SET NOCOUNT OFF
-- -- SP BODY END : IsValidAutoLoginUser.spb ---------------------------------------------------------------------------------------------------------------------------------------
SET @o_xml =
(
    SELECT  @errorCode          AS '@errorCode',
            @errorString        AS '@errorString',
            email               AS '@email',
            [login]             AS '@login',
            (SELECT
                @userId         AS '@userId',
                @userGUID       AS '@userGUID',
                @displayName    AS '@userName'
             FOR XML PATH('userEntity'), TYPE )
    FROM UMUsers
    WHERE id = @userId
    FOR XML PATH('App_UserValidationResp'), TYPE
)
SELECT @o_xml;
GO

IF EXISTS (select * from GxQscripts where name = 'isValidAutoLoginUserXML')
	delete from GxQscripts where name = 'isValidAutoLoginUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='isValidAutoLoginUserXML')
	delete from GXDBVersions where aliasname = 'isValidAutoLoginUserXML'
GO

insert into GXDBVersions values(2, 'isValidAutoLoginUserXML',  '00000000000000000000', 'isValidAutoLoginUserXML', '00000000000000000000')
GO

