

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getdataPathsForSubClientlist.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetdataPathsForSubClientList.sp,v $ $Id: GetdataPathsForSubClientList.sp,v 1.4.304.2 2018/03/20 19:59:47 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetdataPathsForSubClientList()
--  |
--  | Description:  Delete all entries of the storage policy copy from database.
--  |               Include schedules, archive files, jobs, etc.
--  |               Recycle all volumes used by this storage policy copy.
--  |
--  |	    Input:
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Bheemesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getdataPathsForSubClientlist')
BEGIN
	print '>>> Drop Stored Procedure: getdataPathsForSubClientlist <<<'
	drop procedure getdataPathsForSubClientlist
END
IF EXISTS (select * from GxQscripts where name='getdataPathsForSubClientlist')
	delete from GxQscripts where name = 'getdataPathsForSubClientlist'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getdataPathsForSubClientlist')
	delete from GXDBVersions where aliasname = 'getdataPathsForSubClientlist'
GO
print '... Creating Procedure: getdataPathsForSubClientlist'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getdataPathsForSubClientlist
  @i_subClientIdList varchar(255)
AS
  DECLARE @o_drivePoolId INTEGER;
  DECLARE @o_drivePoolName varchar(255);
  DECLARE @o_drivePoolType INTEGER;
  DECLARE @o_mediaAgentId INTEGER;
  DECLARE @o_NDMPHostId INTEGER;
  DECLARE @o_mediaAgentName varchar(255);
  DECLARE @o_libraryId INTEGER;
  DECLARE @o_libraryName varchar(255);
  DECLARE @o_libraryAliasName varchar(255);
  DECLARE @o_libraryType INTEGER;	
  DECLARE @o_clientInterface varchar(255);
  DECLARE @o_mediaAgentInterface varchar(255);
  DECLARE @o_HWCompression INTEGER;
  DECLARE @o_DataPathFlag INTEGER;
  DECLARE @o_archGroupId INTEGER;
  DECLARE @o_clientId INTEGER;
  DECLARE @o_subClientId INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
create table #CCRSubClientList(subClientId	integer)
INSERT	INTO #CCRSubClientList
exec ('SELECT id FROM subClientName WHERE id IN (' + @i_subClientIdList + ')')
	create table #tmpDataPath(	drivePoolId			integer,
								drivePoolName  		varchar(256),
								drivePoolType		integer,
								mediaAgentId		integer,
								NDMPHostId			integer,
								mediaAgentName		varchar(256),
								libraryId			integer,
								libraryName			varchar(256),
								libraryAliasName	varchar(256),
								libraryType			integer,
								clientInterface		varchar(256),
								mediaAgentInterface	varchar(256),
								HWCompression		integer,
								DataPathFlag		integer,
								numRows				integer,
								archGroupId			integer,
								clientId			integer)
	create table #tmpSubClientSP(	subClientId	integer,
					clientId	integer,
					ArchGroupId	integer)
	INSERT INTO #tmpSubClientSP
	select a.id, a.clientId, a.dataArchGrpId
	from APP_Application as a, #CCRSubClientList as t
	where a.id = t.subClientId
	group by a.clientId, a.id, a.DataArchGrpId
	order by a.id
	IF NOT EXISTS(	select * from APP_Application as a, #tmpSubClientSP as t
			where a.logArchGrpId = t.ArchGroupId and t.subclientId = a.id)
	BEGIN
		INSERT INTO #tmpSubClientSP
		select a.id, a.clientId, a.logArchGrpId
		from APP_Application as a, #CCRSubClientList as t
		where a.id = t.subClientId
		group by a.clientId, a.id, a.logArchGrpId
		order by a.id
	END
	declare @tmpClientId	integer
	declare @tmpArchGrpId	integer
	DECLARE ChildCursor CURSOR
	FOR
	SELECT  distinct clientId, ArchGroupId FROM #tmpSubClientSP
	OPEN ChildCursor
	FETCH NEXT FROM ChildCursor
	INTO @tmpClientId, @tmpArchGrpId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		insert into #tmpDataPath
		Exec getdataPathsForSubClient @tmpArchGrpId, @tmpClientId
		FETCH NEXT FROM ChildCursor
		INTO @tmpClientId, @tmpArchGrpId
	END
	select td.drivePoolId, td.drivePoolName, td.drivePoolType, td.mediaAgentId,
	td.NDMPHostId, td.mediaAgentName, td.libraryId, td.libraryName,
	td.libraryAliasName, td.libraryType, td.clientInterface, td.mediaAgentInterface,
	td.HWCompression, td.DataPathFlag, ts.archGroupId, ts.clientId, ts.subClientId
	from #tmpDataPath as td, #tmpSubClientSP as ts
	where td.clientId = ts.clientId and td.archGroupId = ts.ArchGroupId
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
	CLOSE ChildCursor
	DEALLOCATE ChildCursor
	drop table #CCRSubClientList
	drop table #tmpDataPath
	drop table #tmpSubClientSP
GO

IF EXISTS (select * from GxQscripts where name = 'getdataPathsForSubClientlist')
	delete from GxQscripts where name = 'getdataPathsForSubClientlist'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getdataPathsForSubClientlist')
	delete from GXDBVersions where aliasname = 'getdataPathsForSubClientlist'
GO

insert into GXDBVersions values(2, 'getdataPathsForSubClientlist',  '00010004030400020000', 'getdataPathsForSubClientlist', '00010004030400020000')
GO

