

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getdataPathsForSubClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDataPathsForSubClient.sp,v $ $Id: GetDataPathsForSubClient.sp,v 1.17.200.2 2018/03/20 20:00:08 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "GetMediaContents"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getdataPathsForSubClient')
BEGIN
	print '>>> Drop Stored Procedure: getdataPathsForSubClient <<<'
	drop procedure getdataPathsForSubClient
END
IF EXISTS (select * from GxQscripts where name='getdataPathsForSubClient')
	delete from GxQscripts where name = 'getdataPathsForSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getdataPathsForSubClient')
	delete from GXDBVersions where aliasname = 'getdataPathsForSubClient'
GO
print '... Creating Procedure: getdataPathsForSubClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getdataPathsForSubClient
  @in_archGroupId integer,
  @in_clientId integer,
  @fetchDataPathIdOnly integer
AS
  DECLARE @dataPathId integer
  DECLARE @drivePoolId integer
  DECLARE @drivePoolName char(255)
  DECLARE @drivePoolType integer
  DECLARE @mediaAgentId integer
  DECLARE @NDMPHostId integer
  DECLARE @mediaAgentName char(255)
  DECLARE @libraryId integer
  DECLARE @libraryName char(255)
  DECLARE @libraryAliasName char(255)
  DECLARE @libraryType integer
  DECLARE @clientInterface char(255)
  DECLARE @mediaAgentInterface char(255)
  DECLARE @HWCompression integer
  DECLARE @DataPathFlag integer
  DECLARE @numRows integer
  DECLARE @archGroupId integer
  DECLARE @clientId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @i_fetchDataPathOnly	integer
	set @i_fetchDataPathOnly	= @fetchDataPathIdOnly
	declare @i_archGroupId integer
	set @i_archGroupId = @in_archGroupId
	declare @i_ClientId integer
	set @i_ClientId = @in_clientId
	declare @tmpNumRows integer
	set @tmpNumRows = 0
	if object_id('tempdb.dbo.#tmpPoolIds') is not null DROP TABLE #tmpPoolIds
	if object_id('tempdb.dbo.#tmpFailOverCandidates') is not null DROP TABLE #tmpFailOverCandidates
	if object_id('tempdb.dbo.#tmpCopy') is not null DROP TABLE #tmpCopy
	create table #tmpCopy(
		tmpCopyId integer,
		tmpCopyFlags integer
	)
	insert into #tmpCopy
	select distinct AGC.id,AGC.flags
	from archGroupCopy AGC WITH (READUNCOMMITTED),archGroup AG WITH (READUNCOMMITTED)
	where AGC.archgroupid=AG.id and AGC.archgroupid=@i_archGroupId
	create table #tmpPoolIds(	DataPathId		integer,
					DrivePoolId		integer,
					MasterPoolId		integer,
					ClientId		integer,
					Flag			integer,
					IsHardwareCompressed	integer)
	if(exists (select * from #tmpCopy where ((tmpCopyFlags & 8) != 0) OR ((tmpCopyFlags & 16)!= 0) OR ((tmpCopyFlags & 512)!= 0)))
	BEGIN
		insert into #tmpPoolIds
		select distinct mcf.DataPathId, mhdp.DrivePoolId, mhdp.MasterPoolId, mhdp.ClientId, mcf.flag, mcf.IsHardwareCompressed
		from MMDataPath as mcf WITH (READUNCOMMITTED), MMDrivePool as mhdp WITH (READUNCOMMITTED),#tmpCopy as t
		where mcf.DrivePoolId = mhdp.DrivePoolId and mcf.CopyId = t.tmpCopyId and (mcf.flag & 4) != 0
	END
	else
	BEGIN
			insert into #tmpPoolIds
			select distinct mcf.DataPathId, mhdp.DrivePoolId, mhdp.MasterPoolId, mhdp.ClientId, mcf.flag, mcf.IsHardwareCompressed
			from MMDataPath as mcf WITH (READUNCOMMITTED), MMDrivePool as mhdp WITH (READUNCOMMITTED),#tmpCopy as t
			where mcf.DrivePoolId = mhdp.DrivePoolId and mcf.CopyId = t.tmpCopyId and (HostClientId = @i_ClientId OR (mcf.flag & 1) = 1)
	END
	--MR:45305
	set @tmpNumRows = (select count(*) from #tmpPoolIds where DrivePoolId > 0)
	--If the caller is only intersted in only the DataPathId, then don't even
	--touch the other temp table
	if(@i_fetchDataPathOnly = 0)
	begin
		declare @tmpClientAttrVal varchar(255)
		set @tmpClientAttrVal = ''
		declare @tmpDPId integer
		set @tmpDPId = 0
		declare @tmpDefaultFlag integer
		set @tmpDefaultFlag = 1
		declare @tmpNonDefaultFlag integer
		set @tmpNonDefaultFlag = ~@tmpDefaultFlag
		create table #tmpFailOverCandidates( 	DataPathId		integer,
							DrivePoolId 		integer,
							ClientId		integer,
							t_NDMPHostId		integer,
							net_hostName		varchar(255),
							LibraryId		integer,
							LibraryTypeId		integer,
							LibraryName		varchar(255),
							LibraryAliasName	varchar(255),
							t_HWCompressionEnabled 	integer,
							Flag			integer)
		insert into #tmpFailOverCandidates
		select distinct tp.DataPathId, tp.drivepoolid, cl.id, 0, cl.net_hostName,
		ml.libraryId, ml.LibraryTypeId, ml.LibraryName, ml.AliasName,
		tp.IsHardwareCompressed, tp.Flag
		from MMHost as mh WITH (READUNCOMMITTED), MMMasterPool as mmp WITH (READUNCOMMITTED),
		MMLibrary as ml WITH (READUNCOMMITTED), APP_Client as cl WITH (READUNCOMMITTED), #tmpPoolIds as tp
		where tp.ClientId = mh.ClientId and tp.MasterpoolId = mmp.MasterPoolId
		and ml.LibraryId = mmp.LibraryId and cl.Id = mh.clientId
		set @tmpClientAttrVal = (select attrVal from APP_ClientProp
		where ComponentNameId = @i_ClientId and attrName = 'DataPipeInterface')
		update #tmpFailOverCandidates set t_HWCompressionEnabled = 0
		where LibraryTypeId = 2 OR LibraryTypeId = 3 OR LibraryTypeId = 5
		update #tmpFailOverCandidates
		set t_NDMPHostId = mdpn.NDMPHostId
		from MMDrivePool as mdpn WITH (READUNCOMMITTED), #tmpFailOverCandidates as tt
		where mdpn.DrivePoolId = tt.DrivePoolId
		and mdpn.NDMPHostId > 0
		update #tmpFailOverCandidates
		set net_hostName = cc.Net_HostName
		from MMNDMPHostInfo as mnh WITH (READUNCOMMITTED), #tmpFailOverCandidates as tt, APP_Client as cc WITH (READUNCOMMITTED)
		where mnh.NDMPHostId = tt.t_NDMPHostId and tt.t_NDMPHostId <> 0 and cc.id = mnh.ClientId
		if(exists(select top 1 ClientId from #tmpFailOverCandidates where ClientId = 1))
		BEGIN
			--(1,0,'N/A',-1,1,0,'N/A',0,'N/A','N/A',-1,'N/A','N/A',-1,0,1,2,@clientId)
			SELECT TT.DataPathId, TT.DrivePoolId, DrivePoolName = 'N/A', DrivePoolType = -1,
			TT.ClientId, TT.t_NDMPHostId,NETHostName='N/A',TT.LibraryId,TT.LibraryName,TT.LibraryAliasName,
			TT.LibraryTypeId,ClientInterface='N/A',MediaAgentInterface='N/A',HWCompressionEnabled=-1,
			Flag=0,NoOfRows=1,ArchgroupId=@in_archGroupId,ClientId=@in_clientId
			FROM #tmpFailOverCandidates TT
		END
		ELSE
		BEGIN
			if exists(select top 1 flag
				from #tmpFailOverCandidates as tt,  APP_Client as cl
				where cl.id = @i_ClientId and cl.net_hostName = tt.net_hostName)
			BEGIN
				set @tmpDPId = (select top 1 DrivePoolId
						from #tmpFailOverCandidates as tt,  APP_Client as cl WITH (READUNCOMMITTED)
						where cl.id = @i_ClientId and cl.net_hostName = tt.net_hostName)
				update #tmpFailOverCandidates
				set Flag = (Flag | @tmpDefaultFlag)
				from APP_Client as cl WITH (READUNCOMMITTED), #tmpFailOverCandidates as tt
				where cl.id = @i_ClientId and cl.net_hostName = tt.net_hostName
					and tt.DrivePoolId = @tmpDPId
				update #tmpFailOverCandidates
				set Flag = (Flag & ~@tmpDefaultFlag )
				from APP_Client as cl WITH (READUNCOMMITTED), #tmpFailOverCandidates as tt
				where cl.id = @i_ClientId and cl.net_hostName != tt.net_hostName
					and DrivePoolId != @tmpDPId
			END
			else if exists(select top 1 Flag from #tmpFailOverCandidates where ClientId = @i_ClientId)
			BEGIN
				set @tmpDPId = (select top 1 DrivePoolId from #tmpFailOverCandidates where ClientId != @i_ClientId)
				update #tmpFailOverCandidates set Flag = (Flag | @tmpDefaultFlag)
				where ClientId = @i_ClientId and DrivePoolId = @tmpDPId
				update #tmpFailOverCandidates set Flag = (Flag & ~@tmpDefaultFlag )
				where ClientId != @i_ClientId
			END
			select distinct tt.DataPathId,mdp.DrivePoolId, mdp.DrivePoolName, mdp.DrivePoolType,
			tt.ClientId, tt.t_NDMPHostId, tt.net_hostName, tt.LibraryId, tt.LibraryName, tt.LibraryAliasName,
			tt.LibraryTypeId, ClientInterface = @tmpClientAttrVal,
			MediaAgentInterface = cp.attrVal, tt.t_HWCompressionEnabled, tt.Flag, @tmpNumRows,
			@in_archGroupId, @in_clientId
			from #tmpFailOverCandidates as tt, MMDrivePool as mdp WITH (READUNCOMMITTED),
			APP_Client as cl WITH (READUNCOMMITTED), APP_ClientProp as cp WITH (READUNCOMMITTED)
			where tt.ClientId = cl.id and tt.DrivePoolId = mdp.DrivePoolId
			and cp.ComponentNameId = tt.ClientId and cp.attrName = 'DataPipeInterface'
		END
		drop table #tmpFailOverCandidates
	end
	else
	begin
		select distinct tt.DataPathId, 0, '', 0, 0, 0, '', 0, '', '', 0, ClientInterface = '',
		MediaAgentInterface = '', 0, 0, @tmpNumRows, @in_archGroupId, @in_clientId
		from #tmpPoolIds as tt
	end
	drop table #tmpCopy
	drop table #tmpPoolIds
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getdataPathsForSubClient')
	delete from GxQscripts where name = 'getdataPathsForSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getdataPathsForSubClient')
	delete from GXDBVersions where aliasname = 'getdataPathsForSubClient'
GO

insert into GXDBVersions values(2, 'getdataPathsForSubClient',  '00010017020000020000', 'getdataPathsForSubClient', '00010017020000020000')
GO

