

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getclientlistAndInitialProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getclientlistAndInitialProps.sp,v $ $Id: getclientlistAndInitialProps.sp,v 1.121.2.64.8.1 2021/04/27 00:05:21 nnuthakki Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "getClientListAndInitialProps"	|
--	|This Procedure is used when initially getting the list of clients.	|
--	|   It includes only the properties that are absolutely necessary at 	|
--	|	that time!							|
--	|	All other client properties are in getClientProps.cur.		|
--	|	No props should appear in both of these cursors!!		|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  |   getClientListAndInitialProps          6.1 and below                               |
--  |   getClientListAndInitialProps2         7.0 Table name changes + new data returned  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='getClientListAndInitialProps')
BEGIN
	print '>>> Drop Stored Procedure: getClientListAndInitialProps <<<'
	drop procedure getClientListAndInitialProps
END
IF EXISTS (select * from GxQscripts where name='getClientListAndInitialProps')
	delete from GxQscripts where name = 'getClientListAndInitialProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getClientListAndInitialProps')
	delete from GXDBVersions where aliasname = 'getClientListAndInitialProps'
GO
print '... Creating Procedure: getClientListAndInitialProps'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure getClientListAndInitialProps
  @i_userId integer,
  @i_getCommNetClients integer = 0,
  @i_includeHiddenClients integer = 0,
  @i_clientGroupId integer = 0,
  @i_clientId integer = 0,
  @i_hideEnabled integer = 1,
  @i_clientIdStart integer = 0,
  @i_clientIdEnd integer = -1
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :OUT LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
  DECLARE @r_id integer
  DECLARE @r_name nchar(255)
  DECLARE @r_displayName nchar(255)
  DECLARE @r_desc nchar(3072)
  DECLARE @r_netHostName nchar(255)
  DECLARE @r_OSId integer
  DECLARE @r_OSName nchar(255)
  DECLARE @r_hwId integer
  DECLARE @r_hwName char(255)
  DECLARE @r_licenses integer
  DECLARE @r_bkpEnabled integer
  DECLARE @r_rstEnabled integer
  DECLARE @r_deleted integer
  DECLARE @r_priority integer
  DECLARE @r_clientFlag integer
  DECLARE @r_isCommServer integer
  DECLARE @r_encryption integer
  DECLARE @r_rsaPubKey nchar(1024)
  DECLARE @r_rsaPriKeySF nchar(1024)
  DECLARE @r_releaseId integer
  DECLARE @r_status integer
  DECLARE @r_virtual integer
  DECLARE @r_isLicensed integer
  DECLARE @r_physClientId integer
  DECLARE @r_physClientName nchar(1024)
  DECLARE @r_DCinstalled integer
  DECLARE @r_contentIndexingEnabled integer
  DECLARE @r_CIActivityEnabled integer
  DECLARE @r_updateStatus integer
  DECLARE @r_snapBackupsEnabled integer
  DECLARE @r_snapBackupsMAInstalled integer
  DECLARE @r_collectDelegateInfo integer
  DECLARE @r_donotSingleInstance integer
  DECLARE @r_noPhysMachPresent integer
  DECLARE @r_proxyFSClientId integer
  DECLARE @r_proxyFSClientName nchar(1024)
  DECLARE @r_evmgrcPort integer
  DECLARE @r_miniSRM integer
  DECLARE @r_virtualDiscovered integer
  DECLARE @r_EDCDiscovered integer
  DECLARE @r_specialStatusFlags integer
  DECLARE @r_outlookAddin integer
  DECLARE @r_commNetClientCount integer
  DECLARE @r_clientVersion varchar(255)
  DECLARE @r_releasedIDWhenClientWasInstalled integer
  DECLARE @r_ArchiverEnabled integer
  DECLARE @r_virtualEntityFlags integer
  DECLARE @r_isAdvancedFSPackageInstalled integer
  DECLARE @r_isRemoteCacheEnabled integer
  DECLARE @r_isWebServerInstalled integer
  DECLARE @r_cvdPort integer
  DECLARE @r_dataSecurityEnabled integer
  DECLARE @r_sharePointFarmClient integer
  DECLARE @tr_canSchedule integer
  DECLARE @tr_canClientGroup integer
  DECLARE @tr_canSubclientPolicy integer
  DECLARE @tr_canPseudoClientCreate integer
  DECLARE @tr_canAdmin integer
  DECLARE @tr_canLogMonitor integer
  DECLARE @tr_canAlert integer
  DECLARE @tr_canReport integer
  DECLARE @r_SPVersionInfo varchar(255)
--LIMITATION WITH VARCHAR/NVARCHAR (MAX). THIS MUST BE LAST VARIABLE. PLEASE DO NOT ADD ANY VARIABLE AFTER THIS.DECLARE FORWARD.
  DECLARE @r_SPVersionAndPatchInfo varchar(MAX)
  DECLARE @r_isIndexingV2 integer
  DECLARE @r_isQsnapInstalled integer
  DECLARE @r_isDescriptionInHTMLFormat integer
  DECLARE @r_refCopyClientType integer
  DECLARE @r_isFileShareArchiverClientPackageInstalled integer
  DECLARE @r_isAgentLicenseConsumed integer
  DECLARE @r_clientType integer
  DECLARE @r_clusterType integer
  DECLARE @r_isIndexingV2NAS integer
  DECLARE @r_isVirtualServerPresent integer
  DECLARE @r_is1TouchClient integer
  DECLARE @r_clientGuid varchar(40)
  DECLARE @r_cloudStatus integer
-- V11 SP11 adding NAS OS Type and NAS Capabilities to the returned data from this stored procedure. New client properties have been added
-- for NAS clients and need to be returned from this stored procedure to be sent up to the GUI.
  DECLARE @r_nasOSType integer
  DECLARE @r_nasCapabilities bigint
  DECLARE @r_isExchangePackageInstalled integer
  DECLARE @r_clientAppType integer
  DECLARE @r_isIndexingV2VSA integer
  DECLARE @r_retireClientPhase integer
  DECLARE @r_agentList varchar(255)
  DECLARE @r_indexingV2EnabledMask bigint
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	DECLARE @debug TINYINT = 0
	-- Disable Change Tracking Functionality, revert to original implementations
	DECLARE @disableCTClientProperties		INT = 0
	SELECT
		@disableCTClientProperties = (CASE WHEN value <> '0' THEN 1 ELSE 0 END)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = 'CTDisablePropertyCaching'
	IF (@debug > 0 AND @disableCTClientProperties > 0)
	BEGIN
		PRINT 'GetClientListAndInitialProps: disableCTClientProperties = ' + CAST(@disableCTClientProperties AS VARCHAR(12))
	END
	IF (@i_clientIdEnd = -1)
	BEGIN
		SET @i_clientIdEnd = POWER(2,30)
	END
	-- create the client list temporary table
	IF object_id('tempdb.dbo.#ClientListTbl') IS NOT null DROP TABLE #ClientListTbl
	CREATE TABLE #ClientListTbl	(
		[r_id]				INT PRIMARY KEY,
		[r_name]			NVARCHAR(255),
		[r_displayName]		NVARCHAR(255),
		[r_OSId]			INT,
		[r_netHostName]			NVARCHAR(255),
		[r_desc]			NVARCHAR(MAX),
		[r_status]			INT,
		[r_releaseId]     		INT,
	--	[r_OSId]			INT		DEFAULT(0),
		[r_OSName]			NVARCHAR(255)	DEFAULT(''),
		[r_hwId]			INT		DEFAULT(0),
		[r_hwName]			VARCHAR(255)	DEFAULT(''),
		[r_licenses]			INT		DEFAULT(0),
		[r_bkpEnabled]			INT		DEFAULT(null),
		[r_rstEnabled]			INT		DEFAULT(null),
		[r_deleted]			INT		DEFAULT(null),
		[r_priority]			INT		DEFAULT(null),
		[r_clientFlag]			INT		DEFAULT(0),
		[r_isCommServer]		INT		DEFAULT(0),
		[r_encryption]			INT		DEFAULT(null),
		[r_rsaPubKey]			NVARCHAR(1024)	DEFAULT(null),
		[r_rsaPriKeySF]			NVARCHAR(1024)	DEFAULT(null),
 		[r_virtualClient]				INT		DEFAULT(null),
		[r_isLicensed]			INT		DEFAULT(null),
 		[r_physClientId]		INT		DEFAULT(null),
 		[r_physClientName]		NVARCHAR(1024)	DEFAULT(null),
 		[r_DCinstalled]			INT		DEFAULT(null),
 		[r_contentIndexingEnabled]	INT		DEFAULT(null),
 		[r_CIActivityEnabled]		INT		DEFAULT(null),
 		[r_updateStatus]		INT		DEFAULT(0),
 		[r_snapBackupsEnabled]		INT		DEFAULT(null),
 		[r_snapBackupsMAInstalled]	INT		DEFAULT(0),
		[r_hotSpotEnabled]		INT		DEFAULT(null),
		[r_CIEngine]			VARCHAR(1024)	DEFAULT(null),
		[r_OSInfo]			VARCHAR(1024)	DEFAULT(null),
 		[r_collectDelegateInfo]	INT		DEFAULT(0),
 		[r_donotSingleInstance]	INT		DEFAULT(0),
		[r_noPhysMachPresent]	INT		DEFAULT(null),
		[r_proxyFSClientId]		INT		DEFAULT(null),
		[r_proxyFSClientName]		NVARCHAR(255)	DEFAULT(null),
		[r_evmgrcPort]		INT		DEFAULT(0),
		[r_ccpId]			INT		DEFAULT(0),
		[r_miniSRM]			INT		DEFAULT(0),
		[r_virtualDiscovered]			INT		DEFAULT(0),
		[r_EDCDiscovered]			INT		DEFAULT(0),
		[r_specialStatusFlags]			INT		DEFAULT(0),
		[r_outlookAddin]			INT		DEFAULT(0),
		[r_commNetClientCount]			INT		DEFAULT(0),
		[r_clientVersion] 			VARCHAR(255)	DEFAULT(''),
		[r_releasedIDWhenClientWasInstalled]	INT		DEFAULT(0),
		[r_ArchiverEnabled]	INT		DEFAULT(0),
		[r_virtualEntityFlags] INT  DEFAULT(0),
		[r_cvdPort] INT  DEFAULT(0),
		[r_SPVersionInfo]	varchar(255) DEFAULT(null),
		[r_SPVersionAndPatchInfo]	varchar(MAX) DEFAULT(null),
		[r_isAdvancedFSPackageInstalled] INT  DEFAULT(0),
		[r_isRemoteCacheEnabled] INT DEFAULT(0),
		[r_isWebServerInstalled] INT DEFAULT(0),
		-- Reading datasecurityenabled as varchar because it's an encrypted hash value
		[r_dataSecurityEnabled] nvarchar(255) DEFAULT(null),
		[r_sharePointFarmClient] INT DEFAULT(0),
		[tr_canSchedule] INT DEFAULT(0),
		[tr_canClientGroup] INT DEFAULT(0),
		[tr_canSubclientPolicy] INT DEFAULT(0),
		[tr_canPseudoClientCreate] INT DEFAULT(0),
		[tr_canAdmin] INT DEFAULT(0),
		[tr_canLogMonitor] INT DEFAULT(0),
		[tr_canAlert] INT DEFAULT(0),
		[tr_canReport] INT DEFAULT(0),
		[r_isIndexingV2] INT DEFAULT(0),
		[r_isQsnapInstalled] INT DEFAULT(0),
		[r_isDescriptionInHTMLFormat] INT DEFAULT(0),
		[r_refCopyClientType] INT DEFAULT(0),
		[r_isFileShareArchiverClientPackageInstalled] INT DEFAULT(0),
		[r_isAgentLicenseConsumed] INT DEFAULT(0),
		[r_clientType] INT DEFAULT(0),
		[r_clusterType] INT DEFAULT(0),
		[r_isIndexingV2NAS] INT DEFAULT(0),
		[r_isVirtualServerPresent] INT DEFAULT(0),
		[r_is1TouchClient] INT DEFAULT(0),
		[r_clientGuid]	varchar(40) DEFAULT(null),
		[r_cloudStatus] INT DEFAULT(0),
		[r_nasOSType] INT DEFAULT(0),
		[r_nasCapabilities] BIGINT DEFAULT(0),
		[r_isExchangePackageInstalled] INT DEFAULT(0),
		[r_clientAppType] INT DEFAULT(0),
		[r_isIndexingV2VSA] INT DEFAULT(0),
		[r_retireClientPhase] INT DEFAULT(0),
		[r_agentList] varchar(MAX) DEFAULT(null),
		[r_indexingV2EnabledMask] BIGINT DEFAULT(0)
	)
	-- create the client property temporary table
	IF object_id('tempdb.dbo.#clientPropTbl_gclaip') IS NOT null DROP TABLE #clientPropTbl_gclaip
	CREATE TABLE #clientPropTbl_gclaip (
		clientId		INT,
		deleted			INT,
		priority		INT,
		CIEngine		VARCHAR(1024),
		encryption		INT,
		rsaPubKey		NVARCHAR(1024),
		rsaPriKeySF		NVARCHAR(1024),
		virtualClient			INT,
		islicensed		INT,
		physClientId		INT,
		DCinstalled		INT,
		contentIndexingEnabled	INT,
		snapBackupsEnabled	INT,
		hotSpotEnabled		INT,
		OSInfo			VARCHAR(1024),
		collectDelegateInfo	INT,
		donotSingleInstance	INT	,
		noPhysMachPresent INT,
		proxyFSClientId		INT,
		miniSRM	INT,
		virtualServerDiscovered INT,
		outlookAddin INT,
		clientVersion VARCHAR(255),
		virtualEntityFlags INT,
		SPVersionInfo	nvarchar(255),
		SPVersionAndPatchInfo	nvarchar(MAX),
		-- Reading ControlHashString as varchar because it's an encrypted hash value
		ControlHashString  nvarchar(255),
		sharePointFarmClient INT,
		isIndexingV2	INT DEFAULT(0),
		isQsnapInstalled INT DEFAULT(0),
		isDescriptionInHTMLFormat INT DEFAULT(0),
		refCopyClientType INT DEFAULT(0),
		encryptionSettings INT,
		isExchangeOnePass INT DEFAULT(0),
		isDistributedApp INT DEFAULT(0),
		isExchange INT DEFAULT(0),
		clusterType INT DEFAULT(0),
		isIndexingV2NAS	INT DEFAULT(0),
		is1TouchClient INT DEFAULT(0),
		osName nvarchar(255) DEFAULT '',
		hwName nvarchar(255) DEFAULT '',
		nasOSType INT DEFAULT(0),
		nasCapabilities BIGINT DEFAULT(0),
		clientAppType INT DEFAULT(0),
		isDBThinClient INT DEFAULT(0),
		isIndexingV2VSA	INT DEFAULT(0),
		indexingV2EnabledMask BIGINT DEFAULT(0),
		isOffice365Client INT DEFAULT(0),
		isAzureADClient INT DEFAULT(0)
		-- change to only do pivot query for properties defined in this temp table, no need to add unused properties
	)
	--PERF: 8/17/2015 AEB for PIVOT QUERIES
	CREATE CLUSTERED INDEX clientPropTbl_idx ON #clientPropTbl_gclaip(clientId)
	-- PERF new index to speed up PIVOT QUERIES
	--CREATE NONCLUSTERED INDEX APP_ClientProp_modified_componentNameId_idx ON APP_ClientProp (modified, componentNameId, attrName) INCLUDE(attrVal)
	--PERF 8/17/2015 AEB moved user visibility credentials to before client list selected so that default access rights could be assigned initially during insertion.
	-- Initial defaulted access rights - not possible to set as the column default values without alot of scripting
	DECLARE	@initCanSchedule		INT = 0,
			@initCanClientGroup		INT = 0,
			@initCanSubclientPolicy	INT = 0,
			@initCanPseudoClientCreate	INT = 0,
			@initCanAdmin			INT = 0,
			@initCanLogMonitor		INT = 0,
			@initCanAlert			INT = 0,
			@initCanReport			INT = 0
	IF OBJECT_ID('tempdb.dbo.#cumulativeCaps') IS NOT NULL
		DROP TABLE #cumulativeCaps
	CREATE TABLE #cumulativeCaps
	(
		clientId		INT PRIMARY KEY,
		capabilities	BIGINT,
		visible			TINYINT DEFAULT (0)
	)
	--NOTE: XML Parsing inputted XML Security document more costly than performing the security calls below.
	if (@i_userId <> 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getIdaObjectsForUserV2OutputTbl') IS NOT NULL
			DROP TABLE #getIdaObjectsForUserV2OutputTbl
		CREATE TABLE #getIdaObjectsForUserV2OutputTbl
		(
			clientId INT,
			appTypeID INT,
			instanceID INT,
			backupsetId INT,
			subclientID INT,
			capabilities BIGINT
		)
		EXEC sec_getIdaObjectsForUserV2 @i_userId, 3
	END
	-- 09/20/2017 AEB Performance changes
	-- Performance increase work temp tables
	IF object_id('tempdb.dbo.#PkgTypes') IS NOT null DROP TABLE #PkgTypes
	CREATE TABLE #PkgTypes	(
		clientId		INT PRIMARY KEY,
		pkgBit			INT
	)
	--CREATE UNIQUE NONCLUSTERED INDEX PkgTypes_idx ON #PkgTypes (clientId, pkgBit)
	IF object_id('tempdb.dbo.#Platforms') IS NOT null DROP TABLE #Platforms
	CREATE TABLE #Platforms	(
		clientId		INT PRIMARY KEY,
		platformType	INT
	)
	IF object_id('tempdb.dbo.#Licenses') IS NOT null DROP TABLE #Licenses
	CREATE TABLE #Licenses	(
		clientId		INT PRIMARY KEY,
		licenses		INT,
		agents			INT
	)
	IF object_id('tempdb.dbo.#ClientOps') IS NOT null DROP TABLE #ClientOps
	CREATE TABLE #ClientOps	(
		clientId		INT PRIMARY KEY,
		bkpEnabled		INT,
		rstEnabled		INT,
		CIEnabled		INT
	)
	IF object_id('tempdb.dbo.#LicenseConsumed') IS NOT null DROP TABLE #LicenseConsumed
	CREATE TABLE #LicenseConsumed	(
		clientId					INT PRIMARY KEY,
		agentLicenseConsumed		INT
	)
	IF object_id('tempdb.dbo.#ClientRelease') IS NOT null DROP TABLE #ClientRelease
	CREATE TABLE #ClientRelease	(
		clientId		INT PRIMARY KEY,
		releaseID		INT
	)
	--IF object_id('tempdb.dbo.#ClientHdw') IS NOT null DROP TABLE #ClientHdw
	--CREATE TABLE #ClientHdw	(
	--	clientId		INT PRIMARY KEY,
	--	name			NVARCHAR(128)
	--)
	IF object_id('tempdb.dbo.#ObjectServers') IS NOT null DROP TABLE #ObjectServers
	CREATE TABLE #ObjectServers	(
		clientId		INT PRIMARY KEY
	)
	IF object_id('tempdb.dbo.#indexServers') IS NOT null DROP TABLE #indexServers
	CREATE TABLE #indexServers	(
		clientId		INT PRIMARY KEY,
		status		INT
	)
	IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
	CREATE TABLE #RetireInProgressClientListTbl(retireClientId INT)
	IF object_id('tempdb.dbo.#Agents') IS NOT null DROP TABLE #Agents
	CREATE TABLE #Agents(
		clientId		INT PRIMARY KEY,
		agent			VARCHAR(MAX)
	)
	-- 09/20/2017 AEB Performance changes
	-- Populate performance tables
	--IF (@i_userId <> 0 AND @i_hideEnabled <> 0)	-- cannot filter out for user, get all info
	BEGIN
		INSERT INTO #Agents
		SELECT DISTINCT Agent2.clientId,
				(
					SELECT CAST(Agent1.appTypeId AS VARCHAR(16)) + ','
					FROM dbo.APP_IDAName Agent1
					WHERE Agent1.clientId = Agent2.clientId
					FOR XML PATH ('')
				)
		FROM dbo.APP_IDAName Agent2
		WHERE
			clientId > @i_clientIdStart
			AND clientId <= @i_clientIdEnd
		-- Get Client Info that is visible to the user
		INSERT INTO #PkgTypes
			SELECT
				clientId,
				SUM(pkgBit) pkgBit
			FROM (
					SELECT DISTINCT
						ip.clientId,
						CASE ip.simPackageId
WHEN 713 THEN 1			-- r_isVirtualServerPresent
WHEN 252 THEN 2				-- r_isWebServerInstalled
WHEN 552 THEN 4	   -- r_isFileShareArchiverClientPackageInstalled
WHEN 702 THEN 8					-- r_isAdvancedFSPackageInstalled
WHEN 1101 THEN 16					-- r_isAdvancedFSPackageInstalled
WHEN 1401 THEN 32
WHEN 253 THEN 64
WHEN 151 THEN 128			--r_isExchangePackageInstalled
							ELSE 0
						END pkgBit
					FROM  simInstalledPackages ip
				) p
			WHERE
				clientId > @i_clientIdStart
				AND clientId <= @i_clientIdEnd
			GROUP BY clientId
		INSERT INTO #Platforms
			SELECT
				clientId,
				SUM(platformType) platformType
			FROM APP_Platform
			WHERE
				clientId > @i_clientIdStart
				AND clientId <= @i_clientIdEnd
			GROUP BY clientId
		INSERT INTO #Licenses
			SELECT
				l.cid clientId,
				SUM(CASE l.licType
							WHEN 110	THEN POWER(2,0)
							WHEN 102	THEN POWER(2,1)
							WHEN 80		THEN POWER(2,2)
							WHEN 60		THEN POWER(2,4)
							WHEN 70		THEN POWER(2,5)
							WHEN 96		THEN POWER(2,6)
							WHEN 101	THEN POWER(2,7)
							WHEN 136	THEN POWER(2,8)
							WHEN 137	THEN POWER(2,9)
							ELSE 0
					END ) AS licenses,
				SUM(CASE WHEN l.appType < 1000 THEN 1 ELSE 0 END) AS agents
			FROM	licUsage l
			WHERE
				l.optype = 'Install'
				AND l.InstallFlag = 0
				AND l.cid > @i_clientIdStart
				AND l.cid <= @i_clientIdEnd
			GROUP BY l.Cid
		INSERT INTO #LicenseConsumed
			SELECT DISTINCT
				lu.CId clientId,
				1 agentLicenseConsumed
			FROM LicUsage lu
				INNER JOIN SimLicApptypeV2 sl ON
					sl.id = lu.LicType
					AND lu.OpType = 'Install'
					AND lu.InstallFlag = 0
					AND lu.LicType < 16777216
					AND lu.LicType NOT IN (10, 26, 71)
					AND lu.CId > @i_clientIdStart
					AND lu.CId <= @i_clientIdEnd
		INSERT INTO #ClientOps
			SELECT
				clientId,
				[4]		AS bkpEnabled,
				[5]		AS rstEnabled,
				ISNULL([57], 1)	AS CIEnabled
			FROM
				(
					SELECT DISTINCT
						ja.clientId,
						ja.optype,
						ja.action
					FROM JMJobAction ja
					WHERE
						ja.appType = 0
						AND ja.mediaAgentId = 1
						AND ja.clientId > @i_clientIdStart
						AND ja.clientId <= @i_clientIdEnd
				) AS clients
				PIVOT	(MAX(action) FOR optype IN ([4], [5], [57])	) AS P
		INSERT INTO #ClientRelease
			SELECT
				LH.CId clientId,
				MIN(LH.releaseID)
			FROM LicUsageHistory LH
			WHERE
				LH.LicType NOT IN (71,10,26)
				AND LH.CId > @i_clientIdStart
				AND LH.CId <= @i_clientIdEnd
			GROUP BY CId
--		INSERT INTO #ClientHdw
--			SELECT
--				q.clientId,
--				CASE
--					WHEN q.hwPos IS NOT NULL AND q.hwPos > 0 THEN SUBSTRING(q.osInfo, q.osInfoLen - q.hwPos + 1, hwPos + 1)
--					ELSE
--						CASE
--							WHEN q.osName = N'DATA ONTAP' THEN N'Network Appliance'
--							WHEN q.osName = N'Celerra' THEN N'EMC Celerra'
--							ELSE q.osName
--						END
--				END hwName
--			FROM (
--					SELECT
--						c.id clientId,
--						os.name osName,
--						cp.attrVal osInfo,
--						LEN(cp.attrVal) osInfoLen,
--						(CHARINDEX('-:', REVERSE(cp.attrVal))-1) hwPos
--					FROM APP_Client c
--						INNER JOIN simOperatingSystem os ON
--							os.id = c.simOperatingSystemId
--							AND c.id > @i_clientIdStart
--							AND c.id <= @i_clientIdEnd
--						INNER JOIN APP_ClientProp cp ON		-- AEB: should be LEFT OUTER JOIN but this is how dbo.GetClientHardwareName() function works
--							cp.componentNameId = c.id
--							AND cp.attrname = N'Sim OS Info'
--							AND cp.modified = 0
--					WHERE
--						c.id > 1
--				) q
		INSERT INTO #ObjectServers
			SELECT DISTINCT
				oc.id clientId
			FROM APP_Client oc
				INNER JOIN App_ClientProp CP ON
						(oc.status & 4194304) = 4194304   --CV_STATUS_OBJECT_SERVER = 0x400000
						AND CP.componentNameId = oc.id
						AND CP.attrName = N'Object Server Member Servers List'
						AND CP.modified = 0
						AND oc.id > @i_clientIdStart
						AND oc.id <= @i_clientIdEnd
				INNER JOIN APP_Client C ON
						ISNUMERIC(CP.attrVal) = 1
						AND CAST(C.id AS NVARCHAR(10)) = CP.attrVal
				INNER JOIN simInstalledPackages SIP ON
						SIP.ClientId = C.id
			WHERE
				(
						C.releaseId = 16
						AND SIP.HighestSP >= 7
				)
				OR C.releaseId > 16
				--get all index server non duplicate  pseudoclients
				;WITH CTE AS
				(
					SELECT ROW_NUMBER() OVER (PARTITION BY pseudoClientId Order BY cloudId DESC) AS RowNumber,
					pseudoClientId, status
					FROM DM2Cloud tbl
WHERE pseudoClientId > 0 AND cloudType IN (1, 5, 9, 6)
				)
				INSERT INTO #indexServers (clientId, status)
				SELECT pseudoClientId, status  FROM CTE WHERE RowNumber = 1
				--ctree index server will have status =1
				INSERT INTO #indexServers (clientId, status)
				SELECT DISTINCT S.clientId, 1  FROM APP_Application S (NOLOCK)
				JOIN APP_InstanceProp I (NOLOCK) ON I.componentNameId = S.instance
				LEFT JOIN #indexServers tIS (NOLOCK) ON S.ClientId = tIS.clientId
WHERE I.attrname =  'Distributed Cluster Type'
						AND I.modified = 0
AND CAST (I.attrVal AS INT) = 7
						AND tIS.clientId IS NULL
				--List of clients which are currently getting uninstalled. Shouldn't be a huge table
				INSERT INTO #RetireInProgressClientListTbl
				SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
				INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
					AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
					AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
	END
------------------------------------------CACHE TABLE BEGINS HERE----------------------------------------------------------------------------------
	IF (@disableCTClientProperties = 0)
	BEGIN
		-- Use Change Tracking Client Properties implemented in V11 SP12
		IF (@i_clientGroupId <> 0)
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort],[r_cvdPort], [r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString ,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					cpt.clientAppType,
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM	APP_Client c
					INNER JOIN APP_ClientGroupAssoc CG ON
						c. id = CG.clientId
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					CG.clientGroupId = @i_clientGroupId
					AND c.id > @i_clientIdStart
					AND c.id <= @i_clientIdEnd
		END
		ELSE IF (@i_clientId <> 0)
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort], [r_cvdPort],[r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString ,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					cpt.clientAppType,
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM	APP_Client c
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					c.id = @i_clientId
		END
		ELSE IF ( @i_getCommNetClients <> 0 )
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name],[r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort],[r_cvdPort], [r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString ,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					cpt.clientAppType,
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM APP_Client c
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE 	@i_includeHiddenClients > 0 OR (c.id IN ( SELECT clientId FROM APP_IDAName where appTypeId = 121 )) -- 121 IS COMMNET SERVER
		END
		ELSE
		BEGIN
			-- Default Client List Selection
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort], [r_cvdPort],[r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					cpt.clientAppType,
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM
					APP_Client c
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					c.id > @i_clientIdStart
					AND c.id <= @i_clientIdEnd
					AND (
						@i_includeHiddenClients > 0
						OR (c.specialClientFlags & 0x1 <> 0x1)
					)
		END
		-- Update client properties that are dirty by checking Change Tracking
		DECLARE @lastSyncVersion	BIGINT
		DECLARE @lastSyncTime		INT
		-- Get last time change tracking was sync'd to the CT_ClientProperties table
		SELECT
			@lastSyncVersion = ca.syncVersion,
			@lastSyncTime = ca.syncTime
		FROM CT_CacheAssociations ca WITH(NOLOCK)
		WHERE
			ca.cacheTable = 'CT_ClientProperties'
		IF OBJECT_ID('tempdb.dbo.#UpdatedClients') IS NOT NULL
			DROP TABLE #UpdatedClients
		CREATE TABLE #UpdatedClients (
			clientId		INT PRIMARY KEY
		)
		-- Capture all Clients that have had client properties changed since the last sync
		INSERT INTO #UpdatedClients
			SELECT
				ct.componentNameId clientId
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
			WHERE ct.SYS_CHANGE_OPERATION = 'D'
			UNION
			SELECT
				ct.componentNameId clientId
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					cp.id = ct.id
					AND ct.SYS_CHANGE_OPERATION <> 'D'
				INNER JOIN CT_CachePropertyAssociations cpa ON
cpa.tableType = 1
					AND cpa.propertyName = cp.attrName
			UNION
			SELECT
				c.id
			FROM APP_Client c WITH(NOLOCK)
				LEFT OUTER JOIN CT_ClientProperties cp WITH(NOLOCK) ON
					c.id = cp.clientId
					AND c.id > 1
			WHERE
				cp.clientId IS NULL		-- new client row but missing cached property row, mark client as dirty
		DECLARE @UpdateClientRows	INT = @@ROWCOUNT
		IF  (@UpdateClientRows > 0)
		BEGIN
   		-- change to print only for debugging as it caused parsing issue for csv output for report
			IF @debug > 0
   		BEGIN
				PRINT 'GetClientListAndIntialProps: ChangeTracking Client Properties Update Processing due to cached properties out-of-date for some clients.'
			END
			DECLARE @comma		TINYINT = 0
			DECLARE @nl			NVARCHAR(3) = NCHAR(13) + NCHAR(10)
			DECLARE @pivotVars	NVARCHAR(MAX) = @nl
			DECLARE @attrNames	NVARCHAR(MAX) = @nl
			DECLARE @colNames	NVARCHAR(MAX) = @nl
			DECLARE @sqlCmd		NVARCHAR(MAX) = ''
			-- Generate PIVOT Query to get data for dirty client properties that need to be updated
			SELECT
				@attrNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '''' + propertyName + '''' + @nl,
				@pivotVars += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '[' + propertyName + ']' + @nl,
				@colNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + columnName + @nl,
				@comma = 1
			FROM CT_CachePropertyAssociations cpa
WHERE cpa.tableType = 1
			AND EXISTS(SELECT 1 FROM TempDB.INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_NAME = cpa.columnName and TABLE_NAME like '#clientPropTbl_gclaip%')
			-- Generate the Client Properties INSERT PIVOT Command
			DECLARE @pivotCmd		NVARCHAR(MAX) = @nl + '
				INSERT INTO #clientPropTbl_gclaip (clientId, ' + @colNames + ' )
					SELECT
						clientId,' + @pivotVars + '
					FROM (
							SELECT
								c.clientId,
								cp.attrName,
								cp.attrVal
							FROM #UpdatedClients c
								LEFT OUTER JOIN App_ClientProp cp ON
									c.clientId = cp.componentNameId
									AND cp.modified = 0
									AND cp.attrName IN ( ' + @attrNames + ' )
						) AS clients
					PIVOT ( MAX(attrVal) FOR attrName IN ( ' + @pivotVars + ' ) ) AS P' + @nl
			-- Execute command to populate the CT_ClientProperties cache table
			SET @pivotCmd += ' WHERE clientId > 1' + @nl
			EXEC(@pivotCmd)
			-- Update the Client List with the updated client properties for the dirty clients
			UPDATE ctl
				SET [r_deleted] = cpt.deleted,
					[r_priority] = 	ISNULL(cpt.priority, -1),
					[r_CIEngine] = 	cpt.CIEngine,
					[r_encryption] = ISNULL(cpt.encryptionSettings, 0),
					[r_rsaPubKey] = cpt.rsaPubKey,
					[r_rsaPriKeySF] = cpt.rsaPriKeySF,
					[r_virtualClient] = cpt.virtualClient,
					[r_isLicensed] = cpt.isLicensed,
					[r_physClientId] = 	cpt.physClientId,
					[r_DCinstalled] = 	cpt.DCinstalled,
					[r_contentIndexingEnabled] = cpt.contentIndexingEnabled,
					[r_snapBackupsEnabled] = cpt.snapBackupsEnabled,
					[r_hotSpotEnabled] = cpt.hotSpotEnabled,
					[r_OSInfo] = cpt.OSInfo,
					[r_collectDelegateInfo] = cpt.collectDelegateInfo,
					[r_donotSingleInstance] = cpt.donotSingleInstance,
					[r_noPhysMachPresent] = cpt.noPhysMachPresent,
					[r_proxyFSClientId] = cpt.proxyFSClientId,
					[r_miniSRM] = cpt.miniSRM,
					[r_virtualDiscovered] = cpt.virtualServerDiscovered,
					[r_outlookAddin] = cpt.outlookAddin,
					[r_clientVersion] = cpt.clientVersion,
					[r_virtualEntityFlags] = cpt.virtualEntityFlags,
					[r_SPVersionInfo] = cpt.SPVersionInfo,
					[r_SPVersionAndPatchInfo] = cpt.SPVersionAndPatchInfo,
					[r_dataSecurityEnabled] = cpt.ControlHashString,
					[r_sharePointFarmClient] = cpt.sharePointFarmClient,
					[r_isIndexingV2] = cpt.isIndexingV2,
					[r_isQsnapInstalled] = 	cpt.isQsnapInstalled,
					[r_isDescriptionInHTMLFormat] = cpt.isDescriptionInHTMLFormat,
					[r_refCopyClientType] = cpt.refCopyClientType,
					[r_clusterType] = cpt.clusterType,
					[r_isIndexingV2NAS] = cpt.isIndexingV2NAS,
					[r_is1TouchClient] = cpt.is1TouchClient,
					[r_OSName] = cpt.osName,
					[r_hwName] = cpt.hwName,
					[r_clientType] = 	CASE
											WHEN r_clientType = 34 THEN (	 -- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
												CASE
													WHEN cpt.isOffice365Client = 1 THEN 37
													WHEN cpt.isAzureADClient = 1 THEN 38
													WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
													WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
													WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
													WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
													-- ELSE leave unchanged
												END
											)
											WHEN cpt.isOffice365Client = 1 THEN 37
											WHEN cpt.isAzureADClient = 1 THEN 38
											WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
											WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
											WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
											WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
											--WHEN objSrvr.clientId IS NOT NULL THEN 34  -- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
											ELSE 0
										END,
					[r_nasOSType] = cpt.nasOSType,
					[r_nasCapabilities] = cpt.nasCapabilities,
					[r_clientAppType] = cpt.clientAppType,
					[r_isIndexingV2VSA] = cpt.isIndexingV2VSA,
					[r_indexingV2EnabledMask] = cpt.indexingV2EnabledMask
			FROM #ClientListTbl ctl
				INNER JOIN #clientPropTbl_gclaip cpt ON
					cpt.clientId = ctl.r_id
		END
	END
	------------------------------------------CACHE TABLE ENDS HERE ----------------------------------------------------------------------------------
	ELSE
	BEGIN
		-- get client list
		IF (@i_clientGroupId <> 0)
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			-- Slows down small client list retrievals (by 500 ms with large number of clients 23,000) but drastically improves large client list retrievals.
			INSERT INTO #clientPropTbl_gclaip
				(clientId, deleted, priority, CIEngine, encryption, rsaPubKey, rsaPriKeySF, virtualClient, islicensed,
				physClientId, DCinstalled, contentIndexingEnabled, snapBackupsEnabled, hotSpotEnabled, OSInfo, collectDelegateInfo,
				donotSingleInstance, noPhysMachPresent, proxyFSClientId, miniSRM, virtualServerDiscovered, outlookAddin, clientVersion,
				virtualEntityFlags, SPVersionInfo, SPVersionAndPatchInfo, ControlHashString, sharePointFarmClient, isIndexingV2,
				isQsnapInstalled, isDescriptionInHTMLFormat, refCopyClientType, encryptionSettings, isExchangeOnePass, isDistributedApp,
				isExchange, clusterType, isIndexingV2NAS, is1TouchClient, osName, hwName, nasOSType, nasCapabilities, clientAppType, isDBThinClient, isIndexingV2VSA, indexingV2EnabledMask, isOffice365Client, isAzureADClient)
				SELECT	componentNameId					AS clientId,
					[platformdeleted 4]				AS deleted,
					ISNULL([JMPriority], -1)					AS priority,
					[Content Indexing Engine]			AS CIEngine,
					[Encrypt: encryption]				AS encryption,
					[Encrypt: rsaPubKey]				AS rsaPubKey,
					[Encrypt: rsaPriKeySF]				AS rsaPriKeySF,
					[Virtual client]				AS virtualClient,
					[Licensed Client]				AS islicensed,
					[Active Physical Node]				AS physClientId,
					[Data Classification Installed on Client]	AS DCinstalled,
					[Content Indexing Enabled]			AS contentIndexingEnabled,
					[Snap Backups Enabled]				AS snapBackupsEnabled,
					[HotSpot]					AS hotSpotEnabled,
					[Sim OS Info]					AS OSInfo,
					[Collect Delegate Information]	AS collectDelegateInfo,
					[Do not Single Instance Email Messages]		AS donotSingleInstance,
					[NoPhysicalMachinePresent]		AS noPhysMachPresent,
					[Proxy Filesystem Client Id]			AS proxyFSClientId,
					[Mini SRM Agent]	AS miniSRM,
					[Virtual Server Discovered Clients]	AS virtualServerDiscovered,
					[Outlook Addin Client]	AS outlookAddin,
					[Client Version] AS clientVersion,
					[Virtual Entity Flags] AS virtualEntityFlags,
					[SP Version Info]	AS SPVersionInfo,
					[SP Version And Patch Info]	AS SPVersionAndPatchInfo,
					-- Reading from the encrypted attribute name
					[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807]  AS ControlHashString,
					[SharePoint Farm Client] AS sharePointFarmClient,
					[IndexingV2]	AS isIndexingV2,
					[Qsnap installed] AS isQsnapInstalled,
					[Is Client Description in HTML Format] AS isDescriptionInHTMLFormat,
					[ReferenceCopyClientType] AS refCopyClientType,
					[Encryption Settings] AS encryptionSettings,
					[Exchange OnePass Client] AS isExchangeOnePass,
					[Distributed iDA Client] AS isDistributedApp,
					[Exchange Pseudo Client] AS isExchange,
					[Index Server Type]		AS clusterType,
					[IndexingV2_NAS]	AS isIndexingV2NAS,
					[1-Touch Client] AS is1TouchClient,
					[Operating System Name] as osName,
					[Hardware Info] as hwName,
					[NAS OS Type] as nasOSType,
					[NAS Capabilities] as nasCapabilities,
					[Client App Type] as clientAppType,
					[DB Thin Client] as isDBThinClient,
					[IndexingV2_VSA] AS isIndexingV2VSA,
					[IndexingV2_EnabledMask] AS indexingV2EnabledMask,
					[Office 365 Pseudo Client] as isOffice365Client,
					[Azure AD Pseudo Client] as isAzureADClient
				FROM (
				-- selecting from CV_PROP_ENABLE_DATA_SECURITY attribute name instead of Enable Data Security
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							APP_Client c
							INNER JOIN APP_ClientGroupAssoc CG ON
								c. id = CG.clientId
							LEFT OUTER JOIN App_ClientProp cp ON
								c.id = cp.componentNameId
								AND cp.modified = 0
								AND attrName IN (	'platformdeleted 4', 'JMPriority', 'Content Indexing Engine',
										'Encrypt: encryption', 'Encrypt: rsaPubKey', 'Encrypt: rsaPriKeySF',
										'Virtual client', 'Licensed Client', 'Active Physical Node',
										'Data Classification Installed on Client', 'Content Indexing Enabled', 'Snap Backups Enabled',
										'HotSpot', 'Sim OS Info', 'Collect Delegate Information', 'Do not Single Instance Email Messages', 'NoPhysicalMachinePresent',
										'Proxy Filesystem Client Id', 'Mini SRM Agent', 'Virtual Server Discovered Clients','Outlook Addin Client','Client Version', 'Virtual Entity Flags',
'SP Version Info', 'SP Version And Patch Info','7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807','SharePoint Farm Client', 'IndexingV2', 'Qsnap installed', 'Is Client Description in HTML Format',
										'ReferenceCopyClientType','Encryption Settings','Exchang OnePass Client','Distributed iDA Client','Exchange Pseudo Client','Index Server Type', 'IndexingV2_NAS', '1-Touch Client',
										'Operating System Name', 'Hardware Info', 'NAS OS Type', 'NAS Capabilities', 'Client App Type', 'DB Thin Client', 'IndexingV2_VSA', 'IndexingV2_EnabledMask', 'Office 365 Pseudo Client', 'Azure AD Pseudo Client'
								)
						WHERE
							CG.clientGroupId = @i_clientGroupId
							AND c.id > @i_clientIdStart
							AND c.id <= @i_clientIdEnd
					) AS clients
					-- Reading from the encrypted attribute name
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4], [JMPriority], [Content Indexing Engine],
										[Encrypt: encryption], [Encrypt: rsaPubKey], [Encrypt: rsaPriKeySF],
										[Virtual client], [Licensed Client], [Active Physical Node],
										[Data Classification Installed on Client], [Content Indexing Enabled], [Snap Backups Enabled],
										[HotSpot], [Sim OS Info], [Collect Delegate Information], [Do not Single Instance Email Messages], [NoPhysicalMachinePresent],
										[Proxy Filesystem Client Id], [Mini SRM Agent], [Virtual Server Discovered Clients],[Outlook Addin Client],[Client Version], [Virtual Entity Flags],
										[SP Version Info], [SP Version And Patch Info],[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],[SharePoint Farm Client], [IndexingV2], [Qsnap installed], [Is Client Description in HTML Format],
										[ReferenceCopyClientType],[Encryption Settings],[Exchange OnePass Client],[Distributed iDA Client],[Exchange Pseudo Client], [Index Server Type], [IndexingV2_NAS], [1-Touch Client],
										[Operating System Name], [Hardware Info], [NAS OS Type], [NAS Capabilities], [Client App Type],[DB Thin Client],[IndexingV2_VSA], [IndexingV2_EnabledMask], [Office 365 Pseudo Client], [Azure AD Pseudo Client]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort],[r_cvdPort], [r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				-- 09/20/2017 AEB Performance changes
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					-- 09/20/2017 AEB Performance changes
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					--ISNULL(cos.osName, '') [r_OSName],
					--ISNULL(ch.name, '') [r_hwName],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN cpt.isDBThinClient = 1 THEN 35 --App::ClientType_DB_THIN_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					ISNULL(cpt.clientAppType,0) [r_clientAppType],
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM	APP_Client c
					INNER JOIN APP_ClientGroupAssoc CG ON
						c. id = CG.clientId
					-- 09/20/2017 AEB Performance changes
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					--LEFT OUTER JOIN #ClientHdw ch ON
					--	ch.clientId = c.id
					--LEFT OUTER JOIN ClientOSNameView cos ON
					--	cos.clientId = c.id
					LEFT OUTER JOIN #clientPropTbl_gclaip cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					CG.clientGroupId = @i_clientGroupId
					AND c.id > @i_clientIdStart
					AND c.id <= @i_clientIdEnd
		END
		ELSE IF (@i_clientId <> 0)
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			INSERT INTO #clientPropTbl_gclaip
				(clientId, deleted, priority, CIEngine, encryption, rsaPubKey, rsaPriKeySF, virtualClient, islicensed,
				physClientId, DCinstalled, contentIndexingEnabled, snapBackupsEnabled, hotSpotEnabled, OSInfo, collectDelegateInfo,
				donotSingleInstance, noPhysMachPresent, proxyFSClientId, miniSRM, virtualServerDiscovered, outlookAddin, clientVersion,
				virtualEntityFlags, SPVersionInfo, SPVersionAndPatchInfo, ControlHashString, sharePointFarmClient, isIndexingV2,
				isQsnapInstalled, isDescriptionInHTMLFormat, refCopyClientType, encryptionSettings, isExchangeOnePass, isDistributedApp,
				isExchange, clusterType, isIndexingV2NAS, is1TouchClient, osName, hwName, nasOSType, nasCapabilities, clientAppType,isDBThinClient, isIndexingV2VSA, indexingV2EnabledMask, isOffice365Client, isAzureADClient )
				SELECT	componentNameId					AS clientId,
					[platformdeleted 4]				AS deleted,
					ISNULL([JMPriority], -1)					AS priority,
					[Content Indexing Engine]			AS CIEngine,
					[Encrypt: encryption]				AS encryption,
					[Encrypt: rsaPubKey]				AS rsaPubKey,
					[Encrypt: rsaPriKeySF]				AS rsaPriKeySF,
					[Virtual client]				AS virtualClient,
					[Licensed Client]				AS islicensed,
					[Active Physical Node]				AS physClientId,
					[Data Classification Installed on Client]	AS DCinstalled,
					[Content Indexing Enabled]			AS contentIndexingEnabled,
					[Snap Backups Enabled]				AS snapBackupsEnabled,
					[HotSpot]					AS hotSpotEnabled,
					[Sim OS Info]					AS OSInfo,
					[Collect Delegate Information]	AS collectDelegateInfo,
					[Do not Single Instance Email Messages]		AS donotSingleInstance,
					[NoPhysicalMachinePresent]		AS noPhysMachPresent,
					[Proxy Filesystem Client Id]			AS proxyFSClientId,
					[Mini SRM Agent]	AS miniSRM,
					[Virtual Server Discovered Clients]	AS virtualServerDiscovered,
					[Outlook Addin Client]	AS outlookAddin,
					[Client Version] AS clientVersion,
					[Virtual Entity Flags] AS virtualEntityFlags,
					[SP Version Info]	AS SPVersionInfo,
					[SP Version And Patch Info]	AS SPVersionAndPatchInfo,
					-- Reading from the encrypted column name
					[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807]  AS ControlHashString,
					[SharePoint Farm Client] AS sharePointFarmClient,
					[IndexingV2]	AS isIndexingV2,
					[Qsnap installed] AS isQsnapInstalled,
					[Is Client Description in HTML Format] AS isDescriptionInHTMLFormat,
					[ReferenceCopyClientType] AS refCopyClientType,
					[Encryption Settings] AS encryptionSettings,
					[Exchange OnePass Client] AS isExchangeOnePass,
					[Distributed iDA Client] AS isDistributedApp,
					[Exchange Pseudo Client] AS isExchange,
					[Index Server Type]		AS clusterType,
					[IndexingV2_NAS]	AS isIndexingV2NAS,
					[1-Touch Client] AS is1TouchClient,
					[Operating System Name] as osName,
					[Hardware Info] as hwName,
					[NAS OS Type] as nasOSType,
					[NAS Capabilities] as nasCapabilities,
					[Client App Type] as clientAppType,
					[DB Thin Client] as isDBThinClient,
					[IndexingV2_VSA] AS isIndexingV2VSA,
					[IndexingV2_EnabledMask] AS indexingV2EnabledMask,
					[Office 365 Pseudo Client] as isOffice365Client,
					[Azure AD Pseudo Client] as isAzureADClient
				FROM (
				-- selecting from CV_PROP_ENABLE_DATA_SECURITY attribute name instead of Enable Data Security
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp
						WHERE
							cp.componentNameId = @i_clientId
							AND cp.modified = 0
							AND attrName IN (	'platformdeleted 4', 'JMPriority', 'Content Indexing Engine',
									'Encrypt: encryption', 'Encrypt: rsaPubKey', 'Encrypt: rsaPriKeySF',
									'Virtual client', 'Licensed Client', 'Active Physical Node',
									'Data Classification Installed on Client', 'Content Indexing Enabled', 'Snap Backups Enabled',
									'HotSpot', 'Sim OS Info', 'Collect Delegate Information', 'Do not Single Instance Email Messages', 'NoPhysicalMachinePresent',
									'Proxy Filesystem Client Id', 'Mini SRM Agent', 'Virtual Server Discovered Clients','Outlook Addin Client','Client Version', 'Virtual Entity Flags',
'SP Version Info', 'SP Version And Patch Info','7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807','SharePoint Farm Client', 'IndexingV2', 'Qsnap installed', 'Is Client Description in HTML Format',
									'ReferenceCopyClientType','Encryption Settings','Exchange OnePass Client', 'Distributed iDA Client','Exchange Pseudo Client','Index Server Type', 'IndexingV2_NAS', '1-Touch Client',
									'Operating System Name', 'Hardware Info', 'NAS OS Type', 'NAS Capabilities', 'Client App Type', 'DB Thin Client','IndexingV2_VSA', 'IndexingV2_EnabledMask', 'Office 365 Pseudo Client', 'Azure AD Pseudo Client'
								)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4], [JMPriority], [Content Indexing Engine],
										[Encrypt: encryption], [Encrypt: rsaPubKey], [Encrypt: rsaPriKeySF],
										[Virtual client], [Licensed Client], [Active Physical Node],
										[Data Classification Installed on Client], [Content Indexing Enabled], [Snap Backups Enabled],
										[HotSpot], [Sim OS Info], [Collect Delegate Information], [Do not Single Instance Email Messages], [NoPhysicalMachinePresent],
										[Proxy Filesystem Client Id], [Mini SRM Agent], [Virtual Server Discovered Clients],[Outlook Addin Client],[Client Version], [Virtual Entity Flags],
										[SP Version Info], [SP Version And Patch Info],[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],[SharePoint Farm Client], [IndexingV2], [Qsnap installed], [Is Client Description in HTML Format],
										[ReferenceCopyClientType],[Encryption Settings],[Exchange OnePass Client],[Distributed iDA Client],[Exchange Pseudo Client], [Index Server Type], [IndexingV2_NAS], [1-Touch Client],
										[Operating System Name], [Hardware Info], [NAS OS Type], [NAS Capabilities], [Client App Type], [DB Thin Client],[IndexingV2_VSA],[IndexingV2_EnabledMask],  [Office 365 Pseudo Client], [Azure AD Pseudo Client]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort], [r_cvdPort],[r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				-- 09/20/2017 AEB Performance changes
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					-- 09/20/2017 AEB Performance changes
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					--ISNULL(cos.osName, '') [r_OSName],
					--ISNULL(ch.name, '') [r_hwName],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
					ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					ISNULL(cpt.clientAppType, 0) [r_clientAppType],
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM	APP_Client c
					-- 09/20/2017 AEB Performance changes
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					--LEFT OUTER JOIN #ClientHdw ch ON
					--	ch.clientId = c.id
					--LEFT OUTER JOIN ClientOSNameView cos ON
					--	cos.clientId = c.id
					LEFT OUTER JOIN #clientPropTbl_gclaip cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					c.id = @i_clientId
		END
		ELSE IF ( @i_getCommNetClients <> 0 )
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			INSERT INTO #clientPropTbl_gclaip
				(clientId, deleted, priority, CIEngine, encryption, rsaPubKey, rsaPriKeySF, virtualClient, islicensed,
				physClientId, DCinstalled, contentIndexingEnabled, snapBackupsEnabled, hotSpotEnabled, OSInfo, collectDelegateInfo,
				donotSingleInstance, noPhysMachPresent, proxyFSClientId, miniSRM, virtualServerDiscovered, outlookAddin, clientVersion,
				virtualEntityFlags, SPVersionInfo, SPVersionAndPatchInfo, ControlHashString, sharePointFarmClient, isIndexingV2,
				isQsnapInstalled, isDescriptionInHTMLFormat, refCopyClientType, encryptionSettings, isExchangeOnePass, isDistributedApp,
				isExchange, clusterType, isIndexingV2NAS, is1TouchClient, osName, hwName, nasOSType, nasCapabilities, clientAppType, isDBThinClient, isIndexingV2VSA, indexingV2EnabledMask, isOffice365Client, isAzureADClient )
				SELECT	componentNameId					AS clientId,
					[platformdeleted 4]				AS deleted,
					ISNULL([JMPriority], -1)					AS priority,
					[Content Indexing Engine]			AS CIEngine,
					[Encrypt: encryption]				AS encryption,
					[Encrypt: rsaPubKey]				AS rsaPubKey,
					[Encrypt: rsaPriKeySF]				AS rsaPriKeySF,
					[Virtual client]				AS virtualClient,
					[Licensed Client]				AS islicensed,
					[Active Physical Node]				AS physClientId,
					[Data Classification Installed on Client]	AS DCinstalled,
					[Content Indexing Enabled]			AS contentIndexingEnabled,
					[Snap Backups Enabled]				AS snapBackupsEnabled,
					[HotSpot]					AS hotSpotEnabled,
					[Sim OS Info]					AS OSInfo,
					[Collect Delegate Information]	AS collectDelegateInfo,
					[Do not Single Instance Email Messages]		AS donotSingleInstance,
					[NoPhysicalMachinePresent]		AS noPhysMachPresent,
					[Proxy Filesystem Client Id]			AS proxyFSClientId,
					[Mini SRM Agent]	AS miniSRM,
					[Virtual Server Discovered Clients]	AS virtualServerDiscovered,
					[Outlook Addin Client]	AS outlookAddin,
					[Client Version] AS clientVersion,
					[Virtual Entity Flags] AS virtualEntityFlags,
					[SP Version Info]	AS SPVersionInfo,
					[SP Version And Patch Info]	AS SPVersionAndPatchInfo,
					-- Reading from the encrypted attribute name
					[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807]  AS ControlHashString,
					[SharePoint Farm Client] AS sharePointFarmClient,
					[IndexingV2]	AS isIndexingV2,
					[Qsnap installed] AS isQsnapInstalled,
					[Is Client Description in HTML Format] AS isDescriptionInHTMLFormat,
					[ReferenceCopyClientType] AS refCopyClientType,
					[Encryption Settings] AS encryptionSettings,
					[Exchange OnePass Client] AS isExchangeOnePass,
					[Distributed iDA Client] AS isDistributedApp,
					[Exchange Pseudo Client] AS isExchange,
					[Index Server Type]		AS clusterType,
					[IndexingV2_NAS]	AS isIndexingV2NAS,
					[1-Touch Client] AS is1TouchClient,
					[Operating System Name] as osName,
					[Hardware Info] as hwName,
					[NAS OS Type] as nasOSType,
					[NAS Capabilities] as nasCapabilities,
					[Client App Type] as clientAppType,
					[DB Thin Client] as isDBThinClient,
					[IndexingV2_VSA] AS isIndexingV2VSA,
					[IndexingV2_EnabledMask] AS indexingV2EnabledMask,
					[Office 365 Pseudo Client] as isOffice365Client,
					[Azure AD Pseudo Client] as isAzureADClient
				FROM (
				-- selecting from CV_PROP_ENABLE_DATA_SECURITY attribute name instead of Enable Data Security
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp
						WHERE
							(
								@i_includeHiddenClients > 0
								OR (cp.componentNameId IN (SELECT clientId FROM APP_IDAName where appTypeId = 121))
							)
							AND cp.modified = 0
							AND attrName IN (	'platformdeleted 4', 'JMPriority', 'Content Indexing Engine',
									'Encrypt: encryption', 'Encrypt: rsaPubKey', 'Encrypt: rsaPriKeySF',
									'Virtual client', 'Licensed Client', 'Active Physical Node',
									'Data Classification Installed on Client', 'Content Indexing Enabled', 'Snap Backups Enabled',
									'HotSpot', 'Sim OS Info', 'Collect Delegate Information', 'Do not Single Instance Email Messages', 'NoPhysicalMachinePresent',
									'Proxy Filesystem Client Id', 'Mini SRM Agent', 'Virtual Server Discovered Clients','Outlook Addin Client','Client Version', 'Virtual Entity Flags',
'SP Version Info', 'SP Version And Patch Info','7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807','SharePoint Farm Client', 'IndexingV2', 'Qsnap installed', 'Is Client Description in HTML Format',
									'ReferenceCopyClientType','Encryption Settings','Exchange OnePass Client','Distributed iDA Client','Exchange Pseudo Client','Index Server Type', 'IndexingV2_NAS', '1-Touch Client',
									'Operating System Name', 'Hardware Info', 'NAS OS Type', 'NAS Capabilities', 'Client App Type', 'DB Thin Client', 'IndexingV2_VSA', 'IndexingV2_EnabledMask', 'Office 365 Pseudo Client', 'Azure AD Pseudo Client'
							)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4], [JMPriority], [Content Indexing Engine],
										[Encrypt: encryption], [Encrypt: rsaPubKey], [Encrypt: rsaPriKeySF],
										[Virtual client], [Licensed Client], [Active Physical Node],
										[Data Classification Installed on Client], [Content Indexing Enabled], [Snap Backups Enabled],
										[HotSpot], [Sim OS Info], [Collect Delegate Information], [Do not Single Instance Email Messages], [NoPhysicalMachinePresent],
										[Proxy Filesystem Client Id], [Mini SRM Agent], [Virtual Server Discovered Clients],[Outlook Addin Client],[Client Version], [Virtual Entity Flags],
										[SP Version Info], [SP Version And Patch Info],[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],[SharePoint Farm Client], [IndexingV2], [Qsnap installed], [Is Client Description in HTML Format],
										[ReferenceCopyClientType],[Encryption Settings],[Exchange OnePass Client], [Distributed iDA Client],[Exchange Pseudo Client], [Index Server Type], [IndexingV2_NAS], [1-Touch Client],
										[Operating System Name], [Hardware Info], [NAS OS Type], [NAS Capabilities], [Client App Type], [DB Thin Client],[IndexingV2_VSA], [IndexingV2_EnabledMask], [Office 365 Pseudo Client], [Azure AD Pseudo Client]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name],[r_displayName], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort],[r_cvdPort], [r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				-- 09/20/2017 AEB Performance changes
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					-- 09/20/2017 AEB Performance changes
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					--ISNULL(cos.osName, '') [r_OSName],
					--ISNULL(ch.name, '') [r_hwName],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled],
					ISNULL(cpt.clientAppType, 0) [r_clientAppType],
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM APP_Client c
					-- 09/20/2017 AEB Performance changes
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					--LEFT OUTER JOIN #ClientHdw ch ON
					--	ch.clientId = c.id
					--LEFT OUTER JOIN ClientOSNameView cos ON
					--	cos.clientId = c.id
					LEFT OUTER JOIN #clientPropTbl_gclaip cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE 	@i_includeHiddenClients > 0 OR (c.id IN ( SELECT clientId FROM APP_IDAName where appTypeId = 121 )) -- 121 IS COMMNET SERVER
		END
		ELSE
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			-- Slows down small client list retrievals (by 500 ms with large number of clients 23,000) but drastically improves large client list retrievals.
			INSERT INTO #clientPropTbl_gclaip
				(clientId, deleted, priority, CIEngine, encryption, rsaPubKey, rsaPriKeySF, virtualClient, islicensed,
				physClientId, DCinstalled, contentIndexingEnabled, snapBackupsEnabled, hotSpotEnabled, OSInfo, collectDelegateInfo,
				donotSingleInstance, noPhysMachPresent, proxyFSClientId, miniSRM, virtualServerDiscovered, outlookAddin, clientVersion,
				virtualEntityFlags, SPVersionInfo, SPVersionAndPatchInfo, ControlHashString, sharePointFarmClient, isIndexingV2,
				isQsnapInstalled, isDescriptionInHTMLFormat, refCopyClientType, encryptionSettings, isExchangeOnePass, isDistributedApp,
				isExchange, clusterType, isIndexingV2NAS, is1TouchClient, osName, hwName, nasOSType, nasCapabilities, clientAppType,isDBThinClient,isIndexingV2VSA,indexingV2EnabledMask, isOffice365Client, isAzureADClient )
				SELECT	componentNameId					AS clientId,
					[platformdeleted 4]				AS deleted,
					ISNULL([JMPriority], -1)					AS priority,
					[Content Indexing Engine]			AS CIEngine,
					[Encrypt: encryption]				AS encryption,
					[Encrypt: rsaPubKey]				AS rsaPubKey,
					[Encrypt: rsaPriKeySF]				AS rsaPriKeySF,
					[Virtual client]				AS virtualClient,
					[Licensed Client]				AS islicensed,
					[Active Physical Node]				AS physClientId,
					[Data Classification Installed on Client]	AS DCinstalled,
					[Content Indexing Enabled]			AS contentIndexingEnabled,
					[Snap Backups Enabled]				AS snapBackupsEnabled,
					[HotSpot]					AS hotSpotEnabled,
					[Sim OS Info]					AS OSInfo,
					[Collect Delegate Information]	AS collectDelegateInfo,
					[Do not Single Instance Email Messages]		AS donotSingleInstance,
					[NoPhysicalMachinePresent]		AS noPhysMachPresent,
					[Proxy Filesystem Client Id]			AS proxyFSClientId,
					[Mini SRM Agent]	AS miniSRM,
					[Virtual Server Discovered Clients]	AS virtualServerDiscovered,
					[Outlook Addin Client]	AS outlookAddin,
					[Client Version] AS clientVersion,
					[Virtual Entity Flags] AS virtualEntityFlags,
					[SP Version Info]	AS SPVersionInfo,
					[SP Version And Patch Info]	AS SPVersionAndPatchInfo,
					-- Reading from the encrypted attribute name
					[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807]  AS ControlHashString,
					[SharePoint Farm Client] AS sharePointFarmClient,
					[IndexingV2]	AS isIndexingV2,
					[Qsnap installed] AS isQsnapInstalled,
					[Is Client Description in HTML Format] AS isDescriptionInHTMLFormat,
					[ReferenceCopyClientType] AS refCopyClientType,
					[Encryption Settings] AS encryptionSettings,
					[Exchange OnePass Client] AS isExchangeOnePass,
					[Distributed iDA Client] AS isDistributedApp,
					[Exchange Pseudo Client] AS isExchange,
					[Index Server Type]		AS clusterType,
					[IndexingV2_NAS]	AS isIndexingV2NAS,
					[1-Touch Client] AS is1TouchClient,
					[Operating System Name] as osName,
					[Hardware Info] as hwName,
					[NAS OS Type] as nasOSType,
					[NAS Capabilities] as nasCapabilities,
					[Client App Type] as clientAppType,
					[DB Thin Client] as isDBThinClient,
					[IndexingV2_VSA] AS isIndexingV2VSA,
					[IndexingV2_EnabledMask] AS indexingV2EnabledMask,
					[Office 365 Pseudo Client] as isOffice365Client,
					[Azure AD Pseudo Client] as isAzureADClient
				FROM (
				-- selecting from CV_PROP_ENABLE_DATA_SECURITY attribute name instead of Enable Data Security
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp
						WHERE
							cp.componentNameId > @i_clientIdStart
							AND cp.componentNameId <= @i_clientIdEnd
							AND cp.modified = 0
							AND attrName IN (	'platformdeleted 4', 'JMPriority', 'Content Indexing Engine',
									'Encrypt: encryption', 'Encrypt: rsaPubKey', 'Encrypt: rsaPriKeySF',
									'Virtual client', 'Licensed Client', 'Active Physical Node',
									'Data Classification Installed on Client', 'Content Indexing Enabled', 'Snap Backups Enabled',
									'HotSpot', 'Sim OS Info', 'Collect Delegate Information', 'Do not Single Instance Email Messages', 'NoPhysicalMachinePresent',
									'Proxy Filesystem Client Id', 'Mini SRM Agent', 'Virtual Server Discovered Clients','Outlook Addin Client','Client Version', 'Virtual Entity Flags',
'SP Version Info', 'SP Version And Patch Info','7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807','SharePoint Farm Client', 'IndexingV2', 'Qsnap installed', 'Is Client Description in HTML Format',
									'ReferenceCopyClientType','Encryption Settings','Exchange OnePass Client', 'Distributed iDA Client','Exchange Pseudo Client','Index Server Type', 'IndexingV2_NAS', '1-Touch Client',
									'Operating System Name', 'Hardware Info', 'NAS OS Type', 'NAS Capabilities', 'Client App Type', 'DB Thin Client','IndexingV2_VSA', 'IndexingV2_EnabledMask',
 'Office 365 Pseudo Client', 'Azure AD Pseudo Client'
							)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4], [JMPriority], [Content Indexing Engine],
										[Encrypt: encryption], [Encrypt: rsaPubKey], [Encrypt: rsaPriKeySF],
										[Virtual client], [Licensed Client], [Active Physical Node],
										[Data Classification Installed on Client], [Content Indexing Enabled], [Snap Backups Enabled],
										[HotSpot], [Sim OS Info], [Collect Delegate Information], [Do not Single Instance Email Messages], [NoPhysicalMachinePresent],
										[Proxy Filesystem Client Id], [Mini SRM Agent], [Virtual Server Discovered Clients],[Outlook Addin Client],[Client Version], [Virtual Entity Flags],
										[SP Version Info], [SP Version And Patch Info],[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],[SharePoint Farm Client], [IndexingV2], [Qsnap installed], [Is Client Description in HTML Format],
										[ReferenceCopyClientType],[Encryption Settings],[Exchange OnePass Client], [Distributed iDA Client],[Exchange Pseudo Client], [Index Server Type], [IndexingV2_NAS], [1-Touch Client],
										[Operating System Name], [Hardware Info], [NAS OS Type], [NAS Capabilities], [Client App Type], [DB Thin Client],[IndexingV2_VSA],[IndexingV2_EnabledMask],  [Office 365 Pseudo Client], [Azure AD Pseudo Client]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_evmgrcPort], [r_cvdPort],[r_ccpId],[r_specialStatusFlags],
				-- client properties
				[r_deleted],
				[r_priority],
				[r_CIEngine],
				[r_encryption],
				[r_rsaPubKey],
				[r_rsaPriKeySF],
				[r_virtualClient],
				[r_isLicensed],
				[r_physClientId],
				[r_DCinstalled],
				[r_contentIndexingEnabled],
				[r_snapBackupsEnabled],
				[r_hotSpotEnabled],
				[r_OSInfo],
				[r_collectDelegateInfo],
				[r_donotSingleInstance],
				[r_noPhysMachPresent],
				[r_proxyFSClientId],
				[r_miniSRM],
				[r_virtualDiscovered],
				[r_outlookAddin],
				[r_clientVersion],
				[r_virtualEntityFlags],
				[r_SPVersionInfo],
				[r_SPVersionAndPatchInfo],
				[r_dataSecurityEnabled],
				[r_sharePointFarmClient],
				[r_isIndexingV2],
				[r_isQsnapInstalled],
				[r_isDescriptionInHTMLFormat],
				[r_refCopyClientType],
				[r_clusterType],
				-- access rights
				[tr_canSchedule],
				[tr_canClientGroup],
				[tr_canSubclientPolicy],
				[tr_canPseudoClientCreate],
				[tr_canAdmin],
				[tr_canLogMonitor],
				[tr_canAlert],
				[tr_canReport],
				[r_isIndexingV2NAS],
				[r_is1TouchClient],
				[r_clientGuid],
				-- 09/20/2017 AEB Performance changes
				[r_ArchiverEnabled],
				[r_cloudStatus],
				[r_isWebServerInstalled],
				[r_isVirtualServerPresent],
				[r_isCommServer],
				[r_isRemoteCacheEnabled],
				[r_isAgentLicenseConsumed],
				[r_EDCDiscovered],
				[r_snapBackupsMAInstalled],
				[r_licenses],
				[r_commNetClientCount],
				[r_bkpEnabled],
				[r_rstEnabled],
				[r_CIActivityEnabled],
				[r_releasedIDWhenClientWasInstalled],
				[r_OSName],
				[r_hwName],
				[r_clientType],
				[r_nasOSType],
				[r_nasCapabilities],
				[r_isExchangePackageInstalled],
				[r_clientAppType],
				[r_isIndexingV2VSA],
				[r_agentList],
				[r_indexingV2EnabledMask]
			)
				SELECT	c.id, c.name, ISNULL(NULLIF(c.displayname, ''), c.name), c.simOperatingSystemId, c.net_hostname, c.clientDescription, c.status, c.releaseId, c.evmgrcPort,c.cvdPort, c.ccpId, c.specialClientFlags,
					-- client properties
					cpt.deleted,
					cpt.priority,
					cpt.CIEngine,
					ISNULL(cpt.encryptionSettings, 0),
					cpt.rsaPubKey,
					cpt.rsaPriKeySF,
					cpt.virtualClient,
					cpt.isLicensed,
					cpt.physClientId,
					cpt.DCinstalled,
					cpt.contentIndexingEnabled,
					cpt.snapBackupsEnabled,
					cpt.hotSpotEnabled,
					cpt.OSInfo,
					cpt.collectDelegateInfo,
					cpt.donotSingleInstance,
					cpt.noPhysMachPresent,
					cpt.proxyFSClientId,
					cpt.miniSRM,
					cpt.virtualServerDiscovered,
					cpt.outlookAddin,
					cpt.clientVersion,
					cpt.virtualEntityFlags,
					cpt.SPVersionInfo,
					cpt.SPVersionAndPatchInfo,
					cpt.ControlHashString,
					cpt.sharePointFarmClient,
					cpt.isIndexingV2,
					cpt.isQsnapInstalled,
					cpt.isDescriptionInHTMLFormat,
					cpt.refCopyClientType,
					cpt.clusterType,
					-- access rights
					@initCanSchedule,
					@initCanClientGroup,
					@initCanSubclientPolicy,
					@initCanPseudoClientCreate,
					@initCanAdmin,
					@initCanLogMonitor,
					@initCanAlert,
					@initCanReport,
					cpt.isIndexingV2NAS,
					cpt.is1TouchClient,
					c.guid,
					-- 09/20/2017 AEB Performance changes
					CASE
						WHEN ae.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_ArchiverEnabled],
					ISNULL(cloud.status, 0) [r_cloudStatus],
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 2) > 0 THEN 1 ELSE 0 END), 0) r_isWebServerInstalled,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 1) > 0 THEN 1 ELSE 0 END), 0) [r_isVirtualServerPresent],
					isCS.platformType [r_isCommServer],
					ISNULL(remCache.isEnabled, 0) r_isRemoteCacheEnabled,
					ISNULL(alc.agentLicenseConsumed, 0) [r_isAgentLicenseConsumed],
					CASE
						WHEN cga.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_EDCDiscovered],
					CASE
						WHEN snap.clientId IS NOT NULL THEN 1
						ELSE 0
					END [r_snapBackupsMAInstalled],
					ISNULL((l.licenses | (CASE l.agents WHEN 0 THEN 8 ELSE 0 END)), 0) [r_licenses],
					ISNULL(cnCount.cnt, 0) [r_commNetClientCount],
					t.bkpEnabled [r_bkpEnabled],
					t.rstEnabled [r_rstEnabled],
					t.CIEnabled [r_CIActivityEnabled],
					cr.releaseID [r_releasedIDWhenClientWasInstalled],
					--ISNULL(cos.osName, '') [r_OSName],
					--ISNULL(ch.name, '') [r_hwName],
					cpt.osName,
					cpt.hwName,
					CASE
						WHEN cpt.isOffice365Client = 1 THEN 37
						WHEN cpt.isAzureADClient = 1 THEN 38
						WHEN cpt.isExchangeOnePass = 1 THEN 25 --EXCHANGE_ONEPASS
						WHEN cpt.isDistributedApp = 1 THEN 29 --App::ClientType_DISTRIBUTED_IDA
						WHEN cpt.isExchange = 1 THEN 31 --App::ClientType_EXHANGE_CLIENT
						WHEN cpt.isDBThinClient = 1 THEN 35 -- App::DB_THIN_CLIENT
						WHEN objSrvr.clientId IS NOT NULL THEN 34		-- App::ClientType_OBJECT_SERVER_EDGE_COMPATIBLE
						ELSE 0
					END [r_clientType],
					cpt.nasOSType,
					cpt.nasCapabilities,
					ISNULL((CASE WHEN (pkgTypes.pkgBit & 128) > 0 THEN 1 ELSE 0 END), 0) [r_isExchangePackageInstalled]	,
					ISNULL(cpt.clientAppType, 0) [r_clientAppType],
					cpt.isIndexingV2VSA,
					ISNULL( agents.agent, ''),
					cpt.indexingV2EnabledMask
				FROM
					APP_Client c
					-- 09/20/2017 AEB Performance changes
					INNER JOIN #Platforms isCS ON
						isCS.clientId = c.id
					LEFT OUTER JOIN #ObjectServers objSrvr ON
						objSrvr.clientId = c.id
					--LEFT OUTER JOIN #ClientHdw ch ON
					--	ch.clientId = c.id
					--LEFT OUTER JOIN ClientOSNameView cos ON
					--	cos.clientId = c.id
					LEFT OUTER JOIN #clientPropTbl_gclaip cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN #PkgTypes pkgTypes ON
						pkgTypes.clientId = c.id
					LEFT OUTER JOIN  #indexServers cloud ON
					   cloud.clientId = c.id
					LEFT OUTER JOIN (
						SELECT DISTINCT
							an.clientId
						FROM APP_IDAProp ip
							INNER JOIN APP_IDAName an ON
								an.id = ip.componentNameId
						WHERE
							ip.attrName='Enable Archive'
							AND ip.modified=0
							AND ip.attrVal='1'
					) ae ON
						ae.clientId = c.id
					LEFT OUTER JOIN (
							SELECT
								P.clientId,
								P.isEnabled
							FROM PatchUpdateAgentInfo P
							WHERE
								P.isDeleted <> 1
								AND P.clientId <> 2
							UNION ALL
							SELECT
								2,	-- CommServ is enabled by default
								1
					) remCache ON
						remCache.clientId = c.id
					LEFT OUTER JOIN #LicenseConsumed alc ON
						alc.clientId = c.id
					LEFT OUTER JOIN (
								SELECT DISTINCT CGA.clientId
								FROM
									app_clientgroup CG
									INNER JOIN app_clientGroupAssoc CGA ON
										CG.id = CGA.clientGroupId
								WHERE (CG.flag & 768) > 0 --((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
					) cga ON
						cga.clientId = c.id
					LEFT OUTER JOIN (
								SELECT
									c.id clientId
								FROM
									APP_Client c
									INNER JOIN #Platforms p ON
										p.clientId = c.id
										AND (p.platformType & 2) > 0		-- MA
										AND c.releaseId >= 13
								WHERE
									p.clientId IN (
										SELECT c.id FROM APP_Client c INNER JOIN simOperatingSystem os ON c.simOperatingSystemId = os.id AND os.type <> 'Windows'
										UNION ALL -- performance same with or without ALL
										SELECT clientId FROM simInstalledPackages WHERE simPackageId = 453
									)
					) snap ON
						snap.clientId = c.id
					LEFT OUTER JOIN #Licenses AS l ON
						l.clientId = c.id
					LEFT OUTER JOIN (
						SELECT
							CId clientId,
							COUNT(CId) cnt
						FROM LicUsage
						WHERE
							AppType = 122
							AND LicType = 172
						GROUP BY CId
					) cnCount ON
						cnCount.clientId = c.id
					LEFT OUTER JOIN #ClientOps t ON
						t.clientId = c.id
					LEFT OUTER JOIN #ClientRelease cr ON
						cr.clientId = c.id
					LEFT OUTER JOIN #Agents agents ON
						agents.clientId = c.id
				WHERE
					c.id > @i_clientIdStart
					AND c.id <= @i_clientIdEnd
					AND (
						@i_includeHiddenClients > 0
						OR (c.specialClientFlags & 0x1 <> 0x1)
					)
		END
	END		-- End of ChangeTracking IF
	-- removes clients that were "hard deleted"
	-- Could eliminate these rows during the insertion operation, mostly a no gain of only a few milliseconds
	DELETE ct
	FROM  #ClientListTbl ct
		LEFT OUTER JOIN APP_Platform p WITH(NOLOCK) ON
			p.clientId = ct.r_id
			AND p.platformType = 4
	WHERE
		p.clientId IS NULL
	-- Hide the Active Dummy client in Commcell Console GUI in failover environment.
	DELETE ct
    FROM #ClientListTbl ct
    WHERE ct.r_id IN (SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'Linked CS Client' AND modified = 0)
	-- visibility check
	if (@i_userId <> 0)
	BEGIN
		IF (@i_hideEnabled <> 0)
		BEGIN
			DELETE CL
			FROM #ClientListTbl CL
			WHERE NOT EXISTS (SELECT 1 FROM #getIdaObjectsForUserV2OutputTbl  Temp WHERE Temp.clientID = CL.r_id)
		END
DECLARE @manageApplication INT = POWER(2.0, 2 - 1)
DECLARE @canSchedule AS INT = POWER(2.0, 3  - 1) + POWER(2.0, 12 - 1)
		DECLARE @canClientGroup AS INT = @manageApplication
		DECLARE @canSubclientPolicy AS INT = @manageApplication
		DECLARE @canPseudoClientCreate AS INT = @manageApplication
DECLARE @canAdmin AS INT = POWER(2.0, 1 - 1)
		DECLARE @canLogMonitor1 AS INT = @manageApplication
DECLARE @canLogMonitor2 AS INT = POWER(2.0, 1-1)
DECLARE @canAlert AS INT = POWER(2.0, 18 - 1)
DECLARE @canReport AS INT = POWER(2.0, 15 - 1)
		DECLARE @canLogMonitor AS INT = @canLogMonitor1 + @canLogMonitor2
		-- assign individual client access rights
		-- 09/20/2017 AEB Performance changes
		UPDATE Client
			SET Client.tr_canschedule = CASE WHEN (@canSchedule & Rights.capabilities = @canSchedule) THEN 1 END,
				Client.tr_canClientGroup = CASE WHEN (@canClientGroup & Rights.capabilities > 0) THEN 1 END,
				Client.tr_canPseudoClientCreate = CASE WHEN (@canPseudoClientCreate & Rights.capabilities > 0) THEN 1 END,
				Client.tr_canSubclientPolicy = CASE WHEN (@canSubclientPolicy & Rights.capabilities > 0) THEN 1 END,
				Client.tr_canAdmin = CASE WHEN (@canAdmin & Rights.capabilities > 0) THEN 1 END,
				Client.tr_canLogMonitor = CASE WHEN (@canLogMonitor & Rights.capabilities <> 0) THEN 1 END,			-- Either agent management / admin management is enough for logMonitor
				Client.tr_canAlert = CASE WHEN (@canAlert & Rights.capabilities > 0) THEN 1 END,
				Client.tr_canReport = CASE WHEN (@canReport & Rights.capabilities > 0) THEN 1 END
		FROM #getIdaObjectsForUserV2OutputTbl  Rights
			INNER JOIN #ClientListTbl Client ON
				Rights.clientId = Client.r_id
				AND Rights.capabilities > 0
	END
	-- 09/20/2017 AEB Performance changes
	-- Now make passes over data to update what could not be done during the initial insert operation
	UPDATE #ClientListTbl
		SET [r_physClientId] = (SELECT attrVal FROM app_clientprop WHERE componentNameId = r_id AND attrName = N'CS Active Physical Node' )
	WHERE
		r_id = 2		-- Commserver
		AND r_virtualClient = 1
	IF (@disableCTClientProperties = 0)
	BEGIN
		UPDATE ct
		SET [r_SPVersionInfo] = cp.SPVersionInfo,
			[r_SPVersionAndPatchInfo] = cp.SPVersionAndPatchInfo
		FROM #ClientListTbl ct
			LEFT OUTER JOIN CT_ClientProperties cp ON
				cp.clientId = ct.r_physClientId
		WHERE
			ct.r_virtualClient = 1
	END
	ELSE
	BEGIN
		UPDATE ct
		SET [r_SPVersionInfo] = cp.SPVersionInfo,
			[r_SPVersionAndPatchInfo] = cp.SPVersionAndPatchInfo
		FROM #ClientListTbl ct
			LEFT OUTER JOIN #clientPropTbl_gclaip cp ON
				cp.clientId = ct.r_physClientId
		WHERE
			ct.r_virtualClient = 1
	END
	-- 09/20/2017 AEB Major Performance changes in this UPDATE operation with missing operations moved to the INSERT Operation above
	UPDATE ct
		SET	[r_clientFlag] = [r_clientFlag] | f.ciengine | f.hotspot | f.cntIdx | f.pkg | f.ndmp,
			[r_status] = f.status,
			--[r_updateStatus] = dbo.simGetBaseline(ISNULL(bl.baseline, 8)),
[r_updateStatus] = CASE	WHEN bl.baseline IS NULL THEN 8
						WHEN bl.baseline < 0 THEN bl.baseline
WHEN (bl.baseline & 0x2000) > 0 THEN 4
WHEN (bl.baseline & 0x1000) > 0 THEN 2
						ELSE bl.baseline END,
			[r_isAdvancedFSPackageInstalled] = CASE
										   WHEN pkgTypes2.pkgBit IS NULL THEN ISNULL((CASE WHEN (pkgTypes.pkgBit & 24) > 0 THEN 1 ELSE 0 END), 0)
										   WHEN (pkgTypes2.pkgBit & 24) > 0 THEN 1
										   ELSE 0
										END,
			[r_physClientName]		= phyName.name,
			[r_proxyFSClientName]	= proxyName.name,
			[r_isFileShareArchiverClientPackageInstalled] =	ISNULL((CASE WHEN (pkgTypes2.pkgBit & 4) > 0 THEN 1 ELSE 0 END), ISNULL((CASE WHEN (pkgTypes.pkgBit & 4) > 0 THEN 1 ELSE 0 END), 0))
	FROM #ClientListTbl ct
		LEFT OUTER JOIN #PkgTypes pkgTypes ON
			pkgTypes.clientId = ct.r_id
		LEFT OUTER JOIN #PkgTypes pkgTypes2 ON
			ct.r_physClientId IS NOT NULL
			AND ct.r_physClientId > 1
			AND pkgTypes2.clientId = ct.r_physClientId
		INNER JOIN (
				SELECT
					r_id cid,
					CASE WHEN [r_CIEngine] IS NOT NULL THEN 16 ELSE 0 END ciengine,
					CASE WHEN [r_hotSpotEnabled] IS NOT NULL AND [r_hotSpotEnabled] > 0 THEN 64 ELSE 0 END hotspot,
					CASE WHEN [r_contentIndexingEnabled] IS NOT NULL AND [r_contentIndexingEnabled] > 0 THEN 128 ELSE 0 END cntIdx,
					CASE
						WHEN p.simPackageID IS NULL THEN 0
						WHEN p.simPackageID = 1401 THEN 256
						WHEN p.simPackageID = 255 THEN 512
						ELSE 0
					END pkg,
					CASE WHEN m.ClientId IS NOT NULL THEN (1024 | m.OSType) ELSE 0 END ndmp,
					CASE WHEN [r_ccpID] <> 0 THEN ([r_status] + 262144) ELSE [r_status] END status
				FROM #ClientListTbl
					LEFT OUTER JOIN simInstalledPackages p ON
						p.simPackageID IN (1401, 255)
						AND (
								([r_virtualClient] = 1 AND [r_physClientId] = p.ClientId)
								OR ([r_virtualClient] <> 1 AND [r_id] = p.ClientId)
							)
					LEFT OUTER JOIN MMNDMPHostInfo m ON
						m.ClientId = r_id
		) f ON
			f.cid = ct.r_id
		LEFT OUTER JOIN APP_Client phyName ON
			phyName.id = ct.r_physClientId
		LEFT OUTER JOIN APP_Client proxyName ON
			proxyName.id = ct.r_proxyFSClientId
		LEFT OUTER JOIN (
			select
				q.r_id id,
				q.r_physClientId physClientId,
				q.r_virtualClient virtualClient,
				sum(q.Baseline) baseline
			from (
				select
					[r_id],
					[r_physClientId],
					r_virtualClient,
					p.Baseline
				from
					simInstalledPackages p, #ClientListTbl ct
				where
					p.simPackageID NOT BETWEEN 6000 AND 7000
					and r_virtualClient = 1
					and p.clientId in ([r_id], [r_physClientId])
				union
				select
					[r_id],
					[r_physClientId],
					r_virtualClient,
					p.Baseline
				from
					simInstalledPackages p, #ClientListTbl ct
				where
					p.simPackageID NOT BETWEEN 6000 AND 7000
					and r_virtualClient <> 1
					and p.clientId = [r_id]
				) q
			group by
				q.r_id,
				q.r_physClientId,
				q.r_virtualClient
		) bl ON
			bl.id = ct.r_id
	--For the 9.0 and lesser release clients 'Has Diag' will take the precedence than 'Needs Update'.
	--For the 10.0 and above release clients 'Needs Update' will take the precedence than 'Has Diag'.
	UPDATE	#ClientListTbl
		SET	[r_updateStatus] = (case
									WHEN r_releaseId < 15 THEN (
											(case
												WHEN [r_updateStatus] < 0							THEN 7	-- Pending
												WHEN ([r_updateStatus] & 8) > 0 						THEN 8	-- N/A
												WHEN ([r_updateStatus] & 16) > 0 						THEN 16	-- Diag
												WHEN ([r_updateStatus] & 2) > 0 						THEN 2	-- Behind
												WHEN EXISTS (select * from simInstalledPackages where clientId=[r_id] and Baseline=0)	THEN 0	-- Unknown
												WHEN ([r_updateStatus] & 4) > 0 						THEN 4	-- Ahead
												WHEN ([r_updateStatus] & 1) > 0 						THEN 1	-- Uptodate
												ELSE 0
											end)
									)
									ELSE (
											(case
												WHEN [r_updateStatus] < 0							THEN 7	-- Pending
												WHEN ([r_updateStatus] & 8) > 0 						THEN 8	-- N/A
												WHEN ([r_updateStatus] & 2) > 0 						THEN 2	-- Behind
												WHEN ([r_updateStatus] & 16) > 0 						THEN 16	-- Diag
												WHEN EXISTS (select * from simInstalledPackages where clientId=[r_id] and Baseline=0)	THEN 0	-- Unknown
												WHEN ([r_updateStatus] & 4) > 0 						THEN 4	-- Ahead
												WHEN ([r_updateStatus] & 1) > 0 						THEN 1	-- Uptodate
												ELSE 0
											end)
									)
								end)
	-- Delete the physical machines on the cluster CS
	DELETE FROM #ClientListTbl WHERE [r_id] IN (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap WHERE APP_VMToPMMap.VMClientId = 2)
	--Update retireClientPhase for clients which are currently getting uninstalled
	UPDATE #ClientListTbl
	SET [r_retireClientPhase] = 1
	WHERE [r_id] IN (SELECT retireClientId FROM #RetireInProgressClientListTbl)
	-- 09/20/2017 AEB Performance changes
	--*******************************************************************************************************************************************************************************
	--***** NOTE: DO NOT add output columns with no column names!  Example: "ISNULL([r_snapBackupsEnabled], 0)" should be "ISNULL([r_snapBackupsEnabled], 0) r_snapBackupsEnabled"
	--*******************************************************************************************************************************************************************************
	-- 09/20/2017 AEB Performance changes for comparing outputted result set with the original results set in another table
	--IF object_id('Aaron_GetClientListProps_Bld') IS NOT NULL
	--	DROP TABLE Aaron_GetClientListProps_Bld
	-- return client list
	SELECT
		[r_id],
		[r_name],
		[r_displayName],
		[r_desc],
		[r_netHostName],
		[r_OSId],
		[r_OSName],
		[r_hwId],
		[r_hwName],
		[r_licenses],
		[r_bkpEnabled],
		[r_rstEnabled],
		[r_deleted],
		[r_priority],
		[r_clientFlag],
		[r_isCommServer],
		ISNULL([r_encryption], 2) [r_encryption],
		[r_rsaPubKey],
		[r_rsaPriKeySF],
		[r_releaseId],
		[r_status],
		[r_virtualClient],
		[r_isLicensed],
		[r_physClientId],
		[r_physClientName],
		[r_DCinstalled],
		ISNULL([r_contentIndexingEnabled], 0)[r_contentIndexingEnabled],
		[r_CIActivityEnabled],
		[r_updateStatus],
		ISNULL([r_snapBackupsEnabled], 0) [r_snapBackupsEnabled],
		ISNULL([r_snapBackupsMAInstalled], 0) [r_snapBackupsMAInstalled],
		ISNULL([r_collectDelegateInfo], 0) [r_collectDelegateInfo],
		ISNULL([r_donotSingleInstance], 0) [r_donotSingleInstance],
		ISNULL([r_noPhysMachPresent], -1) [r_noPhysMachPresent],
		ISNULL([r_proxyFSClientId], 0) [r_proxyFSClientId],
		[r_proxyFSClientName],
		[r_evmgrcPort],
		[r_miniSRM],
		[r_virtualDiscovered],
		[r_EDCDiscovered],
		[r_specialStatusFlags],
		ISNULL([r_outlookAddin], 0) [r_outlookAddin],
		[r_commNetClientCount],
		[r_clientVersion],
		[r_releasedIDWhenClientWasInstalled],
		[r_ArchiverEnabled],
		[r_virtualEntityFlags],
		[r_isAdvancedFSPackageInstalled],
		[r_isRemoteCacheEnabled],
		[r_isWebServerInstalled],
		[r_cvdPort],
		-- output should remain same hence converting the encrypted values to 0 and 1 respectively
		case [r_dataSecurityEnabled]
when 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' then 1
		else 0
		end as r_dataSecurityEnabled,
		[r_sharePointFarmClient],
		ISNULL([tr_canSchedule], 0) [tr_canSchedule],
		ISNULL([tr_canClientGroup], 0) [tr_canClientGroup],
		ISNULL([tr_canSubclientPolicy], 0) [tr_canSubclientPolicy],
		ISNULL([tr_canPseudoClientCreate], 0) [tr_canPseudoClientCreate],
		ISNULL([tr_canAdmin], 0) [tr_canAdmin],
		ISNULL([tr_canLogMonitor], 0) [tr_canLogMonitor],
		ISNULL([tr_canAlert], 0) [tr_canAlert],
		ISNULL([tr_canReport], 0) [tr_canReport],
		[r_SPVersionInfo],
		[r_SPVersionAndPatchInfo],
		[r_isIndexingV2],
		[r_isQsnapInstalled],
		[r_isDescriptionInHTMLFormat],
		ISNULL([r_refCopyClientType], 0) [r_refCopyClientType],
		[r_isFileShareArchiverClientPackageInstalled],
		[r_isAgentLicenseConsumed],
		[r_clientType],
		ISNULL([r_clusterType], 0) [r_clusterType],
		[r_isIndexingV2NAS],
		[r_isVirtualServerPresent],
		ISNULL([r_is1TouchClient], 0) [r_is1TouchClient],
		ISNULL([r_clientGuid], '') [r_clientGuid],
		ISNULL([r_cloudStatus], 0) [r_cloudStatus],
		ISNULL([r_nasOSType], 0) [r_nasOSType],
		ISNULL([r_nasCapabilities], 0) [r_nasCapabilities],
		ISNULL([r_isExchangePackageInstalled], 0) [r_isExchangePackageInstalled],
		ISNULL([r_clientAppType], 0) [r_clientAppType],
		[r_isIndexingV2VSA],
		[r_retireClientPhase],
		[r_agentList],
		[r_indexingV2EnabledMask]
	-- 09/20/2017 AEB Performance changes for comparing outputted result set with the original results set in another table
	--INTO Aaron_GetClientListProps_Bld
	FROM	#ClientListTbl
	DROP TABLE #ClientListTbl
	DROP TABLE #clientPropTbl_gclaip
	IF OBJECT_ID('tempdb.dbo.#getIdaObjectsForUserV2OutputTbl') IS NOT NULL				-- We need to check because this table is not created when @i_userId = 0
		DROP TABLE #getIdaObjectsForUserV2OutputTbl
	IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL
		DROP TABLE #RetireInProgressClientListTbl
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'getclientlistAndInitialProps')
	delete from GxQscripts where name = 'getclientlistAndInitialProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getclientlistAndInitialProps')
	delete from GXDBVersions where aliasname = 'getclientlistAndInitialProps'
GO

insert into GXDBVersions values(2, 'getclientlistAndInitialProps',  'v1.121.2.64.8.1', 'getclientlistAndInitialProps', 'v1.121.2.64.8.1')
GO

