

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getSchedules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getSchedules.sp,v $ $Id: getSchedules.sp,v 1.22.50.2 2018/03/20 00:35:11 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  getSchedules()
--  |
--  | Description:  Retrieves the Commcell Schedules
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  +========================================================================+
-- Cursor Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getSchedules <<<'

IF EXISTS (select * from sysobjects where name='getSchedules')
	drop procedure getSchedules
IF EXISTS (select * from GxQscripts where name='getSchedules')
	delete from GxQscripts where name = 'getSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getSchedules')
	delete from GXDBVersions where aliasname = 'getSchedules'
GO
print '... Creating Procedure: getSchedules'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getSchedules
-- Cursor Input
  @in_userId integer,
  @in_taskType integer,
  @orderOption char(255),
  @in_localeId integer
-- Following are the "columns" returned, in the order in which they are returned
AS
SET NOCOUNT ON
DECLARE @isBackup		integer
DECLARE @isSRM			integer
DECLARE @isSRMReport	integer
DECLARE @isAdmin		integer
SET @isBackup	 = 0
SET @isSRM		 = 0
SET @isSRMReport = 0
SET @isAdmin	 = 0
if(@in_taskType & 1 = 1)
	SET @isBackup = 1
if(@in_taskType & 16 = 16)
begin
	SET @isSRM = 1
	SET @in_taskType = @in_taskType | 1
end
if(@in_taskType & 4 = 4)
	SET @isAdmin =  1
if(@in_taskType & 32 = 32)
begin
	SET @isSRMReport = 1
	SET @in_taskType = @in_taskType | 4
end
	IF object_id('tempdb.dbo.#ViewSchedule') is not null DROP TABLE #ViewSchedule
   create table  #ViewSchedule
   (
			id				int ,
			taskId			int ,
			taskType		int ,
			type			int ,
			counter			int ,
			errors			int ,
			fireIfMissed	int ,
			canBeDeleted	int ,
			inProcess		int ,
			canBeEdited		int ,
			isReported		int ,
			isSingleton		int ,
			sCount			int ,
			mask			int ,
			monthDay		int ,
			occurence		int ,
			dayNumber		int ,
			atTime			int ,
			interval		int ,
			endValue		int ,
			startTime		int ,
			flags			int ,
			ds_flags		int ,
			tz_offset		int ,
tz_name			varchar(128),
taskDescription	nvarchar(1023),
			nextEvent		DATETIME,
			firstEvent		DATETIME,
			lastEvent		DATETIME,
			lastAttempt		DATETIME,
			schedTemplateInstanceId	int ,
			endOfDay		int ,
			skipOccurence	int ,
			skipDayNumber	int ,
			calendarId		int ,
			backupTaskType	int ,
			clientId		int ,
			appTypeId		int ,
			instanceId		int ,
			backupSetId		int ,
			subclientId		int ,
clientName		nvarchar(256),
backupSetName	nvarchar(256),
instanceName	nvarchar(256),
appTypeName		nvarchar(256),
subclientName	nvarchar(256),
commcellName	nvarchar(256),
			preserveOrStripLevel	int ,
			type_h	int ,
			type_l	int ,
			toTime	int ,
			fromTime int ,
			clientGroupId		int ,
clientGroupName 	nvarchar(256),
			alertId		int ,
alertName 	nvarchar(256),
			userId		int ,
userName 	nvarchar(256),
			srmReportTypeId		integer,
srmReportTypeName	nvarchar(256),
			srmReportGroupId	integer,
srmReportGroupName	nvarchar(256),
			jobDescription nvarchar(max)
   )
   IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
   EXEC sec_getUserObjects @in_userId, 0, 0, '#entitiesWithViewSchedCapability'
   -- needed so that we can join on a user with no privilages
   INSERT INTO #entitiesWithViewSchedCapability (capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,
   mediaAgentId,libraryId,archGroupId,vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId)
   VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
INSERT INTO #ViewSchedule
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
        sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
        sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
        sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber, sc.calendarId,
	    bt.type as backupTaskType, bt.clientId as clientId, bt.appTypeId as appTypeId, bt.instance as instanceId,
        bt.backupSet as backupSetId , bt.subClient as subclientId, CL.name as clientName, BSET.name as backupSetName , INST.name  as instanceName,
        APPT.name as appTypeName, APPL.subclientName as subclientName, CCELL.aliasName as commcellName,  0 as preserveOrStripLevel, 0 as type_h, 0 as type_l ,0 as toTime,0 as fromTime,  CAST(BOPTION.VALUE as int) as clientGroupId, CLGRP.name as clientGroupName, bt.alertId , NTR.notificationName, bt.userId, USR.login as userName,
        0 as srmReportTypeId, null as srmReportTypeName, 0 as srmReportGroupId, null as srmReportGroupName, bt.jobDescription jobDescription
FROM    schedule sc
   INNER JOIN SchedBackupTask bt ON sc.id = bt.scheduleId
   INNER JOIN #entitiesWithViewSchedCapability sec ON
   (capabilities = 2816911 OR @in_userId = bt.userId) OR
   (
      (((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) AND
      (
         ((bt.clientId  = sec.clientId  OR (sec.clientId = 0 AND sec.clientGroupId = 0))
         OR
         (bt.clientId = 0 AND sec.clientGroupId = (select value from SchedBackupTaskOptions where name ='ClientGroupId' and bt.id = SchedBackupTaskOptions.backupTaskId)))
         AND  (bt.appTypeId   = sec.appTypeId   OR  bt.appTypeId = 0  OR sec.appTypeId = 0   )
         AND  (bt.instance    = sec.instanceId  OR  bt.instance  = 0  OR sec.instanceId = 0  )
         AND  (bt.backupSet   = sec.backupSetId OR  bt.backupSet = 0  OR sec.backupSetId = 0 )
         AND  (bt.subClient   = sec.subClientId OR  bt.subClient = 0  OR sec.subClientId = 0 )
      )
   )
LEFT OUTER JOIN    APP_Client CL ON bt.clientId = CL.id
LEFT OUTER JOIN    APP_BackupSetName BSET ON bt.backupSet = BSET.id
LEFT OUTER JOIN    APP_InstanceName INST ON bt.instance = INST.id
LEFT OUTER JOIN    APP_iDAType  APPT ON bt.appTypeId = APPT.type
LEFT OUTER JOIN    APP_Application APPL ON APPL.id = bt.subClient
LEFT OUTER JOIN    APP_CommCell CCELL ON 2 = CCELL.id
left outer JOIN    SchedBackupTaskOptions boption on BOPTION.BACKUPTASKID = Bt.ID and boption.NAME = 'ClientGroupId'
left outer JOIN    APP_ClientGroup CLGRP on CLGRP.ID = CAST(BOPTION.VALUE as int)
LEFT OUTER JOIN    ntnotificationrule as NTR ON bt.alertId = NTR.id
LEFT OUTER JOIN    UMUsers as USR ON bt.userid = USR.id
WHERE   sc.type > 0 AND	((sc.tasktype & @in_taskType) <> 0) AND
(((@isBackup = 1) AND (@isSRM = 1)) OR
((@isBackup = 1) AND NOT (bt.appTypeID >= 600 AND bt.appTypeID <= 654))
OR
((@isSRM =1)   AND	(bt.appTypeID >= 600 AND bt.appTypeID <= 654)))
INSERT INTO #ViewSchedule
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
      sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
      sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
      sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber,sc.calendarId,
	0 as backupTaskType, rt.sourceclientId , rt.appTypeId as appTypeId, rt.instanceId  as instanceId,
        rt.backupSetId as backupSetId, 0  as subclientId,  CL.name as clientName, BSET.name as backupSetName, INST.name as instanceName,
        APPT.name as appTypeName, null as subclientName, CCELL.aliasName as commcellName, rt.preserveOrStripLevel, rt.type_h , rt.type_l, rt.toTime, rt.fromTime, 0 as clientGroupId, null as clientGroupName, rt.alertId, NTR.notificationName, rt.userId, USR.login as userName,
        0 as srmReportTypeId, null as srmReportTypeName, 0 as srmReportGroupId, null as srmReportGroupName, rt.jobDescription jobDescription
FROM    schedule sc
   INNER JOIN SchedRestoreTask rt ON sc.id = rt.scheduleId
   INNER JOIN #entitiesWithViewSchedCapability sec ON
   (capabilities = 2816911 OR @in_userId = rt.userId) OR
   (
      ( (((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0)) AND
      (
         (rt.sourceClientId  = sec.clientId     OR rt.sourceClientId =0   OR sec.clientId = 0      )
         AND  (rt.appTypeId   = sec.appTypeId   OR  rt.appTypeId  = 0  OR sec.appTypeId = 0     )
         AND  (rt.instanceId  = sec.instanceId  OR  rt.instanceId = 0  OR sec.instanceId = 0    )
         AND  (rt.backupSetId = sec.backupSetId OR  rt.backupSetId = 0  OR sec.backupSetId = 0  )
      )
	) OR EXISTS
	(SELECT * FROM [SchedSearchRestoreXML] where [restoreTaskId] = rt.id  )
LEFT OUTER JOIN    APP_Client as CL ON rt.sourceclientId = CL.id
LEFT OUTER JOIN    APP_BackupSetName as BSET ON rt.backupSetId = BSET.id
LEFT OUTER JOIN    APP_InstanceName as INST ON rt.instanceId = INST.id
LEFT OUTER JOIN    APP_iDAType as APPT ON rt.appTypeId = APPT.type
LEFT OUTER JOIN    APP_CommCell as CCELL ON 2 = CCELL.id
LEFT OUTER JOIN    ntnotificationrule as NTR ON rt.alertId = NTR.id
LEFT OUTER JOIN    UMUsers as USR ON rt.userid = USR.id
WHERE   sc.type > 0 AND ((sc.tasktype & @in_taskType) <> 0)
--GET ADMIN TASKS AND SRM REPORTS
INSERT INTO #ViewSchedule
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
        sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
        sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
        sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber,sc.calendarId,
	0 as backupTaskType, 0 as clientId, 0 as appTypeId , 0 as instanceId,
        0 as backupSetId, 0 as subclientId, null as clientName  , null as backupSetName, null as instanceName,
        null as appTypeName, null as subclientName, null as commcellName, 0 as preserveOrStripLevel, 0 as type_h, 0 type_l ,0 toTime,0 as fromTime, 0 as clientGroupId, null as clientGroupName, at.alertId, NTR.notificationName, at.userId, USR.login as userName,
        '',
        '',
        null as srmReportGroupName, at.jobDescription jobDescription
FROM    schedule sc
   INNER JOIN SchedAdminTask at ON sc.id = at.scheduleId
   INNER JOIN #entitiesWithViewSchedCapability sec ON ((capabilities & 1) <> 0 OR @in_userId = at.userId)
   LEFT OUTER JOIN    ntnotificationrule as NTR ON at.alertId = NTR.id
   LEFT OUTER JOIN    UMUsers as USR ON at.userid = USR.id
WHERE   sc.type > 0 AND ((sc.tasktype & @in_taskType) <> 0) AND
(((@isAdmin = 1) AND (@isSRMReport = 1)) OR
((@isAdmin = 1) AND NOT (at.type =  7356))
OR
((@isSRMReport =1) AND (at.type =  7356)))
and ((at.type < 7700) or (at.type > 7799))
--GET REGULAR REPORTS
INSERT INTO #ViewSchedule
SELECT  distinct sc.id, sc.taskId, sc.taskType, sc.type, sc.counter, sc.errors, sc.fireIfMissed, sc.canBeDeleted, sc.inProcess,
        sc.canBeEdited, sc.isReported, sc.isSingleton, sc.sCount, sc.mask, sc.monthDay, sc.occurence, sc.dayNumber, sc.atTime,
        sc.interval, sc.endValue, sc.startTime, sc.flags, sc.ds_flags, sc.tz_offset, sc.tz_name, sc.taskDescription,
        sc.nextEvent, sc.firstEvent, sc.lastEvent, sc.lastAttempt, sc.schedTemplateInstanceId, sc.endOfDay, sc.skipOccurence, sc.skipDayNumber,sc.calendarId,
	0 as backupTaskType, 0 as clientId, 0 as appTypeId , 0 as instanceId,
        0 as backupSetId, 0 as subclientId, null as clientName  , null as backupSetName, null as instanceName,
        null as appTypeName, null as subclientName, null as commcellName, 0 as preserveOrStripLevel, 0 as type_h, 0 type_l ,0 toTime,0 as fromTime, 0 as clientGroupId, null as clientGroupName, at.alertId, NTR.notificationName, at.userId, USR.login as userName,
        0 as srmReportTypeId, null as srmReportTypeName, 0 as srmReportGroupId, null as srmReportGroupName, at.jobDescription jobDescription
FROM    schedule sc
   INNER JOIN SchedAdminTask at ON sc.id = at.scheduleId
   INNER JOIN #entitiesWithViewSchedCapability sec ON ((capabilities & 16384) <> 0 OR @in_userId = at.userId)
   LEFT OUTER JOIN    ntnotificationrule as NTR ON at.alertId = NTR.id
   LEFT OUTER JOIN    UMUsers as USR ON at.userid = USR.id
WHERE   sc.type > 0 AND ((sc.tasktype & @in_taskType) <> 0) AND
(((@isAdmin = 1) AND (@isSRMReport = 1)) OR
((@isAdmin = 1) AND NOT (at.type =  7356))
OR
((@isSRMReport =1) AND (at.type =  7356)))
and ((at.type >= 7700) AND (at.type <= 7799))
--order by option
DECLARE @sql nvarchar(1024)
set @sql = N'SELECT * from #ViewSchedule ' +  @orderOption
EXEC sp_executesql @sql
  Drop table #entitiesWithViewSchedCapability
  Drop table #ViewSchedule
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getSchedules')
	delete from GxQscripts where name = 'getSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getSchedules')
	delete from GXDBVersions where aliasname = 'getSchedules'
GO

insert into GXDBVersions values(2, 'getSchedules',  '00010022005000020000', 'getSchedules', '00010022005000020000')
GO

