

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getSchedPolicyAssotCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getSchedPolicyAssotCount.sp,v $ $Id: getSchedPolicyAssotCount.sp,v 1.27.50.2 2018/03/20 00:37:05 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: getSchedPolicyAssotCount()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Muath Ali  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getSchedPolicyAssotCount <<<'

IF EXISTS (select * from sysobjects where name='getSchedPolicyAssotCount')
	drop procedure getSchedPolicyAssotCount
IF EXISTS (select * from GxQscripts where name='getSchedPolicyAssotCount')
	delete from GxQscripts where name = 'getSchedPolicyAssotCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getSchedPolicyAssotCount')
	delete from GXDBVersions where aliasname = 'getSchedPolicyAssotCount'
GO
print '... Creating Procedure: getSchedPolicyAssotCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getSchedPolicyAssotCount
  @i_templateId INTEGER
AS
  DECLARE @r_retVal INTEGER;
  DECLARE @r_errorString VARCHAR(1024);
SET NOCOUNT ON
    DECLARE @taskId             INTEGER;
    DECLARE @taskType           INTEGER;
    DECLARE @options            INTEGER;
    DECLARE @clientId           INTEGER;
    DECLARE @appTypeId          INTEGER;
    DECLARE @instanceId         INTEGER;
    DECLARE @backupSetId        INTEGER;
    DECLARE @subClientId        INTEGER;
    DECLARE @archGroupId        INTEGER;
    DECLARE @copyId             INTEGER;
	DECLARE @templateType		INTEGER;
    DECLARE @objId              INTEGER;
    DECLARE @objAppTypeId       INTEGER;
    DECLARE @clientGroupId      INTEGER;
    DECLARE @objName            nvarchar(128);
    DECLARE @status             INTEGER;
	DECLARE @srmRepGroupId		INTEGER;
	DECLARE @srmReportId		INTEGER;
/* get all schedules in the policy, filter out those records used to define the template itself */
DECLARE TemplateSchedules CURSOR LOCAL FORWARD_ONLY FOR
SELECT  S.taskId, S.taskType, S.type, T.type
FROM    schedule S, schedTemplate T
WHERE   S.tasktype <> 8         -- TT_TEMPLATE
AND     (S.flags & 1) = 0       -- EV_SCHED_PENDING_DELETE
AND		T.id
in      ( SELECT schedTemplateId
          FROM   schedTemplateInstance
          WHERE  schedTemplateId = @i_templateId )
AND     S.schedTemplateInstanceId
in      ( SELECT id
          FROM   schedTemplateInstance
          WHERE  schedTemplateId = @i_templateId )
--SELECT  taskId, taskType, type
--FROM    schedule
--WHERE   tasktype <> 8         -- TT_TEMPLATE
--AND     (flags & 1) = 0       -- EV_SCHED_PENDING_DELETE
--AND     schedTemplateInstanceId
--in      ( SELECT id
--          FROM   schedTemplateInstance
--          WHERE  schedTemplateId = @i_templateId )
BEGIN TRANSACTION
    DECLARE @tempObjectCount TABLE  (objId integer)
SET @r_retVal = 0
OPEN TemplateSchedules
FETCH FROM TemplateSchedules INTO @taskId, @taskType, @options, @templateType
WHILE @@FETCH_STATUS = 0
BEGIN
   IF @taskType = 1
   BEGIN /* start processing backup records */
      SELECT @clientId = clientId, @appTypeId = appTypeId, @instanceId = instance, @backupSetId = backupSet, @subClientId = subclient
      FROM SchedBackupTask
      WHERE id = @taskId
      IF @clientId = 0 -- This is a Generic Schedule Policy at the Client Level
         BEGIN
            SELECT @clientGroupId = value
            FROM   SchedBackupTaskOptions
            WHERE  backupTaskId = @taskId and name = 'ClientGroupId'
            DECLARE ClientList CURSOR LOCAL FORWARD_ONLY FOR
            SELECT clientId
	        FROM   APP_ClientGroupAssoc
	        WHERE  clientGroupId = @clientGroupId
            OPEN ClientList
            FETCH FROM ClientList INTO @clientId
            WHILE @@FETCH_STATUS = 0
            BEGIN
	           DECLARE ApplicationsList CURSOR LOCAL FORWARD_ONLY FOR
	           SELECT id, appTypeId
	           FROM   APP_Application
	           WHERE  appTypeId <> 1000 AND clientId = @clientId
	           /* if appTypeId = 0 then include records for all appTypeId */
	           /* Check with appTypeGroup. In case of client group selection apptypeId will be groupId */
	           AND    ( @appTypeId = 0 OR ((select (AppGroup1 % 100000) from APP_iDAType where type = appTypeId) = @appTypeId) )
	           /* if instance = 0 then include records for all instance */
	           AND    ( @instanceId = 0 OR instance = @instanceId )
	           /* if backup set = 0 then include records for all backup sets */
	           AND    ( @backupSetId = 0 OR backupSet = @backupSetId )
	           /* if subclient = 0 then include records for all subclients */
	           AND    ( @subClientId = 0 OR id = @subClientId )
	           AND    (( subclientStatus & 2 ) = 0)   -- CV_STATUS_UNINSTALLED
	           AND    (( subclientStatus & 4 ) = 0)   -- CV_STATUS_DELETED
	           AND    (( subclientStatus & 16 ) = 0)  -- CV_STATUS_DUMMY
	           AND    (( subclientStatus & 32 ) = 0)  -- CV_STATUS_HIDDEN
	           AND    (( subclientStatus & 64 ) = 0)  -- CV_STATUS_CMD_LINE
AND (((appTypeId >= 600 AND appTypeId <= 654) AND (@templateType & 32) = 32)
OR ((appTypeId < 600 OR appTypeId > 654) AND (@templateType & 2) = 2))
               OPEN ApplicationsList
               FETCH FROM ApplicationsList INTO @objId, @objAppTypeId
               WHILE @@FETCH_STATUS = 0
               BEGIN
               INSERT INTO @tempObjectCount values ( @objId )
               FETCH NEXT FROM ApplicationsList INTO @objId, @objAppTypeId
               END
               CLOSE ApplicationsList
               DEALLOCATE ApplicationsList
            FETCH NEXT FROM ClientList INTO @clientId
            END
            CLOSE ClientList
            DEALLOCATE ClientList
         END /* client id = 0 */
      ELSE
         BEGIN /* client id <> 0 */
            DECLARE ApplicationsList CURSOR LOCAL FORWARD_ONLY FOR
            SELECT id, appTypeId, subclientName, subclientStatus
            FROM   APP_Application
            WHERE  appTypeId <> 1000 AND  clientId = @clientId
            /* if appTypeId = 0 then include records for all appTypeId */
            AND    ( @appTypeId = 0 OR appTypeId = @appTypeId )
            /* if instance = 0 then include records for all instance */
            AND    ( @instanceId = 0 OR instance = @instanceId )
            /* if backup set = 0 then include records for all backup sets */
            AND    ( @backupSetId = 0 OR backupSet = @backupSetId )
            /* if subclient = 0 then include records for all subclients */
            AND    ( @subClientId = 0 OR id = @subClientId )
	        AND    (( subclientStatus & 2 ) = 0)   -- CV_STATUS_UNINSTALLED
	        AND    (( subclientStatus & 4 ) = 0)   -- CV_STATUS_DELETED
	        AND    (( subclientStatus & 16 ) = 0)  -- CV_STATUS_DUMMY
	        AND    (( subclientStatus & 32 ) = 0)  -- CV_STATUS_HIDDEN
	        AND    (( subclientStatus & 64 ) = 0)  -- CV_STATUS_CMD_LINE
            OPEN ApplicationsList
            FETCH FROM ApplicationsList INTO @objId, @objAppTypeId, @objName, @status
            WHILE @@FETCH_STATUS = 0
            BEGIN
               -- LOTUSNOTES_DATABASE || UNIX_LOTUSNOTES_DB || LOTUS_DOMINO6_DATABASE UNIX_LOTUSNOTES6_DB
               IF (@objAppTypeId in (6, 51, 59, 77) AND  @subClientId = 0)
               BEGIN
                      -- tran log
                  IF (@options&8192) <> 0  AND (@objName <> 'transaction logs') GOTO MyCONTINUE
                  IF (@options&8192) =  0  AND (@objName  = 'transaction logs') GOTO MyCONTINUE
               END
               -- SQL iDAs
               IF (@objAppTypeId in (4, 16, 70) AND  @subClientId = 0)
               BEGIN
                       -- filegroup                   default
                  IF (@options&268435456) <> 0  AND (@status&8) <> 0 GOTO MyCONTINUE
                       -- none filegroup              not default
                  IF (@options&268435456) =  0  AND (@status&8) = 0  GOTO MyCONTINUE
               END
				-- SRM Data Collection
IF (@objAppTypeId >= 600 AND @objAppTypeId <= 654)
				BEGIN
					IF (@templateType & 32) <> 32 GOTO MyCONTINUE
				END
				ELSE
				-- Data Protection
				BEGIN
					IF (@templateType & 2) <> 2 GOTO MyCONTINUE
				END
               INSERT INTO @tempObjectCount values ( @objId )
               MyCONTINUE:
               FETCH NEXT FROM ApplicationsList INTO @objId, @objAppTypeId, @objName, @status
            END
            CLOSE ApplicationsList
            DEALLOCATE ApplicationsList
         END --  client <> 0
   END -- End processing backup records
   IF @taskType = 4 --  auxcopy schedule
   BEGIN
      SELECT @copyId = data
      FROM   SchedAdminParam
      WHERE  adminTaskId = @taskId
      AND    type = 8015 -- ARCHIVE_GROUP_COPY_ITEM
      IF @copyId <> 0
         BEGIN
            INSERT INTO @tempObjectCount values ( @copyId )
         END
      ELSE
         BEGIN
            SELECT @archGroupId = data
            FROM   SchedAdminParam
            WHERE  admintaskid = @taskId
            AND    type = 2231 -- ARCHIVE_GROUP_ITEM
			IF @archGroupId <> 0
			BEGIN
				INSERT INTO @tempObjectCount
				SELECT archGroupCopy.id
				FROM   archGroupCopy, archGroup
				WHERE  archGroupCopy.archGroupId = @archGroupId
				AND    archGroupCopy.archGroupId = archGroup .id
				AND    archGroupCopy.id <> archGroup.defaultCopy
			END
			ELSE	--SRM Reports
				BEGIN
					SELECT @srmReportId = data
					FROM   SchedAdminParam
					WHERE  admintaskid = @taskId
AND    type = 9288 -- _SRM_REPORT_TYPE_ITEM
					IF @srmReportId <> 0
					BEGIN
						INSERT INTO @tempObjectCount values ( @srmReportId )
					END
					ELSE
					BEGIN
						SELECT @srmRepGroupId = data
						FROM   SchedAdminParam
						WHERE  admintaskid = @taskId
AND    type = 9306 -- _SRM_REPORT_GROUP_ITEM
					END
				END
         END
   END
   FETCH NEXT FROM TemplateSchedules INTO @taskId, @taskType, @options, @templateType
END
/****************************************************************************************/
   SELECT @r_retVal = COUNT (DISTINCT objId) FROM @tempObjectCount
   SET @r_errorString = ''
   CLOSE TemplateSchedules
   DEALLOCATE TemplateSchedules
   ROLLBACK TRANSACTION
   SELECT @r_retVal, @r_errorString
   RETURN
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'getSchedPolicyAssotCount')
	delete from GxQscripts where name = 'getSchedPolicyAssotCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getSchedPolicyAssotCount')
	delete from GXDBVersions where aliasname = 'getSchedPolicyAssotCount'
GO

insert into GXDBVersions values(2, 'getSchedPolicyAssotCount',  '00010027005000020000', 'getSchedPolicyAssotCount', '00010027005000020000')
GO

