

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getPendingEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getPendingEvents.sp,v $ $Id: getPendingEvents.sp,v 1.1.2.9 2020/03/17 20:34:11 vmishra Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Procedure: "getPendingEvents"					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getPendingEvents')
BEGIN
	print '>>> Drop Stored Procedure: getPendingEvents <<<'
	drop procedure getPendingEvents
END
IF EXISTS (select * from GxQscripts where name='getPendingEvents')
	delete from GxQscripts where name = 'getPendingEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getPendingEvents')
	delete from GXDBVersions where aliasname = 'getPendingEvents'
GO
print '... Creating Procedure: getPendingEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getPendingEvents
-- The following lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @inUserId INT,
  @inCCID INT,
  @severityFlag INT,
  @firstEventId INT,
  @lastEventId INT
AS
  DECLARE @id integer
  DECLARE @timeSource integer
  DECLARE @severity integer
  DECLARE @ack integer
  DECLARE @type integer
  DECLARE @jobId_h integer
  DECLARE @jobId_l integer
  DECLARE @messageId integer
  DECLARE @clientID integer
  DECLARE @commCellID integer
  DECLARE @userID integer
  DECLARE @subsystemID integer
  DECLARE @client char(255)
  DECLARE @commCell char(255)
  DECLARE @userName char(255)
  DECLARE @subsystem char(255)
  DECLARE @msgEnglish char(255)
  DECLARE @clientDisplayName nvarchar(255)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	SELECT EM.id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, EM.clientID, commCellID, userID,
    subsystemID, Client, CommCell, userName, subsystem, msgEnglish, CL.displayName
	FROM evMsg EM WITH (NOLOCK)
    INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EM.clientID
	WHERE
((@severityFlag & 1 = 1 AND severity = 0) OR
(@severityFlag & 2 = 2 AND severity = 3) OR
(@severityFlag & 4 = 4 AND severity = 6) OR
(@severityFlag & 8 = 8 AND severity = 9))
	AND (@firstEventId = 0 OR EM.id BETWEEN (@firstEventId + 1) AND @lastEventId)
	AND type <> 2
	and (dbo.isClientVisibleEvents(@inUserId , jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
	and commCellID = @inCCID
	ORDER BY EM.id ASC
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'getPendingEvents')
	delete from GxQscripts where name = 'getPendingEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getPendingEvents')
	delete from GXDBVersions where aliasname = 'getPendingEvents'
GO

insert into GXDBVersions values(2, 'getPendingEvents',  '00010001000200090000', 'getPendingEvents', '00010001000200090000')
GO

