

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getMediaListForAppIdByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getMediaListForAppIdByTime.sp,v $ $Id: getMediaListForAppIdByTime.sp,v 1.48.14.17 2020/07/06 22:15:20 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getMediaListForAppIdByTime')
BEGIN
	print '>>> Drop Stored Procedure: getMediaListForAppIdByTime <<<'
	drop procedure getMediaListForAppIdByTime
END
IF EXISTS (select * from GxQscripts where name='getMediaListForAppIdByTime')
	delete from GxQscripts where name = 'getMediaListForAppIdByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMediaListForAppIdByTime')
	delete from GXDBVersions where aliasname = 'getMediaListForAppIdByTime'
GO
print '... Creating Procedure: getMediaListForAppIdByTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getMediaListForAppIdByTime
  @i_copyPrecedence integer,
  @i_appId integer,
  @i_fromTime integer,
  @i_toTime integer,
  @i_includeAgedData integer,
  @i_baseTempDir varchar(1024) = ''
AS
-- Required because we are going to access OLE DB procs like sp_OACreate.
EXECUTE AS LOGIN = 'sqladmin_cv'
  DECLARE @r_mediaId integer;
  DECLARE @r_uniqueId char(64);
  DECLARE @r_barCode char(64);
  DECLARE @r_mediaTypeId integer;
  DECLARE @r_mediaLocation integer;
  DECLARE @r_exportLocation NVARCHAR(64);
  DECLARE @r_containerId integer;
  DECLARE @r_containerName NVARCHAR(64);
  DECLARE @r_libraryId integer;
  DECLARE @r_libraryName NVARCHAR(64);
  DECLARE @r_subclientId integer;
  DECLARE @r_subclientName NVARCHAR(64);
  DECLARE @r_copyPrecedence integer;
  DECLARE @r_copyId integer;
  DECLARE @r_copyName NVARCHAR(64);
  DECLARE @r_spId integer;
  DECLARE @r_spName NVARCHAR(64);
  DECLARE @r_mediaFlags integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE @l_nextFullTime INT
--DECLARE @l_lastIndexTime INT
DECLARE @l_sql NVARCHAR(2048)
--SET @l_nextFullTime = -1
--SET @l_lastIndexTime = -1
if (@i_toTime <= 0)
	SET @i_toTime = dbo.GetUnixTime(GETUTCDATE())
if object_id('tempdb.dbo.#tempAF') is not null DROP TABLE #tempAF
if object_id('tempdb.dbo.#tempAFC') is not null DROP TABLE #tempAFC
if object_id('tempdb.dbo.#tempVol') is not null DROP TABLE #tempVol
if object_id('tempdb.dbo.#tempMedia') is not null DROP TABLE #tempMedia
CREATE TABLE #tempAF (id INT, commCellId INT, archGroupId INT, fileType INT, cTime INT, backupLevel INT, jobStartDate INT, jobEndDate INT, appId int, isForIndex INT)
CREATE TABLE #tempAFC (archFileId INT, commCellId INT, archCopyId INT, appId int, isForIndex INT)
CREATE TABLE #tempVol (archCopyId INT, VolumeId INT, MediaSideId INT, MediaId INT, CreationTime INT, SIDBStoreId INT, SiloStatus INT, appId int, mediaFlags INT)
DECLARE @l_appTypeId int = 0
DECLARE @l_instanceId int = 0
SELECT @l_appTypeId = appTypeId, @l_instanceId = instance
FROM APP_Application WITH(NOLOCK) WHERE id = @i_appId
DECLARE @tblAppIdList table(appId int)
IF @l_appTypeId IN (22, 80, 37, 61, 103, 62, 135, 3 ) AND @l_instanceId > 1
	INSERT INTO @tblAppIdList
	SELECT id FROM App_Application WITH(NOLOCK) WHERE instance = @l_instanceId
ELSE
	INSERT INTO @tblAppIdList
	SELECT @i_appId
IF @l_appTypeId = 1000
	INSERT INTO #tempAF
	SELECT 	A.id, A.commCellId, A.archGroupId, A.fileType, A.cTime,
			B.ER_BkpLevel, B.servStart, B.servEnd, A.appId, 0
	FROM   	archFile A WITH (READUNCOMMITTED), JMAdminJobStatsTable B WITH (READUNCOMMITTED), @tblAppIdList APP
	WHERE	A.appId = B.appId
		AND B.appId = APP.appId
		AND A.jobId = B.jobId
		AND A.commCellId = B.commCellId
		AND A.isValid = 1
		AND B.opType = 11
		AND B.status IN (1, 3, 14)
ELSE IF @l_appTypeId = 106  /* VIRTUAL_SERVER_IDA */
BEGIN
	if object_id('tempdb.dbo.#tempJobs') is not null DROP TABLE #tempJobs
	CREATE TABLE #tempJobs(JobId int, commCellId int, primary key(JobId, commCellId))
	INSERT INTO #tempJobs
	SELECT DISTINCT jobId, commCellId
	FROM JMBkpStats(NOLOCK) B
	JOIN @tblAppIdList APP ON APP.appId = B.appId
	WHERE B.status IN (1, 3, 14)
	AND (@i_fromTime = 0 OR B.servStartDate >= @i_fromTime)
	AND (@i_toTime = 0 OR B.servEndDate <= @i_toTime)
	INSERT INTO #tempJobs
	SELECT DISTINCT JD.childJobId, JD.commCellId
	FROM JMJobDataLink(NOLOCK) JD
	JOIN #tempJobs J ON J.JobId = JD.parentJobId AND JD.commCellId = J.commCellId
	WHERE JD.parentJobId <> JD.childJobId
AND JD.linkType IN (7, 8)
	INSERT INTO #tempAF
	SELECT	A.id, A.commCellId, A.archGroupId, A.fileType, A.cTime,
			(case when B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) then 1 else B.bkpLevel end),
			B.servStartDate, B.servEndDate, A.appId, 0
	FROM	#tempJobs J, archFile A WITH (READUNCOMMITTED), JMBkpStats B WITH (READUNCOMMITTED)
	WHERE	J.JobId = A.JobId
		AND J.CommCellId = A.CommCellId
		AND A.isValid = 1
		AND J.JobId = B.JobId
		AND J.commCellId = B.commCellId
		AND B.status IN (1, 3, 14)
END
ELSE
	INSERT INTO #tempAF
	SELECT 	A.id, A.commCellId, A.archGroupId, A.fileType, A.cTime,
			(case when B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) then 1 else B.bkpLevel end),
			B.servStartDate, B.servEndDate, A.appId, 0
	FROM   	archFile A WITH (READUNCOMMITTED), JMBkpStats B WITH (READUNCOMMITTED), @tblAppIdList APP
	WHERE	A.appId = B.appId
		AND B.appId = APP.appId
		AND A.jobId = B.jobId
		AND A.commCellId = B.commCellId
		AND A.isValid = 1
		AND B.status IN (1, 3, 14)
-- Index restore uses job's end time to find archive files.
-- Here we should also use job's end time to find archive files.
/*
IF @i_fromTime <= 0
   SELECT @i_fromTime = ISNULL(MAX(jobStartDate), 0) FROM #tempAF WHERE backupLevel = 1 AND jobEndDate < @i_toTime
IF EXISTS (SELECT * FROM #tempAF WHERE fileType = 2)
BEGIN
   SELECT @l_nextFullTime = ISNULL(MIN(cTime), -1)
   FROM   #tempAF
   WHERE  backupLevel = 1 AND jobEndDate > @i_toTime
   IF @l_nextFullTime > 0
      SELECT @l_lastIndexTime = ISNULL(MAX(cTime), -1)
      FROM   #tempAF
      WHERE  fileType = 2 AND cTime < @l_nextFullTime
END
DELETE	#tempAF
WHERE	jobEndDate < @i_fromTime OR (jobEndDate > @i_toTime AND cTime <> @l_lastIndexTime)
*/
DECLARE @appIdSpecificTimeRange table(appId int, fromTime int, nextFullTime int, lastIndexTime int, isIndexingV2 int)
INSERT @appIdSpecificTimeRange
SELECT distinct appId, @i_fromTime, -1, -1, 0
FROM #tempAF
IF @i_fromTime <= 0
BEGIN
	UPDATE @appIdSpecificTimeRange SET fromTime = B.jobStartDate
	FROM @appIdSpecificTimeRange A INNER JOIN
	(
	SELECT appId, ISNULL(MAX(jobStartDate), 0) "jobStartDate"
	FROM #tempAF
	WHERE backupLevel = 1 AND jobEndDate < @i_toTime
	GROUP BY appId
	) B ON A.appId = B.appId
END
--Update indexingV2 for the appIds
UPDATE @appidSpecificTimeRange
SET isIndexingV2 = ACP.attrVal
FROM @appIdSpecificTimeRange A INNER JOIN App_Application AA WITH (READUNCOMMITTED) ON A.appId = AA.id
INNER JOIN App_Client AC WITH (READUNCOMMITTED) ON AA.clientId = AC.id
INNER JOIN App_ClientProp ACP WITH (READUNCOMMITTED) ON AC.id = ACP.componentNameId AND ACP.attrName = dbo.GetIndexingV2PropNameByAppType(AA.appTypeId) AND ACP.modified = 0
WHERE ACP.created < @i_toTime
	AND dbo.IsIndexingV2Enabled(AA.clientId, AA.appTypeId, AA.id) = 1 --This is to filter out supported apptypeIds.
--Delete index fileType for indexingV2
DELETE	#tempAF
FROM #tempAF A INNER JOIN @appIdSpecificTimeRange B ON A.appId = B.appId
WHERE B.isIndexingV2 = 1
AND A.fileType in (2, 6) --CVA_DATATYPE_INDEX and CVA_DATATYPE_SNAPMETADATA
IF EXISTS (SELECT * FROM #tempAF WHERE fileType = 2)
BEGIN
--We shouldnt have index Afiles in case of indexingV2 now.
--However, add sanity check in next query to prevent lastIndexTime logic for indexingV2.
   UPDATE @appIdSpecificTimeRange SET nextFullTime = B.nextFullTime
   FROM @appIdSpecificTimeRange A INNER JOIN
   (
   SELECT appId, ISNULL(MIN(cTime), -1) "nextFullTime"
   FROM #tempAF
   WHERE backupLevel = 1 AND jobEndDate > @i_toTime
   GROUP BY appId
	) B ON A.appId = B.appId
	WHERE EXISTS(SELECT 1 FROM #tempAF WHERE appId = A.appId AND fileType = 2)
	AND A.isIndexingV2 <> 1
   IF EXISTS(SELECT 1 FROM @appIdSpecificTimeRange WHERE nextFullTime > 0)
		UPDATE @appIdSpecificTimeRange SET lastIndexTime = B.lastIndexTime
		FROM @appIdSpecificTimeRange A INNER JOIN
		(
		SELECT A1.appId, ISNULL(MAX(A1.cTime), -1) "lastIndexTime"
		FROM #tempAF A1 INNER JOIN @appIdSpecificTimeRange B1 ON A1.appId = B1.appId
		WHERE A1.fileType = 2 AND A1.cTime < B1.nextFullTime AND B1.nextFullTime > 0
		GROUP BY A1.appId
		)B ON A.appId = B.appId
END
DELETE	#tempAF
FROM #tempAF A INNER JOIN @appIdSpecificTimeRange B ON A.appId = B.appId
WHERE	A.jobEndDate < B.fromTime OR (A.jobEndDate > @i_toTime AND A.cTime <> B.lastIndexTime)
UPDATE #tempAF
SET isForIndex = 1
FROM #tempAF A INNER JOIN @appIdSpecificTimeRange B ON A.appId = B.appId
WHERE A.fileType = 2
/*
Sebastian: Get index aFiles for cases where we have indexingV2 involved
	We use @i_appId, should work for current and future scenarios since indexingV2 fetches at backupset level.
*/
IF EXISTS (SELECT 1 FROM @appIdSpecificTimeRange WHERE isIndexingV2 = 1)
BEGIN
	--To handle the case of VSA Index V2.1 where index data for child VMs need to be shown
	DECLARE @indexAppIds table(appId int)
	INSERT INTO @indexAppIds
	SELECT @i_appId
	IF @l_appTypeId = 106  /* VIRTUAL_SERVER_IDA */
		INSERT INTO @indexAppIds
		SELECT AT.appId
		FROM @appIdSpecificTimeRange AT
		LEFT JOIN @indexAppIds IA on IA.appId = AT.appId
		WHERE IA.appId IS NULL
	DECLARE @xmlParam XML
	DECLARE @errorMessage NVARCHAR(MAX) = ''
	DECLARE @mediaPrediction BIT = 1
	DECLARE @copyPrecedence INT = @i_copyPrecedence
	DECLARE @dbGuid varchar(max) = ''
	DECLARE @backupSetGuid varchar(max) = ''
	DECLARE @useCopyPrecdenceForCheckpoint INT = 1
	DECLARE @OutputTable  TABLE (xmloutput xml)
	DECLARE @xmlOutput XML
	DECLARE @indexGuids table(dbGuid varchar(max), backupSetGuid varchar(max))
	INSERT INTO @indexGuids
	SELECT DISTINCT IdxDB.dbName, IdxDB.backupSetGUID FROM App_application APP WITH (READUNCOMMITTED)
	INNER JOIN App_BackupSetName BkpSet WITH(READUNCOMMITTED) ON APP.backupSet = BkpSet.id
	INNER JOIN App_IndexDBInfo IdxDB WITH (READUNCOMMITTED) ON BkpSet.id = IdxDB.backupSetId AND BkpSet.GUID = IdxDB.backupSetGUID
	JOIN @indexAppIds idxAPP ON idxAPP.appId = APP.id
	DECLARE getIndexAFsForBackupSet CURSOR FOR
	SELECT dbGuid, backupSetGuid
	FROM @indexGuids
	OPEN getIndexAFsForBackupSet
	FETCH NEXT FROM getIndexAFsForBackupSet INTO @dbGuid, @backupSetGuid
	WHILE @@FETCH_STATUS = 0
    BEGIN
		IF (@backupSetGUID <> '' AND @dbGuid <> '') -- If there are no backup jobs within the backupSet we wont get these values. Do not go ahead with further calls
		BEGIN
			SET @xmlParam = (
			SELECT @dbGuid as '@dbGuid', @backupSetGuid as '@backupSetGuid', @mediaPrediction as '@isMediaPrediction', @copyPrecedence as '@copyPrecedence', @useCopyPrecdenceForCheckpoint as '@useCopyPrecdenceForCheckpoint'
			FOR XML PATH ('Indexing_GetArchFileInfoForJobs'), TYPE)
			INSERT INTO @OutputTable
			exec AppgetArchFileInfoForJobs @xmlParam
			SELECT TOP 1 @xmlOutput = xmlOutput FROM @OutputTable
			DELETE FROM @OutputTable
			INSERT INTO #tempAF
			SELECT	A.id, A.commCellId, A.archGroupId, A.fileType, A.cTime,
						0, 0, 0, A.appId, 1 --backupLevel and jobTimes are only needed to calculate index media for V1.
			FROM archFile A WITH (READUNCOMMITTED)
			INNER JOIN @xmlOutput.nodes('Indexing_GetArchFileInfoForJobs/archFileInfoList') AFInfo(n)
				ON AFInfo.n.value('@aFileId', 'INT') = A.id AND AFInfo.n.value('@commCellId', 'INT') = A.commCellId
			WHERE A.isValid = 1
			FETCH NEXT FROM getIndexAFsForBackupSet INTO @dbGuid, @backupSetGuid
		END
    END
	CLOSE getIndexAFsForBackupSet
    DEALLOCATE getIndexAFsForBackupSet
END
/*End of indexingV2 media calculation*/
IF (@i_copyPrecedence = -2)
BEGIN
	-- from all copies
	INSERT	INTO #tempAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.appId, AF.isForIndex
	FROM	#tempAF AF, archFileCopy AFC, archGroupCopy AGC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId =AF.commCellId
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AFC.archCopyId = AGC.id
		AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
END
ELSE
IF (@i_copyPrecedence = -1)
BEGIN
	-- from the primary copy
	INSERT	INTO #tempAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.appId, AF.isForIndex
	FROM	#tempAF AF, archFileCopy AFC, archGroup AG
	WHERE	AG.id = AF.archGroupId AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AG.defaultCopy
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
END
ELSE
IF(@i_copyPrecedence > 0)
BEGIN
	-- from a given copy precedence
	INSERT	INTO #tempAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AF.appId, AF.isForIndex
	FROM	#tempAF AF, archFileCopy AFC WITH (READUNCOMMITTED), archGroupCopy AGC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id AND AGC.copy = @i_copyPrecedence
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
END
ELSE
IF(@i_copyPrecedence = 0)
BEGIN
	/*
	-- from the copy which has the given job and has the lowest precedence
	DECLARE getArchFileCopy CURSOR FOR
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#tempAF AF, archFileCopy AFC, archGroupCopy AGC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AGC.type <> 5 -- SELECT only non transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	ORDER BY AFC.archFileId ASC, AFC.isValid DESC, AGC.copy ASC
	OPEN getArchFileCopy
	DECLARE @l_archFileId int
	DECLARE @l_commCellId int
	DECLARE @l_archCopyId int
	FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_commCellId, @l_archCopyId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #tempAFC
		SELECT @l_archFileId, @l_commCellId, @l_archCopyId
		WHERE  NOT EXISTS (SELECT * FROM #tempAFC WHERE archFileId = @l_archFileId AND commCellId = @l_commCellId)
		FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_commCellId, @l_archCopyId
	END
	CLOSE getArchFileCopy
	DEALLOCATE getArchFileCopy
	*/
	-- from the copy which has the given job and has the higher precedence
	INSERT INTO #tempAFC
	SELECT  id, commcellId, archCopyId, appId, isForIndex FROM
	(
	SELECT	AF.id, AF.commCellId, AFC.archCopyId, AF.appId, AF.isForIndex,
			row_number() OVER (PARTITION BY AF.id, AF.commCellId, AF.appId ORDER BY AFC.isValid DESC, AGC.copy ASC) AS rn
	FROM	#tempAF AF, archFileCopy AFC, archGroupCopy AGC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AGC.type <> 5 -- SELECT only non transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	) A
	WHERE rn = 1
END
INSERT	INTO #tempVol
SELECT	AC1.archCopyId, AC.volumeId, 0, 0, 0, 0, 0, MIN(AC1.appId)
		, dbo.bitwiseOR(CASE AC1.isForIndex
						WHEN 1 THEN 8 /*BIT_DATA_MEDIA*/
						WHEN 2 THEN 2 /*BIT_INDEX_MEDIA*/
						ELSE 2|8  END)
FROM	(SELECT ACM.archChunkId, ACM.chunkCommCellId, ACM.archCopyId, MIN(AFC.appId) AS appId
			, dbo.bitwiseOR(CASE isForIndex
							WHEN 0 THEN 1 /*Data*/
							ELSE 2 /*Index*/ END) AS isForIndex
		FROM   #tempAFC AFC, archChunkMapping ACM WITH (READUNCOMMITTED)
		WHERE  ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
		GROUP BY ACM.archChunkId, ACM.chunkCommCellId, ACM.archCopyId) AC1, archChunk AC WITH (READUNCOMMITTED)
WHERE	AC.id = AC1.archChunkId AND AC.commCellId = AC1.chunkCommCellId
GROUP BY AC1.archCopyId, AC.volumeId
UPDATE	#tempVol SET MediaSideId = V.MediaSideId, MediaId = V.MediaId,
		CreationTime = V.CreationTime, SIDBStoreId = V.SIDBStoreId, SiloStatus = V.SiloStatus
FROM	#tempVol T, MMVolume V WITH (READUNCOMMITTED)
WHERE	T.VolumeId = V.VolumeId
IF EXISTS (SELECT * FROM #tempVol WHERE SiloStatus <> 0)
BEGIN
	CREATE	TABLE #SiloVol (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)
	INSERT	INTO #SiloVol
	SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
	FROM	#tempVol
	GROUP BY SIDBStoreId
	EXEC archMediaForSiloViatable 0, 0
	INSERT	INTO #tempVol
	SELECT	T.CopyId, V.VolumeId, V.MediaSideId, V.MediaId, V.CreationTime, V.SIDBStoreId, V.SiloStatus, @i_appId, 0
	FROM	#SiloVol T, MMVolume V WITH (READUNCOMMITTED)
	WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
    /* Sebastian: Ideally we should be having the mediaFlags returned to #SiloVol.
    But this proc is used in many places. Change there would be highly regressive. So use hacky way below.
    Logic -> If we have volumes returned to #SiloVol, update those entries with mediaFlags as a bitwise OR of all the volume entries that require the volumes in #SiloVol for restore.
    To find this correspondence, currently we have no way other than getting first SIDBStoreId, we usually find siloVolumeId to volumeId, here we need the reverse.
    */
    UPDATE T1
    SET mediaFlags = TMP.mediaFlags
    FROM
    (SELECT SIDBStoreId, dbo.bitwiseOR(mediaFlags) AS mediaFlags
    FROM #tempVol T2
    WHERE T2.SiloStatus <> 0
    GROUP BY SIDBStoreId) TMP,
    (SELECT DISTINCT T.VolumeId, V.SIDBStoreId
    FROM #SiloVol T
    JOIN archChunk AC WITH (READUNCOMMITTED) ON T.VolumeId = AC.VolumeId
    JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commcellId
    JOIN archFileSiloVolume AFSV WITH (READUNCOMMITTED) ON ACM.archFileId = AFSV.archFileId AND ACM.commCellId = AFSV.commcellId
    JOIN MMVolume V WITH (READUNCOMMITTED) ON V.VolumeId = AFSV.SiloVolumeId
    WHERE V.SiloStatus = 3) SiloSIDB, #tempVol T1
    WHERE T1.VolumeId = SiloSIDB.VolumeId
        AND TMP.SIDBStoreId = SiloSIDB.SIDBStoreId
        AND T1.mediaFlags = 0
	DROP TABLE #SiloVol
END
SELECT	V.archCopyId, V.MediaSideId, M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.LibraryId, M.ExportLocationId, M.MediaLocation, M.ContainerId, V.appId, V.mediaFlags
INTO	#tempMedia
FROM	#tempVol V, MMMedia M WITH (READUNCOMMITTED)
WHERE	V.MediaId = M.MediaId
UPDATE  #tempMedia
SET BarCode = MP.MountPathName
FROM    #tempMedia M, MMS2getMountPathNameGUIView MP WITH (READUNCOMMITTED)
WHERE   M.MediaSideId = MP.MediaSideId AND M.MediaTypeId = 10001
IF object_id('tempdb.dbo.#tempMediaPredictionRptTbl') IS NOT null
BEGIN
INSERT INTO #tempMediaPredictionRptTbl(	t_mediaId, t_uniqueId, t_barCode, t_mediaTypeId, t_mediaLocation,
                            t_exportLocation, t_containerId, t_containerName,
                            t_libraryId, t_libraryName, t_subclientId, t_subclientName,
                            t_copyPrecedence, t_copyId, t_copyName, t_spId, t_spName)
SELECT	DISTINCT MediaId, UniqueId, BarCode, MediaTypeId, MediaLocation,
	(SELECT ExportLocation FROM MMExportLocation WITH (READUNCOMMITTED) WHERE ExportLocationId = M.ExportLocationId),
	ContainerId,
	(SELECT ISNULL(ContainerName, 'N/A') FROM MMContainer WITH (READUNCOMMITTED) WHERE ContainerId = M.ContainerId),
	LibraryId, (SELECT AliasName FROM MMLibrary WITH (READUNCOMMITTED) WHERE LibraryId = M.LibraryId),
	@i_appId, APP.SubClientname, --For report we just need distinct media
	C.copy, C.id, C.name, C.archGroupId, (SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = C.archGroupId)
FROM 	#tempMedia M, archGroupCopy C, App_Application APP WITH (READUNCOMMITTED)
WHERE M.archCopyId = C.id AND APP.id = @i_appId
END
ELSE -- Temp table is created only for rptGetMediaForRecovery. Other cases print the result output.
BEGIN
SELECT	MediaId, UniqueId, BarCode, MediaTypeId, MediaLocation,
	(SELECT ExportLocation FROM MMExportLocation WITH (READUNCOMMITTED) WHERE ExportLocationId = M.ExportLocationId),
	ContainerId,
	(SELECT ISNULL(ContainerName, 'N/A') FROM MMContainer WITH (READUNCOMMITTED) WHERE ContainerId = M.ContainerId),
	LibraryId, (SELECT AliasName FROM MMLibrary WITH (READUNCOMMITTED) WHERE LibraryId = M.LibraryId),
	APP.id, APP.SubClientname,
	C.copy, C.id, C.name, C.archGroupId, (SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = C.archGroupId), mediaFlags
FROM 	#tempMedia M, archGroupCopy C, App_Application APP WITH (READUNCOMMITTED)
WHERE M.archCopyId = C.id AND M.appId = APP.id
END
IF	@i_appId > 0
BEGIN
	IF object_id('tempdb.dbo.#tempDeviceTypes') is not null DROP TABLE #tempDeviceTypes
	CREATE TABLE #tempDeviceTypes (DeviceTypeId int primary key)
	INSERT INTO #tempDeviceTypes
SELECT 2
	UNION
SELECT 53
	UNION
SELECT 22
	UNION
SELECT 3
	UNION
SELECT 28
	UNION
SELECT 23
IF	EXISTS (	SELECT	DeviceId
			FROM	MMDevice(readuncommitted) D
			JOIN	#tempDeviceTypes DT on DT.DeviceTypeId = D.DeviceTypeId)
	AND EXISTS (SELECT	*
				FROM	MMConfigs
				WHERE	Name = 'MMS_CONFIG_LOG_RESTORE_JOB_CHUNK_INFO'
						AND Value = 1)
BEGIN
	-- Delete all the volume which are not created on amazon clound mount path
	DELETE	#tempVol
	FROM	#tempVol MV
	JOIN	MMMountPath(readuncommitted) MP ON MV.MediaSideId = MP.MediaSideId
	JOIN	MMMountPathToStorageDevice(readuncommitted) MSD ON MP.MountPathId = MSD.MountPathId
	JOIN	MMDevice(readuncommitted) D ON MSD.DeviceId = D.DeviceId
	WHERE 	NOT EXISTS(SELECT TD.DeviceTypeId from #tempDeviceTypes TD WHERE TD.DeviceTypeId = D.DeviceTypeId)
	IF (EXISTS (SELECT * FROM #tempVol WHERE SIDBStoreId > 0))
	BEGIN
		INSERT INTO #tempVol
		SELECT  0, MV.VolumeId, MV.MediaSideId, MV.MediaId, MV.CreationTime, MV.SIDBStoreId, MV.SiloStatus, 0, 0
		FROM	MMVolume MV WITH (NOLOCK) LEFT OUTER JOIN #tempVol TV ON TV.VolumeId = MV.VolumeId,
				MMMountPath MP WITH (readuncommitted), MMMountPathToStorageDevice MSD WITH (readuncommitted), MMDevice D WITH (readuncommitted), #tempDeviceTypes DT
		WHERE	MV.MediaSideId = MP.MediaSideId
			AND MP.MountPathId = MSD.MountPathId
			AND MSD.DeviceId = D.DeviceId
			AND D.DeviceTypeId = DT.DeviceTypeId
			AND TV.VolumeId IS NULL
			AND MV.SIDBStoreID IN (SELECT TOP 1 TV2.SIDBStoreId FROM #tempVol TV2)
	END
	IF EXISTS (	SELECT	*
				FROM	#tempVol)
	BEGIN
		if object_id('tempdb.dbo.#tempChunkPathInfo') is not null DROP TABLE #tempChunkPathInfo
		CREATE	TABLE #tempChunkPathInfo (MountPathId integer, ChunkPath VARCHAR(2048))
		DECLARE	@MountPathId INTEGER = 0
		DECLARE	@PrevMountPathId INTEGER = 0
		DECLARE	@ChunkPath VARCHAR(2048)
		DECLARE	@InstallDir as VARCHAR(1024)
		DECLARE	@FilePath as VARCHAR(1024)
		DECLARE @RetCode int = 0 , @FileSystem int = 0, @FileHandle int = 0
		DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
		IF @isOsWindows = 1
		BEGIN
			EXECUTE @RetCode = sp_OACreate 'Scripting.FileSystemObject' , @FileSystem OUTPUT
			IF (@@ERROR != 0 OR @RetCode != 0 OR @FileSystem < 0)
			BEGIN
				IF (@FileSystem > 0)
					EXEC sp_OADestroy @FileSystem
				GOTO PROC_EXIT
			END
		END
		SET		@InstallDir = @i_baseTempDir
		IF (@InstallDir IS NULL OR LEN(@InstallDir) = 0)
		BEGIN
			SELECT	TOP 1 @InstallDir = install_dir
			FROm	APP_Platform
			WHERE	platformType = 1
			SET		@InstallDir = @InstallDir + '\Base\Temp\'
		END
		-- CODE REVIEW - Check this path generation for unix machines
		INSERT INTO #tempChunkPathInfo
		SELECT	DISTINCT MP.MountPathId, DC.Folder + '\' + MP.MountPathName + '\CV_MAGNETIC\' + MV.VolumeName + '\'
											--+
											--(CASE WHEN MV.SIDBStoreId = 0 AND TC.id IS NOT NULL THEN 'CHUNK_' + CAST(TC.id AS VARCHAR(10)) ELSE '' END)
		FROM	#tempVol TV
		JOIN	MMVolume MV WITH (readuncommitted) ON MV.VolumeId = TV.VolumeId
		JOIN	MMMountPath MP WITH (readuncommitted) ON MV.MediaSideId = MP.MediaSideId
		JOIN	MMMountPathToStorageDevice D WITH (readuncommitted) ON MP.MountPathId = D.MountPathId
		JOIN 	MMDevice DV WITH (readuncommitted) ON DV.DeviceId = D.DeviceId
		JOIN	MMDeviceController DC WITH (readuncommitted) ON D.DeviceId = DC.DeviceId
		JOIN	#tempDeviceTypes DT ON DV.DeviceTypeId = DT.DeviceTypeId
WHERE	DT.DeviceTypeId <> 53
-- Glacier
		INSERT INTO #tempChunkPathInfo
		SELECT	DISTINCT MP.MountPathId, AC.cclip
		FROM	#tempVol TV,
				MMVolume MV WITH (NOLOCK),
				MMMountPath MP WITH (NOLOCK),
				MMMountPathToStorageDevice D WITH (NOLOCK),
				ArchChunk AC WITH (NOLOCK),
				MMDevice DV WITH (NOLOCK),
				MMDeviceController DC WITH (NOLOCK)
		WHERE	MV.MediaSideId = MP.MediaSideId
				AND MP.MountPathId = D.MountPathId
				AND D.DeviceId = DC.DeviceId
				AND MV.VolumeId = TV.VolumeId
				AND AC.VolumeId = MV.VolumeId
				AND DV.DeviceId = D.DeviceId
AND DV.DeviceTypeId = 53
		--UPDATE #tempChunkPathInfo
		--SET	   ChunkPath = REPLACE(ChunkPath, '\', '/')
		--WHERE	CHARINDEX('/', ChunkPath) > 0
		DECLARE MountPath_Cursor CURSOR FOR
		SELECT	DISTINCT MountPathId
		FROM	#tempChunkPathInfo
		ORDER BY MountPathId
		OPEN MountPath_Cursor
		FETCH NEXT FROM MountPath_Cursor
		INTO @MountPathId
		WHILE (@@FETCH_STATUS = 0)
		BEGIN
			IF @isOsWindows = 1
			BEGIN
			IF (@FileHandle > 0)
			BEGIN
				EXECUTE @RetCode = sp_OAMethod @FileHandle , 'Close' , NULL
				IF (@@ERROR != 0 OR @RetCode != 0)
				BEGIN
					GOTO MOUNTPATH_END
				END
				EXEC sp_OADestroy @FileHandle
			END
			END
			SET	@FilePath = @InstallDir + '\ChunkList_' + CAST(@i_appId AS VARCHAR(10)) + '_' + CAST(@MountPathId AS VARCHAR(10)) + '.txt'
			if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
			CREATE TABLE #tempChunkListFileData (chunk VARCHAR(MAX))
			IF @isOsWindows = 1
			BEGIN
				EXEC sp_OAMethod @FileSystem, 'FileExists', @RetCode OUT, @FilePath
			END
			ELSE
			BEGIN
				SELECT @retCode = dbo.cv_fnFileExists(@FilePath)
				IF (@RetCode = 1)
				BEGIN
					--Get existing data from file is file exists
					SET @l_sql = 'BULK INSERT #tempChunkListFileData FROM ''' + @FilePath + ''''
					EXEC(@l_sql)
				END
			END
			IF (@isOsWindows = 1 )
			BEGIN
				IF (@RetCode = 1)
				BEGIN
					--Get existing data from file is file exists
					SET @l_sql = 'BULK INSERT #tempChunkListFileData FROM ''' + @FilePath + ''''
					EXEC(@l_sql)
					EXECUTE @RetCode = sp_OAMethod @FileSystem , 'OpenTextFile' , @FileHandle OUTPUT , @FilePath, 8
					IF (@@ERROR != 0 OR @RetCode != 0 OR @FileHandle < 0)
						GOTO MOUNTPATH_END
				END
				ELSE
				BEGIN
					EXECUTE @RetCode = sp_OAMethod @FileSystem , 'OpenTextFile' , @FileHandle OUTPUT , @FilePath, 2, 1
					IF (@@ERROR != 0 OR @RetCode != 0 OR @FileHandle < 0)
						GOTO MOUNTPATH_END
				END
			END
			DECLARE ChunkInfo_Cursor CURSOR FOR
			SELECT	ChunkPath
			FROM	#tempChunkPathInfo
			WHERE	MountPathId = @MountPathId
			ORDER BY ChunkPath
			OPEN ChunkInfo_Cursor
			-- Perform the first fetch and store the values in variables.
			-- Note: The variables are in the same order as the columns
			-- in the SELECT statement.
			FETCH NEXT FROM ChunkInfo_Cursor
			INTO @ChunkPath
			-- Check @@FETCH_STATUS to see if there are any more rows to fetch.
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF NOT EXISTS (SELECT * FROM #tempChunkListFileData WHERE chunk = @ChunkPath)
				BEGIN
					IF @isOsWindows = 1
					BEGIN
						EXECUTE @RetCode = sp_OAMethod @FileHandle , 'WriteLine' , NULL , @ChunkPath
						IF (@@ERROR != 0 OR @RetCode != 0)
						BEGIN
							CLOSE ChunkInfo_Cursor
							DEALLOCATE ChunkInfo_Cursor
							GOTO MOUNTPATH_END
						END
					END
					ELSE
					BEGIN
						EXECUTE cv_spWriteToFile @FilePath , @ChunkPath, @errorMessage OUTPUT, 1
						IF @errorMessage != NULL AND LEN(@errorMessage)>0
						BEGIN
							CLOSE ChunkInfo_Cursor
							DEALLOCATE ChunkInfo_Cursor
							GOTO MOUNTPATH_END
						END
					END
				END
				-- This is executed as long as the previous fetch succeeds.
				FETCH NEXT FROM ChunkInfo_Cursor
				INTO @ChunkPath
			END
			CLOSE ChunkInfo_Cursor
			DEALLOCATE ChunkInfo_Cursor
			FETCH NEXT FROM MountPath_Cursor
			INTO @MountPathId
			if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
		END
MOUNTPATH_END:
		if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
		CLOSE MountPath_Cursor
		DEALLOCATE MountPath_Cursor
		IF @isOsWindows = 1
		BEGIN
			IF (@FileHandle > 0)
			BEGIN
				EXECUTE @RetCode = sp_OAMethod @FileHandle , 'Close' , NULL
				IF (@@ERROR = 0 AND @RetCode = 0)
					EXEC sp_OADestroy @FileHandle
			END
			IF (@FileSystem > 0)
				EXEC sp_OADestroy @FileSystem
		END
		if object_id('tempdb.dbo.#tempChunkPathInfo') is not null DROP TABLE #tempChunkPathInfo
	END
END
END
PROC_EXIT:
if object_id('tempdb.dbo.#tempAF') is not null DROP TABLE #tempAF
if object_id('tempdb.dbo.#tempAFC') is not null DROP TABLE #tempAFC
if object_id('tempdb.dbo.#tempVol') is not null DROP TABLE #tempVol
if object_id('tempdb.dbo.#tempMedia') is not null DROP TABLE #tempMedia
IF object_id('tempdb.dbo.#tempDeviceTypes') is not null DROP TABLE #tempDeviceTypes
SET NOCOUNT OFF
REVERT
GO

IF EXISTS (select * from GxQscripts where name = 'getMediaListForAppIdByTime')
	delete from GxQscripts where name = 'getMediaListForAppIdByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMediaListForAppIdByTime')
	delete from GXDBVersions where aliasname = 'getMediaListForAppIdByTime'
GO

insert into GXDBVersions values(2, 'getMediaListForAppIdByTime',  '00010048001400170000', 'getMediaListForAppIdByTime', '00010048001400170000')
GO

