

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getMediaListByAfileOffset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getMediaListByAfileOffset.sp,v $ $Id: getMediaListByAfileOffset.sp,v 1.45.32.16 2020/10/04 01:04:56 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getMediaListByAfileOffset')
BEGIN
	print '>>> Drop Stored Procedure: getMediaListByAfileOffset <<<'
	drop procedure getMediaListByAfileOffset
END
IF EXISTS (select * from GxQscripts where name='getMediaListByAfileOffset')
	delete from GxQscripts where name = 'getMediaListByAfileOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMediaListByAfileOffset')
	delete from GXDBVersions where aliasname = 'getMediaListByAfileOffset'
GO
print '... Creating Procedure: getMediaListByAfileOffset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getMediaListByAfileOffset
  @i_archFileId integer,
  @i_commCellId integer,
  @i_offset1 bigint,
  @i_offset2 bigint,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_jobId integer = 0,
  @i_baseTempDir varchar(1024) = '',
  @i_preferMagnetic integer = 0,
  @i_preferAccessible integer = 0
AS
  DECLARE @r_mediaId integer;
  DECLARE @r_uniqueId char(64);
  DECLARE @r_barCode char(64);
  DECLARE @r_mediaTypeId integer;
  DECLARE @r_mediaLocation integer;
  DECLARE @r_exportLocation NVARCHAR(64);
  DECLARE @r_containerId integer;
  DECLARE @r_containerName NVARCHAR(64);
  DECLARE @r_libraryId integer;
  DECLARE @r_libraryName NVARCHAR(64);
  DECLARE @r_subclientId integer;
  DECLARE @r_subclientName NVARCHAR(64);
  DECLARE @r_copyPrecedence integer;
  DECLARE @r_copyId integer;
  DECLARE @r_copyName NVARCHAR(64);
  DECLARE @r_spId integer;
  DECLARE @r_spName NVARCHAR(64);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_appId integer
DECLARE @l_spId integer
DECLARE @l_copyPrec integer
DECLARE @l_copyId integer
DECLARE @l_sql NVARCHAR(2048)
DECLARE @l_concatCount INT = 1000
DECLARE @l_jobId integer = 0
DECLARE @l_archName NVARCHAR(2048)
DECLARE @errorMessage NVARCHAR(2048) = ''
DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
select @l_concatCount = value from MMConfigs where name = 'MMS2_CONFIG_CLOUD_ARCHIVE_STORAGE_MEDIA_PREDICTION_CONCAT_COUNT'
if object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
if object_id('tempdb.dbo.#tempVolume') is not null DROP TABLE #tempVolume
if object_id('tempdb.dbo.#tempMedia') is not null DROP TABLE #tempMedia
if object_id('tempdb.dbo.#tempCopyPrecedence') is not null DROP TABLE #tempCopyPrecedence
if object_id('tempdb.dbo.#tempNASArchive') is not null DROP TABLE #tempNASArchive
CREATE TABLE #tempChunk (archChunkId bigint, chunkCommcellId int)
CREATE TABLE #tempVolume (VolumeId INT, MediaSideId INT, MediaId INT, CreationTime INT, SIDBStoreId INT, SiloStatus INT)
CREATE TABLE #tempCopyPrecedence (errCode INT, copyId INT, AFC_isValid INT, AFC_flags INT, fileType INT, appId INT, appType INT, clientId INT)
CREATE TABLE #tempNASArchive (archFileId integer PRIMARY KEY, archLogicalSize bigint, startOffset bigint, nextOffset bigint)
SELECT	TOP 1 @l_appId = ISNULL(a.appId, -1), @l_spId = ISNULL(a.archGroupId, -1), @l_jobId = ISNULL(a.jobId, 0), @l_archName = ISNULL(a.name, '')
FROM	archFile a WITH (READUNCOMMITTED)
WHERE	a.Id = @i_archFileId AND a.commCellId = @i_commCellId
EXEC archFileCopyByPrecedence @i_archFileId, @i_commCellId, @i_copyPrecedence, @i_includeAgedData, @i_preferMagnetic, @i_preferAccessible
SELECT TOP 1 @l_copyId = ISNULL(T.copyId, -1), @l_copyPrec = ISNULL(C.copy, -1)
FROM #tempCopyPrecedence T, archGroupCopy C WITH (READUNCOMMITTED)
WHERE T.copyId = C.id
DECLARE @iNdmpData	int = 0		-- Indicates is an NDMP backup. Uses logical size AND offsets are relative to the backup, not relative to the archive.
IF EXISTS (	SELECT	TOP 1 A.appTypeId
			FROM	archFile AF WITH (READUNCOMMITTED), APP_Application A WITH (READUNCOMMITTED)
			WHERE	AF.id = @i_archFileId
AND AF.fileType = 1
					AND AF.commCellId = @i_commCellId
					AND AF.appId = A.id
AND A.AppTypeId = 13)
BEGIN
	SET	@iNdmpData = 1
	-- For restartable backups, translate the file server offset to the archive file offset.
	-- The offset in index is the file server offset - this is the "logical" offset. If the backup is restarted,
	-- the offset is the logical offset from the start of the backup - not from the start of the archive file. So we need
	-- to subtract the archive file
	-- * NAS Restore has similar logic. See nasRestoreLib.cpp in OnMsgOpenArchive. Get all archive files:
	--   - Matching CommCell
	--   - Matching AppNumber - same subclient
	--   - Matching JobId - same backup job
	--   - Matching afile name - same backup path (the NAS iDA puts the backup path in the archive file name)
	--   - fileType is CVA_DATATYPE_DATA. This probably does not really matter because only data archives will have a matching name.
	--   - NasRestoreLib also matches on backupTime - we can check if that is necessary.
	--   - Isvalid is 1
	--   - logical size is not 0
	--   - order by afile ID.
	--
	-- NOTE: There are 2 variables i_offset1 and i_offset2 (start and end offset) - technically there is only 1 archive file passed in to this routine so the assumption is that
	-- both these 2 offsets are in the same archive file. Do we need to validate that here?
	--
	IF @l_jobId != 0
	BEGIN
		INSERT INTO #tempNASArchive
		SELECT AFC.archFileId, AFC.logicalSize, 0, 0
		FROM   archFile as AF, archFileCopy as AFC WITH (READUNCOMMITTED)
		WHERE  AF.appID = @l_appId
			   AND AF.commcellId = @i_commCellId
			   AND AF.jobId = @l_jobId
			   AND AF.name  = @l_archName
AND AF.fileType = 1
			   AND AF.isValid = 1
			   AND AFC.archFileId = AF.id
			   AND AFC.commcellId = @i_commCellId
			   AND AFC.archCopyId = @l_copyId
			   AND AFC.logicalSize > 0
			   AND AFC.isValid = 1
		UPDATE #tempNASArchive SET #tempNASArchive.nextOffset  = (SELECT SUM(TNA.archLogicalSize) FROM #tempNASArchive AS TNA where TNA.archFileId <= #tempNASArchive.archFileId)
		UPDATE #tempNASArchive SET startOffset = nextOffset - archLogicalSize
	END
END
IF @i_offset2 = 0
BEGIN
	IF (@iNdmpData = 0)
	BEGIN
		INSERT INTO #tempChunk
		SELECT archChunkId, chunkCommCellId
		FROM   archChunkMapping WITH (READUNCOMMITTED)
		WHERE  archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_copyId AND chunkNumber > 0
			AND physicalSize >= (@i_offset1 - physicalOffset)
	END
	ELSE -- IF (@iNdmpData != 0)
	BEGIN
		-- Should be a single archive
		INSERT INTO #tempChunk
		SELECT ACM.archChunkId, ACM.chunkCommCellId
		FROM   archChunkMapping ACM WITH (READUNCOMMITTED), #tempNASArchive TNA
		WHERE
			TNA.startOffset <= @i_offset1 AND	-- Remove archives after the offset range
			TNA.nextOffset  >  @i_offset1 AND	-- Remove archives before the offset range - at this point there should only by 1 left
			ACM.archFileId = TNA.archFileId AND
			ACM.commCellId = @i_commCellId AND
			ACM.archCopyId = @l_copyId  AND
			ACM.chunkNumber > 0 AND
			ACM.logicalSize >= ((@i_offset1 - TNA.startOffset) - ACM.logicalOffset)
	END
END
IF @i_offset2 <> 0
BEGIN
	IF (@iNdmpData = 0)
	BEGIN
		INSERT INTO #tempChunk
		SELECT archChunkId,chunkCommCellId
		FROM   archChunkMapping WITH (READUNCOMMITTED)
		WHERE  archFileId = @i_archFileId AND commCellId = @i_commCellId AND archCopyId = @l_copyId AND chunkNumber > 0
			AND physicalSize >= (@i_offset1 - physicalOffset) AND physicalOffset <= @i_offset2
	END
	ELSE -- IF (@iNdmpData != 0) - For NDMP backup data
	BEGIN
		-- Typical read for a file:      offset1 = byte start of the file,    offset2 = offset1+filesize      => offset2 is 1 byte after what needs to be read
		-- Similarly for tempNASArchive: startOffset = byte start of archive, nextOffset = startOffset + size => nextOffset is 1 byte after what is in the archive
		INSERT INTO #tempChunk
		SELECT ACM.archChunkId, ACM.chunkCommCellId
		FROM   archChunkMapping ACM WITH (READUNCOMMITTED), #tempNASArchive TNA
		WHERE
			TNA.startOffset < @i_offset2 AND	-- Remove archives after the offset range.  Not <= since offset2 is 1 byte after what needs to be read
			TNA.nextOffset  > @i_offset1 AND	-- Remove archives before the offset range. Not >= since nextOffset is 1 byte after this archive
			ACM.archFileId = TNA.archFileId AND
			ACM.commCellId = @i_commCellId AND
			ACM.archCopyId = @l_copyId  AND
			ACM.chunkNumber > 0 AND
			ACM.logicalSize >= ((@i_offset1 - TNA.startOffset) - ACM.logicalOffset) AND  -- Remove chunks before the offset range
			ACM.logicalOffset <= (@i_offset2 - TNA.startOffset)                          -- Remove chunks after the offset range
	END
END
INSERT	INTO #tempVolume
SELECT	DISTINCT volumeId, 0, 0, 0, 0, 0
FROM	archChunk a WITH (READUNCOMMITTED), #tempChunk b
WHERE	a.id = b.archChunkId AND a.commCellId = b.chunkCommcellId
UPDATE	#tempVolume SET MediaSideId = V.MediaSideId, MediaId = V.MediaId,
		CreationTime = V.CreationTime, SIDBStoreId = V.SIDBStoreId, SiloStatus = V.SiloStatus
FROM	#tempVolume T, MMVolume V WITH (READUNCOMMITTED)
WHERE	T.VolumeId = V.VolumeId
IF EXISTS (SELECT * FROM #tempVolume WHERE SiloStatus <> 0)
BEGIN
	CREATE	TABLE #SiloVol (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)
	INSERT	INTO #SiloVol
	SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
	FROM	#tempVolume
	GROUP BY SIDBStoreId
	EXEC archMediaForSiloViatable 0, 0
	INSERT	INTO #tempVolume
	SELECT	V.VolumeId, V.MediaSideId, V.MediaId, V.CreationTime, V.SIDBStoreId, V.SiloStatus
	FROM	#SiloVol T, MMVolume V WITH (READUNCOMMITTED)
	WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
	DROP TABLE #SiloVol
END
SELECT	V.MediaSideId, M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.LibraryId, M.ExportLocationId, M.MediaLocation, M.ContainerId
INTO	#tempMedia
FROM	#tempVolume V, MMMedia M WITH (READUNCOMMITTED)
WHERE	V.MediaId = M.MediaId
UPDATE	#tempMedia
SET BarCode = MP.MountPathName
FROM	#tempMedia M, MMS2getMountPathNameGUIView MP WITH (READUNCOMMITTED)
WHERE	M.MediaSideId = MP.MediaSideId AND M.MediaTypeId = 10001
SELECT	MediaId, UniqueId, BarCode, MediaTypeId, MediaLocation,
	(SELECT ExportLocation FROM MMExportLocation WITH (READUNCOMMITTED) WHERE ExportLocationId = M.ExportLocationId),
	ContainerId,
	(SELECT ISNULL(ContainerName, 'N/A') FROM MMContainer WITH (READUNCOMMITTED) WHERE ContainerId = M.ContainerId),
	LibraryId, (SELECT AliasName FROM MMLibrary WITH (READUNCOMMITTED) WHERE LibraryId = M.LibraryId),
	@l_appId, (SELECT SubClientname FROM APP_Application WITH (READUNCOMMITTED) WHERE id = @l_appId),
	@l_copyPrec, @l_copyId, (SELECT name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = @l_copyId),
	@l_spId, (SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = @l_spId)
FROM 	#tempMedia M
IF	@i_JobID > 0
BEGIN
	IF object_id('tempdb.dbo.#tempDeviceTypes') is not null DROP TABLE #tempDeviceTypes
	CREATE TABLE #tempDeviceTypes (DeviceTypeId int Primary key)
	INSERT INTO #tempDeviceTypes
SELECT 2
	UNION
SELECT 53
	UNION
SELECT 22
	UNION
SELECT 3
	UNION
SELECT 28
	UNION
SELECT 23
-- This processing is required only for amazon cloud destination device
-- This will generate chunk list present on the amazon cloud might have been moved to Glazier (secondary media)
IF EXISTS (	SELECT	D.DeviceId
		FROM	MMDevice(readuncommitted) D
		JOIN	#tempDeviceTypes DT on DT.DeviceTypeId = D.DeviceTypeId)
AND EXISTS (SELECT	*
			FROM	MMConfigs
			WHERE	Name = 'MMS_CONFIG_LOG_RESTORE_JOB_CHUNK_INFO'
					AND Value = 1)
BEGIN
	-- Delete all the volume which are not created on amazon clound mount path
	DELETE	#tempVolume
	FROM	#tempVolume MV
	JOIN	MMMountPath(readuncommitted) MP ON MV.MediaSideId = MP.MediaSideId
	JOIN	MMMountPathToStorageDevice(readuncommitted) MSD ON MP.MountPathId = MSD.MountPathId
	JOIN	MMDevice(readuncommitted) D ON MSD.DeviceId = D.DeviceId
	WHERE 	NOT EXISTS(SELECT TD.DeviceTypeId from #tempDeviceTypes TD WHERE TD.DeviceTypeId = D.DeviceTypeId)
	IF EXISTS (	SELECT	*
				FROM	#tempVolume)
	BEGIN
		if object_id('tempdb.dbo.#tempChunkPathInfo') is not null DROP TABLE #tempChunkPathInfo
		CREATE	TABLE #tempChunkPathInfo (MountPathId integer, ChunkPath VARCHAR(2048))
		DECLARE	@MountPathId INTEGER = 0
		DECLARE	@PrevMountPathId INTEGER = 0
		DECLARE	@ChunkPath VARCHAR(2048)
		DECLARE	@InstallDir as VARCHAR(1024)
		DECLARE	@FilePath as VARCHAR(1024)
		DECLARE @RetCode int = 0 , @FileSystem int = 0, @FileHandle int = 0
		IF @isOsWindows = 1
		BEGIN
			EXECUTE @RetCode = sp_OACreate 'Scripting.FileSystemObject' , @FileSystem OUTPUT
			IF (@@ERROR != 0 OR @RetCode != 0 OR @FileSystem < 0)
			BEGIN
				IF (@FileSystem > 0)
					EXEC sp_OADestroy @FileSystem
				GOTO PROC_EXIT
			END
		END
		SET		@InstallDir = @i_baseTempDir
		IF (@InstallDir IS NULL)
		BEGIN
			SELECT	TOP 1 @InstallDir = install_dir
			FROm	APP_Platform
			WHERE	platformType = 1
			SET		@InstallDir = @InstallDir + '\Base\Temp\'
		END
		DECLARE @SIDBStoreId INT = ISNULL((SELECT TOP 1 ISNULL(SIDBStoreId, 0) FROM #tempVolume), 0)
		DELETE FROM #tempVolume WHERE SIDBStoreId <> 0
		-- CODE REVIEW - Check this path generation for unix machines
		if object_id('tempdb.dbo.#tempDeviceInfo') is not null DROP TABLE #tempDeviceInfo
		CREATE TABLE  #tempDeviceInfo (DeviceId INT, DeviceTypeId INT, Folder VARCHAR(2048))
		INSERT INTO #tempDeviceInfo
		SELECT DISTINCT D.DeviceId, D.DeviceTypeId, DC.Folder
		FROM MMDevice(NOLOCK) D
		JOIN MMDeviceController(NOLOCK) DC ON DC.DeviceId = D.DeviceId
		JOIN #tempDeviceTypes DT on DT.DeviceTypeId = D.DeviceTypeId
		INSERT INTO #tempChunkPathInfo
SELECT	DISTINCT MP.MountPathId, CASE WHEN D.DeviceTypeId = 53 THEN TC.cclip ELSE
										(D.Folder + '\' + MP.MountPathName + '\CV_MAGNETIC\' + MV.VolumeName + '\' +
											(CASE WHEN MV.SIDBStoreId = 0 AND TC.id IS NOT NULL THEN 'CHUNK_' + CAST(TC.id AS VARCHAR(10)) ELSE '' END)) END
		FROM MMVolume MV WITH (NOLOCK)
		LEFT OUTER JOIN
			(SELECT AC.id, AC.VolumeId, AC.cclip
			FROM ArchChunk AC WITH (NOLOCK), #tempChunk C
			WHERE C.archChunkId = AC.id AND C.chunkCommCellId = AC.commcellId) TC ON MV.VolumeId = TC.volumeId
		JOIN MMMountPath MP WITH (NOLOCK) ON MV.MediaSideId = MP.MediaSideId
		JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MP.MountPathId = MSD.MountPathId
		JOIN #tempDeviceInfo D WITH (NOLOCK) ON MSD.DeviceId = D.DeviceId
		WHERE ((@SIDBStoreId <> 0 AND MV.SIDBStoreID = @SIDBStoreId)
				OR MV.VolumeId IN (SELECT VolumeId FROM #tempVolume))
		--UPDATE #tempChunkPathInfo
		--SET	   ChunkPath = REPLACE(ChunkPath, '\', '/')
		--WHERE	CHARINDEX('/', ChunkPath) > 0
		DECLARE MountPath_Cursor CURSOR FOR
		SELECT	DISTINCT MountPathId
		FROM	#tempChunkPathInfo
		ORDER BY MountPathId
		OPEN MountPath_Cursor
		FETCH NEXT FROM MountPath_Cursor
		INTO @MountPathId
		WHILE (@@FETCH_STATUS = 0)
		BEGIN
			IF (@isOsWindows = 1 AND @FileHandle > 0)
			BEGIN
				EXECUTE @RetCode = sp_OAMethod @FileHandle , 'Close' , NULL
				IF (@@ERROR != 0 OR @RetCode != 0)
				BEGIN
					GOTO MOUNTPATH_END
				END
				EXEC sp_OADestroy @FileHandle
			END
			SET	@FilePath = @InstallDir + '\ChunkList_' + CAST(@i_JobId AS VARCHAR(10)) + '_' + CAST(@MountPathId AS VARCHAR(10)) + '.txt'
			if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
			CREATE TABLE #tempChunkListFileData (chunk VARCHAR(MAX))
			IF @isOsWindows = 1
			BEGIN
				EXEC sp_OAMethod @FileSystem, 'FileExists', @RetCode OUT, @FilePath
				IF (@RetCode = 1)
				BEGIN
					--Get existing data from file is file exists
					SET @l_sql = 'BULK INSERT #tempChunkListFileData FROM ''' + @FilePath + ''''
					EXEC(@l_sql)
					EXECUTE @RetCode = sp_OAMethod @FileSystem , 'OpenTextFile' , @FileHandle OUTPUT , @FilePath, 8
					IF (@@ERROR != 0 OR @RetCode != 0 OR @FileHandle < 0)
						GOTO MOUNTPATH_END
				END
				ELSE
				BEGIN
					EXECUTE @RetCode = sp_OAMethod @FileSystem , 'OpenTextFile' , @FileHandle OUTPUT , @FilePath, 2, 1
					IF (@@ERROR != 0 OR @RetCode != 0 OR @FileHandle < 0)
						GOTO MOUNTPATH_END
				END
			END
			ELSE
			BEGIN
				SELECT @retCode = dbo.cv_fnFileExists(@FilePath)
				IF (@RetCode = 1)
				BEGIN
					--Get existing data from file is file exists
					SET @l_sql = 'BULK INSERT #tempChunkListFileData FROM ''' + @FilePath + ''''
					EXEC(@l_sql)
				END
			END
			DELETE #tempChunkPathInfo
			FROM #tempChunkListFileData
			WHERE MountPathId = @MountPathId AND chunk = ChunkPath
			DECLARE ChunkInfo_Cursor CURSOR FOR
			SELECT	ChunkPath
			FROM	#tempChunkPathInfo
			WHERE	MountPathId = @MountPathId
			ORDER BY ChunkPath
			OPEN ChunkInfo_Cursor
			-- Perform the first fetch and store the values in variables.
			-- Note: The variables are in the same order as the columns
			-- in the SELECT statement.
			FETCH NEXT FROM ChunkInfo_Cursor
			INTO @ChunkPath
			--Write multiple entries to file to reduce write time
			DECLARE @l_chunkPathConcatList VARCHAR(MAX) = ''
			DECLARE @l_concatCountRemaining INT = @l_concatCount
			-- Check @@FETCH_STATUS to see if there are any more rows to fetch.
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @l_concatCountRemaining = @l_concatCountRemaining - 1
				IF(@l_concatCountRemaining = 0)
				BEGIN
					SET @l_chunkPathConcatList = @l_chunkPathConcatList + @ChunkPath
					IF @isOsWindows = 1
					BEGIN
						EXECUTE @RetCode = sp_OAMethod @FileHandle , 'WriteLine' , NULL , @l_chunkPathConcatList
						IF (@@ERROR != 0 OR @RetCode != 0)
						BEGIN
							CLOSE ChunkInfo_Cursor
							DEALLOCATE ChunkInfo_Cursor
							GOTO MOUNTPATH_END
						END
					END
					ELSE
					BEGIN
						EXECUTE cv_spWriteToFile @FilePath , @l_chunkPathConcatList, @errorMessage OUTPUT, 1
						IF @errorMessage != NULL AND LEN(@errorMessage)>0
						BEGIN
							CLOSE ChunkInfo_Cursor
							DEALLOCATE ChunkInfo_Cursor
							GOTO MOUNTPATH_END
						END
					END
					SET @l_concatCountRemaining = @l_concatCount
					SET @l_chunkPathConcatList = ''
				END
				ELSE
				BEGIN
					SET @l_chunkPathConcatList = @l_chunkPathConcatList + @ChunkPath + CHAR(13) + CHAR(10)
				END
				-- This is executed as long as the previous fetch succeeds.
				FETCH NEXT FROM ChunkInfo_Cursor
				INTO @ChunkPath
			END
			IF(@l_chunkPathConcatList <> '')
			BEGIN
				IF @isOsWindows = 1
				BEGIN
					EXECUTE @RetCode = sp_OAMethod @FileHandle , 'WriteLine' , NULL , @l_chunkPathConcatList
					IF (@@ERROR != 0 OR @RetCode != 0)
					BEGIN
						CLOSE ChunkInfo_Cursor
						DEALLOCATE ChunkInfo_Cursor
						GOTO MOUNTPATH_END
					END
				END
				ELSE
				BEGIN
					EXECUTE cv_spWriteToFile @FilePath , @l_chunkPathConcatList, @errorMessage OUTPUT, 1
					IF @errorMessage != NULL AND LEN(@errorMessage)>0
					BEGIN
						CLOSE ChunkInfo_Cursor
						DEALLOCATE ChunkInfo_Cursor
						GOTO MOUNTPATH_END
					END
				END
			END
			CLOSE ChunkInfo_Cursor
			DEALLOCATE ChunkInfo_Cursor
			FETCH NEXT FROM MountPath_Cursor
			INTO @MountPathId
			if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
		END
MOUNTPATH_END:
		if object_id('tempdb.dbo.#tempChunkListFileData') is not null DROP TABLE #tempChunkListFileData
		CLOSE MountPath_Cursor
		DEALLOCATE MountPath_Cursor
		IF (@isOsWindows = 1 AND @FileHandle > 0)
		BEGIN
			EXECUTE @RetCode = sp_OAMethod @FileHandle , 'Close' , NULL
			IF (@@ERROR = 0 AND @RetCode = 0)
				EXEC sp_OADestroy @FileHandle
		END
		IF (@isOsWindows = 1 AND @FileSystem >= 0)
			EXEC sp_OADestroy @FileSystem
		if object_id('tempdb.dbo.#tempChunkPathInfo') is not null DROP TABLE #tempChunkPathInfo
	END
END
END
PROC_EXIT:
if object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
if object_id('tempdb.dbo.#tempVolume') is not null DROP TABLE #tempVolume
if object_id('tempdb.dbo.#tempMedia') is not null DROP TABLE #tempMedia
if object_id('tempdb.dbo.#tempCopyPrecedence') is not null DROP TABLE #tempCopyPrecedence
if object_id('tempdb.dbo.#tempNASArchive') is not null DROP TABLE #tempNASArchive
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getMediaListByAfileOffset')
	delete from GxQscripts where name = 'getMediaListByAfileOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMediaListByAfileOffset')
	delete from GXDBVersions where aliasname = 'getMediaListByAfileOffset'
GO

insert into GXDBVersions values(2, 'getMediaListByAfileOffset',  '00010045003200160000', 'getMediaListByAfileOffset', '00010045003200160000')
GO

