

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getMangledDIPList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Cursor Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getMangledDIPList')
BEGIN
	print '>>> Drop Stored Procedure: getMangledDIPList <<<'
	drop procedure getMangledDIPList
END
IF EXISTS (select * from GxQscripts where name='getMangledDIPList')
	delete from GxQscripts where name = 'getMangledDIPList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMangledDIPList')
	delete from GXDBVersions where aliasname = 'getMangledDIPList'
GO
print '... Creating Procedure: getMangledDIPList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getMangledDIPList
-- Cursor Input
  @i_clientName NVARCHAR(255)
AS
SET NOCOUNT ON
  DECLARE @srcClientId INTEGER;
  DECLARE @srcMangledHostName NVARCHAR(MAX);
  DECLARE @destClientId INTEGER;
  DECLARE @destMangledHostName NVARCHAR(MAX);
DECLARE @l_clientId INTEGER = 0
DECLARE @l_cvdPort INTEGER = 0
DECLARE @l_evmgrcPort INTEGER = 0
SELECT	@l_clientId = id, @l_cvdPort = cvdPort, @l_evmgrcPort = evmgrcPort
FROM	APP_Client CL WITH (READUNCOMMITTED)
WHERE	CL.name = @i_clientName
IF @l_clientId = 0
BEGIN
	SELECT	0, '', 0, ''
	RETURN
END
SELECT  (CASE WHEN DestClientId = @l_clientId THEN destClientId
			ELSE
				(CASE
					WHEN APL.srcClientId = 0  THEN ACG.clientId
					WHEN APL.srcClientId != 0 THEN  APL.srcClientId
				END)
		END) AS 'srcClientId' ,
		(CASE WHEN DestClientId = @l_clientId THEN (APL.destInterface + '*' + Dest.name + '*' + CAST(Dest.cvdPort AS NVARCHAR(10)) + '*' +  CAST(Dest.evmgrcPort AS NVARCHAR(10)))
			ELSE
				 (CASE
					WHEN APL.srcClientId = 0  THEN (AC.net_hostname + '*' + AC.name + '*' + CAST(AC.cvdPort AS NVARCHAR(10)) + '*' +  CAST(AC.evmgrcPort AS NVARCHAR(10)))
					WHEN APL.srcClientId != 0 THEN (APL.srcInterface + '*' + Src.name + '*' + CAST(Src.cvdPort AS NVARCHAR(10)) + '*' +  CAST(src.evmgrcPort AS NVARCHAR(10)))
				 END)
		END) AS 'srcMangledHostName',
		(CASE WHEN DestClientId != @l_clientId THEN destClientId
			ELSE
				(CASE
					WHEN APL.srcClientId = 0  THEN ACG.clientId
					WHEN APL.srcClientId != 0 THEN  APL.srcClientId
				END)
		END) AS 'destClientId' ,
		(CASE WHEN DestClientId != @l_clientId THEN (APL.destInterface + '*' + Dest.name + '*' + CAST(Dest.cvdPort AS NVARCHAR(10)) + '*' +  CAST(Dest.evmgrcPort AS NVARCHAR(10)))
			ELSE
				 (CASE
					WHEN APL.srcClientId = 0  THEN (AC.net_hostname + '*' + AC.name + '*' + CAST(AC.cvdPort AS NVARCHAR(10)) + '*' +  CAST(AC.evmgrcPort AS NVARCHAR(10)))
					WHEN APL.srcClientId != 0 THEN (APL.srcInterface + '*' + Src.name + '*' + CAST(Src.cvdPort AS NVARCHAR(10)) + '*' +  CAST(src.evmgrcPort AS NVARCHAR(10)))
				 END)
		END) AS 'destMangledHostName'
FROM archPipeline  APL WITH (READUNCOMMITTED)
	INNER JOIN APP_Client Dest WITH (READUNCOMMITTED) ON APL.destClientId = Dest.id
	LEFT JOIN APP_ClientGroupAssoc  ACG WITH (READUNCOMMITTED) on APL.srcGroupId=ACG.clientGroupId
	LEFT JOIN APP_Client AC WITH (READUNCOMMITTED) on ACG.clientId=AC.id
	LEFT JOIN APP_Client Src WITH (READUNCOMMITTED) on APL.srcClientId=Src.id
WHERE (APL.srcClientId = @l_clientId OR APL.destClientId =@l_clientId OR ACG.clientId =@l_clientId ) AND ((APL.srcClientId=0 and AC.net_hostname IS NOT NULL) OR APL.srcClientId!=0) AND (APL.isActive = 1)
	AND APL.flags=0 /* Non-wildcard DIPs */
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'getMangledDIPList')
	delete from GxQscripts where name = 'getMangledDIPList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getMangledDIPList')
	delete from GXDBVersions where aliasname = 'getMangledDIPList'
GO

insert into GXDBVersions values(2, 'getMangledDIPList',  '00000000000000000000', 'getMangledDIPList', '00000000000000000000')
GO

