

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/getGroupsForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/getGroupsForUser.sp,v $ $Id: getGroupsForUser.sp,v 1.9.66.2 2018/03/20 00:37:40 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "getGroupsForUser"                                   |
-- 	+-----------------------------------------------------------------------+
--  Note: 10/30/2006 -Skatz	  Do not believe we want to pull in UMDSUserGroup tables into
--                            this list. This should only be called for "local" users anyway!
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getGroupsForUser <<<'

IF EXISTS (select * from sysobjects where name='getGroupsForUser')
	drop procedure getGroupsForUser
IF EXISTS (select * from GxQscripts where name='getGroupsForUser')
	delete from GxQscripts where name = 'getGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getGroupsForUser')
	delete from GXDBVersions where aliasname = 'getGroupsForUser'
GO
print '... Creating Procedure: getGroupsForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getGroupsForUser
  @userId integer
AS
  DECLARE @id integer
  DECLARE @groupFlags integer
  DECLARE @allCapabilities integer
  DECLARE @allAssociations integer
  DECLARE @selfAssociation integer
  DECLARE @name char(255)
  DECLARE @description char(255)
DECLARE    @isNestedSPCall INT
SET NOCOUNT ON
--Start by assuming it is nested call, then we find actual status by checking for temp table #GroupsForUser existence
SET @isNestedSPCall = 1
-- if table #GroupsForUser already exists in scope, this means some calling stored procedure declared it already in order to
-- overcome nesting of stored procedure due to insert exec construct
if object_id('tempdb.dbo.#GroupsForUser') is null
begin
	SET @isNestedSPCall = 0
	CREATE TABLE #GroupsForUser (
	id integer,
	groupFlags integer,
	allCapabilities integer,
	allAssociations integer,
	selfAssociation integer,
name nvarchar(255),
description nvarchar(3072)
	)
end
IF (@userId = 0)
BEGIN
	insert into #GroupsForUser
    SELECT UMGroups.id, UMGroups.groupFlags, UMGroups.allCapabilities
			, UMGroups.allAssociations, UMGroups.selfAssociation, UMGroups.name, UMGroups.description
    FROM UMGroups
	WHERE umdsProviderId=0
    ORDER BY UMGroups.name
END
ELSE
BEGIN
	DECLARE @LocalGroups TABLE (groupId INT)
	INSERT INTO @LocalGroups
	EXEC sec_getLocalUserGroupsOfUser @userId
	insert into #GroupsForUser
	SELECT UMGroups.id, UMGroups.groupFlags, UMGroups.allCapabilities
			, UMGroups.allAssociations, UMGroups.selfAssociation, UMGroups.name, UMGroups.description
	FROM UMGroups INNER JOIN @LocalGroups ON UMGroups.id = [@LocalGroups].groupId
	WHERE umdsProviderId=0
	ORDER BY UMGroups.name
   END
--if it is not nested call, we return data so that caller gets data as result set. other-wise caller takes data from temp table #GroupsForUser
IF @isNestedSPCall = 0
BEGIN
	SELECT * FROM #GroupsForUser
	DROP TABLE #GroupsForUser
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'getGroupsForUser')
	delete from GxQscripts where name = 'getGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getGroupsForUser')
	delete from GXDBVersions where aliasname = 'getGroupsForUser'
GO

insert into GXDBVersions values(2, 'getGroupsForUser',  '00010009006600020000', 'getGroupsForUser', '00010009006600020000')
GO

